/*
 * Decompiled with CFR 0.152.
 */
package dev.rosewood.rosestacker.lib.rosegarden.config;

import dev.rosewood.rosestacker.lib.rosegarden.config.PDCDelegatingSettingSerializer;
import dev.rosewood.rosestacker.lib.rosegarden.config.RoseSetting;
import dev.rosewood.rosestacker.lib.rosegarden.utils.RoseGardenUtils;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.persistence.PersistentDataType;

public interface SettingSerializer<T> {
    public void write(ConfigurationSection var1, String var2, T var3, String ... var4);

    default public void write(ConfigurationSection config, RoseSetting<T> setting, T value) {
        this.write(config, setting.getKey(), value, setting.getComments());
    }

    default public void writeWithDefault(ConfigurationSection config, String key, T value, String ... comments) {
        String[] newComments = SettingSerializer.appendDefaultComment(this, value, comments);
        this.write(config, key, value, newComments);
    }

    default public void writeWithDefault(ConfigurationSection config, RoseSetting<T> setting, T value) {
        this.writeWithDefault(config, setting.getKey(), value, setting.getComments());
    }

    default public String getDefaultCommentText(T value) {
        if (!this.isStringKey()) {
            return null;
        }
        String defaultValueStringKey = this.asStringKey(value);
        String defaultComment = "Default: ";
        defaultComment = RoseGardenUtils.containsConfigSpecialCharacters(defaultValueStringKey) ? defaultComment + '\'' + defaultValueStringKey + '\'' : (defaultValueStringKey.isEmpty() ? defaultComment + "''" : defaultComment + defaultValueStringKey);
        return defaultComment;
    }

    public static <T> String[] appendDefaultComment(SettingSerializer<T> serializer, T value, String[] comments) {
        String defaultComment = serializer.getDefaultCommentText(value);
        if (defaultComment == null) {
            return comments;
        }
        String[] newComments = new String[comments.length + 1];
        System.arraycopy(comments, 0, newComments, 0, comments.length);
        newComments[comments.length] = defaultComment;
        return newComments;
    }

    public T read(ConfigurationSection var1, String var2);

    default public T read(ConfigurationSection config, RoseSetting<T> setting) {
        return this.read(config, setting.getKey());
    }

    default public boolean readIsValid(ConfigurationSection config, String key) {
        return config.contains(key);
    }

    default public boolean readIsValid(ConfigurationSection config, RoseSetting<T> setting) {
        return this.readIsValid(config, setting.getKey());
    }

    public boolean isStringKey();

    public String asStringKey(T var1);

    public T fromStringKey(String var1);

    public Class<T> getType();

    public PDCAdapter<T> pdc();

    public static interface PDCAdapter<T> {
        public PDCDelegatingSettingSerializer<T> adapt(PersistentDataType<?, T> var1);
    }
}

