/*
 * Decompiled with CFR 0.152.
 */
package dev.rosewood.rosestacker.lib.rosegarden.config;

import dev.rosewood.rosestacker.lib.rosegarden.config.BaseSettingSerializer;
import dev.rosewood.rosestacker.lib.rosegarden.config.CommentedConfigurationSection;
import dev.rosewood.rosestacker.lib.rosegarden.config.FieldMappedSettingSerializer;
import dev.rosewood.rosestacker.lib.rosegarden.config.SettingSerializer;
import dev.rosewood.rosestacker.lib.rosegarden.config.SettingSerializers;
import dev.rosewood.rosestacker.lib.rosegarden.utils.NMSUtil;
import dev.rosewood.rosestacker.lib.rosegarden.utils.RoseGardenUtils;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.bukkit.Keyed;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.ConfigurationSection;

final class SettingSerializerFactories {
    private SettingSerializerFactories() {
    }

    public static <T extends Enum<T>> SettingSerializer<T> ofEnum(final Class<T> enumClass) {
        return new BaseSettingSerializer<T>(enumClass, x -> x.name().toLowerCase(), x -> Enum.valueOf(enumClass, x.toUpperCase())){

            @Override
            public void write(ConfigurationSection config, String key, T value, String ... comments) {
                SettingSerializers.setWithComments(config, key, ((Enum)value).name().toLowerCase(), comments);
            }

            @Override
            public T read(ConfigurationSection config, String key) {
                try {
                    return Enum.valueOf(enumClass, config.getString(key, "").toUpperCase());
                }
                catch (IllegalArgumentException e) {
                    return null;
                }
            }
        };
    }

    public static <T extends Keyed> SettingSerializer<T> ofKeyed(Class<T> keyedClass, final Function<NamespacedKey, T> valueOfFunction) {
        return new BaseSettingSerializer<T>(keyedClass, x -> SettingSerializerFactories.translateName(x.getKey()), x -> (Keyed)valueOfFunction.apply(SettingSerializerFactories.translateKey(x))){

            @Override
            public void write(ConfigurationSection config, String key, T value, String ... comments) {
                SettingSerializers.setWithComments(config, key, SettingSerializerFactories.translateName(value.getKey()), comments);
            }

            @Override
            public T read(ConfigurationSection config, String key) {
                return (Keyed)valueOfFunction.apply(SettingSerializerFactories.translateKey(config.getString(key)));
            }
        };
    }

    public static <T> SettingSerializer<T[]> ofArray(final SettingSerializer<T> serializer) {
        return new BaseSettingSerializer<T[]>(Array.newInstance(serializer.getType(), 0).getClass()){

            @Override
            public void write(ConfigurationSection config, String key, T[] value, String ... comments) {
                if (serializer.isStringKey()) {
                    SettingSerializers.setWithComments(config, key, Arrays.stream(value).map(x -> x == null ? "" : serializer.asStringKey(x)).collect(Collectors.toList()), comments);
                } else {
                    ConfigurationSection section = SettingSerializerFactories.getOrCreateSection(config, key, comments);
                    int index = 0;
                    for (Object t : value) {
                        if (t == null) {
                            section.set(String.valueOf(index++), (Object)"");
                            continue;
                        }
                        serializer.write(section, String.valueOf(index++), t, new String[0]);
                    }
                }
            }

            @Override
            public T[] read(ConfigurationSection config, String key) {
                if (!this.readIsValid(config, key)) {
                    return null;
                }
                if (serializer.isStringKey()) {
                    List contents = config.getStringList(key);
                    Object[] array = (Object[])Array.newInstance(serializer.getType(), contents.size());
                    for (int i = 0; i < contents.size(); ++i) {
                        String content = (String)contents.get(i);
                        if (content.isEmpty()) continue;
                        array[i] = serializer.fromStringKey(content);
                    }
                    return array;
                }
                ConfigurationSection section = config.getConfigurationSection(key);
                if (section != null) {
                    List contents = config.getStringList(key);
                    Object[] array = (Object[])Array.newInstance(serializer.getType(), contents.size());
                    for (String configKey : section.getKeys(false)) {
                        int index = Integer.parseInt(configKey);
                        String content = section.getString(configKey, "");
                        if (content.isEmpty()) continue;
                        array[index] = serializer.read(section, configKey);
                    }
                }
                return (Object[])Array.newInstance(serializer.getType(), 0);
            }

            @Override
            public String getDefaultCommentText(T[] values) {
                if (!serializer.isStringKey() || values.length > 5) {
                    return null;
                }
                StringBuilder builder = new StringBuilder("Default: [");
                Iterator iterator = Arrays.stream(values).iterator();
                boolean hasNext = iterator.hasNext();
                while (hasNext) {
                    Object value = iterator.next();
                    String defaultValueStringKey = serializer.asStringKey(value);
                    if (RoseGardenUtils.containsConfigSpecialCharacters(defaultValueStringKey)) {
                        builder.append('\'').append(defaultValueStringKey).append('\'');
                    } else if (defaultValueStringKey.isEmpty()) {
                        builder.append("''");
                    } else {
                        builder.append(defaultValueStringKey);
                    }
                    if (!(hasNext = iterator.hasNext())) continue;
                    builder.append(", ");
                }
                builder.append(']');
                if (builder.length() > 60) {
                    return null;
                }
                return builder.toString();
            }
        };
    }

    public static <T> SettingSerializer<List<T>> ofList(final SettingSerializer<T> serializer) {
        return new BaseSettingSerializer<List<T>>(List.class){

            @Override
            public void write(ConfigurationSection config, String key, List<T> value, String ... comments) {
                if (serializer.isStringKey()) {
                    SettingSerializers.setWithComments(config, key, value.stream().map(serializer::asStringKey).collect(Collectors.toList()), comments);
                } else {
                    ConfigurationSection section = SettingSerializerFactories.getOrCreateSection(config, key, comments);
                    int index = 0;
                    for (Object t : value) {
                        serializer.write(section, String.valueOf(index++), t, new String[0]);
                    }
                }
            }

            @Override
            public List<T> read(ConfigurationSection config, String key) {
                if (!this.readIsValid(config, key)) {
                    return null;
                }
                if (serializer.isStringKey()) {
                    return config.getStringList(key).stream().map(serializer::fromStringKey).collect(Collectors.toList());
                }
                ArrayList list = new ArrayList();
                ConfigurationSection section = config.getConfigurationSection(key);
                if (section != null) {
                    for (String configKey : section.getKeys(false)) {
                        Object t = serializer.read(section, configKey);
                        if (t == null) continue;
                        list.add(t);
                    }
                }
                return list;
            }

            @Override
            public String getDefaultCommentText(List<T> values) {
                if (!serializer.isStringKey() || values.size() > 5) {
                    return null;
                }
                StringBuilder builder = new StringBuilder("Default: [");
                Iterator iterator = values.iterator();
                boolean hasNext = iterator.hasNext();
                while (hasNext) {
                    Object value = iterator.next();
                    String defaultValueStringKey = serializer.asStringKey(value);
                    if (RoseGardenUtils.containsConfigSpecialCharacters(defaultValueStringKey)) {
                        builder.append('\'').append(defaultValueStringKey).append('\'');
                    } else if (defaultValueStringKey.isEmpty()) {
                        builder.append("''");
                    } else {
                        builder.append(defaultValueStringKey);
                    }
                    if (!(hasNext = iterator.hasNext())) continue;
                    builder.append(", ");
                }
                builder.append(']');
                if (builder.length() > 60) {
                    return null;
                }
                return builder.toString();
            }
        };
    }

    public static <K, V> SettingSerializer<Map<K, V>> ofMap(final SettingSerializer<K> keySerializer, final SettingSerializer<V> valueSerializer) {
        return new BaseSettingSerializer<Map<K, V>>(Map.class){

            @Override
            public void write(ConfigurationSection config, String key, Map<K, V> value, String ... comments) {
                ConfigurationSection section = SettingSerializerFactories.getOrCreateSection(config, key, comments);
                if (keySerializer.isStringKey() && valueSerializer.isStringKey()) {
                    for (Map.Entry entry : value.entrySet()) {
                        section.set(keySerializer.asStringKey(entry.getKey()), (Object)valueSerializer.asStringKey(entry.getValue()));
                    }
                } else {
                    int index = 0;
                    for (Map.Entry entry : value.entrySet()) {
                        ConfigurationSection indexedSection = SettingSerializerFactories.getOrCreateSection(section, String.valueOf(index++), new String[0]);
                        keySerializer.write(indexedSection, "key", entry.getKey(), new String[0]);
                        valueSerializer.write(indexedSection, "value", entry.getValue(), new String[0]);
                    }
                }
            }

            @Override
            public Map<K, V> read(ConfigurationSection config, String key) {
                HashMap map;
                block5: {
                    if (!this.readIsValid(config, key)) {
                        return null;
                    }
                    map = new HashMap();
                    ConfigurationSection section = config.getConfigurationSection(key);
                    if (section == null) break block5;
                    if (keySerializer.isStringKey() && valueSerializer.isStringKey()) {
                        for (String configKey : section.getKeys(false)) {
                            Object k = keySerializer.fromStringKey(configKey);
                            Object v = valueSerializer.fromStringKey(section.getString(configKey, ""));
                            if (k == null || v == null) continue;
                            map.put(k, v);
                        }
                    } else {
                        for (String configKey : section.getKeys(false)) {
                            ConfigurationSection indexedSection = section.getConfigurationSection(configKey);
                            if (indexedSection == null) continue;
                            Object k = keySerializer.read(indexedSection, "key");
                            Object v = valueSerializer.read(indexedSection, "value");
                            if (k == null || v == null) continue;
                            map.put(k, v);
                        }
                    }
                }
                return map;
            }
        };
    }

    public static <T, M> SettingSerializer<T> ofFieldMapped(Class<T> type, String fieldKey, SettingSerializer<M> fieldSerializer, Map<M, SettingSerializer<? extends T>> mapper) {
        return new FieldMappedSettingSerializer<T, M>(type, fieldKey, fieldSerializer, mapper);
    }

    static ConfigurationSection getOrCreateSection(ConfigurationSection config, String key, String ... comments) {
        if (config instanceof CommentedConfigurationSection) {
            CommentedConfigurationSection commentedConfig = (CommentedConfigurationSection)config;
            CommentedConfigurationSection section = commentedConfig.getConfigurationSection(key);
            if (section == null) {
                commentedConfig.addPathedComments(key, comments);
                section = commentedConfig.createSection(key);
            }
            return section;
        }
        ConfigurationSection section = config.getConfigurationSection(key);
        if (section == null) {
            section = config.createSection(key);
            if (NMSUtil.getVersionNumber() > 18 || NMSUtil.getVersionNumber() == 18 && NMSUtil.getMinorVersionNumber() >= 1) {
                config.setComments(key, Arrays.asList(comments));
            }
        }
        return section;
    }

    private static NamespacedKey translateKey(String key) {
        return NamespacedKey.fromString((String)key);
    }

    private static String translateName(NamespacedKey key) {
        if (key.getNamespace().equals("minecraft")) {
            return key.getKey();
        }
        return key.toString();
    }
}

