/*
 * Decompiled with CFR 0.152.
 */
package dev.rosewood.rosestacker.lib.rosegarden.config;

import dev.rosewood.rosestacker.lib.rosegarden.config.BaseSettingSerializer;
import dev.rosewood.rosestacker.lib.rosegarden.config.CommentedConfigurationSection;
import dev.rosewood.rosestacker.lib.rosegarden.config.RecordSettingSerializerBuilder;
import dev.rosewood.rosestacker.lib.rosegarden.config.SettingField;
import dev.rosewood.rosestacker.lib.rosegarden.config.SettingSerializer;
import dev.rosewood.rosestacker.lib.rosegarden.config.SettingSerializerFactories;
import dev.rosewood.rosestacker.lib.rosegarden.utils.NMSUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.util.Vector;

public final class SettingSerializers {
    public static final SettingSerializer<Boolean> BOOLEAN = new BaseSettingSerializer<Boolean>(Boolean.class, Object::toString, Boolean::parseBoolean){

        @Override
        public void write(ConfigurationSection config, String key, Boolean value, String ... comments) {
            SettingSerializers.setWithComments(config, key, value, comments);
        }

        @Override
        public Boolean read(ConfigurationSection config, String key) {
            return (Boolean)SettingSerializers.getOrNull(config, key, ConfigurationSection::getBoolean);
        }
    };
    public static final SettingSerializer<Integer> INTEGER = new BaseSettingSerializer<Integer>(Integer.class, Object::toString, Integer::parseInt){

        @Override
        public void write(ConfigurationSection config, String key, Integer value, String ... comments) {
            SettingSerializers.setWithComments(config, key, value, comments);
        }

        @Override
        public Integer read(ConfigurationSection config, String key) {
            return (Integer)SettingSerializers.getOrNull(config, key, ConfigurationSection::getInt);
        }
    };
    public static final SettingSerializer<Long> LONG = new BaseSettingSerializer<Long>(Long.class, Object::toString, Long::parseLong){

        @Override
        public void write(ConfigurationSection config, String key, Long value, String ... comments) {
            SettingSerializers.setWithComments(config, key, value, comments);
        }

        @Override
        public Long read(ConfigurationSection config, String key) {
            return (Long)SettingSerializers.getOrNull(config, key, ConfigurationSection::getLong);
        }
    };
    public static final SettingSerializer<Short> SHORT = new BaseSettingSerializer<Short>(Short.class, Object::toString, Short::parseShort){

        @Override
        public void write(ConfigurationSection config, String key, Short value, String ... comments) {
            SettingSerializers.setWithComments(config, key, value, comments);
        }

        @Override
        public Short read(ConfigurationSection config, String key) {
            return (Short)SettingSerializers.getOrNull(config, key, (x, y) -> (short)x.getInt(y));
        }
    };
    public static final SettingSerializer<Byte> BYTE = new BaseSettingSerializer<Byte>(Byte.class, Object::toString, Byte::parseByte){

        @Override
        public void write(ConfigurationSection config, String key, Byte value, String ... comments) {
            SettingSerializers.setWithComments(config, key, value, comments);
        }

        @Override
        public Byte read(ConfigurationSection config, String key) {
            return (Byte)SettingSerializers.getOrNull(config, key, (x, y) -> (byte)x.getInt(y));
        }
    };
    public static final SettingSerializer<Double> DOUBLE = new BaseSettingSerializer<Double>(Double.class, Object::toString, Double::parseDouble){

        @Override
        public void write(ConfigurationSection config, String key, Double value, String ... comments) {
            SettingSerializers.setWithComments(config, key, value, comments);
        }

        @Override
        public Double read(ConfigurationSection config, String key) {
            return (Double)SettingSerializers.getOrNull(config, key, ConfigurationSection::getDouble);
        }
    };
    public static final SettingSerializer<Float> FLOAT = new BaseSettingSerializer<Float>(Float.class, Object::toString, Float::parseFloat){

        @Override
        public void write(ConfigurationSection config, String key, Float value, String ... comments) {
            SettingSerializers.setWithComments(config, key, value, comments);
        }

        @Override
        public Float read(ConfigurationSection config, String key) {
            return (Float)SettingSerializers.getOrNull(config, key, (x, y) -> Float.valueOf((float)x.getDouble(y)));
        }
    };
    public static final SettingSerializer<Character> CHAR = new BaseSettingSerializer<Character>(Character.class, Object::toString, x -> Character.valueOf(x.charAt(0))){

        @Override
        public void write(ConfigurationSection config, String key, Character value, String ... comments) {
            SettingSerializers.setWithComments(config, key, value, comments);
        }

        @Override
        public Character read(ConfigurationSection config, String key) {
            String value = config.getString(key);
            if (value == null || value.isEmpty()) {
                return Character.valueOf(' ');
            }
            return Character.valueOf(value.charAt(0));
        }
    };
    public static final SettingSerializer<List<Boolean>> BOOLEAN_LIST = SettingSerializers.ofList(BOOLEAN);
    public static final SettingSerializer<List<Long>> LONG_LIST = SettingSerializers.ofList(LONG);
    public static final SettingSerializer<List<Short>> SHORT_LIST = SettingSerializers.ofList(SHORT);
    public static final SettingSerializer<List<Byte>> BYTE_LIST = SettingSerializers.ofList(BYTE);
    public static final SettingSerializer<List<Double>> DOUBLE_LIST = SettingSerializers.ofList(DOUBLE);
    public static final SettingSerializer<List<Float>> FLOAT_LIST = SettingSerializers.ofList(FLOAT);
    public static final SettingSerializer<List<Character>> CHAR_LIST = SettingSerializers.ofList(CHAR);
    public static final SettingSerializer<String> STRING = new BaseSettingSerializer<String>(String.class, Function.identity(), Function.identity()){

        @Override
        public void write(ConfigurationSection config, String key, String value, String ... comments) {
            SettingSerializers.setWithComments(config, key, value, comments);
        }

        @Override
        public String read(ConfigurationSection config, String key) {
            return config.getString(key);
        }
    };
    public static final SettingSerializer<List<String>> STRING_LIST = SettingSerializers.ofList(STRING);
    public static final SettingSerializer<Material> MATERIAL = SettingSerializers.ofEnum(Material.class);
    public static final SettingSerializer<List<Material>> MATERIAL_LIST = SettingSerializers.ofList(MATERIAL);
    public static final SettingSerializer<ConfigurationSection> SECTION = new BaseSettingSerializer<ConfigurationSection>(ConfigurationSection.class){

        @Override
        public void write(ConfigurationSection config, String key, ConfigurationSection value, String ... comments) {
            if (config instanceof CommentedConfigurationSection) {
                ((CommentedConfigurationSection)config).addPathedComments(key, comments);
            } else if (NMSUtil.getVersionNumber() > 18 || NMSUtil.getVersionNumber() == 18 && NMSUtil.getMinorVersionNumber() >= 1) {
                if (!config.isConfigurationSection(key)) {
                    config.createSection(key);
                }
                config.setComments(key, Arrays.asList(comments));
            }
        }

        @Override
        public ConfigurationSection read(ConfigurationSection config, String key) {
            return config.getConfigurationSection(key);
        }
    };
    public static final SettingSerializer<Vector> VECTOR = SettingSerializers.ofRecord(Vector.class, instance -> instance.group(SettingField.of("x", DOUBLE, Vector::getX, new String[0]), SettingField.of("y", DOUBLE, Vector::getY, new String[0]), SettingField.of("z", DOUBLE, Vector::getZ, new String[0])).apply((RecordSettingSerializerBuilder<Vector>)instance, Vector::new));

    private SettingSerializers() {
    }

    private static <T> T getOrNull(ConfigurationSection section, String key, BiFunction<ConfigurationSection, String, T> function) {
        if (!section.contains(key)) {
            return null;
        }
        return function.apply(section, key);
    }

    public static <T extends Enum<T>> SettingSerializer<T> ofEnum(Class<T> enumClass) {
        return SettingSerializerFactories.ofEnum(enumClass);
    }

    public static <T extends Keyed> SettingSerializer<T> ofKeyed(Class<T> keyedClass, Function<NamespacedKey, T> valueOfFunction) {
        return SettingSerializerFactories.ofKeyed(keyedClass, valueOfFunction);
    }

    public static <T> SettingSerializer<T[]> ofArray(SettingSerializer<T> serializer) {
        return SettingSerializerFactories.ofArray(serializer);
    }

    public static <T> SettingSerializer<List<T>> ofList(SettingSerializer<T> serializer) {
        return SettingSerializerFactories.ofList(serializer);
    }

    public static <K, V> SettingSerializer<Map<K, V>> ofMap(SettingSerializer<K> keySerializer, SettingSerializer<V> valueSerializer) {
        return SettingSerializerFactories.ofMap(keySerializer, valueSerializer);
    }

    public static <O> SettingSerializer<O> ofRecord(Class<O> clazz, Function<RecordSettingSerializerBuilder<O>, RecordSettingSerializerBuilder.Built<O>> builder) {
        return RecordSettingSerializerBuilder.create(clazz, builder);
    }

    public static <T, M> SettingSerializer<T> ofFieldMapped(Class<T> type, String fieldKey, SettingSerializer<M> fieldSerializer, Map<M, SettingSerializer<? extends T>> mapper) {
        return SettingSerializerFactories.ofFieldMapped(type, fieldKey, fieldSerializer, mapper);
    }

    public static void setWithComments(ConfigurationSection section, String key, Object value, String[] comments) {
        if (section instanceof CommentedConfigurationSection) {
            ((CommentedConfigurationSection)section).set(key, value, comments);
        } else {
            section.set(key, value);
            if (NMSUtil.getVersionNumber() > 18 || NMSUtil.getVersionNumber() == 18 && NMSUtil.getMinorVersionNumber() >= 1) {
                section.setComments(key, Arrays.asList(comments));
            }
        }
    }
}

