/*
 * Decompiled with CFR 0.152.
 */
package dev.rosewood.rosestacker.lib.rosegarden.datatype;

import dev.rosewood.rosestacker.lib.rosegarden.utils.KeyHelper;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import org.bukkit.Bukkit;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.persistence.PersistentDataAdapterContext;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;

public final class CustomPersistentDataType {
    public static final PersistentDataType<PersistentDataContainer, Location> LOCATION = new PersistentDataType<PersistentDataContainer, Location>(){

        public Class<PersistentDataContainer> getPrimitiveType() {
            return PersistentDataContainer.class;
        }

        public Class<Location> getComplexType() {
            return Location.class;
        }

        public PersistentDataContainer toPrimitive(Location location, PersistentDataAdapterContext context) {
            PersistentDataContainer container = context.newPersistentDataContainer();
            container.set(KeyHelper.get("world"), PersistentDataType.STRING, (Object)location.getWorld().getName());
            container.set(KeyHelper.get("x"), PersistentDataType.DOUBLE, (Object)location.getX());
            container.set(KeyHelper.get("y"), PersistentDataType.DOUBLE, (Object)location.getY());
            container.set(KeyHelper.get("z"), PersistentDataType.DOUBLE, (Object)location.getZ());
            container.set(KeyHelper.get("yaw"), PersistentDataType.FLOAT, (Object)Float.valueOf(location.getYaw()));
            container.set(KeyHelper.get("pitch"), PersistentDataType.FLOAT, (Object)Float.valueOf(location.getPitch()));
            return container;
        }

        public Location fromPrimitive(PersistentDataContainer container, PersistentDataAdapterContext context) {
            String worldName = (String)container.get(KeyHelper.get("world"), PersistentDataType.STRING);
            Double x = (Double)container.get(KeyHelper.get("x"), PersistentDataType.DOUBLE);
            Double y = (Double)container.get(KeyHelper.get("y"), PersistentDataType.DOUBLE);
            Double z = (Double)container.get(KeyHelper.get("z"), PersistentDataType.DOUBLE);
            Float yaw = (Float)container.get(KeyHelper.get("yaw"), PersistentDataType.FLOAT);
            Float pitch = (Float)container.get(KeyHelper.get("pitch"), PersistentDataType.FLOAT);
            if (worldName == null || x == null || y == null || z == null || yaw == null || pitch == null) {
                throw new IllegalArgumentException("Invalid Location");
            }
            World world = Bukkit.getWorld((String)worldName);
            if (world == null) {
                throw new IllegalArgumentException("Invalid Location, world is not loaded");
            }
            return new Location(world, x.doubleValue(), y.doubleValue(), z.doubleValue(), yaw.floatValue(), pitch.floatValue());
        }
    };
    public static final PersistentDataType<byte[], UUID> UUID = new PersistentDataType<byte[], UUID>(){

        public Class<byte[]> getPrimitiveType() {
            return byte[].class;
        }

        public Class<UUID> getComplexType() {
            return UUID.class;
        }

        public byte[] toPrimitive(UUID uuid, PersistentDataAdapterContext context) {
            return ByteBuffer.wrap(new byte[16]).putLong(uuid.getMostSignificantBits()).putLong(uuid.getLeastSignificantBits()).array();
        }

        public UUID fromPrimitive(byte[] primitive, PersistentDataAdapterContext context) {
            ByteBuffer byteBuffer = ByteBuffer.wrap(primitive);
            return new UUID(byteBuffer.getLong(), byteBuffer.getLong());
        }
    };
    public static final PersistentDataType<String, Character> CHARACTER = new PersistentDataType<String, Character>(){

        public Class<String> getPrimitiveType() {
            return String.class;
        }

        public Class<Character> getComplexType() {
            return Character.class;
        }

        public String toPrimitive(Character character, PersistentDataAdapterContext context) {
            return String.valueOf(character);
        }

        public Character fromPrimitive(String primitive, PersistentDataAdapterContext context) {
            return Character.valueOf(primitive.charAt(0));
        }
    };
    public static final PersistentDataType<PersistentDataContainer, ConfigurationSection> SECTION = new PersistentDataType<PersistentDataContainer, ConfigurationSection>(){

        public Class<PersistentDataContainer> getPrimitiveType() {
            return PersistentDataContainer.class;
        }

        public Class<ConfigurationSection> getComplexType() {
            return ConfigurationSection.class;
        }

        public PersistentDataContainer toPrimitive(ConfigurationSection container, PersistentDataAdapterContext context) {
            new RuntimeException("Unsupported usage of PersistentDataType#toPrimitive for ConfigurationSection").printStackTrace();
            return context.newPersistentDataContainer();
        }

        public ConfigurationSection fromPrimitive(PersistentDataContainer primitive, PersistentDataAdapterContext context) {
            new RuntimeException("Unsupported usage of PersistentDataType#fromPrimitive for ConfigurationSection").printStackTrace();
            return new YamlConfiguration();
        }
    };

    public static <T extends Enum<T>> PersistentDataType<String, T> forEnum(final Class<T> enumClass) {
        return new PersistentDataType<String, T>(){

            public Class<String> getPrimitiveType() {
                return String.class;
            }

            public Class<T> getComplexType() {
                return enumClass;
            }

            public String toPrimitive(T enumValue, PersistentDataAdapterContext context) {
                return ((Enum)enumValue).name();
            }

            public T fromPrimitive(String primitive, PersistentDataAdapterContext context) {
                return Enum.valueOf(enumClass, primitive);
            }
        };
    }

    public static <T extends Keyed> PersistentDataType<String, T> forKeyed(final Class<T> keyedClass, final Function<NamespacedKey, T> valueOfFunction) {
        return new PersistentDataType<String, T>(){

            public Class<String> getPrimitiveType() {
                return String.class;
            }

            public Class<T> getComplexType() {
                return keyedClass;
            }

            public String toPrimitive(T enumValue, PersistentDataAdapterContext context) {
                return enumValue.getKey().asString();
            }

            public T fromPrimitive(String primitive, PersistentDataAdapterContext context) {
                return (Keyed)valueOfFunction.apply(NamespacedKey.fromString((String)primitive));
            }
        };
    }

    public static <T> PersistentDataType<PersistentDataContainer, T[]> forArray(final PersistentDataType<?, T> arrayElementDataType) {
        return new PersistentDataType<PersistentDataContainer, T[]>(){

            public Class<PersistentDataContainer> getPrimitiveType() {
                return PersistentDataContainer.class;
            }

            public Class<T[]> getComplexType() {
                return arrayElementDataType.getComplexType().arrayType();
            }

            public PersistentDataContainer toPrimitive(T[] array, PersistentDataAdapterContext context) {
                PersistentDataContainer container = context.newPersistentDataContainer();
                container.set(KeyHelper.get("size"), PersistentDataType.INTEGER, (Object)array.length);
                for (int i = 0; i < array.length; ++i) {
                    Object element = array[i];
                    if (element == null) continue;
                    NamespacedKey elementKey = KeyHelper.get(String.valueOf(i));
                    container.set(elementKey, arrayElementDataType, element);
                }
                return container;
            }

            public T[] fromPrimitive(PersistentDataContainer container, PersistentDataAdapterContext context) {
                Integer size = (Integer)container.get(KeyHelper.get("size"), PersistentDataType.INTEGER);
                if (size == null) {
                    throw new IllegalArgumentException("Invalid " + arrayElementDataType.getComplexType().getSimpleName() + "[]");
                }
                Object[] array = (Object[])Array.newInstance(arrayElementDataType.getComplexType(), (int)size);
                for (int i = 0; i < size; ++i) {
                    NamespacedKey elementKey = KeyHelper.get(String.valueOf(i));
                    array[i] = container.get(elementKey, arrayElementDataType);
                }
                return array;
            }
        };
    }

    public static <T> PersistentDataType<PersistentDataContainer, List<T>> forList(final PersistentDataType<?, T> listElementDataType) {
        return new PersistentDataType<PersistentDataContainer, List<T>>(){

            public Class<PersistentDataContainer> getPrimitiveType() {
                return PersistentDataContainer.class;
            }

            public Class<List<T>> getComplexType() {
                return List.class;
            }

            public PersistentDataContainer toPrimitive(List<T> list, PersistentDataAdapterContext context) {
                PersistentDataContainer container = context.newPersistentDataContainer();
                container.set(KeyHelper.get("size"), PersistentDataType.INTEGER, (Object)list.size());
                for (int i = 0; i < list.size(); ++i) {
                    Object element = list.get(i);
                    if (element == null) continue;
                    NamespacedKey elementKey = KeyHelper.get(String.valueOf(i));
                    container.set(elementKey, listElementDataType, element);
                }
                return container;
            }

            public List<T> fromPrimitive(PersistentDataContainer container, PersistentDataAdapterContext context) {
                Integer size = (Integer)container.get(KeyHelper.get("size"), PersistentDataType.INTEGER);
                if (size == null) {
                    throw new IllegalArgumentException("Invalid List<" + listElementDataType.getComplexType().getSimpleName() + ">");
                }
                ArrayList<Object> list = new ArrayList<Object>(size);
                for (int i = 0; i < size; ++i) {
                    NamespacedKey elementKey = KeyHelper.get(String.valueOf(i));
                    list.add(container.get(elementKey, listElementDataType));
                }
                return list;
            }
        };
    }

    public static <K, V> PersistentDataType<PersistentDataContainer, Map<K, V>> forMap(final PersistentDataType<?, K> keyDataType, final PersistentDataType<?, V> valueDataType) {
        return new PersistentDataType<PersistentDataContainer, Map<K, V>>(){

            public Class<PersistentDataContainer> getPrimitiveType() {
                return PersistentDataContainer.class;
            }

            public Class<Map<K, V>> getComplexType() {
                return Map.class;
            }

            public PersistentDataContainer toPrimitive(Map<K, V> map, PersistentDataAdapterContext context) {
                PersistentDataContainer container = context.newPersistentDataContainer();
                container.set(KeyHelper.get("size"), PersistentDataType.INTEGER, (Object)map.size());
                int index = 0;
                for (Map.Entry entry : map.entrySet()) {
                    Object keyValue = entry.getKey();
                    Object valueValue = entry.getValue();
                    if (valueValue == null) continue;
                    NamespacedKey keyKey = this.makeKey(true, index);
                    NamespacedKey valueKey = this.makeKey(false, index);
                    container.set(keyKey, keyDataType, keyValue);
                    container.set(valueKey, valueDataType, valueValue);
                    ++index;
                }
                return container;
            }

            public Map<K, V> fromPrimitive(PersistentDataContainer container, PersistentDataAdapterContext context) {
                Integer size = (Integer)container.get(KeyHelper.get("size"), PersistentDataType.INTEGER);
                if (size == null) {
                    throw new IllegalArgumentException("Invalid Map<" + keyDataType.getComplexType().getSimpleName() + ", " + valueDataType.getComplexType().getSimpleName() + ">");
                }
                HashMap<Object, Object> map = new HashMap<Object, Object>();
                for (int i = 0; i < size; ++i) {
                    NamespacedKey keyKey = this.makeKey(true, i);
                    NamespacedKey valueKey = this.makeKey(false, i);
                    Object key = container.get(keyKey, keyDataType);
                    Object value = container.get(valueKey, valueDataType);
                    map.put(key, value);
                }
                return map;
            }

            private NamespacedKey makeKey(boolean key, int index) {
                return KeyHelper.get(String.format("%s-%d", key ? "key" : "value", index));
            }
        };
    }
}

