/*
 * Decompiled with CFR 0.152.
 */
package dev.rosewood.rosestacker.lib.rosegarden.manager;

import dev.rosewood.rosestacker.lib.rosegarden.RosePlugin;
import dev.rosewood.rosestacker.lib.rosegarden.command.framework.BaseRoseCommand;
import dev.rosewood.rosestacker.lib.rosegarden.command.framework.RoseCommandWrapper;
import dev.rosewood.rosestacker.lib.rosegarden.manager.Manager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractCommandManager
extends Manager {
    private final List<RoseCommandWrapper> commandWrappers = new ArrayList<RoseCommandWrapper>();

    public AbstractCommandManager(RosePlugin rosePlugin) {
        super(rosePlugin);
    }

    @Override
    public void reload() {
        this.getRootCommands().stream().map(x -> (BaseRoseCommand)x.apply(this.rosePlugin)).map(x -> new RoseCommandWrapper(this.rosePlugin, (BaseRoseCommand)x)).forEach(this.commandWrappers::add);
        this.commandWrappers.forEach(RoseCommandWrapper::register);
    }

    @Override
    public void disable() {
        this.commandWrappers.forEach(RoseCommandWrapper::unregister);
        this.commandWrappers.clear();
    }

    @NotNull
    public abstract List<Function<RosePlugin, BaseRoseCommand>> getRootCommands();

    public List<RoseCommandWrapper> getActiveCommands() {
        return Collections.unmodifiableList(this.commandWrappers);
    }
}

