/*
 * Decompiled with CFR 0.152.
 */
package dev.rosewood.rosestacker.lib.rosegarden.manager;

import dev.rosewood.rosestacker.lib.rosegarden.RosePlugin;
import dev.rosewood.rosestacker.lib.rosegarden.config.RoseConfig;
import dev.rosewood.rosestacker.lib.rosegarden.config.RoseSetting;
import dev.rosewood.rosestacker.lib.rosegarden.config.SettingHolder;
import dev.rosewood.rosestacker.lib.rosegarden.database.DataMigration;
import dev.rosewood.rosestacker.lib.rosegarden.database.DatabaseConnector;
import dev.rosewood.rosestacker.lib.rosegarden.database.MySQLConnector;
import dev.rosewood.rosestacker.lib.rosegarden.database.SQLiteConnector;
import dev.rosewood.rosestacker.lib.rosegarden.manager.Manager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractDataManager
extends Manager {
    protected DatabaseConnector databaseConnector;

    public AbstractDataManager(RosePlugin rosePlugin) {
        super(rosePlugin);
    }

    @Override
    public void reload() {
        try {
            RoseConfig roseConfig = this.rosePlugin.getRoseConfig();
            if (!this.rosePlugin.isLocalDatabaseOnly() && roseConfig.get(Settings.MYSQL_SETTINGS_ENABLED).booleanValue()) {
                String hostname = roseConfig.get(Settings.MYSQL_SETTINGS_HOSTNAME);
                int port = roseConfig.get(Settings.MYSQL_SETTINGS_PORT);
                String database = roseConfig.get(Settings.MYSQL_SETTINGS_DATABASE);
                String username = roseConfig.get(Settings.MYSQL_SETTINGS_USERNAME);
                String password = roseConfig.get(Settings.MYSQL_SETTINGS_PASSWORD);
                boolean useSSL = roseConfig.get(Settings.MYSQL_SETTINGS_USE_SSL);
                int poolSize = roseConfig.get(Settings.MYSQL_SETTINGS_POOL_SIZE);
                this.databaseConnector = new MySQLConnector(this.rosePlugin, hostname, port, database, username, password, useSSL, poolSize);
                this.rosePlugin.getLogger().info("Data handler connected using MySQL.");
            } else {
                this.databaseConnector = new SQLiteConnector(this.rosePlugin);
                this.databaseConnector.cleanup();
                this.rosePlugin.getLogger().info("Data handler connected using SQLite.");
            }
            this.applyMigrations();
        }
        catch (Exception ex) {
            this.rosePlugin.getLogger().severe("Fatal error trying to connect to database. Please make sure all your connection settings are correct and try again. Plugin has been disabled.");
            ex.printStackTrace();
            Bukkit.getPluginManager().disablePlugin((Plugin)this.rosePlugin);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disable() {
        if (this.databaseConnector == null) {
            return;
        }
        long now = System.currentTimeMillis();
        long deadline = now + 5000L;
        Object object = this.databaseConnector.getLock();
        synchronized (object) {
            while (!this.databaseConnector.isFinished() && now < deadline) {
                try {
                    this.databaseConnector.getLock().wait(deadline - now);
                    now = System.currentTimeMillis();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        this.databaseConnector.closeConnection();
    }

    public final boolean isConnected() {
        return this.databaseConnector != null;
    }

    @NotNull
    public final DatabaseConnector getDatabaseConnector() {
        if (this.databaseConnector == null) {
            throw new IllegalStateException("A database connection could not be established.");
        }
        return this.databaseConnector;
    }

    @NotNull
    public String getTablePrefix() {
        return this.rosePlugin.getDescription().getName().toLowerCase() + '_';
    }

    @NotNull
    public abstract List<Supplier<? extends DataMigration>> getDataMigrations();

    private void applyMigrations() {
        List migrations = this.getDataMigrations().stream().map(Supplier::get).collect(Collectors.toList());
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        databaseConnector.connect(connection -> {
            PreparedStatement statement;
            PreparedStatement statement2;
            boolean migrationsExist;
            int currentMigration = -1;
            String query = databaseConnector instanceof SQLiteConnector ? "SELECT 1 FROM sqlite_master WHERE type = 'table' AND name = ?" : "SHOW TABLES LIKE ?";
            try (PreparedStatement statement3 = connection.prepareStatement(query);){
                statement3.setString(1, this.getMigrationsTableName());
                migrationsExist = statement3.executeQuery().next();
            }
            if (!migrationsExist) {
                String createTable = "CREATE TABLE " + this.getMigrationsTableName() + " (migration_version INT NOT NULL)";
                try (PreparedStatement statement4 = connection.prepareStatement(createTable);){
                    statement4.execute();
                }
                String insertRow = "INSERT INTO " + this.getMigrationsTableName() + " VALUES (?)";
                statement2 = connection.prepareStatement(insertRow);
                try {
                    statement2.setInt(1, -1);
                    statement2.execute();
                }
                finally {
                    if (statement2 != null) {
                        statement2.close();
                    }
                }
            }
            String selectVersion = "SELECT migration_version FROM " + this.getMigrationsTableName();
            boolean badState = false;
            statement2 = connection.prepareStatement(selectVersion);
            try {
                ResultSet result = statement2.executeQuery();
                if (result.next()) {
                    currentMigration = result.getInt("migration_version");
                } else {
                    badState = true;
                }
            }
            finally {
                if (statement2 != null) {
                    statement2.close();
                }
            }
            if (badState) {
                this.rosePlugin.getLogger().severe("Database migration table is missing the migration_version row! The database is currently in a bad state due to an unknown issue. Attempting to fix the migration column automatically... please contact the plugin developer for assistance if this does not work.");
                currentMigration = migrations.stream().mapToInt(DataMigration::getRevision).max().orElse(-1);
                String insertRow = "INSERT INTO " + this.getMigrationsTableName() + " VALUES (?)";
                statement = connection.prepareStatement(insertRow);
                try {
                    statement.setInt(1, currentMigration);
                    statement.execute();
                }
                finally {
                    if (statement != null) {
                        statement.close();
                    }
                }
            }
            int finalCurrentMigration = currentMigration;
            List requiredMigrations = migrations.stream().filter(x -> x.getRevision() > finalCurrentMigration).sorted(Comparator.comparingInt(DataMigration::getRevision)).collect(Collectors.toList());
            if (requiredMigrations.isEmpty()) {
                return;
            }
            for (DataMigration dataMigration : requiredMigrations) {
                dataMigration.migrate(databaseConnector, connection, this.getTablePrefix());
            }
            currentMigration = requiredMigrations.stream().mapToInt(DataMigration::getRevision).max().orElse(-1);
            String updateVersion = "UPDATE " + this.getMigrationsTableName() + " SET migration_version = ?";
            statement = connection.prepareStatement(updateVersion);
            try {
                statement.setInt(1, currentMigration);
                statement.execute();
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        });
    }

    private String getMigrationsTableName() {
        return this.rosePlugin.getManager(AbstractDataManager.class).getTablePrefix() + "migrations";
    }

    public static final class Settings
    implements SettingHolder {
        public static final SettingHolder INSTANCE = new Settings();
        private static final List<RoseSetting<?>> SETTINGS = new ArrayList();
        public static final RoseSetting<ConfigurationSection> MYSQL_SETTINGS = Settings.define(RoseSetting.ofSection("mysql-settings", "Settings for if you want to use MySQL for data management"));
        public static final RoseSetting<Boolean> MYSQL_SETTINGS_ENABLED = Settings.define(RoseSetting.ofBoolean("mysql-settings.enabled", false, "Enable MySQL", "If false, SQLite will be used instead"));
        public static final RoseSetting<String> MYSQL_SETTINGS_HOSTNAME = Settings.define(RoseSetting.ofString("mysql-settings.hostname", "127.0.0.1", "MySQL Database Hostname"));
        public static final RoseSetting<Integer> MYSQL_SETTINGS_PORT = Settings.define(RoseSetting.ofInteger("mysql-settings.port", 3306, "MySQL Database Port"));
        public static final RoseSetting<String> MYSQL_SETTINGS_DATABASE = Settings.define(RoseSetting.ofString("mysql-settings.database-name", "", "MySQL Database Name"));
        public static final RoseSetting<String> MYSQL_SETTINGS_USERNAME = Settings.define(RoseSetting.ofString("mysql-settings.user-name", "", "MySQL Database User Name"));
        public static final RoseSetting<String> MYSQL_SETTINGS_PASSWORD = Settings.define(RoseSetting.ofString("mysql-settings.user-password", "", "MySQL Database User Password"));
        public static final RoseSetting<Boolean> MYSQL_SETTINGS_USE_SSL = Settings.define(RoseSetting.ofBoolean("mysql-settings.use-ssl", false, "If the database connection should use SSL", "You should enable this if your database supports SSL"));
        public static final RoseSetting<Integer> MYSQL_SETTINGS_POOL_SIZE = Settings.define(RoseSetting.ofInteger("mysql-settings.connection-pool-size", 3, "The number of connections to make to the database"));

        private Settings() {
        }

        @Override
        public List<RoseSetting<?>> get() {
            return Collections.unmodifiableList(SETTINGS);
        }

        private static <T> RoseSetting<T> define(RoseSetting<T> setting) {
            SETTINGS.add(setting);
            return setting;
        }
    }
}

