/*
 * Decompiled with CFR 0.152.
 */
package dev.rosewood.rosestacker.lib.rosegarden.manager;

import dev.rosewood.rosestacker.lib.rosegarden.RosePlugin;
import dev.rosewood.rosestacker.lib.rosegarden.command.framework.CommandMessages;
import dev.rosewood.rosestacker.lib.rosegarden.config.CommentedFileConfiguration;
import dev.rosewood.rosestacker.lib.rosegarden.config.RoseSetting;
import dev.rosewood.rosestacker.lib.rosegarden.config.SettingHolder;
import dev.rosewood.rosestacker.lib.rosegarden.hook.PlaceholderAPIHook;
import dev.rosewood.rosestacker.lib.rosegarden.locale.Locale;
import dev.rosewood.rosestacker.lib.rosegarden.locale.YamlFileLocale;
import dev.rosewood.rosestacker.lib.rosegarden.locale.provider.JarResourceLocaleProvider;
import dev.rosewood.rosestacker.lib.rosegarden.manager.Manager;
import dev.rosewood.rosestacker.lib.rosegarden.utils.HexUtils;
import dev.rosewood.rosestacker.lib.rosegarden.utils.StringPlaceholders;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractLocaleManager
extends Manager {
    protected final File localeDirectory;
    protected Locale defaultLocale;
    protected Locale loadedLocale;

    public AbstractLocaleManager(RosePlugin rosePlugin) {
        super(rosePlugin);
        this.localeDirectory = new File(this.rosePlugin.getDataFolder(), "locale");
    }

    private void registerLocales(Collection<Locale> locales) {
        File[] files;
        StringPlaceholders.Builder placeholdersBuilder = StringPlaceholders.builder().delimiters("{{", "}}");
        this.injectPlaceholderConstants(placeholdersBuilder);
        StringPlaceholders placeholders = placeholdersBuilder.build();
        for (Locale locale : locales) {
            for (Map.Entry<String, Object> entry : locale.getLocaleValues().entrySet()) {
                if (entry.getValue() instanceof String) {
                    String value = (String)entry.getValue();
                    locale.getLocaleValues().put(entry.getKey(), placeholders.apply(value));
                    continue;
                }
                if (!(entry.getValue() instanceof List)) continue;
                List list = (List)entry.getValue();
                list.replaceAll(placeholders::apply);
                locale.getLocaleValues().put(entry.getKey(), list);
            }
        }
        Optional<Locale> defaultLocaleOptional = locales.stream().filter(x -> x.getLocaleName().equals("en_US")).findFirst();
        if (defaultLocaleOptional.isPresent()) {
            this.defaultLocale = defaultLocaleOptional.get();
        } else {
            this.rosePlugin.getLogger().warning("No default 'locale/en_US.yml' locale found!");
            this.defaultLocale = new Locale(){

                @Override
                public String getLocaleName() {
                    return "none";
                }

                @Override
                public Map<String, Object> getLocaleValues() {
                    return new LinkedHashMap<String, Object>();
                }
            };
        }
        if (!this.localeDirectory.exists()) {
            this.localeDirectory.mkdirs();
        }
        if ((files = this.localeDirectory.listFiles()) != null) {
            int migrated = 0;
            for (File file : files) {
                if (!file.getName().endsWith(".lang")) continue;
                File newFile = new File(this.localeDirectory, file.getName().replace(".lang", ".yml"));
                file.renameTo(newFile);
                ++migrated;
            }
            if (migrated > 0) {
                this.rosePlugin.getLogger().info("Migrated " + migrated + " locale files to the new .yml format");
            }
        }
        locales.forEach(this::registerLocale);
        String localeName = this.rosePlugin.getRoseConfig().get(Settings.LOCALE);
        File file = new File(this.localeDirectory, localeName + ".yml");
        if (file.exists()) {
            this.loadedLocale = new YamlFileLocale(file);
        } else {
            this.rosePlugin.getLogger().warning("Locale file '" + file.getName() + "' not found, using default locale");
            this.loadedLocale = this.defaultLocale;
        }
    }

    private void registerLocale(Locale locale) {
        File file = new File(this.rosePlugin.getDataFolder() + "/locale", locale.getLocaleName() + ".yml");
        boolean newFile = false;
        if (!file.exists()) {
            try {
                file.createNewFile();
                newFile = true;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        boolean changed = false;
        CommentedFileConfiguration configuration = CommentedFileConfiguration.loadConfiguration(file);
        Map<String, Object> defaultLocaleStrings = locale.getLocaleValues();
        for (String key : defaultLocaleStrings.keySet()) {
            Object value = defaultLocaleStrings.get(key);
            if (newFile && key.startsWith("_COMMENT_")) {
                configuration.addComments(((String)value).substring(1));
                changed = true;
                continue;
            }
            if (configuration.contains(key)) continue;
            configuration.set(key, value);
            changed = true;
        }
        if (changed) {
            configuration.save(file);
        }
    }

    @Override
    public void reload() {
        this.registerLocales(this.getJarResourceLocales());
    }

    @Override
    public void disable() {
    }

    protected Collection<Locale> getJarResourceLocales() {
        return new JarResourceLocaleProvider("locale").getLocales();
    }

    protected void injectPlaceholderConstants(StringPlaceholders.Builder builder) {
        builder.add("PLUGIN_NAME", this.rosePlugin.getName());
    }

    protected void handleMessage(CommandSender sender, String message) {
        sender.sendMessage(message);
    }

    @NotNull
    protected String getLocaleString(String key) {
        Object value = this.loadedLocale.getLocaleValues().get(key);
        if (!(value instanceof String)) {
            value = this.defaultLocale.getLocaleValues().get(key);
        }
        if (!(value instanceof String)) {
            value = this.getErrorMessage(key);
        }
        return (String)value;
    }

    public String getLocaleMessage(String messageKey) {
        return this.getLocaleMessage(messageKey, StringPlaceholders.empty());
    }

    public String getLocaleMessage(String messageKey, StringPlaceholders stringPlaceholders) {
        return HexUtils.colorify(stringPlaceholders.apply(this.getLocaleString(messageKey)));
    }

    public String getCommandLocaleMessage(String messageKey) {
        return this.getCommandLocaleMessage(messageKey, StringPlaceholders.empty());
    }

    public String getCommandLocaleMessage(String messageKey, StringPlaceholders stringPlaceholders) {
        String message;
        if (this.loadedLocale.getLocaleValues().containsKey(messageKey)) {
            message = this.getLocaleMessage(messageKey, stringPlaceholders);
        } else {
            message = CommandMessages.DEFAULT_MESSAGES.get(messageKey);
            if (message == null) {
                message = this.getErrorMessage(messageKey);
            }
        }
        return HexUtils.colorify(stringPlaceholders.apply(message));
    }

    public void sendMessage(CommandSender sender, String messageKey, StringPlaceholders stringPlaceholders) {
        String prefix = this.getLocaleMessage("prefix");
        String message = this.getLocaleMessage(messageKey, stringPlaceholders);
        if (!message.isEmpty()) {
            this.sendParsedMessage(sender, prefix + message);
        }
    }

    public void sendMessage(CommandSender sender, String messageKey) {
        this.sendMessage(sender, messageKey, StringPlaceholders.empty());
    }

    public void sendCommandMessage(CommandSender sender, String messageKey, StringPlaceholders stringPlaceholders) {
        String prefix = this.getLocaleMessage("prefix");
        String message = this.getCommandLocaleMessage(messageKey, stringPlaceholders);
        if (!message.isEmpty()) {
            this.sendUnparsedMessage(sender, prefix + message);
        }
    }

    public void sendCommandMessage(CommandSender sender, String messageKey) {
        this.sendCommandMessage(sender, messageKey, StringPlaceholders.empty());
    }

    public void sendSimpleMessage(CommandSender sender, String messageKey, StringPlaceholders stringPlaceholders) {
        this.sendParsedMessage(sender, this.getLocaleMessage(messageKey, stringPlaceholders));
    }

    public void sendSimpleMessage(CommandSender sender, String messageKey) {
        this.sendSimpleMessage(sender, messageKey, StringPlaceholders.empty());
    }

    public void sendSimpleCommandMessage(CommandSender sender, String messageKey, StringPlaceholders stringPlaceholders) {
        this.sendUnparsedMessage(sender, this.getCommandLocaleMessage(messageKey, stringPlaceholders));
    }

    public void sendSimpleCommandMessage(CommandSender sender, String messageKey) {
        this.sendSimpleCommandMessage(sender, messageKey, StringPlaceholders.empty());
    }

    public void sendCustomMessage(CommandSender sender, String message) {
        this.sendParsedMessage(sender, message);
    }

    protected String parsePlaceholders(CommandSender sender, String message) {
        if (sender instanceof Player) {
            return PlaceholderAPIHook.applyPlaceholders((OfflinePlayer)((Player)sender), message);
        }
        return message;
    }

    protected void sendParsedMessage(CommandSender sender, String message) {
        if (message.isEmpty()) {
            return;
        }
        String parsedMessage = HexUtils.colorify(this.parsePlaceholders(sender, message));
        this.handleMessage(sender, parsedMessage);
    }

    protected void sendUnparsedMessage(CommandSender sender, String message) {
        if (message.isEmpty()) {
            return;
        }
        String parsedMessage = HexUtils.colorify(message);
        this.handleMessage(sender, parsedMessage);
    }

    protected String getErrorMessage(String messageKey) {
        new LocaleException(messageKey).printStackTrace();
        return "&cMissing locale string: " + messageKey;
    }

    public static final class Settings
    implements SettingHolder {
        public static final SettingHolder INSTANCE = new Settings();
        private static final List<RoseSetting<?>> SETTINGS = new ArrayList();
        public static final RoseSetting<String> LOCALE = Settings.create(RoseSetting.ofString("locale", "en_US", "The locale to use in the /locale folder"));

        private Settings() {
        }

        @Override
        public List<RoseSetting<?>> get() {
            return Collections.unmodifiableList(SETTINGS);
        }

        private static <T> RoseSetting<T> create(RoseSetting<T> setting) {
            SETTINGS.add(setting);
            return setting;
        }
    }

    public static class LocaleException
    extends RuntimeException {
        public LocaleException(String messageKey) {
            super(String.format("Missing locale string: %s", messageKey));
        }
    }
}

