/*
 * Decompiled with CFR 0.152.
 */
package dev.rosewood.rosestacker.lib.rosegarden.scheduler.wrapper;

import dev.rosewood.rosestacker.lib.rosegarden.RosePlugin;
import dev.rosewood.rosestacker.lib.rosegarden.scheduler.task.FoliaScheduledTask;
import dev.rosewood.rosestacker.lib.rosegarden.scheduler.wrapper.SchedulerWrapper;
import dev.rosewood.rosestacker.lib.rosegarden.utils.RoseGardenUtils;
import io.papermc.paper.threadedregions.scheduler.AsyncScheduler;
import io.papermc.paper.threadedregions.scheduler.GlobalRegionScheduler;
import io.papermc.paper.threadedregions.scheduler.RegionScheduler;
import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;

public class FoliaSchedulerWrapper
implements SchedulerWrapper {
    private final RosePlugin rosePlugin;
    private final RegionScheduler regionScheduler;
    private final GlobalRegionScheduler globalRegionScheduler;
    private final AsyncScheduler asyncScheduler;

    public FoliaSchedulerWrapper(RosePlugin rosePlugin) {
        this.rosePlugin = rosePlugin;
        this.regionScheduler = Bukkit.getRegionScheduler();
        this.globalRegionScheduler = Bukkit.getGlobalRegionScheduler();
        this.asyncScheduler = Bukkit.getAsyncScheduler();
    }

    @Override
    public boolean isEntityThread(Entity entity) {
        return Bukkit.isOwnedByCurrentRegion((Entity)entity);
    }

    @Override
    public boolean isLocationThread(Location location) {
        return Bukkit.isOwnedByCurrentRegion((Location)location);
    }

    @Override
    public dev.rosewood.rosestacker.lib.rosegarden.scheduler.task.ScheduledTask runTask(Runnable runnable) {
        return FoliaSchedulerWrapper.wrap(this.globalRegionScheduler.run((Plugin)this.rosePlugin, task -> runnable.run()));
    }

    @Override
    public dev.rosewood.rosestacker.lib.rosegarden.scheduler.task.ScheduledTask runTaskAsync(Runnable runnable) {
        return FoliaSchedulerWrapper.wrap(this.asyncScheduler.runNow((Plugin)this.rosePlugin, task -> runnable.run()));
    }

    @Override
    public dev.rosewood.rosestacker.lib.rosegarden.scheduler.task.ScheduledTask runTaskLater(Runnable runnable, long delay) {
        return FoliaSchedulerWrapper.wrap(this.globalRegionScheduler.runDelayed((Plugin)this.rosePlugin, task -> runnable.run(), FoliaSchedulerWrapper.fix(delay)));
    }

    @Override
    public dev.rosewood.rosestacker.lib.rosegarden.scheduler.task.ScheduledTask runTaskLater(Runnable runnable, long delay, TimeUnit timeUnit) {
        return FoliaSchedulerWrapper.wrap(this.globalRegionScheduler.runDelayed((Plugin)this.rosePlugin, task -> runnable.run(), FoliaSchedulerWrapper.fix(delay)));
    }

    @Override
    public dev.rosewood.rosestacker.lib.rosegarden.scheduler.task.ScheduledTask runTaskLaterAsync(Runnable runnable, long delay) {
        return FoliaSchedulerWrapper.wrap(this.asyncScheduler.runDelayed((Plugin)this.rosePlugin, task -> runnable.run(), FoliaSchedulerWrapper.fix(FoliaSchedulerWrapper.ticksToMillis(delay)), TimeUnit.MILLISECONDS));
    }

    @Override
    public dev.rosewood.rosestacker.lib.rosegarden.scheduler.task.ScheduledTask runTaskLaterAsync(Runnable runnable, long delay, TimeUnit timeUnit) {
        return FoliaSchedulerWrapper.wrap(this.asyncScheduler.runDelayed((Plugin)this.rosePlugin, task -> runnable.run(), FoliaSchedulerWrapper.fix(delay), timeUnit));
    }

    @Override
    public dev.rosewood.rosestacker.lib.rosegarden.scheduler.task.ScheduledTask runTaskTimer(Runnable runnable, long delay, long period) {
        return FoliaSchedulerWrapper.wrap(this.globalRegionScheduler.runAtFixedRate((Plugin)this.rosePlugin, task -> runnable.run(), FoliaSchedulerWrapper.fix(delay), FoliaSchedulerWrapper.fix(period)));
    }

    @Override
    public dev.rosewood.rosestacker.lib.rosegarden.scheduler.task.ScheduledTask runTaskTimer(Runnable runnable, long delay, long period, TimeUnit timeUnit) {
        return FoliaSchedulerWrapper.wrap(this.globalRegionScheduler.runAtFixedRate((Plugin)this.rosePlugin, task -> runnable.run(), FoliaSchedulerWrapper.fix(RoseGardenUtils.timeUnitToTicks(delay, timeUnit)), FoliaSchedulerWrapper.fix(RoseGardenUtils.timeUnitToTicks(period, timeUnit))));
    }

    @Override
    public dev.rosewood.rosestacker.lib.rosegarden.scheduler.task.ScheduledTask runTaskTimerAsync(Runnable runnable, long delay, long period) {
        return FoliaSchedulerWrapper.wrap(this.asyncScheduler.runAtFixedRate((Plugin)this.rosePlugin, task -> runnable.run(), FoliaSchedulerWrapper.fix(FoliaSchedulerWrapper.ticksToMillis(delay)), FoliaSchedulerWrapper.fix(FoliaSchedulerWrapper.ticksToMillis(period)), TimeUnit.MILLISECONDS));
    }

    @Override
    public dev.rosewood.rosestacker.lib.rosegarden.scheduler.task.ScheduledTask runTaskTimerAsync(Runnable runnable, long delay, long period, TimeUnit timeUnit) {
        return FoliaSchedulerWrapper.wrap(this.asyncScheduler.runAtFixedRate((Plugin)this.rosePlugin, task -> runnable.run(), FoliaSchedulerWrapper.fix(delay), FoliaSchedulerWrapper.fix(period), timeUnit));
    }

    @Override
    public dev.rosewood.rosestacker.lib.rosegarden.scheduler.task.ScheduledTask runTaskAtLocation(Location location, Runnable runnable) {
        return FoliaSchedulerWrapper.wrap(this.regionScheduler.run((Plugin)this.rosePlugin, location, task -> runnable.run()));
    }

    @Override
    public dev.rosewood.rosestacker.lib.rosegarden.scheduler.task.ScheduledTask runTaskAtLocationLater(Location location, Runnable runnable, long delay) {
        return FoliaSchedulerWrapper.wrap(this.regionScheduler.runDelayed((Plugin)this.rosePlugin, location, task -> runnable.run(), FoliaSchedulerWrapper.fix(delay)));
    }

    @Override
    public dev.rosewood.rosestacker.lib.rosegarden.scheduler.task.ScheduledTask runTaskAtLocationLater(Location location, Runnable runnable, long delay, TimeUnit timeUnit) {
        return FoliaSchedulerWrapper.wrap(this.regionScheduler.runDelayed((Plugin)this.rosePlugin, location, task -> runnable.run(), FoliaSchedulerWrapper.fix(RoseGardenUtils.timeUnitToTicks(delay, timeUnit))));
    }

    @Override
    public dev.rosewood.rosestacker.lib.rosegarden.scheduler.task.ScheduledTask runTaskTimerAtLocation(Location location, Runnable runnable, long delay, long period) {
        return FoliaSchedulerWrapper.wrap(this.regionScheduler.runAtFixedRate((Plugin)this.rosePlugin, location, task -> runnable.run(), FoliaSchedulerWrapper.fix(delay), FoliaSchedulerWrapper.fix(period)));
    }

    @Override
    public dev.rosewood.rosestacker.lib.rosegarden.scheduler.task.ScheduledTask runTaskTimerAtLocation(Location location, Runnable runnable, long delay, long period, TimeUnit timeUnit) {
        return FoliaSchedulerWrapper.wrap(this.regionScheduler.runAtFixedRate((Plugin)this.rosePlugin, location, task -> runnable.run(), FoliaSchedulerWrapper.fix(RoseGardenUtils.timeUnitToTicks(delay, timeUnit)), FoliaSchedulerWrapper.fix(RoseGardenUtils.timeUnitToTicks(period, timeUnit))));
    }

    @Override
    public dev.rosewood.rosestacker.lib.rosegarden.scheduler.task.ScheduledTask runTaskAtEntity(Entity entity, Runnable runnable) {
        return FoliaSchedulerWrapper.wrap(entity.getScheduler().run((Plugin)this.rosePlugin, task -> runnable.run(), null));
    }

    @Override
    public dev.rosewood.rosestacker.lib.rosegarden.scheduler.task.ScheduledTask runTaskAtEntityLater(Entity entity, Runnable runnable, long delay) {
        return FoliaSchedulerWrapper.wrap(entity.getScheduler().runDelayed((Plugin)this.rosePlugin, task -> runnable.run(), null, FoliaSchedulerWrapper.fix(delay)));
    }

    @Override
    public dev.rosewood.rosestacker.lib.rosegarden.scheduler.task.ScheduledTask runTaskAtEntityLater(Entity entity, Runnable runnable, long delay, TimeUnit timeUnit) {
        return FoliaSchedulerWrapper.wrap(entity.getScheduler().runDelayed((Plugin)this.rosePlugin, task -> runnable.run(), null, FoliaSchedulerWrapper.fix(RoseGardenUtils.timeUnitToTicks(delay, timeUnit))));
    }

    @Override
    public dev.rosewood.rosestacker.lib.rosegarden.scheduler.task.ScheduledTask runTaskTimerAtEntity(Entity entity, Runnable runnable, long delay, long period) {
        return FoliaSchedulerWrapper.wrap(entity.getScheduler().runAtFixedRate((Plugin)this.rosePlugin, task -> runnable.run(), null, FoliaSchedulerWrapper.fix(delay), FoliaSchedulerWrapper.fix(period)));
    }

    @Override
    public dev.rosewood.rosestacker.lib.rosegarden.scheduler.task.ScheduledTask runTaskTimerAtEntity(Entity entity, Runnable runnable, long delay, long period, TimeUnit timeUnit) {
        return FoliaSchedulerWrapper.wrap(entity.getScheduler().runAtFixedRate((Plugin)this.rosePlugin, task -> runnable.run(), null, FoliaSchedulerWrapper.fix(RoseGardenUtils.timeUnitToTicks(delay, timeUnit)), FoliaSchedulerWrapper.fix(RoseGardenUtils.timeUnitToTicks(period, timeUnit))));
    }

    @Override
    public void cancelAllTasks() {
        this.globalRegionScheduler.cancelTasks((Plugin)this.rosePlugin);
        this.asyncScheduler.cancelTasks((Plugin)this.rosePlugin);
    }

    private static dev.rosewood.rosestacker.lib.rosegarden.scheduler.task.ScheduledTask wrap(ScheduledTask foliaTask) {
        return new FoliaScheduledTask(foliaTask);
    }

    private static long fix(long delay) {
        return delay > 0L ? delay : 1L;
    }

    private static long ticksToMillis(long ticks) {
        return ticks * 50L;
    }
}

