/*
 * Decompiled with CFR 0.152.
 */
package dev.rosewood.rosestacker.lib.rosegarden.utils;

import dev.rosewood.rosestacker.lib.rosegarden.utils.NMSUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;

public final class HexUtils {
    private static final int CHARS_UNTIL_LOOP = 30;
    private static final Pattern RAINBOW_PATTERN = Pattern.compile("<(?<type>rainbow|r)(#(?<speed>\\d+))?(:(?<saturation>\\d*\\.?\\d+))?(:(?<brightness>\\d*\\.?\\d+))?(:(?<loop>l|L|loop))?>");
    private static final Pattern GRADIENT_PATTERN = Pattern.compile("<(?<type>gradient|g)(#(?<speed>\\d+))?(?<hex>(:#([A-Fa-f0-9]{6}|[A-Fa-f0-9]{3})){2,})(:(?<loop>l|L|loop))?>");
    private static final List<Pattern> HEX_PATTERNS = Arrays.asList(Pattern.compile("<#([A-Fa-f0-9]){6}>"), Pattern.compile("\\{#([A-Fa-f0-9]){6}}"), Pattern.compile("&#([A-Fa-f0-9]){6}"), Pattern.compile("#([A-Fa-f0-9]){6}"));
    private static final Pattern STOP = Pattern.compile("<(rainbow|r)(#(\\d+))?(:(\\d*\\.?\\d+))?(:(\\d*\\.?\\d+))?(:(l|L|loop))?>|<(gradient|g)(#(\\d+))?((:#([A-Fa-f0-9]{6}|[A-Fa-f0-9]{3})){2,})(:(l|L|loop))?>|(&[a-f0-9r])|<#([A-Fa-f0-9]){6}>|\\{#([A-Fa-f0-9]){6}}|&#([A-Fa-f0-9]){6}|#([A-Fa-f0-9]){6}|\u00a7");

    private HexUtils() {
    }

    private static String getCaptureGroup(Matcher matcher, String group) {
        try {
            return matcher.group(group);
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            return null;
        }
    }

    public static void sendMessage(CommandSender sender, String message) {
        sender.sendMessage(HexUtils.colorify(message));
    }

    public static String colorify(String message) {
        String parsed = message;
        parsed = HexUtils.parseRainbow(parsed);
        parsed = HexUtils.parseGradients(parsed);
        parsed = HexUtils.parseHex(parsed);
        parsed = HexUtils.parseLegacy(parsed);
        return parsed;
    }

    public static String parseRainbow(String message) {
        String parsed = message;
        Matcher matcher = RAINBOW_PATTERN.matcher(parsed);
        while (matcher.find()) {
            String brightnessGroup;
            String saturationGroup;
            StringBuilder parsedRainbow = new StringBuilder();
            int speed = -1;
            float saturation = 1.0f;
            float brightness = 1.0f;
            boolean looping = HexUtils.getCaptureGroup(matcher, "looping") != null;
            String speedGroup = HexUtils.getCaptureGroup(matcher, "speed");
            if (speedGroup != null) {
                try {
                    speed = Integer.parseInt(speedGroup);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if ((saturationGroup = HexUtils.getCaptureGroup(matcher, "saturation")) != null) {
                try {
                    saturation = Float.parseFloat(saturationGroup);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if ((brightnessGroup = HexUtils.getCaptureGroup(matcher, "brightness")) != null) {
                try {
                    brightness = Float.parseFloat(brightnessGroup);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            int stop = HexUtils.findStop(parsed, matcher.end());
            String content = parsed.substring(matcher.end(), stop);
            int contentLength = content.length();
            char[] chars = content.toCharArray();
            for (int i = 0; i < chars.length - 1; ++i) {
                if (chars[i] != '&' || "KkLlMmNnOoRr".indexOf(chars[i + 1]) <= -1) continue;
                contentLength -= 2;
            }
            int length = looping ? Math.min(contentLength, 30) : contentLength;
            Rainbow rainbow = speed == -1 ? new Rainbow(length, saturation, brightness) : new AnimatedRainbow(length, saturation, brightness, speed);
            String compoundedFormat = "";
            for (int i = 0; i < chars.length; ++i) {
                char next;
                ChatColor color;
                char c = chars[i];
                if (c == '&' && i + 1 < chars.length && (color = ChatColor.getByChar((char)(next = chars[i + 1]))) != null && color.isFormat()) {
                    compoundedFormat = compoundedFormat + String.valueOf('\u00a7') + next;
                    ++i;
                    continue;
                }
                parsedRainbow.append(rainbow.nextChatColor()).append(compoundedFormat).append(c);
            }
            String before = parsed.substring(0, matcher.start());
            String after = parsed.substring(stop);
            parsed = before + parsedRainbow + after;
            matcher = RAINBOW_PATTERN.matcher(parsed);
        }
        return parsed;
    }

    public static String parseGradients(String message) {
        String parsed = message;
        Matcher matcher = GRADIENT_PATTERN.matcher(parsed);
        while (matcher.find()) {
            StringBuilder parsedGradient = new StringBuilder();
            int speed = -1;
            boolean looping = HexUtils.getCaptureGroup(matcher, "loop") != null;
            List<Color> hexSteps = Arrays.stream(HexUtils.getCaptureGroup(matcher, "hex").substring(1).split(":")).map(x -> x.length() != 4 ? x : String.format("#%s%s%s%s%s%s", Character.valueOf(x.charAt(1)), Character.valueOf(x.charAt(1)), Character.valueOf(x.charAt(2)), Character.valueOf(x.charAt(2)), Character.valueOf(x.charAt(3)), Character.valueOf(x.charAt(3)))).map(Color::decode).collect(Collectors.toList());
            String speedGroup = HexUtils.getCaptureGroup(matcher, "speed");
            if (speedGroup != null) {
                try {
                    speed = Integer.parseInt(speedGroup);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            int stop = HexUtils.findStop(parsed, matcher.end());
            String content = parsed.substring(matcher.end(), stop);
            int contentLength = content.length();
            char[] chars = content.toCharArray();
            for (int i = 0; i < chars.length - 1; ++i) {
                if (chars[i] != '&' || "KkLlMmNnOoRr".indexOf(chars[i + 1]) <= -1) continue;
                contentLength -= 2;
            }
            int length = looping ? Math.min(contentLength, 30) : contentLength;
            Gradient gradient = speed == -1 ? new Gradient(hexSteps, length) : new AnimatedGradient(hexSteps, length, speed);
            String compoundedFormat = "";
            for (int i = 0; i < chars.length; ++i) {
                char next;
                ChatColor color;
                char c = chars[i];
                if (c == '&' && i + 1 < chars.length && (color = ChatColor.getByChar((char)(next = chars[i + 1]))) != null && color.isFormat()) {
                    compoundedFormat = compoundedFormat + String.valueOf('\u00a7') + next;
                    ++i;
                    continue;
                }
                parsedGradient.append(gradient.nextChatColor()).append(compoundedFormat).append(c);
            }
            String before = parsed.substring(0, matcher.start());
            String after = parsed.substring(stop);
            parsed = before + parsedGradient + after;
            matcher = GRADIENT_PATTERN.matcher(parsed);
        }
        return parsed;
    }

    public static String parseHex(String message) {
        String parsed = message;
        for (Pattern pattern : HEX_PATTERNS) {
            Matcher matcher = pattern.matcher(parsed);
            while (matcher.find()) {
                String color = HexUtils.translateHex(HexUtils.cleanHex(matcher.group())).toString();
                String before = parsed.substring(0, matcher.start());
                String after = parsed.substring(matcher.end());
                parsed = before + color + after;
                matcher = pattern.matcher(parsed);
            }
        }
        return parsed;
    }

    public static String parseLegacy(String message) {
        return net.md_5.bungee.api.ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }

    private static int findStop(String content, int searchAfter) {
        Matcher matcher = STOP.matcher(content);
        while (matcher.find()) {
            if (matcher.start() <= searchAfter) continue;
            return matcher.start();
        }
        return content.length();
    }

    private static String cleanHex(String hex) {
        if (hex.startsWith("<") || hex.startsWith("{")) {
            return hex.substring(1, hex.length() - 1);
        }
        if (hex.startsWith("&")) {
            return hex.substring(1);
        }
        return hex;
    }

    public static net.md_5.bungee.api.ChatColor translateHex(String hex) {
        if (NMSUtil.getVersionNumber() >= 16) {
            return net.md_5.bungee.api.ChatColor.of((String)hex);
        }
        return HexUtils.translateHex(Color.decode(hex));
    }

    public static net.md_5.bungee.api.ChatColor translateHex(Color color) {
        if (NMSUtil.getVersionNumber() >= 16) {
            return net.md_5.bungee.api.ChatColor.of((Color)color);
        }
        int minDist = Integer.MAX_VALUE;
        net.md_5.bungee.api.ChatColor legacy = net.md_5.bungee.api.ChatColor.WHITE;
        for (ChatColorHexMapping mapping : ChatColorHexMapping.values()) {
            int b;
            int g;
            int r = mapping.getRed() - color.getRed();
            int dist = r * r + (g = mapping.getGreen() - color.getGreen()) * g + (b = mapping.getBlue() - color.getBlue()) * b;
            if (dist >= minDist) continue;
            minDist = dist;
            legacy = mapping.getChatColor();
        }
        return legacy;
    }

    public static class Rainbow
    implements ColorGenerator {
        protected final float hueStep;
        protected final float saturation;
        protected final float brightness;
        protected float hue;

        public Rainbow(int totalColors, float saturation, float brightness) {
            if (totalColors < 1) {
                totalColors = 1;
            }
            this.hueStep = 1.0f / (float)totalColors;
            this.saturation = Math.max(0.0f, Math.min(1.0f, saturation));
            this.brightness = Math.max(0.0f, Math.min(1.0f, brightness));
            this.hue = 0.0f;
        }

        @Override
        public net.md_5.bungee.api.ChatColor nextChatColor() {
            return HexUtils.translateHex(this.nextColor());
        }

        @Override
        public Color nextColor() {
            Color color = Color.getHSBColor(this.hue, this.saturation, this.brightness);
            this.hue += this.hueStep;
            return color;
        }
    }

    public static class AnimatedRainbow
    extends Rainbow {
        public AnimatedRainbow(int totalColors, float saturation, float brightness, int speed) {
            super(totalColors, saturation, brightness);
            this.hue = (float)(Math.floor((double)System.currentTimeMillis() / 50.0) / 360.0 * (double)speed % 1.0);
        }
    }

    public static interface ColorGenerator {
        public net.md_5.bungee.api.ChatColor nextChatColor();

        public Color nextColor();
    }

    public static class Gradient
    implements ColorGenerator {
        private final List<TwoStopGradient> gradients;
        private final int steps;
        protected long step;

        public Gradient(List<Color> colors, int steps) {
            if (colors.size() < 2) {
                throw new IllegalArgumentException("Must provide at least 2 colors");
            }
            this.gradients = new ArrayList<TwoStopGradient>();
            this.steps = steps;
            this.step = 0L;
            float increment = (float)(this.steps - 1) / (float)(colors.size() - 1);
            for (int i = 0; i < colors.size() - 1; ++i) {
                this.gradients.add(new TwoStopGradient(colors.get(i), colors.get(i + 1), increment * (float)i, increment * (float)(i + 1)));
            }
        }

        @Override
        public net.md_5.bungee.api.ChatColor nextChatColor() {
            if (NMSUtil.getVersionNumber() < 16 || this.steps <= 1) {
                return HexUtils.translateHex(this.gradients.get(0).colorAt(0));
            }
            return HexUtils.translateHex(this.nextColor());
        }

        @Override
        public Color nextColor() {
            Color color;
            int adjustedStep = this.adjustStep(this.step, this.steps);
            if (this.gradients.size() < 2) {
                color = this.gradients.get(0).colorAt(adjustedStep);
            } else {
                float segment = (float)this.steps / (float)this.gradients.size();
                int index = (int)Math.min(Math.floor((float)adjustedStep / segment), (double)(this.gradients.size() - 1));
                color = this.gradients.get(index).colorAt(adjustedStep);
            }
            ++this.step;
            return color;
        }

        private int adjustStep(long t, int steps) {
            int period = steps * 2;
            int modT = (int)(t % (long)period);
            if (modT <= steps) {
                return modT;
            }
            return period - modT;
        }

        public static class TwoStopGradient {
            private final Color startColor;
            private final Color endColor;
            private final float lowerRange;
            private final float upperRange;

            private TwoStopGradient(Color startColor, Color endColor, float lowerRange, float upperRange) {
                this.startColor = startColor;
                this.endColor = endColor;
                this.lowerRange = lowerRange;
                this.upperRange = upperRange;
            }

            public Color colorAt(int step) {
                return new Color(this.calculateHexPiece(step, this.startColor.getRed(), this.endColor.getRed()), this.calculateHexPiece(step, this.startColor.getGreen(), this.endColor.getGreen()), this.calculateHexPiece(step, this.startColor.getBlue(), this.endColor.getBlue()));
            }

            private int calculateHexPiece(int step, int channelStart, int channelEnd) {
                float range = this.upperRange - this.lowerRange;
                if (range == 0.0f) {
                    return channelStart;
                }
                float interval = (float)(channelEnd - channelStart) / range;
                return Math.min(Math.max(Math.round(interval * ((float)step - this.lowerRange) + (float)channelStart), 0), 255);
            }
        }
    }

    public static class AnimatedGradient
    extends Gradient {
        public AnimatedGradient(List<Color> colors, int steps, int speed) {
            super(colors, steps);
            this.step = System.currentTimeMillis() / (long)speed;
        }
    }

    public static enum ChatColorHexMapping {
        BLACK(0, net.md_5.bungee.api.ChatColor.BLACK),
        DARK_BLUE(170, net.md_5.bungee.api.ChatColor.DARK_BLUE),
        DARK_GREEN(43520, net.md_5.bungee.api.ChatColor.DARK_GREEN),
        DARK_AQUA(43690, net.md_5.bungee.api.ChatColor.DARK_AQUA),
        DARK_RED(0xAA0000, net.md_5.bungee.api.ChatColor.DARK_RED),
        DARK_PURPLE(0xAA00AA, net.md_5.bungee.api.ChatColor.DARK_PURPLE),
        GOLD(0xFFAA00, net.md_5.bungee.api.ChatColor.GOLD),
        GRAY(0xAAAAAA, net.md_5.bungee.api.ChatColor.GRAY),
        DARK_GRAY(0x555555, net.md_5.bungee.api.ChatColor.DARK_GRAY),
        BLUE(0x5555FF, net.md_5.bungee.api.ChatColor.BLUE),
        GREEN(0x55FF55, net.md_5.bungee.api.ChatColor.GREEN),
        AQUA(0x55FFFF, net.md_5.bungee.api.ChatColor.AQUA),
        RED(0xFF5555, net.md_5.bungee.api.ChatColor.RED),
        LIGHT_PURPLE(0xFF55FF, net.md_5.bungee.api.ChatColor.LIGHT_PURPLE),
        YELLOW(0xFFFF55, net.md_5.bungee.api.ChatColor.YELLOW),
        WHITE(0xFFFFFF, net.md_5.bungee.api.ChatColor.WHITE);

        private final int r;
        private final int g;
        private final int b;
        private final net.md_5.bungee.api.ChatColor chatColor;

        private ChatColorHexMapping(int hex, net.md_5.bungee.api.ChatColor chatColor) {
            this.r = hex >> 16 & 0xFF;
            this.g = hex >> 8 & 0xFF;
            this.b = hex & 0xFF;
            this.chatColor = chatColor;
        }

        public int getRed() {
            return this.r;
        }

        public int getGreen() {
            return this.g;
        }

        public int getBlue() {
            return this.b;
        }

        public net.md_5.bungee.api.ChatColor getChatColor() {
            return this.chatColor;
        }
    }
}

