/*
 * Decompiled with CFR 0.152.
 */
package dev.rosewood.rosestacker.lib.rosegarden.utils;

import dev.rosewood.rosestacker.lib.rosegarden.RosePlugin;
import dev.rosewood.rosestacker.lib.rosegarden.utils.HexUtils;
import dev.rosewood.rosestacker.lib.rosegarden.utils.StringPlaceholders;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.bukkit.command.CommandSender;

public final class RoseGardenUtils {
    private static final List<String> SNAPSHOT_IDENTIFIERS = Arrays.asList("snapshot", "beta", "alpha", "rc");
    private static final String[] SNAPSHOT_HEADER = new String[]{"================================================", " You are currently running a DEVELOPMENT BUILD!", " These types of builds are not fully tested and", "   may contain experimental features or bugs!", "================================================"};
    public static final String GRADIENT = "<g:#8A2387:#E94057:#F27121>";
    public static final String PREFIX = "&7[<g:#8A2387:#E94057:#F27121>RoseGarden&7] ";
    private static Logger logger;

    private RoseGardenUtils() {
    }

    public static boolean checkSnapshotVersion(RosePlugin rosePlugin) {
        String currentVersion = rosePlugin.getDescription().getVersion().toLowerCase();
        if (SNAPSHOT_IDENTIFIERS.stream().anyMatch(currentVersion::contains)) {
            for (String line : SNAPSHOT_HEADER) {
                rosePlugin.getLogger().warning(line);
            }
            return true;
        }
        return false;
    }

    public static boolean containsConfigSpecialCharacters(String string) {
        for (char c : string.toCharArray()) {
            if (c == '\n' || ' ' <= c && c <= '~' || !(c == '\u0085' || c >= '\u00a0' && c <= '\ud7ff' || c >= '\ue000' && c <= '\ufffd') && (c < '\u10000' || c > '\u10ffff')) continue;
            return true;
        }
        return false;
    }

    public static boolean isUpdateAvailable(String latest, String current) {
        int[] currentSplit;
        if (latest == null || current == null) {
            return false;
        }
        int[] latestSplit = Arrays.stream(latest.replaceAll("[^0-9.]", "").split(Pattern.quote("."))).mapToInt(Integer::parseInt).toArray();
        if (latestSplit.length > (currentSplit = Arrays.stream(current.replaceAll("[^0-9.]", "").split(Pattern.quote("."))).mapToInt(Integer::parseInt).toArray()).length) {
            currentSplit = Arrays.copyOf(currentSplit, latestSplit.length);
        } else if (currentSplit.length > latestSplit.length) {
            latestSplit = Arrays.copyOf(latestSplit, currentSplit.length);
        }
        for (int i = 0; i < latestSplit.length; ++i) {
            if (latestSplit[i] > currentSplit[i]) {
                return true;
            }
            if (currentSplit[i] > latestSplit[i]) break;
        }
        return false;
    }

    public static boolean isRelocated() {
        String defaultPackage = "dev,rosewood,rosegarden".replace(",", ".");
        return !RosePlugin.class.getPackage().getName().startsWith(defaultPackage);
    }

    public static void sendMessage(CommandSender recipient, String message) {
        recipient.sendMessage(HexUtils.colorify(PREFIX + message));
    }

    public static void sendMessage(CommandSender recipient, String message, StringPlaceholders placeholders) {
        RoseGardenUtils.sendMessage(recipient, placeholders.apply(message));
    }

    public static long timeUnitToTicks(long value, TimeUnit timeUnit) {
        return Math.round((double)timeUnit.toMillis(value) / 50.0);
    }
}

