/*
 * Decompiled with CFR 0.152.
 */
package dev.rosewood.rosestacker.listener;

import dev.rosewood.rosestacker.config.SettingKey;
import dev.rosewood.rosestacker.lib.rosegarden.RosePlugin;
import dev.rosewood.rosestacker.lib.rosegarden.utils.EntitySpawnUtil;
import dev.rosewood.rosestacker.lib.rosegarden.utils.NMSUtil;
import dev.rosewood.rosestacker.manager.StackManager;
import dev.rosewood.rosestacker.stack.StackedEntity;
import dev.rosewood.rosestacker.stack.settings.EntityStackSettings;
import dev.rosewood.rosestacker.utils.PersistentDataUtils;
import dev.rosewood.rosestacker.utils.StackerUtils;
import dev.rosewood.rosestacker.utils.ThreadUtils;
import io.papermc.paper.entity.CollarColorable;
import org.bukkit.Bukkit;
import org.bukkit.EntityEffect;
import org.bukkit.GameMode;
import org.bukkit.Statistic;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Cat;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Fox;
import org.bukkit.entity.Frog;
import org.bukkit.entity.Horse;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Llama;
import org.bukkit.entity.MushroomCow;
import org.bukkit.entity.Panda;
import org.bukkit.entity.Player;
import org.bukkit.entity.Rabbit;
import org.bukkit.entity.Tameable;
import org.bukkit.entity.Wolf;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityBreedEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.Colorable;

public class BreedingListener
implements Listener {
    private final RosePlugin rosePlugin;

    public BreedingListener(RosePlugin rosePlugin) {
        this.rosePlugin = rosePlugin;
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onBreed(PlayerInteractEntityEvent event) {
        int totalChildren;
        Animals animal;
        Entity entity = event.getRightClicked();
        if (!(entity instanceof Animals) || !(animal = (Animals)entity).canBreed()) {
            return;
        }
        StackManager stackManager = this.rosePlugin.getManager(StackManager.class);
        if (!stackManager.isEntityStackingEnabled()) {
            return;
        }
        StackedEntity stackedEntity = stackManager.getStackedEntity((LivingEntity)animal);
        if (stackedEntity == null) {
            return;
        }
        Player player = event.getPlayer();
        EntityStackSettings stackSettings = stackedEntity.getStackSettings();
        ItemStack breedingItem = player.getInventory().getItem(event.getHand());
        if (breedingItem == null || !stackSettings.getEntityTypeData().isValidBreedingMaterial(breedingItem.getType()) || player.getGameMode() != GameMode.CREATIVE && breedingItem.getAmount() < 2) {
            return;
        }
        if (PersistentDataUtils.isAiDisabled((LivingEntity)animal) && SettingKey.SPAWNER_DISABLE_MOB_AI_OPTIONS_DISABLE_BREEDING.get().booleanValue()) {
            event.setCancelled(true);
            return;
        }
        if (!SettingKey.ENTITY_CUMULATIVE_BREEDING.get().booleanValue()) {
            return;
        }
        int stackSize = stackedEntity.getStackSize();
        if (stackSize < 2) {
            return;
        }
        Class entityClass = animal.getType().getEntityClass();
        if (entityClass == null) {
            return;
        }
        event.setCancelled(true);
        if (player.getGameMode() != GameMode.CREATIVE) {
            int requiredFood = Math.min(stackSize, breedingItem.getAmount());
            breedingItem.setAmount(breedingItem.getAmount() - requiredFood);
            totalChildren = requiredFood / 2;
        } else {
            totalChildren = Math.min(stackSize / 2, breedingItem.getMaxStackSize() / 2);
        }
        animal.setAge(6000);
        animal.setBreedCause(player.getUniqueId());
        animal.playEffect(EntityEffect.LOVE_HEARTS);
        boolean disableAi = PersistentDataUtils.isAiDisabled((LivingEntity)animal);
        ThreadUtils.runSyncDelayed(() -> {
            ItemStack breedingItemCopy = breedingItem.clone();
            breedingItemCopy.setAmount(1);
            boolean callEvents = SettingKey.ENTITY_CUMULATIVE_BREEDING_TRIGGER_BREED_EVENT.get();
            int totalExperience = callEvents ? 0 : totalChildren * 7;
            boolean modern = NMSUtil.getVersionNumber() >= 21 && NMSUtil.isPaper();
            for (int i = 0; i < totalChildren; ++i) {
                LivingEntity child = modern ? (LivingEntity)animal.getLocation().getWorld().spawn(animal.getLocation(), entityClass, CreatureSpawnEvent.SpawnReason.BREEDING, x -> {
                    Ageable baby = (Ageable)x;
                    baby.setBaby();
                    this.transferEntityProperties((LivingEntity)animal, (LivingEntity)baby);
                    if (disableAi) {
                        PersistentDataUtils.removeEntityAi((LivingEntity)baby);
                    }
                }) : (LivingEntity)EntitySpawnUtil.spawn(animal.getLocation(), entityClass, x -> {
                    Ageable baby = (Ageable)x;
                    baby.setBaby();
                    this.transferEntityProperties((LivingEntity)animal, (LivingEntity)baby);
                    if (disableAi) {
                        PersistentDataUtils.removeEntityAi((LivingEntity)baby);
                    }
                });
                if (!callEvents) continue;
                EntityBreedEvent breedEvent = new EntityBreedEvent(child, (LivingEntity)animal, (LivingEntity)animal, (LivingEntity)player, breedingItemCopy.clone(), 7);
                Bukkit.getPluginManager().callEvent((Event)breedEvent);
                if (breedEvent.isCancelled()) {
                    child.remove();
                    breedingItem.setAmount(breedingItem.getAmount() + 2);
                    continue;
                }
                totalExperience += breedEvent.getExperience();
            }
            StackerUtils.dropExperience(animal.getLocation(), totalChildren, totalExperience, totalChildren);
            player.incrementStatistic(Statistic.ANIMALS_BRED, totalChildren);
        }, 30L);
    }

    private void transferEntityProperties(LivingEntity parent, LivingEntity child) {
        if (parent instanceof Colorable) {
            Colorable colorableParent = (Colorable)parent;
            if (child instanceof Colorable) {
                Colorable colorableChild = (Colorable)child;
                colorableChild.setColor(colorableParent.getColor());
            }
        }
        if (parent instanceof Tameable) {
            Tameable tameableParent = (Tameable)parent;
            if (child instanceof Tameable) {
                Tameable tameableChild = (Tameable)child;
                tameableChild.setOwner(tameableParent.getOwner());
            }
        }
        if (NMSUtil.isPaper() && NMSUtil.getVersionNumber() >= 19 && parent instanceof CollarColorable) {
            CollarColorable collarColorableParent = (CollarColorable)parent;
            if (child instanceof CollarColorable) {
                CollarColorable collarColorableChild = (CollarColorable)child;
                collarColorableChild.setCollarColor(collarColorableParent.getCollarColor());
            }
        }
        if (parent instanceof Cat) {
            Cat parentCat = (Cat)parent;
            if (child instanceof Cat) {
                Cat childCat = (Cat)child;
                childCat.setCatType(parentCat.getCatType());
            }
        }
        if (parent instanceof Fox) {
            Fox parentFox = (Fox)parent;
            if (child instanceof Fox) {
                Fox childFox = (Fox)child;
                childFox.setFoxType(parentFox.getFoxType());
            }
        }
        if (NMSUtil.getVersionNumber() >= 19 && parent instanceof Frog) {
            Frog parentFrog = (Frog)parent;
            if (child instanceof Frog) {
                Frog childFrog = (Frog)child;
                childFrog.setVariant(parentFrog.getVariant());
            }
        }
        if (parent instanceof Horse) {
            Horse parentHorse = (Horse)parent;
            if (child instanceof Horse) {
                Horse childHorse = (Horse)child;
                childHorse.setStyle(parentHorse.getStyle());
                childHorse.setColor(parentHorse.getColor());
            }
        }
        if (parent instanceof MushroomCow) {
            MushroomCow parentMooshroom = (MushroomCow)parent;
            if (child instanceof MushroomCow) {
                MushroomCow childMooshroom = (MushroomCow)child;
                childMooshroom.setVariant(parentMooshroom.getVariant());
            }
        }
        if (parent instanceof Panda) {
            Panda parentPanda = (Panda)parent;
            if (child instanceof Panda) {
                Panda childPanda = (Panda)child;
                childPanda.setMainGene(parentPanda.getMainGene());
            }
        }
        if (parent instanceof Rabbit) {
            Rabbit parentRabbit = (Rabbit)parent;
            if (child instanceof Rabbit) {
                Rabbit childRabbit = (Rabbit)child;
                childRabbit.setRabbitType(parentRabbit.getRabbitType());
            }
        }
        if (parent instanceof Llama) {
            Llama parentLlama = (Llama)parent;
            if (child instanceof Llama) {
                Llama childLlama = (Llama)child;
                childLlama.setColor(parentLlama.getColor());
            }
        }
        if ((NMSUtil.getVersionNumber() > 20 || NMSUtil.getVersionNumber() == 20 && NMSUtil.getMinorVersionNumber() >= 6) && parent instanceof Wolf) {
            Wolf parentWolf = (Wolf)parent;
            if (child instanceof Wolf) {
                Wolf childWolf = (Wolf)child;
                childWolf.setVariant(parentWolf.getVariant());
            }
        }
    }
}

