/*
 * Decompiled with CFR 0.152.
 */
package dev.rosewood.rosestacker.listener;

import dev.rosewood.rosestacker.RoseStacker;
import dev.rosewood.rosestacker.config.SettingKey;
import dev.rosewood.rosestacker.event.AsyncEntityDeathEvent;
import dev.rosewood.rosestacker.lib.guiframework.framework.util.GuiUtil;
import dev.rosewood.rosestacker.lib.rosegarden.RosePlugin;
import dev.rosewood.rosestacker.lib.rosegarden.compatibility.CompatibilityAdapter;
import dev.rosewood.rosestacker.lib.rosegarden.compatibility.handler.ShearedHandler;
import dev.rosewood.rosestacker.manager.EntityCacheManager;
import dev.rosewood.rosestacker.manager.StackManager;
import dev.rosewood.rosestacker.manager.StackSettingManager;
import dev.rosewood.rosestacker.nms.storage.EntityDataEntry;
import dev.rosewood.rosestacker.nms.storage.StackedEntityDataStorageType;
import dev.rosewood.rosestacker.stack.StackedEntity;
import dev.rosewood.rosestacker.stack.StackedItem;
import dev.rosewood.rosestacker.stack.StackedSpawner;
import dev.rosewood.rosestacker.stack.settings.EntityStackSettings;
import dev.rosewood.rosestacker.stack.settings.ItemStackSettings;
import dev.rosewood.rosestacker.stack.settings.MultikillBound;
import dev.rosewood.rosestacker.stack.settings.SpawnerStackSettings;
import dev.rosewood.rosestacker.utils.EntityUtils;
import dev.rosewood.rosestacker.utils.ItemUtils;
import dev.rosewood.rosestacker.utils.PersistentDataUtils;
import dev.rosewood.rosestacker.utils.StackerUtils;
import dev.rosewood.rosestacker.utils.ThreadUtils;
import dev.rosewood.rosestacker.utils.VersionUtils;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Statistic;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Chicken;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Guardian;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.MushroomCow;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Sheep;
import org.bukkit.entity.Slime;
import org.bukkit.entity.Wither;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockShearEntityEvent;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityCombustByBlockEvent;
import org.bukkit.event.entity.EntityCombustByEntityEvent;
import org.bukkit.event.entity.EntityCombustEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityDropItemEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.EntityPortalEvent;
import org.bukkit.event.entity.EntitySpawnEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.EntityTeleportEvent;
import org.bukkit.event.entity.EntityTransformEvent;
import org.bukkit.event.entity.PigZapEvent;
import org.bukkit.event.entity.SheepRegrowWoolEvent;
import org.bukkit.event.entity.SpawnerSpawnEvent;
import org.bukkit.event.player.PlayerShearEntityEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

public class EntityListener
implements Listener {
    private static final Set<CreatureSpawnEvent.SpawnReason> DELAYED_SPAWN_REASONS = EnumSet.of(CreatureSpawnEvent.SpawnReason.BEEHIVE, CreatureSpawnEvent.SpawnReason.BUILD_IRONGOLEM, CreatureSpawnEvent.SpawnReason.BUILD_SNOWMAN, CreatureSpawnEvent.SpawnReason.BUILD_WITHER);
    private final RosePlugin rosePlugin;
    private final StackManager stackManager;
    private final StackSettingManager stackSettingManager;

    public EntityListener(RosePlugin rosePlugin) {
        this.rosePlugin = rosePlugin;
        this.stackManager = rosePlugin.getManager(StackManager.class);
        this.stackSettingManager = rosePlugin.getManager(StackSettingManager.class);
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onEntitySpawn(EntitySpawnEvent event) {
        Entity entity = event.getEntity();
        if (this.stackManager.isAreaDisabled(entity.getLocation())) {
            return;
        }
        if (!this.stackManager.isItemStackingEnabled() || this.stackManager.isEntityStackingTemporarilyDisabled()) {
            return;
        }
        if (entity instanceof Item) {
            Item item = (Item)entity;
            ItemStackSettings itemStackSettings = this.stackSettingManager.getItemStackSettings(item);
            if (itemStackSettings != null && !itemStackSettings.isStackingEnabled()) {
                return;
            }
            StackedItem stackedItem = this.stackManager.createItemStack(item, true);
            if (stackedItem == null || stackedItem.getStackSize() > 0) {
                this.rosePlugin.getManager(EntityCacheManager.class).preCacheEntity(entity);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onCreatureSpawn(CreatureSpawnEvent event) {
        LivingEntity entity = event.getEntity();
        if (this.stackManager.isAreaDisabled(entity.getLocation())) {
            return;
        }
        if (!this.stackManager.isEntityStackingEnabled() || this.stackManager.isEntityStackingTemporarilyDisabled()) {
            return;
        }
        Runnable task = () -> {
            this.rosePlugin.getManager(EntityCacheManager.class).preCacheEntity((Entity)entity);
            this.stackManager.createEntityStack(entity, !DELAYED_SPAWN_REASONS.contains(event.getSpawnReason()));
            PersistentDataUtils.applyDisabledAi(entity);
        };
        if (event.getSpawnReason() == CreatureSpawnEvent.SpawnReason.SPAWNER_EGG) {
            ThreadUtils.runSync(task);
        } else {
            task.run();
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onSpawnerSpawn(SpawnerSpawnEvent event) {
        boolean placedByPlayer;
        LivingEntity entity;
        block8: {
            block7: {
                Entity entity2 = event.getEntity();
                if (!(entity2 instanceof LivingEntity)) break block7;
                entity = (LivingEntity)entity2;
                if (event.getSpawner() != null) break block8;
            }
            return;
        }
        if (this.stackManager.isAreaDisabled(event.getEntity().getLocation())) {
            return;
        }
        this.rosePlugin.getManager(EntityCacheManager.class).preCacheEntity((Entity)entity);
        PersistentDataUtils.tagSpawnedFromSpawner((Entity)entity);
        if (this.stackManager.isEntityStackingEnabled() && !this.stackManager.isEntityStackingTemporarilyDisabled()) {
            this.stackManager.createEntityStack(entity, true);
        }
        SpawnerStackSettings stackSettings = this.stackSettingManager.getSpawnerStackSettings(event.getSpawner());
        StackedSpawner stackedSpawner = this.stackManager.getStackedSpawner(event.getSpawner().getBlock());
        if (stackedSpawner == null) {
            stackedSpawner = this.stackManager.createSpawnerStack(event.getSpawner().getBlock(), 1, false);
        }
        boolean bl = placedByPlayer = stackedSpawner != null && stackedSpawner.isPlacedByPlayer();
        if (stackSettings.isMobAIDisabled() && (!SettingKey.SPAWNER_DISABLE_MOB_AI_ONLY_PLAYER_PLACED.get().booleanValue() || placedByPlayer)) {
            PersistentDataUtils.removeEntityAi(entity);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onSecondarySpawnerSpawn(CreatureSpawnEvent event) {
        LivingEntity entity = event.getEntity();
        if (this.stackManager.isAreaDisabled(entity.getLocation())) {
            return;
        }
        if (EntityUtils.hasTrialSpawnerSpawnReason((Entity)entity)) {
            PersistentDataUtils.tagSpawnedFromTrialSpawner((Entity)entity);
            return;
        }
        if (EntityUtils.hasSpawnerSpawnReason((Entity)entity)) {
            if (PersistentDataUtils.isSpawnedFromSpawner((Entity)entity)) {
                return;
            }
            PersistentDataUtils.tagSpawnedFromSpawner((Entity)entity);
            SpawnerStackSettings stackSettings = this.stackSettingManager.getSpawnerStackSettings(entity.getType());
            if (stackSettings.isMobAIDisabled()) {
                PersistentDataUtils.removeEntityAi(entity);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onEntityTarget(EntityTargetEvent event) {
        boolean disableAttacking;
        Entity entity = event.getEntity();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        boolean bl = disableAttacking = event.getEntityType() == EntityType.WITHER && PersistentDataUtils.isAiDisabled((LivingEntity)((Wither)event.getEntity())) || SettingKey.SPAWNER_DISABLE_ATTACKING.get() != false && PersistentDataUtils.isSpawnedFromSpawner(event.getEntity());
        if (disableAttacking) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onEntityTeleport(EntityTeleportEvent event) {
        if (event.getEntityType() == EntityType.ENDERMAN && PersistentDataUtils.isAiDisabled((LivingEntity)((Enderman)event.getEntity()))) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onEntityTeleport(EntityPortalEvent event) {
        if (event.getTo() == null || event.getFrom().getWorld() == event.getTo().getWorld()) {
            return;
        }
        if (this.stackManager.isAreaDisabled(event.getEntity().getLocation())) {
            return;
        }
        Entity entity = event.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (!this.stackManager.isEntityStackingEnabled()) {
                return;
            }
            StackedEntity stackedEntity = this.stackManager.getStackedEntity(livingEntity);
            if (stackedEntity != null) {
                this.stackManager.changeStackingThread(livingEntity.getUniqueId(), stackedEntity, event.getFrom().getWorld(), event.getTo().getWorld());
                stackedEntity.updateDisplay();
            }
        } else if (entity instanceof Item) {
            Item item = (Item)entity;
            if (!this.stackManager.isItemStackingEnabled()) {
                return;
            }
            StackedItem stackedItem = this.stackManager.getStackedItem(item);
            if (stackedItem != null) {
                this.stackManager.changeStackingThread(item.getUniqueId(), stackedItem, event.getFrom().getWorld(), event.getTo().getWorld());
                stackedItem.updateDisplay();
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onEntityDamageByEntity(EntityDamageByEntityEvent event) {
        Projectile projectile;
        LivingEntity entity;
        block9: {
            block8: {
                Entity entity2;
                if (event.getEntity().getType() == EntityType.PLAYER && (event.getDamager() instanceof Guardian || event.getDamager() instanceof Slime) && PersistentDataUtils.isAiDisabled((LivingEntity)event.getDamager())) {
                    event.setCancelled(true);
                }
                if (!((entity2 = event.getEntity()) instanceof LivingEntity)) break block8;
                entity = (LivingEntity)entity2;
                if (event.getEntity().getType() != EntityType.PLAYER) break block9;
            }
            return;
        }
        if (!SettingKey.ENTITY_INSTANT_KILL_DISABLED_AI.get().booleanValue() || this.stackManager.isAreaDisabled(entity.getLocation()) || !PersistentDataUtils.isAiDisabled(entity)) {
            return;
        }
        Entity damager = event.getDamager();
        if (damager instanceof Projectile && !((projectile = (Projectile)damager).getShooter() instanceof Player) || !(damager instanceof Player)) {
            return;
        }
        AttributeInstance attributeInstance = entity.getAttribute(VersionUtils.MAX_HEALTH);
        if (attributeInstance != null) {
            event.setDamage(attributeInstance.getValue() * 2.0);
        } else {
            event.setDamage(entity.getHealth() * 2.0);
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onEntityDamage(EntityDamageEvent event) {
        LivingEntity entity;
        block10: {
            block9: {
                Entity entity2 = event.getEntity();
                if (!(entity2 instanceof LivingEntity)) break block9;
                entity = (LivingEntity)entity2;
                if (event.getEntity().getType() != EntityType.ARMOR_STAND && event.getEntity().getType() != EntityType.PLAYER) break block10;
            }
            return;
        }
        if (this.stackManager.isAreaDisabled(entity.getLocation())) {
            return;
        }
        if (!this.stackManager.isEntityStackingEnabled()) {
            return;
        }
        StackedEntity stackedEntity = this.stackManager.getStackedEntity(entity);
        if (stackedEntity == null || stackedEntity.getStackSize() == 1) {
            return;
        }
        if (!SettingKey.ENTITY_SHARE_DAMAGE_CONDITIONS.get().contains(event.getCause().name())) {
            return;
        }
        double damage = event.getFinalDamage();
        List<LivingEntity> killedEntities = stackedEntity.getDataStorage().removeIf(internal -> {
            if (internal.getHealth() - damage <= 0.0) {
                return true;
            }
            internal.setHealth(internal.getHealth() - damage);
            return false;
        });
        if (!killedEntities.isEmpty()) {
            stackedEntity.dropPartialStackLoot(killedEntities);
            Player killer = entity.getKiller();
            if (killer != null && killedEntities.size() - 1 > 0 && SettingKey.MISC_STACK_STATISTICS.get().booleanValue()) {
                killer.incrementStatistic(Statistic.KILL_ENTITY, entity.getType(), killedEntities.size() - 1);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onEntityCombust(EntityCombustEvent event) {
        Entity entity = event.getEntity();
        if (event instanceof EntityCombustByBlockEvent || event instanceof EntityCombustByEntityEvent || !(entity instanceof LivingEntity)) {
            return;
        }
        if (PersistentDataUtils.isAiDisabled((LivingEntity)entity) && !SettingKey.SPAWNER_DISABLE_MOB_AI_OPTIONS_UNDEAD_BURN_IN_DAYLIGHT.get().booleanValue()) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onEntityExplode(EntityExplodeEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof Creeper)) {
            return;
        }
        Creeper creeper = (Creeper)entity;
        StackManager stackManager = this.rosePlugin.getManager(StackManager.class);
        StackedEntity stackedEntity = stackManager.getStackedEntity((LivingEntity)creeper);
        if (stackedEntity == null) {
            return;
        }
        if (stackedEntity.getStackSettings().getSettingValue("explode-kill-entire-stack").getBoolean()) {
            stackManager.removeEntityStack(stackedEntity);
        } else {
            this.handleEntityDeath(null, (LivingEntity)creeper);
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onEntityDeath(EntityDeathEvent event) {
        if (!(event instanceof AsyncEntityDeathEvent)) {
            this.handleEntityDeath(event, event.getEntity());
        }
    }

    private void handleEntityDeath(EntityDeathEvent event, LivingEntity entity) {
        if (this.stackManager.isAreaDisabled(entity.getLocation())) {
            return;
        }
        if (!this.stackManager.isEntityStackingEnabled()) {
            return;
        }
        StackedEntity stackedEntity = this.stackManager.getStackedEntity(entity);
        if (stackedEntity == null) {
            return;
        }
        int stackSize = stackedEntity.getStackSize();
        if (stackSize == 1) {
            this.stackManager.removeEntityStack(stackedEntity);
            return;
        }
        if (event != null && stackedEntity.isEntireStackKilledOnDeath()) {
            stackedEntity.killEntireStack(event);
            return;
        }
        Vector previousVelocity = entity.getVelocity().clone();
        Runnable task = () -> {
            if (SettingKey.ENTITY_MULTIKILL_ENABLED.get().booleanValue()) {
                int targetAmount;
                int killAmount;
                int enchantmentMultiplier = 1;
                if ((!SettingKey.ENTITY_MULTIKILL_PLAYER_ONLY.get().booleanValue() || entity.getKiller() != null) && SettingKey.ENTITY_MULTIKILL_ENCHANTMENT_ENABLED.get().booleanValue()) {
                    Enchantment requiredEnchantment = Enchantment.getByKey((NamespacedKey)NamespacedKey.fromString((String)SettingKey.ENTITY_MULTIKILL_ENCHANTMENT_TYPE.get()));
                    if (requiredEnchantment == null) {
                        RoseStacker.getInstance().getLogger().warning("Invalid multikill enchantment type: " + SettingKey.ENTITY_MULTIKILL_ENCHANTMENT_TYPE.get());
                    } else if (event != null && event.getEntity().getKiller() != null) {
                        Player killer = event.getEntity().getKiller();
                        enchantmentMultiplier = killer.getInventory().getItemInMainHand().getEnchantmentLevel(requiredEnchantment);
                    }
                }
                MultikillBound lowerBound = this.stackManager.getLowerMultikillBound();
                MultikillBound upperBound = this.stackManager.getUpperMultikillBound();
                int lowerValue = lowerBound.getValue(stackSize);
                int upperValue = upperBound.getValue(stackSize);
                if (upperValue < lowerValue) {
                    upperValue = lowerValue;
                }
                if ((killAmount = Math.max(1, (targetAmount = StackerUtils.randomInRange(lowerValue, upperValue)) * enchantmentMultiplier)) >= stackSize) {
                    stackedEntity.killEntireStack(event);
                } else {
                    stackedEntity.killPartialStack(event, killAmount);
                }
            } else {
                stackedEntity.decreaseStackSize();
            }
            stackedEntity.getEntity().setVelocity(new Vector());
            if (SettingKey.ENTITY_KILL_TRANSFER_VELOCITY.get().booleanValue()) {
                stackedEntity.getEntity().setVelocity(previousVelocity);
            }
        };
        if (SettingKey.ENTITY_KILL_DELAY_NEXT_SPAWN.get().booleanValue()) {
            ThreadUtils.runSync(task);
        } else {
            task.run();
        }
        if (SettingKey.ENTITY_KILL_TRANSFER_VELOCITY.get().booleanValue()) {
            entity.setVelocity(new Vector());
        }
        if (!SettingKey.ENTITY_DISPLAY_CORPSE.get().booleanValue()) {
            entity.remove();
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onEntityTransform(EntityTransformEvent event) {
        this.handleEntityTransformation(event);
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPigZap(PigZapEvent event) {
        this.handleEntityTransformation((EntityTransformEvent)event);
    }

    private void handleEntityTransformation(EntityTransformEvent event) {
        LivingEntity transformedEntity;
        boolean fromSpawner;
        boolean aiDisabled;
        EntityStackSettings newStackSettings;
        block18: {
            block17: {
                Entity entity;
                if (this.stackManager.isAreaDisabled(event.getEntity().getLocation())) {
                    return;
                }
                if (!this.stackManager.isEntityStackingEnabled()) {
                    return;
                }
                newStackSettings = this.stackSettingManager.getEntityStackSettings(event.getTransformedEntity().getType());
                aiDisabled = PersistentDataUtils.isAiDisabled((LivingEntity)event.getEntity());
                fromSpawner = PersistentDataUtils.isSpawnedFromSpawner(event.getEntity());
                if (event.getEntity() instanceof Slime) {
                    if (aiDisabled) {
                        event.getTransformedEntities().stream().map(x -> (Slime)x).forEach(PersistentDataUtils::removeEntityAi);
                    }
                    if (fromSpawner) {
                        event.getTransformedEntities().stream().map(x -> (Slime)x).forEach(newStackSettings::applySpawnerSpawnedProperties);
                    }
                    return;
                }
                if (!(event.getEntity() instanceof LivingEntity) || !((entity = event.getTransformedEntity()) instanceof LivingEntity)) break block17;
                transformedEntity = (LivingEntity)entity;
                if (event.getEntity().getType() != event.getTransformedEntity().getType() && this.stackManager.isEntityStacked((LivingEntity)event.getEntity())) break block18;
            }
            return;
        }
        StackedEntity stackedEntity = this.stackManager.getStackedEntity((LivingEntity)event.getEntity());
        if (stackedEntity == null || stackedEntity.getStackSize() == 1) {
            return;
        }
        if (SettingKey.ENTITY_TRANSFORM_ENTIRE_STACK.get().booleanValue()) {
            EntityDataEntry serialized = EntityDataEntry.createFromEntityNBT(transformedEntity);
            event.setCancelled(true);
            EntityType entityType = event.getEntityType();
            if (entityType == VersionUtils.MOOSHROOM) {
                int mushroomsDropped = 5;
                EntityStackSettings mooshroomStackSettings = this.stackSettingManager.getEntityStackSettings(entityType);
                if (mooshroomStackSettings.getSettingValue("drop-additional-mushrooms-for-each-cow-in-stack").getBoolean()) {
                    mushroomsDropped += (stackedEntity.getStackSize() - 1) * stackedEntity.getStackSettings().getSettingValue("extra-mushrooms-per-cow-in-stack").getInt();
                }
                Material dropType = ((MushroomCow)event.getEntity()).getVariant() == MushroomCow.Variant.BROWN ? Material.BROWN_MUSHROOM : Material.RED_MUSHROOM;
                this.stackManager.preStackItems(GuiUtil.getMaterialAmountAsItemStacks(dropType, mushroomsDropped), event.getEntity().getLocation());
            }
            event.getEntity().remove();
            ThreadUtils.runSync(() -> {
                this.stackManager.setEntityStackingTemporarilyDisabled(true);
                LivingEntity newEntity = serialized.createEntity(transformedEntity.getLocation(), true, transformedEntity.getType());
                if (aiDisabled) {
                    PersistentDataUtils.removeEntityAi(newEntity);
                }
                if (fromSpawner) {
                    PersistentDataUtils.tagSpawnedFromSpawner((Entity)newEntity);
                }
                StackedEntity newStack = this.stackManager.createEntityStack(newEntity, false);
                this.stackManager.setEntityStackingTemporarilyDisabled(false);
                if (newStack == null) {
                    return;
                }
                if (fromSpawner) {
                    newStack.getStackSettings().applySpawnerSpawnedProperties(newEntity);
                }
                stackedEntity.getDataStorage().forEach(entity -> {
                    if (aiDisabled) {
                        PersistentDataUtils.removeEntityAi(entity);
                    }
                    newStack.increaseStackSize((LivingEntity)entity, false);
                });
                newStack.updateDisplay();
            });
        } else {
            if (aiDisabled) {
                event.getTransformedEntities().stream().map(x -> (LivingEntity)x).forEach(PersistentDataUtils::removeEntityAi);
            }
            if (fromSpawner) {
                event.getTransformedEntities().stream().map(x -> (LivingEntity)x).forEach(newStackSettings::applySpawnerSpawnedProperties);
            }
            if (event.getTransformReason() == EntityTransformEvent.TransformReason.LIGHTNING) {
                ThreadUtils.runSyncDelayed(stackedEntity::decreaseStackSize, 20L);
            } else {
                ThreadUtils.runSync(stackedEntity::decreaseStackSize);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onChickenLayEgg(EntityDropItemEvent event) {
        if (event.getEntityType() != EntityType.CHICKEN) {
            return;
        }
        Material eggMaterial = event.getItemDrop().getItemStack().getType();
        switch (eggMaterial.getKey().getKey()) {
            case "egg": 
            case "blue_egg": 
            case "brown_egg": {
                break;
            }
            default: {
                return;
            }
        }
        if (this.stackManager.isAreaDisabled(event.getEntity().getLocation())) {
            return;
        }
        if (!this.stackManager.isEntityStackingEnabled()) {
            return;
        }
        Chicken chickenEntity = (Chicken)event.getEntity();
        StackedEntity stackedEntity = this.stackManager.getStackedEntity((LivingEntity)chickenEntity);
        if (stackedEntity == null || stackedEntity.getStackSize() == 1) {
            return;
        }
        EntityStackSettings chickenStackSettings = stackedEntity.getStackSettings();
        if (!chickenStackSettings.getSettingValue("multiply-egg-drops-by-stack-size").getBoolean()) {
            return;
        }
        event.getItemDrop().remove();
        int maxAmount = chickenStackSettings.getSettingValue("max-egg-stack-size").getInt();
        if (maxAmount == 0) {
            return;
        }
        int amount = stackedEntity.getStackSize();
        if (maxAmount > 0) {
            amount = Math.min(amount, maxAmount);
        }
        List<ItemStack> items = GuiUtil.getMaterialAmountAsItemStacks(eggMaterial, amount);
        this.stackManager.preStackItems(items, event.getEntity().getLocation());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerShearSheep(PlayerShearEntityEvent event) {
        this.handleSheepShear(event.getEntity());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockShearSheep(BlockShearEntityEvent event) {
        this.handleSheepShear(event.getEntity());
    }

    private void handleSheepShear(Entity entity) {
        if (entity.getType() != EntityType.SHEEP) {
            return;
        }
        if (this.stackManager.isAreaDisabled(entity.getLocation())) {
            return;
        }
        if (!this.stackManager.isEntityStackingEnabled()) {
            return;
        }
        Sheep sheepEntity = (Sheep)entity;
        StackedEntity stackedEntity = this.stackManager.getStackedEntity((LivingEntity)sheepEntity);
        if (stackedEntity == null) {
            return;
        }
        if (stackedEntity.getStackSize() == 1) {
            ThreadUtils.runAsync(() -> {
                stackedEntity.resetHasMoved();
                this.stackManager.tryStackEntity(stackedEntity);
            });
            return;
        }
        if (!stackedEntity.getStackSettings().getSettingValue("shear-all-sheep-in-stack").getBoolean()) {
            ThreadUtils.runSync(() -> {
                if (!stackedEntity.shouldStayStacked()) {
                    this.stackManager.splitEntityStack(stackedEntity);
                }
            });
            return;
        }
        ShearedHandler shearedHandler = CompatibilityAdapter.getShearedHandler();
        ArrayList drops = new ArrayList();
        this.stackManager.setEntityUnstackingTemporarilyDisabled(true);
        ThreadUtils.runAsync(() -> {
            try {
                stackedEntity.getDataStorage().forEachTransforming(internal -> {
                    Sheep sheep = (Sheep)internal;
                    if (!shearedHandler.isSheared((LivingEntity)sheep) || this.stackManager.getEntityDataStorageType(sheep.getType()) == StackedEntityDataStorageType.SIMPLE) {
                        shearedHandler.setSheared((LivingEntity)sheep, true);
                        drops.add(new ItemStack(ItemUtils.getWoolMaterial(sheep.getColor()), EntityListener.getWoolDropAmount()));
                        return true;
                    }
                    return false;
                });
                Location location = sheepEntity.getLocation();
                location.add(0.0, sheepEntity.getEyeHeight(), 0.0);
                ThreadUtils.runSync(() -> this.stackManager.preStackItems(drops, location, false));
            }
            finally {
                this.stackManager.setEntityUnstackingTemporarilyDisabled(false);
            }
        });
    }

    private static int getWoolDropAmount() {
        return (int)(Math.random() * 3.0) + 1;
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onSheepRegrowWool(SheepRegrowWoolEvent event) {
        if (this.stackManager.isAreaDisabled(event.getEntity().getLocation())) {
            return;
        }
        if (!this.stackManager.isEntityStackingEnabled()) {
            return;
        }
        Sheep sheepEntity = event.getEntity();
        StackedEntity stackedEntity = this.stackManager.getStackedEntity((LivingEntity)sheepEntity);
        if (stackedEntity == null || stackedEntity.getStackSize() == 1) {
            return;
        }
        double regrowPercentage = stackedEntity.getStackSettings().getSettingValue("percentage-of-wool-to-regrow-per-grass-eaten").getDouble() / 100.0;
        int regrowAmount = Math.max(1, (int)Math.round((double)stackedEntity.getStackSize() * regrowPercentage));
        ShearedHandler shearedHandler = CompatibilityAdapter.getShearedHandler();
        if (shearedHandler.isSheared((LivingEntity)sheepEntity)) {
            shearedHandler.setSheared((LivingEntity)sheepEntity, false);
            --regrowAmount;
        }
        if (regrowAmount <= 1) {
            return;
        }
        AtomicInteger regrowRemaining = new AtomicInteger(regrowAmount);
        ThreadUtils.runAsync(() -> stackedEntity.getDataStorage().forEachTransforming(internal -> {
            Sheep sheep = (Sheep)internal;
            if (shearedHandler.isSheared((LivingEntity)sheep) && regrowRemaining.getAndDecrement() > 0) {
                shearedHandler.setSheared((LivingEntity)sheep, false);
                return true;
            }
            return false;
        }));
    }
}

