/*
 * Decompiled with CFR 0.152.
 */
package dev.rosewood.rosestacker.listener;

import dev.rosewood.rosestacker.config.SettingKey;
import dev.rosewood.rosestacker.lib.rosegarden.RosePlugin;
import dev.rosewood.rosestacker.lib.rosegarden.utils.NMSUtil;
import dev.rosewood.rosestacker.manager.StackManager;
import dev.rosewood.rosestacker.manager.StackSettingManager;
import dev.rosewood.rosestacker.stack.StackedEntity;
import dev.rosewood.rosestacker.stack.StackedItem;
import dev.rosewood.rosestacker.stack.settings.ItemStackSettings;
import dev.rosewood.rosestacker.utils.StackerUtils;
import java.util.ArrayList;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Container;
import org.bukkit.entity.Allay;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Villager;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.entity.ItemDespawnEvent;
import org.bukkit.event.entity.ItemMergeEvent;
import org.bukkit.event.inventory.InventoryPickupItemEvent;
import org.bukkit.event.inventory.PrepareAnvilEvent;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

public class ItemListener
implements Listener {
    private final RosePlugin rosePlugin;
    private final StackManager stackManager;
    private final StackSettingManager stackSettingManager;

    public ItemListener(RosePlugin rosePlugin) {
        this.rosePlugin = rosePlugin;
        this.stackManager = rosePlugin.getManager(StackManager.class);
        this.stackSettingManager = rosePlugin.getManager(StackSettingManager.class);
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onItemDespawn(ItemDespawnEvent event) {
        if (this.stackManager.isAreaDisabled(event.getEntity().getLocation()) || !this.stackManager.isItemStackingEnabled()) {
            return;
        }
        StackedItem stackedItem = this.stackManager.getStackedItem(event.getEntity());
        if (stackedItem != null) {
            this.stackManager.removeItemStack(stackedItem);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onItemMerge(ItemMergeEvent event) {
        if (this.stackManager.isAreaDisabled(event.getEntity().getLocation()) || !this.stackManager.isItemStackingEnabled()) {
            return;
        }
        ItemStackSettings itemStackSettings = this.stackSettingManager.getItemStackSettings(event.getEntity());
        if (itemStackSettings != null && !itemStackSettings.isStackingEnabled()) {
            return;
        }
        event.setCancelled(true);
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onItemPickup(EntityPickupItemEvent event) {
        Inventory inventory;
        LivingEntity entity = event.getEntity();
        if (this.stackManager.isAreaDisabled(entity.getLocation())) {
            return;
        }
        if (!this.stackManager.isItemStackingEnabled()) {
            return;
        }
        StackedItem stackedItem = this.stackManager.getStackedItem(event.getItem());
        if (stackedItem == null) {
            return;
        }
        int maxStack = event.getItem().getItemStack().getType().getMaxStackSize();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (SettingKey.ITEM_DISABLE_PICKUP_IF_VANISHED.get().booleanValue() && StackerUtils.isVanished(player)) {
                event.setCancelled(true);
                return;
            }
            inventory = player.getInventory();
        } else if (entity instanceof Villager) {
            Villager villager = (Villager)entity;
            inventory = villager.getInventory();
        } else {
            if (event.getEntityType() == EntityType.DOLPHIN) {
                if (stackedItem.getStackSize() > maxStack) {
                    ItemStack clone = event.getItem().getItemStack().clone();
                    clone.setAmount(maxStack);
                    stackedItem.setStackSize(stackedItem.getStackSize() - maxStack);
                    EntityEquipment equipment = entity.getEquipment();
                    if (equipment != null) {
                        equipment.setItemInMainHand(clone);
                    }
                    stackedItem.getItem().setPickupDelay(20);
                    event.setCancelled(true);
                }
                return;
            }
            if (NMSUtil.getVersionNumber() >= 19 && entity instanceof Allay) {
                Allay allay = (Allay)entity;
                int pickedUpAmount = Math.min(maxStack, stackedItem.getStackSize()) - event.getRemaining();
                if (stackedItem.getStackSize() > maxStack) {
                    ItemStack clone = event.getItem().getItemStack().clone();
                    clone.setAmount(pickedUpAmount);
                    stackedItem.setStackSize(stackedItem.getStackSize() - pickedUpAmount);
                    allay.getInventory().addItem(new ItemStack[]{clone});
                    stackedItem.getItem().setPickupDelay(20);
                    event.setCancelled(true);
                }
                return;
            }
            if (stackedItem.getStackSize() > 1) {
                this.stackManager.splitItemStack(stackedItem, 1);
                event.setCancelled(true);
            }
            if (SettingKey.ENTITY_DONT_STACK_IF_HAS_EQUIPMENT.get().booleanValue()) {
                this.rosePlugin.getScheduler().runTask(() -> {
                    StackedEntity stackedEntity = this.stackManager.getStackedEntity(entity);
                    if (stackedEntity != null) {
                        this.stackManager.tryUnstackEntity(stackedEntity);
                    }
                });
            }
            return;
        }
        if (this.applyInventoryItemPickup(inventory, stackedItem, (Entity)entity)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onInventoryPickup(InventoryPickupItemEvent event) {
        if (this.stackManager.isAreaDisabled(event.getItem().getLocation())) {
            return;
        }
        if (!this.stackManager.isItemStackingEnabled()) {
            return;
        }
        StackedItem stackedItem = this.stackManager.getStackedItem(event.getItem());
        if (stackedItem == null) {
            return;
        }
        Inventory inventory = event.getInventory();
        if (this.applyInventoryItemPickup(inventory, stackedItem, null)) {
            InventoryHolder holder = NMSUtil.isPaper() ? inventory.getHolder(false) : inventory.getHolder();
            if (holder instanceof Container) {
                Container container = (Container)holder;
                container.update();
            }
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onAnvilRenameSpawner(PrepareAnvilEvent event) {
        ItemStack item = event.getInventory().getFirstItem();
        if (item != null && item.getType() == Material.SPAWNER && SettingKey.SPAWNER_DISABLE_ITEM_ANVIL_RENAMING.get().booleanValue()) {
            event.setResult(null);
        }
    }

    private boolean applyInventoryItemPickup(Inventory inventory, StackedItem stackedItem, Entity eventEntity) {
        ItemStack target = stackedItem.getItem().getItemStack();
        int maxStackSize = target.getMaxStackSize();
        int inventorySpace = this.getAmountAvailable(inventory, target);
        if (inventorySpace >= stackedItem.getStackSize() && stackedItem.getStackSize() <= maxStackSize) {
            this.stackManager.removeItemStack(stackedItem);
            return false;
        }
        boolean willPickupAll = inventorySpace >= stackedItem.getStackSize();
        int amount = willPickupAll ? stackedItem.getStackSize() - target.getAmount() : inventorySpace;
        this.addItemStackAmountToInventory(inventory, target, amount);
        if (!willPickupAll) {
            stackedItem.setStackSize(stackedItem.getStackSize() - amount);
            if (eventEntity instanceof Player) {
                eventEntity.getWorld().playSound(eventEntity.getLocation(), Sound.ENTITY_ITEM_PICKUP, 0.2f, (float)(1.0 + Math.random()));
            }
            return true;
        }
        this.stackManager.removeItemStack(stackedItem);
        return false;
    }

    private int getAmountAvailable(Inventory inventory, ItemStack target) {
        PlayerInventory playerInventory;
        ItemStack offhandStack;
        int maxStackSize = target.getMaxStackSize();
        int inventorySpace = 0;
        if (inventory instanceof PlayerInventory && (offhandStack = (playerInventory = (PlayerInventory)inventory).getItemInOffHand()).isSimilar(target)) {
            inventorySpace += Math.max(maxStackSize - offhandStack.getAmount(), 0);
        }
        for (ItemStack itemStack : inventory.getStorageContents()) {
            if (itemStack == null || itemStack.getType() == Material.AIR) {
                inventorySpace += maxStackSize;
                continue;
            }
            if (!itemStack.isSimilar(target)) continue;
            inventorySpace += Math.max(maxStackSize - itemStack.getAmount(), 0);
        }
        return inventorySpace;
    }

    private void addItemStackAmountToInventory(Inventory inventory, ItemStack target, int amount) {
        int available;
        int toTake;
        PlayerInventory playerInventory;
        ItemStack itemStack;
        ArrayList<ItemStack> toAdd = new ArrayList<ItemStack>();
        if (inventory instanceof PlayerInventory && (itemStack = (playerInventory = (PlayerInventory)inventory).getItemInOffHand()).isSimilar(target) && (toTake = Math.min(available = Math.max(target.getMaxStackSize() - itemStack.getAmount(), 0), amount)) > 0) {
            itemStack.setAmount(itemStack.getAmount() + toTake);
            amount -= toTake;
        }
        while (amount > 0) {
            ItemStack newItemStack = target.clone();
            int toTake2 = Math.min(amount, target.getMaxStackSize());
            newItemStack.setAmount(toTake2);
            amount -= toTake2;
            toAdd.add(newItemStack);
        }
        inventory.addItem(toAdd.toArray(new ItemStack[0])).isEmpty();
    }
}

