/*
 * Decompiled with CFR 0.152.
 */
package dev.rosewood.rosestacker.listener;

import dev.rosewood.rosestacker.lib.rosegarden.RosePlugin;
import dev.rosewood.rosestacker.lib.rosegarden.compatibility.CompatibilityAdapter;
import dev.rosewood.rosestacker.lib.rosegarden.utils.StringPlaceholders;
import dev.rosewood.rosestacker.manager.LocaleManager;
import dev.rosewood.rosestacker.manager.StackManager;
import dev.rosewood.rosestacker.stack.EntityStackComparisonResult;
import dev.rosewood.rosestacker.stack.StackedBlock;
import dev.rosewood.rosestacker.stack.StackedEntity;
import dev.rosewood.rosestacker.stack.StackedItem;
import dev.rosewood.rosestacker.stack.StackedSpawner;
import dev.rosewood.rosestacker.utils.EntityUtils;
import dev.rosewood.rosestacker.utils.ItemUtils;
import dev.rosewood.rosestacker.utils.PersistentDataUtils;
import dev.rosewood.rosestacker.utils.StackerUtils;
import dev.rosewood.rosestacker.utils.ThreadUtils;
import dev.rosewood.rosestacker.utils.VersionUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.block.Block;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class StackToolListener
implements Listener {
    private final RosePlugin rosePlugin;
    private final Map<UUID, SelectedEntities> selectedEntities;

    public StackToolListener(RosePlugin rosePlugin) {
        this.rosePlugin = rosePlugin;
        this.selectedEntities = new HashMap<UUID, SelectedEntities>();
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onRightClick(PlayerInteractAtEntityEvent event) {
        LivingEntity entity;
        Player player;
        block8: {
            block7: {
                player = event.getPlayer();
                ItemStack tool = player.getInventory().getItemInMainHand();
                Entity entity2 = event.getRightClicked();
                if (!(entity2 instanceof LivingEntity)) break block7;
                entity = (LivingEntity)entity2;
                if (event.getHand() == EquipmentSlot.HAND && ItemUtils.isStackingTool(tool)) break block8;
            }
            return;
        }
        event.setCancelled(true);
        LocaleManager localeManager = this.rosePlugin.getManager(LocaleManager.class);
        if (!player.hasPermission("rosestacker.stacktool")) {
            localeManager.sendCommandMessage((CommandSender)player, "command-stacktool-no-permission");
            return;
        }
        StackedEntity stackedEntity = this.rosePlugin.getManager(StackManager.class).getStackedEntity(entity);
        if (stackedEntity == null) {
            localeManager.sendCommandMessage((CommandSender)player, "command-stacktool-invalid-entity");
            return;
        }
        if (!player.isSneaking()) {
            boolean stackable = !PersistentDataUtils.isUnstackable((Entity)entity);
            PersistentDataUtils.setUnstackable((Entity)entity, stackable);
            String stackableStr = !stackable ? "stackable" : "unstackable";
            localeManager.sendCommandMessage((CommandSender)player, "command-stacktool-marked-" + stackableStr, StringPlaceholders.of("type", stackedEntity.getStackSettings().getDisplayName()));
        } else {
            PersistentDataUtils.setUnstackable((Entity)entity, true);
            ThreadUtils.runAsync(() -> stackedEntity.getDataStorage().forEachTransforming(x -> {
                PersistentDataUtils.setUnstackable((Entity)x, true);
                return true;
            }));
            localeManager.sendCommandMessage((CommandSender)player, "command-stacktool-marked-all-unstackable", StringPlaceholders.of("type", stackedEntity.getStackSettings().getDisplayName()));
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onLeftClickEntity(EntityDamageByEntityEvent event) {
        Entity entity = event.getDamager();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        ItemStack tool = player.getInventory().getItemInMainHand();
        if (!ItemUtils.isStackingTool(tool)) {
            return;
        }
        event.setCancelled(true);
        Entity entity2 = event.getEntity();
        if (!(entity2 instanceof LivingEntity)) {
            return;
        }
        LivingEntity entity3 = (LivingEntity)entity2;
        LocaleManager localeManager = this.rosePlugin.getManager(LocaleManager.class);
        if (!player.hasPermission("rosestacker.stacktool")) {
            localeManager.sendCommandMessage((CommandSender)player, "command-stacktool-no-permission");
            return;
        }
        StackedEntity stackedEntity = this.rosePlugin.getManager(StackManager.class).getStackedEntity(entity3);
        if (stackedEntity == null) {
            localeManager.sendCommandMessage((CommandSender)player, "command-stacktool-invalid-entity");
            return;
        }
        if (!player.isSneaking()) {
            SelectedEntities selected = this.selectedEntities.computeIfAbsent(player.getUniqueId(), x -> new SelectedEntities());
            if (selected.getEntity1() == stackedEntity) {
                selected.unselect();
                localeManager.sendCommandMessage((CommandSender)player, "command-stacktool-unselect-1", StringPlaceholders.of("type", stackedEntity.getStackSettings().getDisplayName()));
                return;
            }
            selected.select(stackedEntity);
            if (!selected.hasSelected()) {
                localeManager.sendCommandMessage((CommandSender)player, "command-stacktool-select-1", StringPlaceholders.of("type", stackedEntity.getStackSettings().getDisplayName()));
            } else {
                localeManager.sendCommandMessage((CommandSender)player, "command-stacktool-select-2", StringPlaceholders.of("type", stackedEntity.getStackSettings().getDisplayName()));
                StackedEntity entity1 = selected.getEntity1();
                StackedEntity entity22 = selected.getEntity2();
                selected.unselect();
                EntityStackComparisonResult result = stackedEntity.getStackSettings().canStackWith(entity1, entity22, false, true);
                if (result == EntityStackComparisonResult.CAN_STACK) {
                    localeManager.sendCommandMessage((CommandSender)player, "command-stacktool-can-stack");
                } else {
                    localeManager.sendCommandMessage((CommandSender)player, "command-stacktool-can-not-stack", StringPlaceholders.of("reason", result.name()));
                }
            }
        } else {
            String trueStr = localeManager.getLocaleMessage("command-stacktool-info-true");
            String falseStr = localeManager.getLocaleMessage("command-stacktool-info-false");
            localeManager.sendCommandMessage((CommandSender)player, "command-stacktool-info");
            localeManager.sendSimpleCommandMessage((CommandSender)player, "command-stacktool-info-uuid", StringPlaceholders.of("uuid", entity3.getUniqueId().toString()));
            localeManager.sendSimpleCommandMessage((CommandSender)player, "command-stacktool-info-entity-id", StringPlaceholders.of("id", StackerUtils.formatNumber(entity3.getEntityId())));
            localeManager.sendSimpleCommandMessage((CommandSender)player, "command-stacktool-info-entity-type", StringPlaceholders.of("type", entity3.getType().name()));
            localeManager.sendSimpleCommandMessage((CommandSender)player, "command-stacktool-info-stack-size", StringPlaceholders.of("amount", StackerUtils.formatNumber(stackedEntity.getStackSize())));
            localeManager.sendSimpleCommandMessage((CommandSender)player, "command-stacktool-info-data-storage-type", StringPlaceholders.of("type", stackedEntity.getDataStorage().getType().name()));
            if (entity3.getCustomName() != null) {
                localeManager.sendSimpleCommandMessage((CommandSender)player, "command-stacktool-info-custom-name", StringPlaceholders.of("name", entity3.getCustomName()));
            }
            localeManager.sendSimpleCommandMessage((CommandSender)player, "command-stacktool-info-entity-stackable", StringPlaceholders.of("value", PersistentDataUtils.isUnstackable((Entity)entity3) ? falseStr : trueStr));
            localeManager.sendSimpleCommandMessage((CommandSender)player, "command-stacktool-info-entity-from-spawner", StringPlaceholders.of("value", PersistentDataUtils.isSpawnedFromSpawner((Entity)entity3) ? trueStr : falseStr));
            localeManager.sendSimpleCommandMessage((CommandSender)player, "command-stacktool-info-entity-has-ai", StringPlaceholders.of("value", !PersistentDataUtils.isAiDisabled(entity3) && entity3.hasAI() ? trueStr : falseStr));
            localeManager.sendSimpleCommandMessage((CommandSender)player, "command-stacktool-info-location", StringPlaceholders.builder("x", StackerUtils.formatNumber(entity3.getLocation().getBlockX())).add("y", StackerUtils.formatNumber(entity3.getLocation().getBlockY())).add("z", StackerUtils.formatNumber(entity3.getLocation().getBlockZ())).add("world", entity3.getWorld().getName()).build());
            localeManager.sendSimpleCommandMessage((CommandSender)player, "command-stacktool-info-chunk", StringPlaceholders.builder("x", StackerUtils.formatNumber(entity3.getLocation().getChunk().getX())).add("z", StackerUtils.formatNumber(entity3.getLocation().getChunk().getZ())).build());
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onInteract(PlayerInteractEvent event) {
        StackedSpawner stackedSpawner;
        Block clickedBlock;
        Player player = event.getPlayer();
        ItemStack tool = player.getInventory().getItemInMainHand();
        if (event.getAction() == Action.PHYSICAL || !ItemUtils.isStackingTool(tool)) {
            return;
        }
        event.setCancelled(true);
        if (!player.isSneaking() || event.getHand() != EquipmentSlot.HAND) {
            return;
        }
        LocaleManager localeManager = this.rosePlugin.getManager(LocaleManager.class);
        if (!player.hasPermission("rosestacker.stacktool")) {
            localeManager.sendCommandMessage((CommandSender)player, "command-stacktool-no-permission");
            return;
        }
        StackManager stackManager = this.rosePlugin.getManager(StackManager.class);
        if (event.getAction() == Action.LEFT_CLICK_AIR || event.getAction() == Action.LEFT_CLICK_BLOCK) {
            for (Entity entity : player.getNearbyEntities(3.0, 3.0, 3.0)) {
                StackedItem stackedItem;
                Item item;
                if (entity.getType() != VersionUtils.ITEM || !EntityUtils.isLookingAtItem(player, item = (Item)entity) || (stackedItem = stackManager.getStackedItem(item)) == null) continue;
                ItemMeta itemMeta = item.getItemStack().getItemMeta();
                localeManager.sendCommandMessage((CommandSender)player, "command-stacktool-info");
                localeManager.sendSimpleCommandMessage((CommandSender)player, "command-stacktool-info-uuid", StringPlaceholders.of("uuid", item.getUniqueId().toString()));
                localeManager.sendSimpleCommandMessage((CommandSender)player, "command-stacktool-info-entity-id", StringPlaceholders.of("id", StackerUtils.formatNumber(item.getEntityId())));
                localeManager.sendSimpleCommandMessage((CommandSender)player, "command-stacktool-info-item-type", StringPlaceholders.of("type", item.getItemStack().getType().name()));
                localeManager.sendSimpleCommandMessage((CommandSender)player, "command-stacktool-info-stack-size", StringPlaceholders.of("amount", StackerUtils.formatNumber(stackedItem.getStackSize())));
                if (itemMeta != null && itemMeta.hasDisplayName()) {
                    localeManager.sendSimpleCommandMessage((CommandSender)player, "command-stacktool-info-custom-name", StringPlaceholders.of("name", itemMeta.getDisplayName()));
                }
                localeManager.sendSimpleCommandMessage((CommandSender)player, "command-stacktool-info-location", StringPlaceholders.builder("x", StackerUtils.formatNumber(item.getLocation().getBlockX())).add("y", StackerUtils.formatNumber(item.getLocation().getBlockY())).add("z", StackerUtils.formatNumber(item.getLocation().getBlockZ())).add("world", item.getWorld().getName()).build());
                localeManager.sendSimpleCommandMessage((CommandSender)player, "command-stacktool-info-chunk", StringPlaceholders.builder("x", StackerUtils.formatNumber(item.getLocation().getChunk().getX())).add("z", StackerUtils.formatNumber(item.getLocation().getChunk().getZ())).build());
                return;
            }
        }
        if (event.getAction() == Action.LEFT_CLICK_BLOCK) {
            clickedBlock = event.getClickedBlock();
            if (clickedBlock == null) {
                return;
            }
            if (clickedBlock.getType() != Material.SPAWNER) {
                StackedBlock stackedBlock = stackManager.getStackedBlock(clickedBlock);
                if (stackedBlock == null) {
                    return;
                }
                localeManager.sendCommandMessage((CommandSender)player, "command-stacktool-info");
                localeManager.sendSimpleCommandMessage((CommandSender)player, "command-stacktool-info-block-type", StringPlaceholders.of("type", clickedBlock.getType().name()));
                localeManager.sendSimpleCommandMessage((CommandSender)player, "command-stacktool-info-stack-size", StringPlaceholders.of("amount", StackerUtils.formatNumber(stackedBlock.getStackSize())));
                localeManager.sendSimpleCommandMessage((CommandSender)player, "command-stacktool-info-location", StringPlaceholders.builder("x", StackerUtils.formatNumber(clickedBlock.getX())).add("y", StackerUtils.formatNumber(clickedBlock.getY())).add("z", StackerUtils.formatNumber(clickedBlock.getZ())).add("world", clickedBlock.getWorld().getName()).build());
                localeManager.sendSimpleCommandMessage((CommandSender)player, "command-stacktool-info-chunk", StringPlaceholders.builder("x", StackerUtils.formatNumber(clickedBlock.getChunk().getX())).add("z", StackerUtils.formatNumber(clickedBlock.getChunk().getZ())).build());
            } else {
                stackedSpawner = stackManager.getStackedSpawner(clickedBlock);
                if (stackedSpawner == null) {
                    return;
                }
                localeManager.sendCommandMessage((CommandSender)player, "command-stacktool-info");
                localeManager.sendSimpleCommandMessage((CommandSender)player, "command-stacktool-info-spawner-type", StringPlaceholders.of("type", stackedSpawner.getSpawnerTile().getSpawnerType().getEnumName()));
                localeManager.sendSimpleCommandMessage((CommandSender)player, "command-stacktool-info-stack-size", StringPlaceholders.of("amount", StackerUtils.formatNumber(stackedSpawner.getStackSize())));
                localeManager.sendSimpleCommandMessage((CommandSender)player, "command-stacktool-info-location", StringPlaceholders.builder("x", StackerUtils.formatNumber(clickedBlock.getX())).add("y", StackerUtils.formatNumber(clickedBlock.getY())).add("z", StackerUtils.formatNumber(clickedBlock.getZ())).add("world", clickedBlock.getWorld().getName()).build());
                localeManager.sendSimpleCommandMessage((CommandSender)player, "command-stacktool-info-chunk", StringPlaceholders.builder("x", StackerUtils.formatNumber(clickedBlock.getChunk().getX())).add("z", StackerUtils.formatNumber(clickedBlock.getChunk().getZ())).build());
            }
        }
        if (event.getAction() == Action.RIGHT_CLICK_BLOCK) {
            clickedBlock = event.getClickedBlock();
            if (clickedBlock == null || clickedBlock.getType() != Material.SPAWNER) {
                return;
            }
            stackedSpawner = stackManager.getStackedSpawner(clickedBlock);
            if (stackedSpawner == null) {
                CreatureSpawner creatureSpawner = (CreatureSpawner)clickedBlock.getState();
                CompatibilityAdapter.getCreatureSpawnerHandler().setDelay(creatureSpawner, 5);
                creatureSpawner.update();
            } else {
                stackedSpawner.getSpawnerTile().setDelay(5);
            }
            int points = 50;
            for (int i = 0; i < points; ++i) {
                double dx = Math.cos(Math.PI * 2 * ((double)i / (double)points)) * 0.25;
                double dy = 0.5;
                double dz = Math.sin(Math.PI * 2 * ((double)i / (double)points)) * 0.25;
                double angle = Math.atan2(dz, dx);
                double xAng = Math.cos(angle);
                double zAng = Math.sin(angle);
                clickedBlock.getWorld().spawnParticle(Particle.END_ROD, clickedBlock.getLocation().add(0.5 + dx, dy, 0.5 + dz), 0, xAng, 0.0, zAng, 0.15);
            }
        }
        player.updateInventory();
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerQuit(PlayerQuitEvent event) {
        this.selectedEntities.remove(event.getPlayer().getUniqueId());
    }

    private static class SelectedEntities {
        private StackedEntity entity1;
        private StackedEntity entity2;

        private SelectedEntities() {
        }

        public void select(StackedEntity entity) {
            if (this.entity1 == null) {
                this.entity1 = entity;
            } else if (this.entity2 == null) {
                this.entity2 = entity;
            }
        }

        public void unselect() {
            this.entity1 = null;
            this.entity2 = null;
        }

        public boolean hasSelected() {
            return this.entity1 != null && this.entity2 != null;
        }

        public StackedEntity getEntity1() {
            return this.entity1;
        }

        public StackedEntity getEntity2() {
            return this.entity2;
        }
    }
}

