/*
 * Decompiled with CFR 0.152.
 */
package dev.rosewood.rosestacker.listener;

import dev.rosewood.rosestacker.lib.rosegarden.RosePlugin;
import dev.rosewood.rosestacker.lib.rosegarden.utils.NMSUtil;
import dev.rosewood.rosestacker.manager.StackManager;
import dev.rosewood.rosestacker.stack.StackingThread;
import dev.rosewood.rosestacker.utils.PersistentDataUtils;
import dev.rosewood.rosestacker.utils.ThreadUtils;
import java.util.Arrays;
import org.bukkit.Chunk;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.event.world.ChunkUnloadEvent;
import org.bukkit.event.world.WorldLoadEvent;
import org.bukkit.event.world.WorldUnloadEvent;

public class WorldListener
implements Listener {
    private final StackManager stackManager;

    public WorldListener(RosePlugin rosePlugin) {
        this.stackManager = rosePlugin.getManager(StackManager.class);
    }

    /*
     * WARNING - void declaration
     */
    @EventHandler
    public void onChunkLoad(ChunkLoadEvent event) {
        if (this.stackManager.isWorldDisabled(event.getWorld())) {
            return;
        }
        Chunk chunk = event.getChunk();
        if (event.isNewChunk()) {
            if (NMSUtil.getVersionNumber() < 17 && this.stackManager.isEntityStackingEnabled()) {
                for (Entity entity : chunk.getEntities()) {
                    if (!(entity instanceof LivingEntity)) continue;
                    this.stackManager.createEntityStack((LivingEntity)entity, true);
                }
            }
            if (this.stackManager.isSpawnerStackingEnabled()) {
                for (Entity entity : chunk.getTileEntities()) {
                    if (!(entity instanceof CreatureSpawner)) continue;
                    this.stackManager.createSpawnerStack(entity.getBlock(), 1, false);
                }
            }
        } else {
            if (NMSUtil.getVersionNumber() < 17) {
                void var6_13;
                Entity[] entities;
                Entity[] entityArray = entities = chunk.getEntities();
                int n = entityArray.length;
                boolean bl = false;
                while (var6_13 < n) {
                    Entity entity = entityArray[var6_13];
                    if (entity instanceof LivingEntity) {
                        PersistentDataUtils.applyDisabledAi((LivingEntity)entity);
                    }
                    ++var6_13;
                }
                this.stackManager.loadChunkEntities(Arrays.asList(entities));
            }
            this.stackManager.loadChunkBlocks(chunk);
        }
    }

    @EventHandler
    public void onChunkUnload(ChunkUnloadEvent event) {
        this.stackManager.saveChunkBlocks(event.getChunk(), true);
        if (NMSUtil.getVersionNumber() < 17) {
            this.stackManager.saveChunkEntities(Arrays.asList(event.getChunk().getEntities()), true);
        }
    }

    @EventHandler
    public void onWorldLoad(WorldLoadEvent event) {
        this.stackManager.loadWorld(event.getWorld());
    }

    @EventHandler
    public void onWorldUnload(WorldUnloadEvent event) {
        this.stackManager.unloadWorld(event.getWorld());
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        StackingThread stackingThread = this.stackManager.getStackingThread(event.getPlayer().getWorld());
        if (stackingThread != null) {
            ThreadUtils.runAsync(stackingThread::processNametags);
        }
    }
}

