/*
 * Decompiled with CFR 0.152.
 */
package dev.rosewood.rosestacker.manager;

import dev.rosewood.rosestacker.config.SettingKey;
import dev.rosewood.rosestacker.lib.rosegarden.RosePlugin;
import dev.rosewood.rosestacker.lib.rosegarden.manager.Manager;
import dev.rosewood.rosestacker.lib.rosegarden.scheduler.task.ScheduledTask;
import dev.rosewood.rosestacker.nms.NMSAdapter;
import dev.rosewood.rosestacker.nms.NMSHandler;
import dev.rosewood.rosestacker.nms.hologram.Hologram;
import dev.rosewood.rosestacker.utils.ThreadUtils;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.world.WorldUnloadEvent;
import org.bukkit.plugin.Plugin;

public class HologramManager
extends Manager
implements Listener {
    private final Map<Location, Hologram> holograms = new ConcurrentHashMap<Location, Hologram>();
    private final NMSHandler nmsHandler = NMSAdapter.getHandler();
    private ScheduledTask watcherTask;
    private double renderDistanceSqrd;
    private boolean hideThroughWalls;

    public HologramManager(RosePlugin rosePlugin) {
        super(rosePlugin);
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this.rosePlugin);
    }

    @Override
    public void reload() {
        this.watcherTask = this.rosePlugin.getScheduler().runTaskTimerAsync(this::updateWatchers, 0L, SettingKey.HOLOGRAM_UPDATE_FREQUENCY.get());
        this.renderDistanceSqrd = SettingKey.BLOCK_DYNAMIC_TAG_VIEW_RANGE.get() * SettingKey.BLOCK_DYNAMIC_TAG_VIEW_RANGE.get();
        this.hideThroughWalls = SettingKey.BLOCK_DYNAMIC_TAG_VIEW_RANGE_WALL_DETECTION_ENABLED.get();
    }

    @Override
    public void disable() {
        if (this.watcherTask != null) {
            this.watcherTask.cancel();
            this.watcherTask = null;
        }
        this.holograms.values().forEach(Hologram::delete);
        this.holograms.clear();
    }

    private void updateWatchers() {
        Collection players = Bukkit.getOnlinePlayers();
        for (Player player : players) {
            for (Hologram hologram : this.holograms.values()) {
                this.updateWatcher(player, hologram);
            }
        }
    }

    private void updateWatcher(Player player, Hologram hologram) {
        if (this.isPlayerInRange(player, hologram.getLocation())) {
            hologram.addWatcher(player);
            if (this.hideThroughWalls) {
                hologram.setVisibility(player, this.nmsHandler.hasLineOfSight((LivingEntity)player, hologram.getDisplayLocation()));
            }
        } else {
            hologram.removeWatcher(player);
        }
    }

    private boolean isPlayerInRange(Player player, Location location) {
        return player.getWorld().equals((Object)location.getWorld()) && player.getLocation().distanceSquared(location) <= this.renderDistanceSqrd;
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        ThreadUtils.runAsync(() -> {
            Player player = event.getPlayer();
            for (Hologram hologram : this.holograms.values()) {
                this.updateWatcher(player, hologram);
            }
        });
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        ThreadUtils.runAsync(() -> {
            Player player = event.getPlayer();
            for (Hologram hologram : this.holograms.values()) {
                hologram.removeWatcher(player);
            }
        });
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onWorldUnload(WorldUnloadEvent event) {
        this.holograms.entrySet().removeIf(x -> {
            if (((Location)x.getKey()).getWorld().equals((Object)event.getWorld())) {
                ((Hologram)x.getValue()).delete();
                return true;
            }
            return false;
        });
    }

    public void createOrUpdateHologram(Location location, List<String> text) {
        Hologram hologram = this.holograms.get(location);
        if (hologram == null) {
            hologram = this.nmsHandler.createHologram(location, text);
            this.holograms.put(location, hologram);
            for (Player player : Bukkit.getOnlinePlayers()) {
                this.updateWatcher(player, hologram);
            }
        } else {
            hologram.setText(text);
        }
    }

    public void deleteHologram(Location location) {
        Hologram hologram = this.holograms.get(location);
        if (hologram != null) {
            hologram.delete();
            this.holograms.remove(location);
        }
    }
}

