/*
 * Decompiled with CFR 0.152.
 */
package dev.rosewood.rosestacker.manager;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import dev.rosewood.rosestacker.lib.rosegarden.RosePlugin;
import dev.rosewood.rosestacker.lib.rosegarden.manager.AbstractLocaleManager;
import dev.rosewood.rosestacker.lib.rosegarden.utils.HexUtils;
import dev.rosewood.rosestacker.lib.rosegarden.utils.StringPlaceholders;
import dev.rosewood.rosestacker.utils.StackerUtils;
import dev.rosewood.rosestacker.utils.ThreadUtils;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.bukkit.Material;
import org.bukkit.entity.EntityType;
import org.jetbrains.annotations.NotNull;

public class LocaleManager
extends AbstractLocaleManager {
    private List<String> translationLocales = new ArrayList<String>();

    public LocaleManager(RosePlugin rosePlugin) {
        super(rosePlugin);
        this.fetchMinecraftTranslationLocales();
    }

    @NotNull
    protected List<String> getLocaleStrings(String key) {
        Object value = this.loadedLocale.getLocaleValues().get(key);
        if (value instanceof String) {
            return new ArrayList<String>(Collections.singletonList((String)value));
        }
        if (value instanceof List) {
            return (List)value;
        }
        value = this.defaultLocale.getLocaleValues().get(key);
        if (value instanceof String) {
            return new ArrayList<String>(Collections.singletonList((String)value));
        }
        if (value instanceof List) {
            return (List)value;
        }
        throw new IllegalStateException("Missing locale string: " + key);
    }

    public List<String> getLocaleMessages(String messageKey, StringPlaceholders stringPlaceholders) {
        return this.getLocaleStrings(messageKey).stream().map(message -> HexUtils.colorify(stringPlaceholders.apply((String)message))).collect(Collectors.toList());
    }

    public void fetchMinecraftTranslationLocales() {
        ThreadUtils.runAsync(() -> {
            ArrayList<String> locales = new ArrayList<String>();
            String queryLink = "https://api.github.com/repos/InventivetalentDev/minecraft-assets/contents/assets/minecraft/lang?ref=1.21.10";
            try {
                URL url = new URL(queryLink);
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestProperty("Accept", "application/vnd.github.v3+json");
                JsonParser parser = new JsonParser();
                try (InputStreamReader reader = new InputStreamReader(connection.getInputStream());){
                    JsonArray json = parser.parse((Reader)reader).getAsJsonArray();
                    for (JsonElement element : json) {
                        String name = element.getAsJsonObject().get("name").getAsString().replaceAll(Pattern.quote(".json"), "");
                        if (name.startsWith("_")) continue;
                        locales.add(name);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            locales.sort(String::compareTo);
            this.translationLocales = locales;
            this.rosePlugin.getLogger().info("Fetched " + locales.size() + " translation locales.");
        });
    }

    public void getMinecraftTranslationValues(String locale, Consumer<TranslationResponse> callback) {
        ThreadUtils.runAsync(() -> {
            TranslationResponse.Result result;
            EnumMap<EntityType, String> entityValues;
            EnumMap<Material, String> materialValues;
            block13: {
                materialValues = new EnumMap<Material, String>(Material.class);
                entityValues = new EnumMap<EntityType, String>(EntityType.class);
                String fileLink = "https://raw.githubusercontent.com/InventivetalentDev/minecraft-assets/1.21.10/assets/minecraft/lang/" + locale.toLowerCase() + ".json";
                try {
                    URL url = new URL(fileLink);
                    HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                    if (connection.getResponseCode() == 200) {
                        JsonParser parser = new JsonParser();
                        try (InputStreamReader reader = new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8);){
                            JsonObject json = parser.parse((Reader)reader).getAsJsonObject();
                            Set entrySet = json.entrySet();
                            Map<String, String> entries = entrySet.stream().collect(Collectors.toMap(Map.Entry::getKey, x -> ((JsonElement)x.getValue()).getAsString()));
                            for (Material material : Material.values()) {
                                if (material.isLegacy()) continue;
                                String type = material.isBlock() ? "block" : "item";
                                String key = type + ".minecraft." + material.getKey().getKey();
                                String value = entries.get(key);
                                if (value == null) {
                                    value = StackerUtils.formatName(material.name());
                                }
                                materialValues.put(material, value);
                            }
                            for (Material material : EntityType.values()) {
                                if (material == EntityType.UNKNOWN) continue;
                                String key = "entity.minecraft." + material.getKey().getKey();
                                String value = entries.get(key);
                                if (value == null) {
                                    value = StackerUtils.formatName(material.name());
                                }
                                entityValues.put((EntityType)material, value);
                            }
                        }
                        result = TranslationResponse.Result.SUCCESS;
                        break block13;
                    }
                    result = connection.getResponseCode() == 404 ? TranslationResponse.Result.INVALID_LOCALE : TranslationResponse.Result.FAILURE;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    result = TranslationResponse.Result.FAILURE;
                }
            }
            callback.accept(new TranslationResponse(materialValues, entityValues, result));
        });
    }

    public List<String> getPossibleTranslationLocales() {
        return this.translationLocales;
    }

    public static class TranslationResponse {
        private final Map<Material, String> materialValues;
        private final Map<EntityType, String> entityValues;
        private final Result result;

        private TranslationResponse(Map<Material, String> materialValues, Map<EntityType, String> entityValues, Result result) {
            this.materialValues = materialValues;
            this.entityValues = entityValues;
            this.result = result;
        }

        public Map<Material, String> getMaterialValues() {
            return this.materialValues;
        }

        public Map<EntityType, String> getEntityValues() {
            return this.entityValues;
        }

        public Result getResult() {
            return this.result;
        }

        public static enum Result {
            SUCCESS,
            INVALID_LOCALE,
            FAILURE;

        }
    }
}

