/*
 * Decompiled with CFR 0.152.
 */
package dev.rosewood.rosestacker.manager;

import dev.rosewood.rosestacker.config.SettingKey;
import dev.rosewood.rosestacker.hook.WorldGuardHook;
import dev.rosewood.rosestacker.lib.rosegarden.RosePlugin;
import dev.rosewood.rosestacker.lib.rosegarden.manager.Manager;
import dev.rosewood.rosestacker.lib.rosegarden.scheduler.task.ScheduledTask;
import dev.rosewood.rosestacker.manager.StackSettingManager;
import dev.rosewood.rosestacker.nms.spawner.SpawnerType;
import dev.rosewood.rosestacker.nms.storage.StackedEntityDataStorageType;
import dev.rosewood.rosestacker.stack.Stack;
import dev.rosewood.rosestacker.stack.StackedBlock;
import dev.rosewood.rosestacker.stack.StackedEntity;
import dev.rosewood.rosestacker.stack.StackedItem;
import dev.rosewood.rosestacker.stack.StackedSpawner;
import dev.rosewood.rosestacker.stack.StackingLogic;
import dev.rosewood.rosestacker.stack.StackingThread;
import dev.rosewood.rosestacker.stack.settings.BlockStackSettings;
import dev.rosewood.rosestacker.stack.settings.EntityStackSettings;
import dev.rosewood.rosestacker.stack.settings.MultikillBound;
import dev.rosewood.rosestacker.stack.settings.SpawnerStackSettings;
import dev.rosewood.rosestacker.utils.DataUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class StackManager
extends Manager
implements StackingLogic {
    private final Map<UUID, StackingThread> stackingThreads = new ConcurrentHashMap<UUID, StackingThread>();
    private final Set<String> disabledWorldNames = new HashSet<String>();
    private ScheduledTask autosaveTask;
    private boolean isEntityStackingTemporarilyDisabled = false;
    private boolean isEntityUnstackingTemporarilyDisabled;
    private StackedEntityDataStorageType entityDataStorageType;
    private MultikillBound lowerMultikillBound;
    private MultikillBound upperMultikillBound;

    public StackManager(RosePlugin rosePlugin) {
        super(rosePlugin);
    }

    @Override
    public void reload() {
        String multikillAmountValue;
        int separatorIndex;
        this.entityDataStorageType = StackedEntityDataStorageType.fromName(SettingKey.ENTITY_DATA_STORAGE_TYPE.get());
        this.disabledWorldNames.addAll((Collection<String>)SettingKey.DISABLED_WORLDS.get());
        Bukkit.getWorlds().forEach(this::loadWorld);
        long autosaveFrequency = SettingKey.AUTOSAVE_FREQUENCY.get();
        if (autosaveFrequency > 0L) {
            long interval = autosaveFrequency * 20L * 60L;
            this.autosaveTask = this.rosePlugin.getScheduler().runTaskTimer(() -> this.saveAllData(false), interval, interval);
        }
        if ((separatorIndex = (multikillAmountValue = SettingKey.ENTITY_MULTIKILL_AMOUNT.get()).indexOf("-")) != -1) {
            String lower = multikillAmountValue.substring(0, separatorIndex);
            String upper = multikillAmountValue.substring(separatorIndex + 1);
            this.lowerMultikillBound = MultikillBound.parse(lower);
            this.upperMultikillBound = MultikillBound.parse(upper);
        } else {
            MultikillBound bound;
            this.lowerMultikillBound = bound = MultikillBound.parse(multikillAmountValue);
            this.upperMultikillBound = bound;
        }
    }

    @Override
    public void disable() {
        if (this.autosaveTask != null) {
            this.autosaveTask.cancel();
            this.autosaveTask = null;
        }
        this.saveAllData(true);
        this.stackingThreads.values().forEach(StackingThread::close);
        this.stackingThreads.clear();
        this.disabledWorldNames.clear();
    }

    @Override
    public Map<UUID, StackedEntity> getStackedEntities() {
        HashMap<UUID, StackedEntity> stackedEntities = new HashMap<UUID, StackedEntity>();
        this.stackingThreads.values().forEach(x -> stackedEntities.putAll(x.getStackedEntities()));
        return stackedEntities;
    }

    @Override
    public Map<UUID, StackedItem> getStackedItems() {
        HashMap<UUID, StackedItem> stackedItems = new HashMap<UUID, StackedItem>();
        this.stackingThreads.values().forEach(x -> stackedItems.putAll(x.getStackedItems()));
        return stackedItems;
    }

    @Override
    public Map<Block, StackedBlock> getStackedBlocks() {
        HashMap<Block, StackedBlock> stackedBlocks = new HashMap<Block, StackedBlock>();
        this.stackingThreads.values().forEach(x -> stackedBlocks.putAll(x.getStackedBlocks()));
        return stackedBlocks;
    }

    @Override
    public Map<Block, StackedSpawner> getStackedSpawners() {
        HashMap<Block, StackedSpawner> stackedSpawners = new HashMap<Block, StackedSpawner>();
        this.stackingThreads.values().forEach(x -> stackedSpawners.putAll(x.getStackedSpawners()));
        return stackedSpawners;
    }

    @Override
    public StackedEntity getStackedEntity(LivingEntity livingEntity) {
        StackingThread stackingThread = this.getStackingThread(livingEntity.getWorld());
        if (stackingThread == null) {
            return null;
        }
        return stackingThread.getStackedEntity(livingEntity);
    }

    @Override
    public StackedItem getStackedItem(Item item) {
        StackingThread stackingThread = this.getStackingThread(item.getWorld());
        if (stackingThread == null) {
            return null;
        }
        return stackingThread.getStackedItem(item);
    }

    @Override
    public StackedBlock getStackedBlock(Block block) {
        StackingThread stackingThread = this.getStackingThread(block.getWorld());
        if (stackingThread == null) {
            return null;
        }
        return stackingThread.getStackedBlock(block);
    }

    @Override
    public StackedSpawner getStackedSpawner(Block block) {
        StackingThread stackingThread = this.getStackingThread(block.getWorld());
        if (stackingThread == null) {
            return null;
        }
        return stackingThread.getStackedSpawner(block);
    }

    @Override
    public boolean isEntityStacked(LivingEntity livingEntity) {
        return this.getStackedEntity(livingEntity) != null;
    }

    @Override
    public boolean isItemStacked(Item item) {
        return this.getStackedItem(item) != null;
    }

    @Override
    public boolean isBlockStacked(Block block) {
        return this.getStackedBlock(block) != null;
    }

    @Override
    public boolean isSpawnerStacked(Block block) {
        return this.getStackedSpawner(block) != null;
    }

    @Override
    public void removeEntityStack(StackedEntity stackedEntity) {
        StackingThread stackingThread = this.getStackingThread(stackedEntity.getEntity().getWorld());
        if (stackingThread != null) {
            stackingThread.removeEntityStack(stackedEntity);
        }
    }

    @Override
    public void removeItemStack(StackedItem stackedItem) {
        StackingThread stackingThread = this.getStackingThread(stackedItem.getItem().getWorld());
        if (stackingThread != null) {
            stackingThread.removeItemStack(stackedItem);
        }
    }

    @Override
    public void removeBlockStack(StackedBlock stackedBlock) {
        StackingThread stackingThread = this.getStackingThread(stackedBlock.getBlock().getWorld());
        if (stackingThread != null) {
            stackingThread.removeBlockStack(stackedBlock);
        }
    }

    @Override
    public void removeSpawnerStack(StackedSpawner stackedSpawner) {
        StackingThread stackingThread = this.getStackingThread(stackedSpawner.getWorld());
        if (stackingThread != null) {
            stackingThread.removeSpawnerStack(stackedSpawner);
        }
    }

    @Override
    public int removeAllEntityStacks() {
        int total = 0;
        for (StackingThread stackingThread : this.stackingThreads.values()) {
            total += stackingThread.removeAllEntityStacks();
        }
        return total;
    }

    @Override
    public int removeAllItemStacks() {
        int total = 0;
        for (StackingThread stackingThread : this.stackingThreads.values()) {
            total += stackingThread.removeAllItemStacks();
        }
        return total;
    }

    @Override
    public void updateStackedEntityKey(LivingEntity oldKey, StackedEntity stackedEntity) {
        StackingThread stackingThread = this.getStackingThread(stackedEntity.getWorld());
        if (stackingThread != null) {
            stackingThread.updateStackedEntityKey(oldKey, stackedEntity);
        }
    }

    @Override
    public StackedEntity splitEntityStack(StackedEntity stackedEntity) {
        StackingThread stackingThread = this.getStackingThread(stackedEntity.getEntity().getWorld());
        if (stackingThread == null) {
            return null;
        }
        return stackingThread.splitEntityStack(stackedEntity);
    }

    @Override
    public StackedItem splitItemStack(StackedItem stackedItem, int newSize) {
        StackingThread stackingThread = this.getStackingThread(stackedItem.getItem().getWorld());
        if (stackingThread == null) {
            return null;
        }
        return stackingThread.splitItemStack(stackedItem, newSize);
    }

    @Override
    public StackedEntity createEntityStack(LivingEntity livingEntity, boolean tryStack) {
        StackingThread stackingThread = this.getStackingThread(livingEntity.getWorld());
        if (stackingThread == null) {
            return null;
        }
        return stackingThread.createEntityStack(livingEntity, tryStack);
    }

    @Override
    public StackedItem createItemStack(Item item, boolean tryStack) {
        StackingThread stackingThread = this.getStackingThread(item.getWorld());
        if (stackingThread == null) {
            return null;
        }
        return stackingThread.createItemStack(item, tryStack);
    }

    @Override
    public StackedBlock createBlockStack(Block block, int amount) {
        StackingThread stackingThread = this.getStackingThread(block.getWorld());
        if (stackingThread == null) {
            return null;
        }
        return stackingThread.createBlockStack(block, amount);
    }

    @Override
    public StackedSpawner createSpawnerStack(Block block, int amount, boolean placedByPlayer) {
        StackingThread stackingThread = this.getStackingThread(block.getWorld());
        if (stackingThread == null) {
            return null;
        }
        return stackingThread.createSpawnerStack(block, amount, placedByPlayer);
    }

    @Override
    public void addEntityStack(StackedEntity stackedEntity) {
        StackingThread stackingThread = this.getStackingThread(stackedEntity.getEntity().getWorld());
        if (stackingThread == null) {
            return;
        }
        stackingThread.addEntityStack(stackedEntity);
    }

    @Override
    public void addItemStack(StackedItem stackedItem) {
        StackingThread stackingThread = this.getStackingThread(stackedItem.getItem().getWorld());
        if (stackingThread == null) {
            return;
        }
        stackingThread.addItemStack(stackedItem);
    }

    @Override
    public void preStackEntities(EntityType entityType, int amount, Location location, CreatureSpawnEvent.SpawnReason spawnReason) {
        World world = location.getWorld();
        if (world == null) {
            return;
        }
        StackingThread stackingThread = this.getStackingThread(world);
        if (stackingThread == null) {
            return;
        }
        stackingThread.preStackEntities(entityType, amount, location, spawnReason);
    }

    @Override
    public void preStackEntities(EntityType entityType, int amount, Location location) {
        this.preStackEntities(entityType, amount, location, CreatureSpawnEvent.SpawnReason.CUSTOM);
    }

    @Override
    public void preStackItems(Collection<ItemStack> items, Location location, boolean dropNaturally) {
        World world = location.getWorld();
        if (world == null) {
            return;
        }
        StackingThread stackingThread = this.getStackingThread(world);
        if (stackingThread == null) {
            return;
        }
        stackingThread.preStackItems(items, location, dropNaturally);
    }

    @Override
    public StackedItem dropItemStack(ItemStack itemStack, int amount, Location location, boolean dropNaturally) {
        World world = location.getWorld();
        if (world == null) {
            return null;
        }
        StackingThread stackingThread = this.getStackingThread(world);
        if (stackingThread == null) {
            return null;
        }
        return stackingThread.dropItemStack(itemStack, amount, location, dropNaturally);
    }

    @Override
    public void loadChunkBlocks(Chunk chunk) {
        StackingThread stackingThread = this.getStackingThread(chunk.getWorld());
        if (stackingThread != null) {
            stackingThread.loadChunkBlocks(chunk);
        }
    }

    @Override
    public void loadChunkEntities(List<Entity> entities) {
        if (entities.isEmpty()) {
            return;
        }
        StackingThread stackingThread = this.getStackingThread(entities.get(0).getWorld());
        if (stackingThread != null) {
            stackingThread.loadChunkEntities(entities);
        }
    }

    @Override
    public void saveChunkBlocks(Chunk chunk, boolean clearStored) {
        StackingThread stackingThread = this.getStackingThread(chunk.getWorld());
        if (stackingThread != null) {
            stackingThread.saveChunkBlocks(chunk, clearStored);
        }
    }

    @Override
    public void saveChunkEntities(List<Entity> entities, boolean clearStored) {
        if (entities.isEmpty()) {
            return;
        }
        StackingThread stackingThread = this.getStackingThread(entities.get(0).getWorld());
        if (stackingThread != null) {
            stackingThread.saveChunkEntities(entities, clearStored);
        }
    }

    @Override
    public <T extends Stack<?>> void saveChunkEntityStacks(List<T> stacks, boolean clearStored) {
        if (stacks.isEmpty()) {
            return;
        }
        StackingThread stackingThread = this.getStackingThread(((Stack)stacks.get(0)).getWorld());
        if (stackingThread != null) {
            stackingThread.saveChunkEntityStacks(stacks, clearStored);
        }
    }

    @Override
    public void saveAllData(boolean clearStored) {
        for (StackingThread stackingThread : this.stackingThreads.values()) {
            stackingThread.saveAllData(clearStored);
        }
    }

    @Override
    public void tryStackEntity(StackedEntity stackedEntity) {
        StackingThread stackingThread = this.getStackingThread(stackedEntity.getEntity().getWorld());
        if (stackingThread == null) {
            return;
        }
        stackingThread.tryStackEntity(stackedEntity);
    }

    @Override
    public void tryStackItem(StackedItem stackedItem) {
        StackingThread stackingThread = this.getStackingThread(stackedItem.getItem().getWorld());
        if (stackingThread == null) {
            return;
        }
        stackingThread.tryStackItem(stackedItem);
    }

    @Override
    public void tryUnstackEntity(StackedEntity stackedEntity) {
        StackingThread stackingThread = this.getStackingThread(stackedEntity.getEntity().getWorld());
        if (stackingThread == null) {
            return;
        }
        stackingThread.tryUnstackEntity(stackedEntity);
    }

    public boolean isEntityStackingEnabled() {
        return SettingKey.ENTITY_STACKING_ENABLED.get();
    }

    public boolean isItemStackingEnabled() {
        return SettingKey.ITEM_STACKING_ENABLED.get();
    }

    public boolean isBlockStackingEnabled() {
        return SettingKey.BLOCK_STACKING_ENABLED.get();
    }

    public boolean isSpawnerStackingEnabled() {
        return SettingKey.SPAWNER_STACKING_ENABLED.get();
    }

    @Nullable
    public StackingThread getStackingThread(World world) {
        return this.stackingThreads.get(world.getUID());
    }

    @NotNull
    public Map<UUID, StackingThread> getStackingThreads() {
        return this.stackingThreads;
    }

    public void loadWorld(World world) {
        if (this.isWorldDisabled(world) || this.stackingThreads.containsKey(world.getUID())) {
            return;
        }
        this.stackingThreads.put(world.getUID(), new StackingThread(this.rosePlugin, this, world));
    }

    public void unloadWorld(World world) {
        UUID worldUUID = world.getUID();
        StackingThread stackingThread = this.stackingThreads.get(worldUUID);
        if (stackingThread != null) {
            stackingThread.close();
            this.stackingThreads.remove(worldUUID);
        }
    }

    public boolean isBlockTypeStackable(Block block) {
        BlockStackSettings stackSettings = this.rosePlugin.getManager(StackSettingManager.class).getBlockStackSettings(block);
        return stackSettings != null && stackSettings.isStackingEnabled();
    }

    public boolean isSpawnerTypeStackable(EntityType entityType) {
        SpawnerStackSettings stackSettings = this.rosePlugin.getManager(StackSettingManager.class).getSpawnerStackSettings(entityType);
        return stackSettings != null && stackSettings.isStackingEnabled();
    }

    public boolean isSpawnerTypeStackable(SpawnerType spawnerType) {
        SpawnerStackSettings stackSettings = this.rosePlugin.getManager(StackSettingManager.class).getSpawnerStackSettings(spawnerType);
        return stackSettings != null && stackSettings.isStackingEnabled();
    }

    public boolean isWorldDisabled(World world) {
        if (world == null) {
            return true;
        }
        return this.disabledWorldNames.contains(world.getName());
    }

    public boolean isAreaDisabled(Location location) {
        World world = location.getWorld();
        if (this.isWorldDisabled(world)) {
            return true;
        }
        return !WorldGuardHook.testLocation(location);
    }

    public void changeStackingThread(UUID entityUUID, StackedEntity stackedEntity, World from, World to) {
        StackingThread fromThread = this.getStackingThread(from);
        StackingThread toThread = this.getStackingThread(to);
        if (fromThread == null || toThread == null) {
            return;
        }
        DataUtils.writeStackedEntity(stackedEntity);
        fromThread.transferExistingEntityStack(entityUUID, stackedEntity, toThread);
    }

    public void changeStackingThread(UUID entityUUID, StackedItem stackedItem, World from, World to) {
        StackingThread fromThread = this.getStackingThread(from);
        StackingThread toThread = this.getStackingThread(to);
        if (fromThread == null || toThread == null) {
            return;
        }
        DataUtils.writeStackedItem(stackedItem);
        fromThread.transferExistingItemStack(entityUUID, stackedItem, toThread);
    }

    public void setEntityStackingTemporarilyDisabled(boolean disabled) {
        this.isEntityStackingTemporarilyDisabled = disabled;
    }

    public void setEntityUnstackingTemporarilyDisabled(boolean disabled) {
        this.isEntityUnstackingTemporarilyDisabled = disabled;
    }

    public boolean isEntityStackingTemporarilyDisabled() {
        return this.isEntityStackingTemporarilyDisabled;
    }

    public boolean isEntityUnstackingTemporarilyDisabled() {
        return this.isEntityUnstackingTemporarilyDisabled;
    }

    public StackedEntityDataStorageType getEntityDataStorageType(EntityType entityType) {
        EntityStackSettings entityStackSettings = this.rosePlugin.getManager(StackSettingManager.class).getEntityStackSettings(entityType);
        if (entityStackSettings != null && entityStackSettings.getStackedEntityDataStorageType() != null) {
            return entityStackSettings.getStackedEntityDataStorageType();
        }
        return this.entityDataStorageType;
    }

    public MultikillBound getLowerMultikillBound() {
        return this.lowerMultikillBound;
    }

    public MultikillBound getUpperMultikillBound() {
        return this.upperMultikillBound;
    }
}

