/*
 * Decompiled with CFR 0.152.
 */
package dev.rosewood.rosestacker.manager;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import dev.rosewood.rosestacker.lib.rosegarden.RosePlugin;
import dev.rosewood.rosestacker.lib.rosegarden.compatibility.CompatibilityAdapter;
import dev.rosewood.rosestacker.lib.rosegarden.config.CommentedFileConfiguration;
import dev.rosewood.rosestacker.lib.rosegarden.manager.Manager;
import dev.rosewood.rosestacker.nms.NMSAdapter;
import dev.rosewood.rosestacker.nms.spawner.SpawnerType;
import dev.rosewood.rosestacker.stack.settings.BlockStackSettings;
import dev.rosewood.rosestacker.stack.settings.EntityStackSettings;
import dev.rosewood.rosestacker.stack.settings.ItemStackSettings;
import dev.rosewood.rosestacker.stack.settings.SpawnerStackSettings;
import dev.rosewood.rosestacker.stack.settings.conditions.spawner.ConditionTags;
import dev.rosewood.rosestacker.utils.ItemUtils;
import dev.rosewood.rosestacker.utils.StackerUtils;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.permissions.Permission;
import org.bukkit.plugin.PluginManager;

public class StackSettingManager
extends Manager {
    private final Map<Material, BlockStackSettings> blockSettings = new LinkedHashMap<Material, BlockStackSettings>();
    private final Map<EntityType, EntityStackSettings> entitySettings = new LinkedHashMap<EntityType, EntityStackSettings>();
    private final Map<Material, ItemStackSettings> itemSettings = new LinkedHashMap<Material, ItemStackSettings>();
    private final Map<SpawnerType, SpawnerStackSettings> spawnerSettings = new LinkedHashMap<SpawnerType, SpawnerStackSettings>();
    private static boolean registeredPermissions = false;

    public StackSettingManager(RosePlugin rosePlugin) {
        super(rosePlugin);
    }

    @Override
    public void reload() {
        File blockSettingsFile = this.getBlockSettingsFile();
        File entitySettingsFile = this.getEntitySettingsFile();
        File itemSettingsFile = this.getItemSettingsFile();
        File spawnerSettingsFile = this.getSpawnerSettingsFile();
        AtomicBoolean saveBlockSettingsFile = new AtomicBoolean(false);
        AtomicBoolean saveEntitySettingsFile = new AtomicBoolean(false);
        AtomicBoolean saveItemSettingsFile = new AtomicBoolean(false);
        AtomicBoolean saveSpawnerSettingsFile = new AtomicBoolean(false);
        CommentedFileConfiguration blockSettingsConfiguration = CommentedFileConfiguration.loadConfiguration(blockSettingsFile);
        StackerUtils.getPossibleStackableBlockMaterials().forEach(x -> {
            BlockStackSettings blockStackSettings = new BlockStackSettings(blockSettingsConfiguration, (Material)x);
            this.blockSettings.put((Material)x, blockStackSettings);
            if (blockStackSettings.hasChanges()) {
                saveBlockSettingsFile.set(true);
            }
        });
        CommentedFileConfiguration entitySettingsConfiguration = CommentedFileConfiguration.loadConfiguration(entitySettingsFile);
        try (InputStream entityDataStream = this.getClass().getResourceAsStream("/entity_data.json");
             InputStreamReader entityDataReader = new InputStreamReader(entityDataStream);){
            JsonParser jsonParser = new JsonParser();
            JsonObject jsonObject = jsonParser.parse((Reader)entityDataReader).getAsJsonObject();
            TreeSet invalidKeys = new TreeSet();
            TreeSet treeSet = new TreeSet(Map.Entry.comparingByKey());
            treeSet.addAll(jsonObject.entrySet());
            treeSet.forEach(entry -> {
                EntityType entityType;
                String name = (String)entry.getKey();
                try {
                    entityType = EntityType.valueOf((String)name);
                }
                catch (Exception e) {
                    JsonObject entityObject = ((JsonElement)entry.getValue()).getAsJsonObject();
                    if (entityObject.has("alternate_id")) {
                        String alternateId = entityObject.get("alternate_id").getAsString();
                        try {
                            entityType = EntityType.valueOf((String)alternateId);
                        }
                        catch (Exception e2) {
                            invalidKeys.add(name);
                            return;
                        }
                    }
                    invalidKeys.add(name);
                    return;
                }
                EntityStackSettings entityStackSetting = new EntityStackSettings(entitySettingsConfiguration, ((JsonElement)entry.getValue()).getAsJsonObject(), entityType);
                this.entitySettings.put(entityType, entityStackSetting);
                if (entityStackSetting.hasChanges()) {
                    saveEntitySettingsFile.set(true);
                }
            });
            if (!invalidKeys.isEmpty()) {
                this.rosePlugin.getLogger().info("Ignored loading stack settings for unknown entities: " + String.valueOf(invalidKeys));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        CommentedFileConfiguration itemSettingsConfiguration = CommentedFileConfiguration.loadConfiguration(itemSettingsFile);
        Stream.of(Material.values()).sorted(Comparator.comparing(Enum::name)).forEach(x -> {
            ItemStackSettings itemStackSettings = new ItemStackSettings(itemSettingsConfiguration, (Material)x);
            this.itemSettings.put((Material)x, itemStackSettings);
            if (itemStackSettings.hasChanges()) {
                saveItemSettingsFile.set(true);
            }
        });
        boolean addSpawnerHeaderComments = !spawnerSettingsFile.exists();
        CommentedFileConfiguration spawnerSettingsConfiguration = CommentedFileConfiguration.loadConfiguration(spawnerSettingsFile);
        if (addSpawnerHeaderComments) {
            saveSpawnerSettingsFile.set(true);
            Map<String, String> conditionTags = ConditionTags.getTagDescriptionMap();
            spawnerSettingsConfiguration.addComments("Available Spawn Requirements:", "");
            for (Map.Entry entry2 : conditionTags.entrySet()) {
                String tag = (String)entry2.getKey();
                String description = (String)entry2.getValue();
                spawnerSettingsConfiguration.addComments(tag + " - " + description);
            }
            spawnerSettingsConfiguration.addComments("", "Valid Blocks: https://hub.spigotmc.org/javadocs/spigot/org/bukkit/Material.html", "Valid Biomes: https://hub.spigotmc.org/javadocs/spigot/org/bukkit/block/Biome.html", "", "Want to remove all requirements? Set the value to the following:", "spawn-requirements: []", "", "If on 1.21.3+, tooltip-style can be set to a namespaced key to change the item tooltip style.");
        }
        TreeSet<SpawnerType> spawnerTypes = new TreeSet<SpawnerType>(Comparator.comparing(SpawnerType::getEnumName));
        if (NMSAdapter.getHandler().supportsEmptySpawners()) {
            spawnerTypes.add(SpawnerType.empty());
        }
        this.entitySettings.keySet().forEach(x -> spawnerTypes.add(SpawnerType.of(x)));
        spawnerTypes.forEach(spawnerType -> {
            SpawnerStackSettings spawnerStackSettings = new SpawnerStackSettings(spawnerSettingsConfiguration, (SpawnerType)spawnerType);
            this.spawnerSettings.put((SpawnerType)spawnerType, spawnerStackSettings);
            if (spawnerStackSettings.hasChanges()) {
                saveSpawnerSettingsFile.set(true);
            }
        });
        if (saveBlockSettingsFile.get()) {
            blockSettingsConfiguration.save(blockSettingsFile, true);
        }
        if (saveEntitySettingsFile.get()) {
            entitySettingsConfiguration.save(entitySettingsFile, true);
        }
        if (saveItemSettingsFile.get()) {
            itemSettingsConfiguration.save(itemSettingsFile, true);
        }
        if (saveSpawnerSettingsFile.get()) {
            spawnerSettingsConfiguration.save(spawnerSettingsFile, true);
        }
        if (!registeredPermissions) {
            PluginManager pluginManager = Bukkit.getPluginManager();
            ArrayList<Permission> arrayList = new ArrayList<Permission>();
            ArrayList<Permission> nosilk = new ArrayList<Permission>();
            ArrayList<Permission> spawnerplace = new ArrayList<Permission>();
            ArrayList<Permission> spawnerconvert = new ArrayList<Permission>();
            for (EntityType entityType : this.entitySettings.keySet()) {
                String type = entityType.getKey().getKey();
                arrayList.add(new Permission("rosestacker.silktouch." + type));
                nosilk.add(new Permission("rosestacker.nosilk." + type));
                spawnerplace.add(new Permission("rosestacker.spawnerplace." + type));
                spawnerconvert.add(new Permission("rosestacker.spawnerconvert." + type));
            }
            arrayList.forEach(arg_0 -> ((PluginManager)pluginManager).addPermission(arg_0));
            pluginManager.addPermission(new Permission("rosestacker.silktouch.*", arrayList.stream().collect(Collectors.toMap(Permission::getName, x -> true))));
            nosilk.forEach(arg_0 -> ((PluginManager)pluginManager).addPermission(arg_0));
            pluginManager.addPermission(new Permission("rosestacker.nosilk.*", nosilk.stream().collect(Collectors.toMap(Permission::getName, x -> true))));
            spawnerplace.forEach(arg_0 -> ((PluginManager)pluginManager).addPermission(arg_0));
            pluginManager.addPermission(new Permission("rosestacker.spawnerplace.*", spawnerplace.stream().collect(Collectors.toMap(Permission::getName, x -> true))));
            spawnerconvert.forEach(arg_0 -> ((PluginManager)pluginManager).addPermission(arg_0));
            pluginManager.addPermission(new Permission("rosestacker.spawnerconvert.*", spawnerconvert.stream().collect(Collectors.toMap(Permission::getName, x -> true))));
            registeredPermissions = true;
        }
    }

    @Override
    public void disable() {
        this.blockSettings.clear();
        this.entitySettings.clear();
        this.itemSettings.clear();
        this.spawnerSettings.clear();
    }

    public File getBlockSettingsFile() {
        return new File(this.rosePlugin.getDataFolder(), "block_settings.yml");
    }

    public File getEntitySettingsFile() {
        return new File(this.rosePlugin.getDataFolder(), "entity_settings.yml");
    }

    public File getItemSettingsFile() {
        return new File(this.rosePlugin.getDataFolder(), "item_settings.yml");
    }

    public File getSpawnerSettingsFile() {
        return new File(this.rosePlugin.getDataFolder(), "spawner_settings.yml");
    }

    public BlockStackSettings getBlockStackSettings(Material material) {
        return this.blockSettings.get(material);
    }

    public BlockStackSettings getBlockStackSettings(Block block) {
        return this.getBlockStackSettings(block.getType());
    }

    public EntityStackSettings getEntityStackSettings(EntityType entityType) {
        return this.entitySettings.get(entityType);
    }

    public EntityStackSettings getEntityStackSettings(LivingEntity entity) {
        return this.getEntityStackSettings(entity.getType());
    }

    public EntityStackSettings getEntityStackSettings(Material material) {
        if (!ItemUtils.isSpawnEgg(material)) {
            return null;
        }
        for (EntityStackSettings settings : this.entitySettings.values()) {
            if (settings.getEntityTypeData().spawnEggMaterial() != material) continue;
            return settings;
        }
        return null;
    }

    public ItemStackSettings getItemStackSettings(Material material) {
        return this.itemSettings.get(material);
    }

    public ItemStackSettings getItemStackSettings(Item item) {
        return this.getItemStackSettings(item.getItemStack().getType());
    }

    public SpawnerStackSettings getSpawnerStackSettings(SpawnerType spawnerType) {
        return this.spawnerSettings.get(spawnerType);
    }

    public SpawnerStackSettings getSpawnerStackSettings(EntityType entityType) {
        return this.getSpawnerStackSettings(SpawnerType.of(entityType));
    }

    public SpawnerStackSettings getSpawnerStackSettings(CreatureSpawner creatureSpawner) {
        return this.getSpawnerStackSettings(CompatibilityAdapter.getCreatureSpawnerHandler().getSpawnedType(creatureSpawner));
    }

    public Set<EntityType> getStackableEntityTypes() {
        return this.entitySettings.values().stream().filter(EntityStackSettings::isStackingEnabled).map(EntityStackSettings::getEntityType).collect(Collectors.toSet());
    }

    public Set<EntityType> getStackableEntityTypesWithSpawnEggs() {
        return this.entitySettings.values().stream().filter(x -> x.getEntityTypeData().spawnEggMaterial() != null).filter(EntityStackSettings::isStackingEnabled).map(EntityStackSettings::getEntityType).collect(Collectors.toSet());
    }

    public Set<Material> getStackableItemTypes() {
        return this.itemSettings.values().stream().filter(ItemStackSettings::isStackingEnabled).map(ItemStackSettings::getType).collect(Collectors.toSet());
    }

    public Set<Material> getStackableBlockTypes() {
        return this.blockSettings.values().stream().filter(BlockStackSettings::isStackingEnabled).map(BlockStackSettings::getType).collect(Collectors.toSet());
    }

    public Set<SpawnerType> getStackableSpawnerTypes() {
        return this.spawnerSettings.values().stream().filter(SpawnerStackSettings::isStackingEnabled).map(SpawnerStackSettings::getSpawnerType).collect(Collectors.toSet());
    }
}

