/*
 * Decompiled with CFR 0.152.
 */
package dev.rosewood.rosestacker.nms;

import dev.rosewood.rosestacker.nms.hologram.Hologram;
import dev.rosewood.rosestacker.nms.spawner.StackedSpawnerTile;
import dev.rosewood.rosestacker.nms.storage.EntityDataEntry;
import dev.rosewood.rosestacker.nms.storage.StackedEntityDataStorage;
import dev.rosewood.rosestacker.nms.storage.StackedEntityDataStorageType;
import dev.rosewood.rosestacker.nms.storage.StorageMigrationType;
import java.util.List;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public interface NMSHandler {
    public static final List<String> REMOVABLE_NBT_KEYS = List.of("UUID", "Pos", "Rotation", "WorldUUIDMost", "WorldUUIDLeast", "Motion", "OnGround", "FallDistance", "Leash", "Spigot.ticksLived", "Paper.OriginWorld", "Paper.Origin", "Patrolling", "PatrolTarget", "RaidId", "Wave", "AngryAt", "AngerTime", "Pose", "LastPoseTick", "uuid", "pos", "rotation", "world_uuid_most", "world_uuid_least", "motion", "on_ground", "fall_distance", "leash", "patrolling", "patrol_target", "raid_id", "wave", "angry_at", "anger_time", "pose", "last_pose_tick");
    public static final List<String> UNSAFE_NBT_KEYS = List.of("ArmorItems", "HandItems", "Items", "ChestedHorse", "Saddle", "DecorItem", "Inventory", "carriedBlockState", "DeathTime", "Health", "Attributes", "ActiveEffects", "ArmorDropChances", "HandDropChances", "Brain", "LeftHanded", "Team", "SaddleItem", "CanPickUpLoot", "Equipment", "DropChances", "armor_items", "hand_items", "items", "chested_horse", "saddle", "decor_item", "inventory", "carried_block_state", "death_time", "health", "attributes", "active_effects", "armor_drop_chances", "hand_drop_chances", "brain", "left_handed", "team", "saddle_item", "can_pick_up_loot", "equipment", "drop_chances");

    public LivingEntity createNewEntityUnspawned(EntityType var1, Location var2, CreatureSpawnEvent.SpawnReason var3);

    public void spawnExistingEntity(LivingEntity var1, CreatureSpawnEvent.SpawnReason var2, boolean var3);

    default public LivingEntity spawnEntityWithReason(EntityType entityType, Location location, CreatureSpawnEvent.SpawnReason spawnReason, boolean bypassSpawnEvent) {
        LivingEntity entity = this.createNewEntityUnspawned(entityType, location, spawnReason);
        this.spawnExistingEntity(entity, spawnReason, bypassSpawnEvent);
        return entity;
    }

    public void updateEntityNameTagForPlayer(Player var1, Entity var2, String var3, boolean var4);

    public void updateEntityNameTagVisibilityForPlayer(Player var1, Entity var2, boolean var3);

    public void unigniteCreeper(Creeper var1);

    public void removeEntityGoals(LivingEntity var1);

    public ItemStack setItemStackNBT(ItemStack var1, String var2, String var3);

    public ItemStack setItemStackNBT(ItemStack var1, String var2, int var3);

    public String getItemStackNBTString(ItemStack var1, String var2);

    public int getItemStackNBTInt(ItemStack var1, String var2);

    public String getItemStackNBTStringFromCompound(ItemStack var1, String var2, String var3);

    public void setLastHurtBy(LivingEntity var1, Player var2);

    public boolean hasLineOfSight(LivingEntity var1, Location var2);

    default public boolean hasLineOfSight(LivingEntity entity1, Entity entity2) {
        Location location = entity2 instanceof LivingEntity ? ((LivingEntity)entity2).getEyeLocation() : entity2.getLocation().add(0.0, entity2.getHeight() * 0.85, 0.0);
        return this.hasLineOfSight(entity1, location);
    }

    public boolean isActiveRaider(LivingEntity var1);

    public EntityDataEntry createEntityDataEntry(LivingEntity var1);

    public StackedEntityDataStorage createEntityDataStorage(LivingEntity var1, StackedEntityDataStorageType var2);

    public StackedEntityDataStorage deserializeEntityDataStorage(LivingEntity var1, byte[] var2, StackedEntityDataStorageType var3, Set<StorageMigrationType> var4);

    public StackedSpawnerTile injectStackedSpawnerTile(Object var1);

    public Hologram createHologram(Location var1, List<String> var2);

    default public boolean supportsEmptySpawners() {
        return false;
    }

    default public void hijackRandomSource(World world) {
    }

    default public void setPaperFromMobSpawner(Entity entity) {
    }

    public void setCustomNameUncapped(Entity var1, String var2);

    public int getItemDespawnRate(Item var1);

    public EntityDeathEvent createAsyncEntityDeathEvent(@NotNull LivingEntity var1, @NotNull List<ItemStack> var2, int var3);

    default public List<Entity> getEntities(World world) {
        return world.getEntities();
    }
}

