/*
 * Decompiled with CFR 0.152.
 */
package dev.rosewood.rosestacker.nms.hologram;

import dev.rosewood.rosestacker.nms.hologram.HologramLine;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.Supplier;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public abstract class Hologram {
    private static final double LINE_OFFSET = 0.3;
    protected final List<HologramLine> hologramLines;
    protected final Map<Player, Boolean> watchers;
    protected final Location location;
    private final Supplier<Integer> entityIdSupplier;

    public Hologram(List<String> text, Location location, Supplier<Integer> entityIdSupplier) {
        this.location = location.clone();
        this.watchers = Collections.synchronizedMap(new WeakHashMap());
        this.entityIdSupplier = entityIdSupplier;
        this.hologramLines = new ArrayList<HologramLine>();
        this.createLines(text);
    }

    public void addWatcher(Player player, boolean visible) {
        if (!this.watchers.containsKey(player)) {
            this.watchers.put(player, visible);
            this.create(player);
            this.update(List.of(player), true);
        }
    }

    public void addWatcher(Player player) {
        this.addWatcher(player, true);
    }

    public void removeWatcher(Player player) {
        if (this.watchers.containsKey(player)) {
            this.watchers.remove(player);
            this.delete(player);
        }
    }

    public Set<Player> getWatchers() {
        return this.watchers.keySet();
    }

    public Location getLocation() {
        return this.location;
    }

    public Location getDisplayLocation() {
        return this.location.clone().add(0.0, 1.0, 0.0);
    }

    public List<String> getText() {
        return this.hologramLines.stream().map(HologramLine::getText).toList();
    }

    public void setVisibility(Player player, boolean visible) {
        Boolean alreadyVisible = this.watchers.get(player);
        if (alreadyVisible == null) {
            return;
        }
        if (alreadyVisible ^ visible) {
            this.watchers.put(player, visible);
            this.update(List.of(player), true);
        }
    }

    public void delete() {
        this.watchers.keySet().forEach(this::delete);
        this.watchers.clear();
    }

    public void setText(List<String> text) {
        if (text.size() != this.hologramLines.size()) {
            this.createLines(text);
            return;
        }
        for (int i = 0; i < text.size(); ++i) {
            this.hologramLines.get(i).setText(text.get(i));
        }
        this.update(this.watchers.keySet(), false);
    }

    private void createLines(List<String> text) {
        this.watchers.keySet().forEach(this::delete);
        this.hologramLines.clear();
        for (int i = 0; i < text.size(); ++i) {
            double offset = (double)(text.size() - i - 1) * 0.3;
            Location lineLocation = this.location.clone().add(0.0, offset, 0.0);
            this.hologramLines.add(new HologramLine(this.entityIdSupplier.get(), lineLocation, text.get(i)));
        }
        this.watchers.keySet().forEach(this::create);
        this.update(this.watchers.keySet(), true);
    }

    protected abstract void create(Player var1);

    protected abstract void update(Collection<Player> var1, boolean var2);

    protected abstract void delete(Player var1);
}

