/*
 * Decompiled with CFR 0.152.
 */
package dev.rosewood.rosestacker.nms.spawner;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.entity.EntityType;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Experimental
public final class SpawnerType {
    private static final SpawnerType EMPTY = new SpawnerType();
    private final List<EntityType> entityTypes;
    private int activeIndex;

    private SpawnerType() {
        this.entityTypes = List.of();
    }

    private SpawnerType(EntityType entityType) {
        this.entityTypes = List.of(entityType);
    }

    private SpawnerType(Collection<EntityType> entityTypes) {
        this.entityTypes = List.copyOf(entityTypes);
    }

    public Optional<EntityType> get() {
        if (this.entityTypes.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(this.entityTypes.get(this.activeIndex));
    }

    public EntityType getOrThrow() {
        return this.get().orElseThrow(() -> new IllegalStateException("Check isEmpty() before calling getOrThrow()"));
    }

    public EntityType next() {
        if (this.entityTypes.isEmpty()) {
            throw new IllegalStateException("Check isEmpty() before calling next()");
        }
        this.activeIndex = (this.activeIndex + 1) % this.entityTypes.size();
        return this.entityTypes.get(this.activeIndex);
    }

    public boolean isEmpty() {
        return this.entityTypes.isEmpty();
    }

    public int size() {
        return this.entityTypes.size();
    }

    public List<EntityType> getEntityTypes() {
        return this.entityTypes;
    }

    public String getEnumName() {
        return this.get().map(Enum::name).orElse("EMPTY");
    }

    public static SpawnerType of(EntityType entityType) {
        if (entityType == null || entityType == EntityType.UNKNOWN) {
            return SpawnerType.empty();
        }
        return new SpawnerType(entityType);
    }

    public static SpawnerType of(EntityType ... entityTypes) {
        return new SpawnerType(Arrays.asList(entityTypes));
    }

    public static SpawnerType of(Collection<EntityType> entityTypes) {
        if (entityTypes.isEmpty()) {
            return SpawnerType.empty();
        }
        Set<EntityType> filteredTypes = entityTypes.stream().filter(x -> x != null && x != EntityType.UNKNOWN).collect(Collectors.toSet());
        return new SpawnerType(filteredTypes);
    }

    public static SpawnerType empty() {
        return EMPTY;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SpawnerType)) {
            return false;
        }
        SpawnerType other = (SpawnerType)obj;
        return this.entityTypes.equals(other.entityTypes);
    }

    public int hashCode() {
        return this.entityTypes.hashCode();
    }
}

