/*
 * Decompiled with CFR 0.152.
 */
package dev.rosewood.rosestacker.nms.storage;

import dev.rosewood.rosestacker.nms.storage.EntityDataEntry;
import dev.rosewood.rosestacker.nms.storage.StackedEntityDataIOException;
import dev.rosewood.rosestacker.nms.storage.StackedEntityDataStorage;
import dev.rosewood.rosestacker.nms.storage.StackedEntityDataStorageType;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import org.bukkit.entity.LivingEntity;

public abstract class AbstractSimpleStackedEntityDataStorage
extends StackedEntityDataStorage {
    protected int size = 0;

    public AbstractSimpleStackedEntityDataStorage(LivingEntity livingEntity) {
        super(StackedEntityDataStorageType.SIMPLE, livingEntity);
    }

    public AbstractSimpleStackedEntityDataStorage(LivingEntity livingEntity, byte[] data) {
        this(livingEntity);
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(data);
             ObjectInputStream dataInput = new ObjectInputStream(inputStream);){
            this.size = dataInput.readInt();
        }
        catch (Exception e) {
            throw new StackedEntityDataIOException(e);
        }
    }

    @Override
    public void add(LivingEntity entity) {
        ++this.size;
    }

    @Override
    public void addAll(StackedEntityDataStorage stackedEntityDataStorage) {
        this.size += stackedEntityDataStorage.size();
    }

    @Override
    public void addClones(int amount) {
        this.size += amount;
    }

    @Override
    public EntityDataEntry peek() {
        return this.copy();
    }

    @Override
    public EntityDataEntry pop() {
        if (this.isEmpty()) {
            throw new IllegalStateException("No more data is available");
        }
        --this.size;
        return this.copy();
    }

    @Override
    public List<EntityDataEntry> pop(int amount) {
        amount = Math.min(amount, this.size);
        this.size -= amount;
        Object[] popped = new EntityDataEntry[amount];
        Arrays.fill(popped, this.copy());
        return Arrays.asList(popped);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public List<EntityDataEntry> getAll() {
        Object[] entries = new EntityDataEntry[this.size];
        Arrays.fill(entries, this.copy());
        return Arrays.asList(entries);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] serialize(int maxAmount) {
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            byte[] byArray;
            try (ObjectOutputStream dataOutput = new ObjectOutputStream(outputStream);){
                dataOutput.writeInt(Math.min(maxAmount, this.size()));
                dataOutput.close();
                byArray = outputStream.toByteArray();
            }
            return byArray;
        }
        catch (Exception e) {
            throw new StackedEntityDataIOException(e);
        }
    }

    @Override
    public void forEachCapped(int count, Consumer<LivingEntity> consumer) {
        LivingEntity entity = (LivingEntity)this.entity.get();
        if (entity == null) {
            return;
        }
        int amount = Math.min(count, this.size);
        LivingEntity clone = this.copy().createEntity(entity.getLocation(), false, entity.getType());
        for (int i = 0; i < amount; ++i) {
            consumer.accept(clone);
        }
    }

    @Override
    public List<LivingEntity> removeIf(Function<LivingEntity, Boolean> function) {
        LivingEntity entity = (LivingEntity)this.entity.get();
        if (entity == null) {
            return List.of();
        }
        ArrayList<LivingEntity> removedEntries = new ArrayList<LivingEntity>(this.size);
        LivingEntity clone = this.copy().createEntity(entity.getLocation(), false, entity.getType());
        for (int i = 0; i < this.size; ++i) {
            if (!function.apply(clone).booleanValue()) continue;
            removedEntries.add(clone);
        }
        this.size -= removedEntries.size();
        return removedEntries;
    }

    protected abstract EntityDataEntry copy();
}

