/*
 * Decompiled with CFR 0.152.
 */
package dev.rosewood.rosestacker.nms.storage;

import dev.rosewood.rosestacker.nms.storage.EntityDataEntry;
import dev.rosewood.rosestacker.nms.storage.StackedEntityDataStorageType;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.Consumer;
import java.util.function.Function;
import org.bukkit.entity.LivingEntity;

public abstract class StackedEntityDataStorage {
    private final StackedEntityDataStorageType type;
    protected Reference<LivingEntity> entity;

    public StackedEntityDataStorage(StackedEntityDataStorageType type, LivingEntity entity) {
        this.type = type;
        this.entity = new WeakReference<LivingEntity>(entity);
    }

    public StackedEntityDataStorageType getType() {
        return this.type;
    }

    public LivingEntity getEntity() {
        return this.entity.get();
    }

    public void updateEntity(LivingEntity entity) {
        this.entity = new WeakReference<LivingEntity>(entity);
    }

    public abstract void add(LivingEntity var1);

    public abstract void addAll(StackedEntityDataStorage var1);

    public abstract void addClones(int var1);

    public abstract EntityDataEntry peek();

    public abstract EntityDataEntry pop();

    public abstract List<EntityDataEntry> pop(int var1);

    public abstract int size();

    public abstract boolean isEmpty();

    public abstract List<EntityDataEntry> getAll();

    public abstract byte[] serialize(int var1);

    public byte[] serialize() {
        return this.serialize(Integer.MAX_VALUE);
    }

    public void forEach(Consumer<LivingEntity> consumer) {
        this.forEachCapped(Integer.MAX_VALUE, consumer);
    }

    public abstract void forEachCapped(int var1, Consumer<LivingEntity> var2);

    public void forEachTransforming(Function<LivingEntity, Boolean> function) {
        this.forEach(function::apply);
    }

    public abstract List<LivingEntity> removeIf(Function<LivingEntity, Boolean> var1);

    public static <T> Queue<T> createBackingQueue() {
        return new LinkedBlockingQueue();
    }
}

