/*
 * Decompiled with CFR 0.152.
 */
package dev.rosewood.rosestacker.nms.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.stream.Collectors;

public final class ReflectionUtils {
    private ReflectionUtils() {
    }

    public static Field getFieldByName(Class<?> clazz, String name) {
        try {
            Field field = clazz.getDeclaredField(name);
            field.setAccessible(true);
            return field;
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalStateException("Failed to get field reflectively: [" + clazz.getName() + ";" + name + "]");
        }
    }

    public static Field getFieldByPositionAndType(Class<?> clazz, int index, Class<?> type) {
        int n = 0;
        for (Field field : clazz.getDeclaredFields()) {
            if (!type.isAssignableFrom(field.getType()) || n++ != index) continue;
            field.setAccessible(true);
            return field;
        }
        throw new IllegalStateException("Failed to get field reflectively: [" + clazz.getName() + ";" + type.getName() + ";" + index + "]");
    }

    public static Method getMethodByName(Class<?> clazz, String name, Class<?> ... parameterTypes) {
        try {
            Method method = clazz.getDeclaredMethod(name, parameterTypes);
            method.setAccessible(true);
            return method;
        }
        catch (ReflectiveOperationException e) {
            try {
                Method method = clazz.getMethod(name, parameterTypes);
                method.setAccessible(true);
                return method;
            }
            catch (ReflectiveOperationException e2) {
                throw new IllegalStateException("Failed to get method reflectively: [" + clazz.getName() + ";" + Arrays.stream(parameterTypes).map(Class::getName).collect(Collectors.joining(";")) + "]");
            }
        }
    }

    public static Method getMethodByPositionAndTypes(Class<?> clazz, int index, Class<?> ... parameterTypes) {
        int n = 0;
        block0: for (Method method : clazz.getDeclaredMethods()) {
            Class<?>[] types = method.getParameterTypes();
            if (types.length != parameterTypes.length) continue;
            for (int i = 0; i < types.length; ++i) {
                if (!parameterTypes[i].isAssignableFrom(types[i])) continue block0;
            }
            if (n++ != index) continue;
            method.setAccessible(true);
            return method;
        }
        throw new IllegalStateException("Failed to get method reflectively: [" + clazz.getName() + ";" + index + ";" + Arrays.stream(parameterTypes).map(Class::getName).collect(Collectors.joining(";")) + "]");
    }

    public static <T> Constructor<T> getConstructor(Class<T> clazz, Class<?> ... parameterTypes) {
        try {
            Constructor<T> constructor = clazz.getDeclaredConstructor(parameterTypes);
            constructor.setAccessible(true);
            return constructor;
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalStateException("Failed to get constructor reflectively: [" + clazz.getName() + ";" + Arrays.stream(parameterTypes).map(Class::getName).collect(Collectors.joining(";")) + "]");
        }
    }
}

