/*
 * Decompiled with CFR 0.152.
 */
package dev.rosewood.rosestacker.nms.v1_16_R3;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import dev.rosewood.rosestacker.lib.rosegarden.utils.NMSUtil;
import dev.rosewood.rosestacker.nms.NMSHandler;
import dev.rosewood.rosestacker.nms.hologram.Hologram;
import dev.rosewood.rosestacker.nms.spawner.StackedSpawnerTile;
import dev.rosewood.rosestacker.nms.storage.EntityDataEntry;
import dev.rosewood.rosestacker.nms.storage.StackedEntityDataStorage;
import dev.rosewood.rosestacker.nms.storage.StackedEntityDataStorageType;
import dev.rosewood.rosestacker.nms.storage.StorageMigrationType;
import dev.rosewood.rosestacker.nms.util.ReflectionUtils;
import dev.rosewood.rosestacker.nms.v1_16_R3.entity.DataWatcherWrapper;
import dev.rosewood.rosestacker.nms.v1_16_R3.entity.SoloEntitySpider;
import dev.rosewood.rosestacker.nms.v1_16_R3.entity.SoloEntityStrider;
import dev.rosewood.rosestacker.nms.v1_16_R3.event.AsyncEntityDeathEventImpl;
import dev.rosewood.rosestacker.nms.v1_16_R3.hologram.HologramImpl;
import dev.rosewood.rosestacker.nms.v1_16_R3.spawner.StackedSpawnerTileImpl;
import dev.rosewood.rosestacker.nms.v1_16_R3.storage.NBTEntityDataEntry;
import dev.rosewood.rosestacker.nms.v1_16_R3.storage.NBTStackedEntityDataStorage;
import dev.rosewood.rosestacker.nms.v1_16_R3.storage.SimpleStackedEntityDataStorage;
import dev.rosewood.rosestacker.stack.StackedSpawner;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.server.v1_16_R3.BehaviorController;
import net.minecraft.server.v1_16_R3.BlockPosition;
import net.minecraft.server.v1_16_R3.Chunk;
import net.minecraft.server.v1_16_R3.ChunkStatus;
import net.minecraft.server.v1_16_R3.ControllerJump;
import net.minecraft.server.v1_16_R3.ControllerLook;
import net.minecraft.server.v1_16_R3.ControllerMove;
import net.minecraft.server.v1_16_R3.DataWatcher;
import net.minecraft.server.v1_16_R3.DataWatcherObject;
import net.minecraft.server.v1_16_R3.DataWatcherRegistry;
import net.minecraft.server.v1_16_R3.Entity;
import net.minecraft.server.v1_16_R3.EntityCreeper;
import net.minecraft.server.v1_16_R3.EntityHuman;
import net.minecraft.server.v1_16_R3.EntityInsentient;
import net.minecraft.server.v1_16_R3.EntityLiving;
import net.minecraft.server.v1_16_R3.EntityRabbit;
import net.minecraft.server.v1_16_R3.EntityRaider;
import net.minecraft.server.v1_16_R3.EntityTypes;
import net.minecraft.server.v1_16_R3.EntityVillagerAbstract;
import net.minecraft.server.v1_16_R3.EntityZombie;
import net.minecraft.server.v1_16_R3.EnumMobSpawn;
import net.minecraft.server.v1_16_R3.GroupDataEntity;
import net.minecraft.server.v1_16_R3.IChatBaseComponent;
import net.minecraft.server.v1_16_R3.IChunkAccess;
import net.minecraft.server.v1_16_R3.IRegistry;
import net.minecraft.server.v1_16_R3.MathHelper;
import net.minecraft.server.v1_16_R3.MerchantRecipeList;
import net.minecraft.server.v1_16_R3.MobSpawnerAbstract;
import net.minecraft.server.v1_16_R3.MovingObjectPosition;
import net.minecraft.server.v1_16_R3.NBTTagCompound;
import net.minecraft.server.v1_16_R3.Packet;
import net.minecraft.server.v1_16_R3.PacketPlayOutEntityMetadata;
import net.minecraft.server.v1_16_R3.PathfinderGoalFloat;
import net.minecraft.server.v1_16_R3.PathfinderGoalSelector;
import net.minecraft.server.v1_16_R3.PathfinderGoalWrapped;
import net.minecraft.server.v1_16_R3.RayTrace;
import net.minecraft.server.v1_16_R3.TileEntity;
import net.minecraft.server.v1_16_R3.TileEntityMobSpawner;
import net.minecraft.server.v1_16_R3.Vec3D;
import net.minecraft.server.v1_16_R3.World;
import net.minecraft.server.v1_16_R3.WorldAccess;
import net.minecraft.server.v1_16_R3.WorldServer;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_16_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftAbstractVillager;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftCreeper;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_16_R3.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_16_R3.util.CraftChatMessage;
import org.bukkit.craftbukkit.v1_16_R3.util.CraftNamespacedKey;
import org.bukkit.entity.AbstractVillager;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import sun.misc.Unsafe;

public class NMSHandlerImpl
implements NMSHandler {
    private static Method method_WorldServer_registerEntity;
    private static DataWatcherObject<Boolean> value_EntityCreeper_d;
    private static Field field_EntityCreeper_fuseTicks;
    private static Field field_PathfinderGoalSelector_d;
    private static Field field_EntityInsentient_lookController;
    private static Field field_EntityInsentient_moveController;
    private static Field field_EntityInsentient_jumpController;
    private static Field field_EntityLiving_behaviorController;
    private static Field field_Entity_spawnReason;
    private static AtomicInteger entityCounter;
    private static Unsafe unsafe;
    private static long field_SpawnerBlockEntity_spawner_offset;
    private static Field field_AbstractVillager_offers;

    @Override
    public LivingEntity createNewEntityUnspawned(EntityType entityType, Location location, CreatureSpawnEvent.SpawnReason spawnReason) {
        org.bukkit.World world = location.getWorld();
        if (world == null) {
            return null;
        }
        Class entityClass = entityType.getEntityClass();
        if (entityClass == null || !LivingEntity.class.isAssignableFrom(entityClass)) {
            throw new IllegalArgumentException("EntityType must be of a LivingEntity");
        }
        EntityTypes nmsEntityType = (EntityTypes)IRegistry.ENTITY_TYPE.get(CraftNamespacedKey.toMinecraft((NamespacedKey)entityType.getKey()));
        Object nmsEntity = this.createCreature(nmsEntityType, ((CraftWorld)world).getHandle(), null, null, null, new BlockPosition(location.getBlockX(), location.getBlockY(), location.getBlockZ()), this.toNmsSpawnReason(spawnReason));
        return nmsEntity == null ? null : (LivingEntity)nmsEntity.getBukkitEntity();
    }

    public <T extends Entity> T createCreature(EntityTypes<T> entityTypes, WorldServer worldserver, NBTTagCompound nbttagcompound, IChatBaseComponent ichatbasecomponent, EntityHuman entityhuman, BlockPosition blockposition, EnumMobSpawn enummobspawn) {
        Object newEntity = entityTypes == EntityTypes.SPIDER ? new SoloEntitySpider(entityTypes, (World)worldserver) : (entityTypes == EntityTypes.STRIDER ? new SoloEntityStrider(entityTypes, (World)worldserver) : entityTypes.a((World)worldserver));
        if (newEntity == null) {
            return null;
        }
        if (field_Entity_spawnReason != null) {
            try {
                field_Entity_spawnReason.set(newEntity, this.toBukkitSpawnReason(enummobspawn));
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        newEntity.setPositionRotation((double)blockposition.getX() + 0.5, blockposition.getY(), (double)blockposition.getZ() + 0.5, MathHelper.g((float)(worldserver.random.nextFloat() * 360.0f)), 0.0f);
        if (newEntity instanceof EntityInsentient) {
            EntityInsentient entityinsentient = (EntityInsentient)newEntity;
            entityinsentient.aC = entityinsentient.yaw;
            entityinsentient.aA = entityinsentient.yaw;
            EntityZombie.GroupDataZombie groupDataEntity = null;
            if (entityTypes == EntityTypes.DROWNED || entityTypes == EntityTypes.HUSK || entityTypes == EntityTypes.ZOMBIE_VILLAGER || entityTypes == EntityTypes.ZOMBIFIED_PIGLIN || entityTypes == EntityTypes.ZOMBIE) {
                groupDataEntity = new EntityZombie.GroupDataZombie(EntityZombie.a((Random)worldserver.getRandom()), false);
            }
            entityinsentient.prepare((WorldAccess)worldserver, worldserver.getDamageScaler(entityinsentient.getChunkCoordinates()), enummobspawn, (GroupDataEntity)groupDataEntity, nbttagcompound);
        }
        if (ichatbasecomponent != null && newEntity instanceof EntityLiving) {
            newEntity.setCustomName(ichatbasecomponent);
        }
        try {
            EntityTypes.a((World)worldserver, (EntityHuman)entityhuman, (Entity)newEntity, (NBTTagCompound)nbttagcompound);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return (T)newEntity;
    }

    @Override
    public void spawnExistingEntity(LivingEntity entity, CreatureSpawnEvent.SpawnReason spawnReason, boolean bypassSpawnEvent) {
        Location location = entity.getLocation();
        org.bukkit.World world = location.getWorld();
        if (world == null) {
            throw new IllegalArgumentException("Entity is not in a loaded world");
        }
        if (bypassSpawnEvent) {
            IChunkAccess ichunkaccess = ((CraftWorld)world).getHandle().getChunkAt(MathHelper.floor((double)(entity.getLocation().getX() / 16.0)), MathHelper.floor((double)(entity.getLocation().getZ() / 16.0)), ChunkStatus.FULL, false);
            if (!(ichunkaccess instanceof Chunk)) {
                return;
            }
            ichunkaccess.a(((CraftEntity)entity).getHandle());
            ((CraftWorld)world).getHandle().addEntityChunk(((CraftEntity)entity).getHandle());
        } else {
            ((CraftWorld)world).addEntity(((CraftEntity)entity).getHandle(), spawnReason);
        }
    }

    @Override
    public void updateEntityNameTagForPlayer(Player player, org.bukkit.entity.Entity entity, String customName, boolean customNameVisible) {
        try {
            ArrayList dataWatchers = new ArrayList();
            Optional<IChatBaseComponent> nameComponent = Optional.ofNullable(CraftChatMessage.fromStringOrNull((String)customName));
            dataWatchers.add(new DataWatcher.Item(DataWatcherRegistry.f.a(2), nameComponent));
            dataWatchers.add(new DataWatcher.Item(DataWatcherRegistry.i.a(3), (Object)customNameVisible));
            PacketPlayOutEntityMetadata packetPlayOutEntityMetadata = new PacketPlayOutEntityMetadata(entity.getEntityId(), (DataWatcher)new DataWatcherWrapper(dataWatchers), false);
            ((CraftPlayer)player).getHandle().playerConnection.sendPacket((Packet)packetPlayOutEntityMetadata);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void updateEntityNameTagVisibilityForPlayer(Player player, org.bukkit.entity.Entity entity, boolean customNameVisible) {
        try {
            ArrayList dataItems = Lists.newArrayList((Object[])new DataWatcher.Item[]{new DataWatcher.Item(DataWatcherRegistry.i.a(3), (Object)customNameVisible)});
            PacketPlayOutEntityMetadata packetPlayOutEntityMetadata = new PacketPlayOutEntityMetadata(entity.getEntityId(), (DataWatcher)new DataWatcherWrapper(dataItems), false);
            ((CraftPlayer)player).getHandle().playerConnection.sendPacket((Packet)packetPlayOutEntityMetadata);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void unigniteCreeper(Creeper creeper) {
        EntityCreeper entityCreeper = ((CraftCreeper)creeper).getHandle();
        entityCreeper.getDataWatcher().set(value_EntityCreeper_d, (Object)false);
        try {
            field_EntityCreeper_fuseTicks.set(entityCreeper, entityCreeper.maxFuseTicks);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void removeEntityGoals(LivingEntity livingEntity) {
        EntityLiving nmsEntity = ((CraftLivingEntity)livingEntity).getHandle();
        if (!(nmsEntity instanceof EntityInsentient)) {
            return;
        }
        try {
            EntityInsentient insentient = (EntityInsentient)nmsEntity;
            Set goals = (Set)field_PathfinderGoalSelector_d.get(insentient.goalSelector);
            Iterator goalsIterator = goals.iterator();
            while (goalsIterator.hasNext()) {
                PathfinderGoalWrapped goal = (PathfinderGoalWrapped)goalsIterator.next();
                if (goal.j() instanceof PathfinderGoalFloat) continue;
                goalsIterator.remove();
            }
            ((Set)field_PathfinderGoalSelector_d.get(insentient.targetSelector)).clear();
            insentient.setGoalTarget(null);
            field_EntityInsentient_lookController.set(insentient, new ControllerLook(insentient){

                public void a() {
                }
            });
            field_EntityInsentient_moveController.set(insentient, new ControllerMove(insentient){

                public void a() {
                }
            });
            if (!(insentient instanceof EntityRabbit)) {
                field_EntityInsentient_jumpController.set(insentient, new ControllerJump(insentient){

                    public void b() {
                    }
                });
            }
            field_EntityLiving_behaviorController.set(insentient, new BehaviorController(List.of(), List.of(), ImmutableList.of(), () -> BehaviorController.b(List.of(), List.of())));
        }
        catch (ReflectiveOperationException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public ItemStack setItemStackNBT(ItemStack itemStack, String key, String value) {
        net.minecraft.server.v1_16_R3.ItemStack nmsItem = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        NBTTagCompound tagCompound = nmsItem.getOrCreateTag();
        tagCompound.setString(key, value);
        return CraftItemStack.asBukkitCopy((net.minecraft.server.v1_16_R3.ItemStack)nmsItem);
    }

    @Override
    public ItemStack setItemStackNBT(ItemStack itemStack, String key, int value) {
        net.minecraft.server.v1_16_R3.ItemStack nmsItem = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        NBTTagCompound tagCompound = nmsItem.getOrCreateTag();
        tagCompound.setInt(key, value);
        return CraftItemStack.asBukkitCopy((net.minecraft.server.v1_16_R3.ItemStack)nmsItem);
    }

    @Override
    public String getItemStackNBTString(ItemStack itemStack, String key) {
        net.minecraft.server.v1_16_R3.ItemStack nmsItem = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        NBTTagCompound tagCompound = nmsItem.getOrCreateTag();
        return tagCompound.getString(key);
    }

    @Override
    public int getItemStackNBTInt(ItemStack itemStack, String key) {
        net.minecraft.server.v1_16_R3.ItemStack nmsItem = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        NBTTagCompound tagCompound = nmsItem.getOrCreateTag();
        return tagCompound.getInt(key);
    }

    @Override
    public String getItemStackNBTStringFromCompound(ItemStack itemStack, String compoundKey, String valueKey) {
        net.minecraft.server.v1_16_R3.ItemStack nmsItem = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        NBTTagCompound tagCompound = nmsItem.getOrCreateTag();
        NBTTagCompound targetCompound = tagCompound.getCompound(compoundKey);
        if (targetCompound == null) {
            return "";
        }
        return targetCompound.getString(valueKey);
    }

    @Override
    public void setLastHurtBy(LivingEntity livingEntity, Player player) {
        if (player != null) {
            ((CraftLivingEntity)livingEntity).getHandle().killer = ((CraftPlayer)player).getHandle();
        }
    }

    @Override
    public boolean hasLineOfSight(LivingEntity entity1, Location location) {
        Vec3D target;
        EntityLiving nmsEntity1 = ((CraftLivingEntity)entity1).getHandle();
        Vec3D vec3d = new Vec3D(nmsEntity1.locX(), nmsEntity1.getHeadY(), nmsEntity1.locZ());
        return nmsEntity1.world.rayTrace(new RayTrace(vec3d, target = new Vec3D(location.getX(), location.getY(), location.getZ()), RayTrace.BlockCollisionOption.VISUAL, RayTrace.FluidCollisionOption.NONE, (Entity)nmsEntity1)).getType() == MovingObjectPosition.EnumMovingObjectType.MISS;
    }

    @Override
    public boolean isActiveRaider(LivingEntity entity) {
        EntityRaider raider;
        EntityLiving entityLiving = ((CraftLivingEntity)entity).getHandle();
        return entityLiving instanceof EntityRaider && (raider = (EntityRaider)entityLiving).fa() != null;
    }

    @Override
    public EntityDataEntry createEntityDataEntry(LivingEntity livingEntity) {
        return new NBTEntityDataEntry(livingEntity);
    }

    @Override
    public StackedEntityDataStorage createEntityDataStorage(LivingEntity livingEntity, StackedEntityDataStorageType storageType) {
        return switch (storageType) {
            default -> throw new IncompatibleClassChangeError();
            case StackedEntityDataStorageType.NBT -> new NBTStackedEntityDataStorage(livingEntity);
            case StackedEntityDataStorageType.SIMPLE -> new SimpleStackedEntityDataStorage(livingEntity);
        };
    }

    @Override
    public StackedEntityDataStorage deserializeEntityDataStorage(LivingEntity livingEntity, byte[] data, StackedEntityDataStorageType storageType, Set<StorageMigrationType> migrations) {
        return switch (storageType) {
            default -> throw new IncompatibleClassChangeError();
            case StackedEntityDataStorageType.NBT -> new NBTStackedEntityDataStorage(livingEntity, data);
            case StackedEntityDataStorageType.SIMPLE -> new SimpleStackedEntityDataStorage(livingEntity, data);
        };
    }

    @Override
    public StackedSpawnerTile injectStackedSpawnerTile(Object stackedSpawnerObj) {
        BlockPosition blockPos;
        StackedSpawner stackedSpawner = (StackedSpawner)stackedSpawnerObj;
        Block block = stackedSpawner.getBlock();
        WorldServer level = ((CraftWorld)block.getWorld()).getHandle();
        TileEntity blockEntity = level.getTileEntity(blockPos = new BlockPosition(block.getX(), block.getY(), block.getZ()));
        if (!(blockEntity instanceof TileEntityMobSpawner)) {
            return null;
        }
        TileEntityMobSpawner spawnerBlockEntity = (TileEntityMobSpawner)blockEntity;
        StackedSpawnerTileImpl stackedSpawnerTile = new StackedSpawnerTileImpl(spawnerBlockEntity.getSpawner(), spawnerBlockEntity, stackedSpawner);
        unsafe.putObject(spawnerBlockEntity, field_SpawnerBlockEntity_spawner_offset, stackedSpawnerTile);
        return stackedSpawnerTile;
    }

    @Override
    public Hologram createHologram(Location location, List<String> text) {
        return new HologramImpl(text, location, entityCounter::incrementAndGet);
    }

    @Override
    public void setCustomNameUncapped(org.bukkit.entity.Entity entity, String customName) {
        ((CraftEntity)entity).getHandle().setCustomName(CraftChatMessage.fromStringOrNull((String)customName));
    }

    @Override
    public int getItemDespawnRate(Item item) {
        return ((CraftWorld)item.getWorld()).getHandle().spigotConfig.itemDespawnRate;
    }

    @Override
    public EntityDeathEvent createAsyncEntityDeathEvent(@NotNull LivingEntity what, @NotNull List<ItemStack> drops, int droppedExp) {
        return new AsyncEntityDeathEventImpl(what, drops, droppedExp);
    }

    @Override
    public List<org.bukkit.entity.Entity> getEntities(org.bukkit.World world) {
        CraftWorld craftWorld = (CraftWorld)world;
        ArrayList<org.bukkit.entity.Entity> entities = new ArrayList<org.bukkit.entity.Entity>();
        for (Entity entity : craftWorld.getHandle().entitiesById.values()) {
            entities.add((org.bukkit.entity.Entity)entity.getBukkitEntity());
        }
        return entities;
    }

    private CreatureSpawnEvent.SpawnReason toBukkitSpawnReason(EnumMobSpawn mobSpawnType) {
        return switch (mobSpawnType) {
            case EnumMobSpawn.SPAWN_EGG -> CreatureSpawnEvent.SpawnReason.SPAWNER_EGG;
            case EnumMobSpawn.SPAWNER -> CreatureSpawnEvent.SpawnReason.SPAWNER;
            default -> CreatureSpawnEvent.SpawnReason.CUSTOM;
        };
    }

    private EnumMobSpawn toNmsSpawnReason(CreatureSpawnEvent.SpawnReason spawnReason) {
        return switch (spawnReason) {
            case CreatureSpawnEvent.SpawnReason.SPAWNER_EGG -> EnumMobSpawn.SPAWN_EGG;
            case CreatureSpawnEvent.SpawnReason.SPAWNER -> EnumMobSpawn.SPAWNER;
            default -> EnumMobSpawn.COMMAND;
        };
    }

    public void saveEntityToTag(LivingEntity livingEntity, NBTTagCompound compoundTag) {
        if (livingEntity instanceof AbstractVillager) {
            try {
                boolean bypassTrades;
                EntityVillagerAbstract villager = ((CraftAbstractVillager)livingEntity).getHandle();
                boolean bl = bypassTrades = field_AbstractVillager_offers.get(villager) == null;
                if (bypassTrades) {
                    field_AbstractVillager_offers.set(villager, new MerchantRecipeList());
                }
                ((CraftLivingEntity)livingEntity).getHandle().save(compoundTag);
                if (bypassTrades) {
                    field_AbstractVillager_offers.set(villager, null);
                    compoundTag.remove("Offers");
                }
            }
            catch (ReflectiveOperationException e) {
                e.printStackTrace();
            }
        } else {
            ((CraftLivingEntity)livingEntity).getHandle().save(compoundTag);
        }
    }

    public void registerEntity(WorldServer world, Entity entity) {
        try {
            method_WorldServer_registerEntity.invoke((Object)world, entity);
        }
        catch (ReflectiveOperationException e) {
            e.printStackTrace();
        }
    }

    static {
        try {
            method_WorldServer_registerEntity = ReflectionUtils.getMethodByName(WorldServer.class, "registerEntity", Entity.class);
            Field field_EntityCreeper_d = ReflectionUtils.getFieldByName(EntityCreeper.class, "d");
            value_EntityCreeper_d = (DataWatcherObject)field_EntityCreeper_d.get(null);
            field_EntityCreeper_fuseTicks = ReflectionUtils.getFieldByName(EntityCreeper.class, "fuseTicks");
            field_PathfinderGoalSelector_d = ReflectionUtils.getFieldByName(PathfinderGoalSelector.class, "d");
            field_EntityInsentient_lookController = ReflectionUtils.getFieldByName(EntityInsentient.class, "lookController");
            field_EntityInsentient_moveController = ReflectionUtils.getFieldByName(EntityInsentient.class, "moveController");
            field_EntityInsentient_jumpController = ReflectionUtils.getFieldByName(EntityInsentient.class, "bi");
            field_EntityLiving_behaviorController = ReflectionUtils.getFieldByName(EntityLiving.class, "bg");
            if (NMSUtil.isPaper()) {
                field_Entity_spawnReason = ReflectionUtils.getFieldByPositionAndType(Entity.class, 0, CreatureSpawnEvent.SpawnReason.class);
            }
            entityCounter = (AtomicInteger)ReflectionUtils.getFieldByName(Entity.class, "entityCount").get(null);
            Field field_SpawnerBlockEntity_spawner = ReflectionUtils.getFieldByPositionAndType(TileEntityMobSpawner.class, 0, MobSpawnerAbstract.class);
            Field unsafeField = Unsafe.class.getDeclaredField("theUnsafe");
            unsafeField.setAccessible(true);
            unsafe = (Unsafe)unsafeField.get(null);
            field_SpawnerBlockEntity_spawner_offset = unsafe.objectFieldOffset(field_SpawnerBlockEntity_spawner);
            field_AbstractVillager_offers = ReflectionUtils.getFieldByName(EntityVillagerAbstract.class, "trades");
        }
        catch (ReflectiveOperationException e) {
            e.printStackTrace();
        }
    }
}

