/*
 * Decompiled with CFR 0.152.
 */
package dev.rosewood.rosestacker.nms.v1_16_R3.hologram;

import dev.rosewood.rosestacker.nms.hologram.Hologram;
import dev.rosewood.rosestacker.nms.hologram.HologramLine;
import dev.rosewood.rosestacker.nms.v1_16_R3.entity.DataWatcherWrapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.server.v1_16_R3.Blocks;
import net.minecraft.server.v1_16_R3.DataWatcher;
import net.minecraft.server.v1_16_R3.DataWatcherRegistry;
import net.minecraft.server.v1_16_R3.EntityTypes;
import net.minecraft.server.v1_16_R3.IChatBaseComponent;
import net.minecraft.server.v1_16_R3.Packet;
import net.minecraft.server.v1_16_R3.PacketPlayOutEntityDestroy;
import net.minecraft.server.v1_16_R3.PacketPlayOutEntityMetadata;
import net.minecraft.server.v1_16_R3.PacketPlayOutSpawnEntity;
import net.minecraft.server.v1_16_R3.ParticleParamBlock;
import net.minecraft.server.v1_16_R3.Particles;
import net.minecraft.server.v1_16_R3.Vec3D;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_16_R3.util.CraftChatMessage;
import org.bukkit.entity.Player;

public class HologramImpl
extends Hologram {
    private static final List<DataWatcher.Item<?>> DATA_ITEMS = List.of(new DataWatcher.Item(DataWatcherRegistry.c.a(7), (Object)Float.valueOf(0.5f)), new DataWatcher.Item(DataWatcherRegistry.i.a(9), (Object)true), new DataWatcher.Item(DataWatcherRegistry.j.a(10), (Object)new ParticleParamBlock(Particles.BLOCK, Blocks.AIR.getBlockData())));

    public HologramImpl(List<String> text, Location location, Supplier<Integer> entityIdSupplier) {
        super(text, location, entityIdSupplier);
    }

    @Override
    protected void create(Player player) {
        for (HologramLine line : this.hologramLines) {
            PacketPlayOutSpawnEntity packet = new PacketPlayOutSpawnEntity(line.getEntityId(), UUID.randomUUID(), line.getLocation().getX(), line.getLocation().getY(), line.getLocation().getZ(), 90.0f, 0.0f, EntityTypes.AREA_EFFECT_CLOUD, 1, Vec3D.ORIGIN);
            ((CraftPlayer)player).getHandle().playerConnection.sendPacket((Packet)packet);
        }
    }

    @Override
    protected void update(Collection<Player> players, boolean force) {
        for (HologramLine line : this.hologramLines) {
            if (!force && !line.checkDirty()) continue;
            ArrayList dataItems = new ArrayList(DATA_ITEMS);
            Optional<IChatBaseComponent> chatMessage = Optional.of(CraftChatMessage.fromStringOrNull((String)line.getText()));
            dataItems.add(new DataWatcher.Item(DataWatcherRegistry.f.a(2), chatMessage));
            for (Player player : players) {
                Boolean visible = (Boolean)this.watchers.get(player);
                if (visible == null) {
                    return;
                }
                ArrayList allDataItems = new ArrayList(dataItems);
                allDataItems.add(new DataWatcher.Item(DataWatcherRegistry.i.a(3), (Object)visible));
                ((CraftPlayer)player).getHandle().playerConnection.sendPacket((Packet)new PacketPlayOutEntityMetadata(line.getEntityId(), (DataWatcher)new DataWatcherWrapper(allDataItems), false));
            }
        }
    }

    @Override
    protected void delete(Player player) {
        PacketPlayOutEntityDestroy packet = new PacketPlayOutEntityDestroy(this.hologramLines.stream().mapToInt(HologramLine::getEntityId).toArray());
        ((CraftPlayer)player).getHandle().playerConnection.sendPacket((Packet)packet);
    }
}

