/*
 * Decompiled with CFR 0.152.
 */
package dev.rosewood.rosestacker.nms.v1_17_R1;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import dev.rosewood.rosestacker.lib.rosegarden.utils.NMSUtil;
import dev.rosewood.rosestacker.nms.NMSHandler;
import dev.rosewood.rosestacker.nms.hologram.Hologram;
import dev.rosewood.rosestacker.nms.spawner.StackedSpawnerTile;
import dev.rosewood.rosestacker.nms.storage.EntityDataEntry;
import dev.rosewood.rosestacker.nms.storage.StackedEntityDataStorage;
import dev.rosewood.rosestacker.nms.storage.StackedEntityDataStorageType;
import dev.rosewood.rosestacker.nms.storage.StorageMigrationType;
import dev.rosewood.rosestacker.nms.util.ReflectionUtils;
import dev.rosewood.rosestacker.nms.v1_17_R1.entity.SoloEntitySpider;
import dev.rosewood.rosestacker.nms.v1_17_R1.entity.SoloEntityStrider;
import dev.rosewood.rosestacker.nms.v1_17_R1.entity.SynchedEntityDataWrapper;
import dev.rosewood.rosestacker.nms.v1_17_R1.event.AsyncEntityDeathEventImpl;
import dev.rosewood.rosestacker.nms.v1_17_R1.hologram.HologramImpl;
import dev.rosewood.rosestacker.nms.v1_17_R1.spawner.StackedSpawnerTileImpl;
import dev.rosewood.rosestacker.nms.v1_17_R1.storage.NBTEntityDataEntry;
import dev.rosewood.rosestacker.nms.v1_17_R1.storage.NBTStackedEntityDataStorage;
import dev.rosewood.rosestacker.nms.v1_17_R1.storage.SimpleStackedEntityDataStorage;
import dev.rosewood.rosestacker.stack.StackedSpawner;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IRegistry;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.control.ControllerJump;
import net.minecraft.world.entity.ai.control.ControllerLook;
import net.minecraft.world.entity.ai.control.ControllerMove;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalSelector;
import net.minecraft.world.entity.ai.goal.PathfinderGoalWrapped;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.animal.EntityRabbit;
import net.minecraft.world.entity.monster.EntityCreeper;
import net.minecraft.world.entity.monster.EntityZombie;
import net.minecraft.world.entity.npc.EntityVillagerAbstract;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.raid.EntityRaider;
import net.minecraft.world.item.trading.MerchantRecipeList;
import net.minecraft.world.level.MobSpawnerAbstract;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityMobSpawner;
import net.minecraft.world.level.entity.EntityAccess;
import net.minecraft.world.level.entity.PersistentEntitySectionManager;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_17_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_17_R1.entity.CraftAbstractVillager;
import org.bukkit.craftbukkit.v1_17_R1.entity.CraftCreeper;
import org.bukkit.craftbukkit.v1_17_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_17_R1.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_17_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_17_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_17_R1.util.CraftChatMessage;
import org.bukkit.craftbukkit.v1_17_R1.util.CraftNamespacedKey;
import org.bukkit.entity.AbstractVillager;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import sun.misc.Unsafe;

public class NMSHandlerImpl
implements NMSHandler {
    private static DataWatcherObject<Boolean> value_Creeper_DATA_IS_IGNITED;
    private static Field field_GoalSelector_availableGoals;
    private static Field field_Mob_lookControl;
    private static Field field_Mob_moveControl;
    private static Field field_Mob_jumpControl;
    private static Field field_LivingEntity_brain;
    private static Field field_ServerLevel_entityManager;
    private static Field field_Entity_spawnReason;
    private static AtomicInteger entityCounter;
    private static Unsafe unsafe;
    private static long field_SpawnerBlockEntity_spawner_offset;
    private static Field field_AbstractVillager_offers;

    @Override
    public LivingEntity createNewEntityUnspawned(EntityType entityType, Location location, CreatureSpawnEvent.SpawnReason spawnReason) {
        World world = location.getWorld();
        if (world == null) {
            return null;
        }
        Class entityClass = entityType.getEntityClass();
        if (entityClass == null || !LivingEntity.class.isAssignableFrom(entityClass)) {
            throw new IllegalArgumentException("EntityType must be of a LivingEntity");
        }
        EntityTypes nmsEntityType = (EntityTypes)IRegistry.Y.get(CraftNamespacedKey.toMinecraft((NamespacedKey)entityType.getKey()));
        Object nmsEntity = this.createCreature(nmsEntityType, ((CraftWorld)world).getHandle(), null, null, null, new BlockPosition(location.getBlockX(), location.getBlockY(), location.getBlockZ()), this.toNmsSpawnReason(spawnReason));
        return nmsEntity == null ? null : (LivingEntity)nmsEntity.getBukkitEntity();
    }

    public <T extends net.minecraft.world.entity.Entity> T createCreature(EntityTypes<T> entityType, WorldServer world, NBTTagCompound nbt, IChatBaseComponent component, EntityHuman player, BlockPosition blockPos, EnumMobSpawn mobSpawnType) {
        Object newEntity = entityType == EntityTypes.aI ? new SoloEntitySpider(entityType, (net.minecraft.world.level.World)world) : (entityType == EntityTypes.aL ? new SoloEntityStrider(entityType, (net.minecraft.world.level.World)world) : entityType.a((net.minecraft.world.level.World)world));
        if (newEntity == null) {
            return null;
        }
        if (field_Entity_spawnReason != null) {
            try {
                field_Entity_spawnReason.set(newEntity, this.toBukkitSpawnReason(mobSpawnType));
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        newEntity.setPositionRotation((double)blockPos.getX() + 0.5, blockPos.getY(), (double)blockPos.getZ() + 0.5, MathHelper.g((float)(world.w.nextFloat() * 360.0f)), 0.0f);
        if (newEntity instanceof EntityInsentient) {
            EntityInsentient mob = (EntityInsentient)newEntity;
            mob.aZ = mob.getYRot();
            mob.aX = mob.getYRot();
            EntityZombie.GroupDataZombie groupDataEntity = null;
            if (entityType == EntityTypes.s || entityType == EntityTypes.N || entityType == EntityTypes.bg || entityType == EntityTypes.bh || entityType == EntityTypes.be) {
                groupDataEntity = new EntityZombie.GroupDataZombie(EntityZombie.a((Random)world.getRandom()), false);
            }
            mob.prepare((WorldAccess)world, world.getDamageScaler(mob.getChunkCoordinates()), mobSpawnType, (GroupDataEntity)groupDataEntity, nbt);
        }
        if (component != null && newEntity instanceof EntityInsentient) {
            newEntity.setCustomName(component);
        }
        EntityTypes.a((net.minecraft.world.level.World)world, (EntityHuman)player, (net.minecraft.world.entity.Entity)newEntity, (NBTTagCompound)nbt);
        return (T)newEntity;
    }

    @Override
    public void spawnExistingEntity(LivingEntity entity, CreatureSpawnEvent.SpawnReason spawnReason, boolean bypassSpawnEvent) {
        Location location = entity.getLocation();
        World world = location.getWorld();
        if (world == null) {
            throw new IllegalArgumentException("Entity is not in a loaded world");
        }
        if (bypassSpawnEvent) {
            ((CraftWorld)world).getHandle().G.a((EntityAccess)((CraftEntity)entity).getHandle());
        } else {
            ((CraftWorld)world).addEntityToWorld(((CraftEntity)entity).getHandle(), spawnReason);
        }
    }

    @Override
    public void updateEntityNameTagForPlayer(Player player, Entity entity, String customName, boolean customNameVisible) {
        try {
            ArrayList dataItems = new ArrayList();
            Optional<IChatBaseComponent> nameComponent = Optional.ofNullable(CraftChatMessage.fromStringOrNull((String)customName));
            dataItems.add(new DataWatcher.Item(DataWatcherRegistry.f.a(2), nameComponent));
            dataItems.add(new DataWatcher.Item(DataWatcherRegistry.i.a(3), (Object)customNameVisible));
            PacketPlayOutEntityMetadata entityDataPacket = new PacketPlayOutEntityMetadata(entity.getEntityId(), (DataWatcher)new SynchedEntityDataWrapper(dataItems), false);
            ((CraftPlayer)player).getHandle().b.sendPacket((Packet)entityDataPacket);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void updateEntityNameTagVisibilityForPlayer(Player player, Entity entity, boolean customNameVisible) {
        try {
            ArrayList dataItems = Lists.newArrayList((Object[])new DataWatcher.Item[]{new DataWatcher.Item(DataWatcherRegistry.i.a(3), (Object)customNameVisible)});
            PacketPlayOutEntityMetadata entityDataPacket = new PacketPlayOutEntityMetadata(entity.getEntityId(), (DataWatcher)new SynchedEntityDataWrapper(dataItems), false);
            ((CraftPlayer)player).getHandle().b.sendPacket((Packet)entityDataPacket);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void unigniteCreeper(Creeper creeper) {
        EntityCreeper nmsCreeper = ((CraftCreeper)creeper).getHandle();
        nmsCreeper.getDataWatcher().set(value_Creeper_DATA_IS_IGNITED, (Object)false);
        if (!Bukkit.getBukkitVersion().contains("1.17-")) {
            nmsCreeper.bT = nmsCreeper.bU;
        }
    }

    @Override
    public void removeEntityGoals(LivingEntity livingEntity) {
        EntityLiving nmsEntity = ((CraftLivingEntity)livingEntity).getHandle();
        if (!(nmsEntity instanceof EntityInsentient)) {
            return;
        }
        try {
            EntityInsentient mob = (EntityInsentient)nmsEntity;
            Set goals = (Set)field_GoalSelector_availableGoals.get(mob.bP);
            Iterator goalsIterator = goals.iterator();
            while (goalsIterator.hasNext()) {
                PathfinderGoalWrapped goal = (PathfinderGoalWrapped)goalsIterator.next();
                if (goal.j() instanceof PathfinderGoalFloat) continue;
                goalsIterator.remove();
            }
            ((Set)field_GoalSelector_availableGoals.get(mob.bQ)).clear();
            mob.setGoalTarget(null);
            field_Mob_lookControl.set(mob, new ControllerLook(mob){

                public void a() {
                }
            });
            field_Mob_moveControl.set(mob, new ControllerMove(mob){

                public void a() {
                }
            });
            if (!(mob instanceof EntityRabbit)) {
                field_Mob_jumpControl.set(mob, new ControllerJump(mob){

                    public void b() {
                    }
                });
            }
            field_LivingEntity_brain.set(mob, new BehaviorController(List.of(), List.of(), ImmutableList.of(), () -> BehaviorController.b(List.of(), List.of())){

                public Optional<?> getMemory(MemoryModuleType var0) {
                    return Optional.empty();
                }
            });
        }
        catch (ReflectiveOperationException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public ItemStack setItemStackNBT(ItemStack itemStack, String key, String value) {
        net.minecraft.world.item.ItemStack nmsItem = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        NBTTagCompound tagCompound = nmsItem.getOrCreateTag();
        tagCompound.setString(key, value);
        return CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)nmsItem);
    }

    @Override
    public ItemStack setItemStackNBT(ItemStack itemStack, String key, int value) {
        net.minecraft.world.item.ItemStack nmsItem = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        NBTTagCompound tagCompound = nmsItem.getOrCreateTag();
        tagCompound.setInt(key, value);
        return CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)nmsItem);
    }

    @Override
    public String getItemStackNBTString(ItemStack itemStack, String key) {
        net.minecraft.world.item.ItemStack nmsItem = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        NBTTagCompound tagCompound = nmsItem.getOrCreateTag();
        return tagCompound.getString(key);
    }

    @Override
    public int getItemStackNBTInt(ItemStack itemStack, String key) {
        net.minecraft.world.item.ItemStack nmsItem = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        NBTTagCompound tagCompound = nmsItem.getOrCreateTag();
        return tagCompound.getInt(key);
    }

    @Override
    public String getItemStackNBTStringFromCompound(ItemStack itemStack, String compoundKey, String valueKey) {
        net.minecraft.world.item.ItemStack nmsItem = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        NBTTagCompound tagCompound = nmsItem.getOrCreateTag();
        NBTTagCompound targetCompound = tagCompound.getCompound(compoundKey);
        if (targetCompound == null) {
            return "";
        }
        return targetCompound.getString(valueKey);
    }

    @Override
    public void setLastHurtBy(LivingEntity livingEntity, Player player) {
        if (player != null) {
            ((CraftLivingEntity)livingEntity).getHandle().bc = ((CraftPlayer)player).getHandle();
        }
    }

    @Override
    public boolean hasLineOfSight(LivingEntity entity1, Location location) {
        Vec3D target;
        EntityLiving nmsEntity1 = ((CraftLivingEntity)entity1).getHandle();
        Vec3D vec3d = new Vec3D(nmsEntity1.locX(), nmsEntity1.getHeadY(), nmsEntity1.locZ());
        return nmsEntity1.t.rayTrace(new RayTrace(vec3d, target = new Vec3D(location.getX(), location.getY(), location.getZ()), RayTrace.BlockCollisionOption.c, RayTrace.FluidCollisionOption.a, (net.minecraft.world.entity.Entity)nmsEntity1)).getType() == MovingObjectPosition.EnumMovingObjectType.a;
    }

    @Override
    public boolean isActiveRaider(LivingEntity entity) {
        EntityRaider raider;
        EntityLiving entityLiving = ((CraftLivingEntity)entity).getHandle();
        return entityLiving instanceof EntityRaider && (raider = (EntityRaider)entityLiving).fK() != null;
    }

    @Override
    public EntityDataEntry createEntityDataEntry(LivingEntity livingEntity) {
        return new NBTEntityDataEntry(livingEntity);
    }

    @Override
    public StackedEntityDataStorage createEntityDataStorage(LivingEntity livingEntity, StackedEntityDataStorageType storageType) {
        return switch (storageType) {
            default -> throw new IncompatibleClassChangeError();
            case StackedEntityDataStorageType.NBT -> new NBTStackedEntityDataStorage(livingEntity);
            case StackedEntityDataStorageType.SIMPLE -> new SimpleStackedEntityDataStorage(livingEntity);
        };
    }

    @Override
    public StackedEntityDataStorage deserializeEntityDataStorage(LivingEntity livingEntity, byte[] data, StackedEntityDataStorageType storageType, Set<StorageMigrationType> migrations) {
        return switch (storageType) {
            default -> throw new IncompatibleClassChangeError();
            case StackedEntityDataStorageType.NBT -> new NBTStackedEntityDataStorage(livingEntity, data);
            case StackedEntityDataStorageType.SIMPLE -> new SimpleStackedEntityDataStorage(livingEntity, data);
        };
    }

    @Override
    public StackedSpawnerTile injectStackedSpawnerTile(Object stackedSpawnerObj) {
        BlockPosition blockPos;
        StackedSpawner stackedSpawner = (StackedSpawner)stackedSpawnerObj;
        Block block = stackedSpawner.getBlock();
        WorldServer level = ((CraftWorld)block.getWorld()).getHandle();
        TileEntity blockEntity = level.getTileEntity(blockPos = new BlockPosition(block.getX(), block.getY(), block.getZ()));
        if (!(blockEntity instanceof TileEntityMobSpawner)) {
            return null;
        }
        TileEntityMobSpawner spawnerBlockEntity = (TileEntityMobSpawner)blockEntity;
        StackedSpawnerTileImpl stackedSpawnerTile = new StackedSpawnerTileImpl(spawnerBlockEntity.getSpawner(), spawnerBlockEntity, stackedSpawner);
        unsafe.putObject(spawnerBlockEntity, field_SpawnerBlockEntity_spawner_offset, stackedSpawnerTile);
        return stackedSpawnerTile;
    }

    @Override
    public Hologram createHologram(Location location, List<String> text) {
        return new HologramImpl(text, location, entityCounter::incrementAndGet);
    }

    @Override
    public void setCustomNameUncapped(Entity entity, String customName) {
        ((CraftEntity)entity).getHandle().setCustomName(CraftChatMessage.fromStringOrNull((String)customName));
    }

    @Override
    public int getItemDespawnRate(Item item) {
        return ((CraftWorld)item.getWorld()).getHandle().spigotConfig.itemDespawnRate;
    }

    @Override
    public EntityDeathEvent createAsyncEntityDeathEvent(@NotNull LivingEntity what, @NotNull List<ItemStack> drops, int droppedExp) {
        return new AsyncEntityDeathEventImpl(what, drops, droppedExp);
    }

    @Override
    public List<Entity> getEntities(World world) {
        CraftWorld craftWorld = (CraftWorld)world;
        ArrayList<Entity> entities = new ArrayList<Entity>();
        for (net.minecraft.world.entity.Entity entity : craftWorld.getNMSEntities()) {
            entities.add((Entity)entity.getBukkitEntity());
        }
        return entities;
    }

    private CreatureSpawnEvent.SpawnReason toBukkitSpawnReason(EnumMobSpawn mobSpawnType) {
        return switch (mobSpawnType) {
            case EnumMobSpawn.m -> CreatureSpawnEvent.SpawnReason.SPAWNER_EGG;
            case EnumMobSpawn.c -> CreatureSpawnEvent.SpawnReason.SPAWNER;
            default -> CreatureSpawnEvent.SpawnReason.CUSTOM;
        };
    }

    private EnumMobSpawn toNmsSpawnReason(CreatureSpawnEvent.SpawnReason spawnReason) {
        return switch (spawnReason) {
            case CreatureSpawnEvent.SpawnReason.SPAWNER_EGG -> EnumMobSpawn.m;
            case CreatureSpawnEvent.SpawnReason.SPAWNER -> EnumMobSpawn.c;
            default -> EnumMobSpawn.n;
        };
    }

    public void saveEntityToTag(LivingEntity livingEntity, NBTTagCompound compoundTag) {
        if (livingEntity instanceof AbstractVillager) {
            try {
                boolean bypassTrades;
                EntityVillagerAbstract villager = ((CraftAbstractVillager)livingEntity).getHandle();
                boolean bl = bypassTrades = field_AbstractVillager_offers.get(villager) == null;
                if (bypassTrades) {
                    field_AbstractVillager_offers.set(villager, new MerchantRecipeList());
                }
                ((CraftLivingEntity)livingEntity).getHandle().save(compoundTag);
                if (bypassTrades) {
                    field_AbstractVillager_offers.set(villager, null);
                    compoundTag.remove("Offers");
                }
            }
            catch (ReflectiveOperationException e) {
                e.printStackTrace();
            }
        } else {
            ((CraftLivingEntity)livingEntity).getHandle().save(compoundTag);
        }
    }

    public void registerEntity(WorldServer world, net.minecraft.world.entity.Entity entity) {
        try {
            PersistentEntitySectionManager entityManager = (PersistentEntitySectionManager)field_ServerLevel_entityManager.get(world);
            entityManager.a((EntityAccess)entity);
        }
        catch (ReflectiveOperationException e) {
            e.printStackTrace();
        }
    }

    static {
        try {
            Field field_Creeper_DATA_IS_IGNITED = ReflectionUtils.getFieldByPositionAndType(EntityCreeper.class, 2, DataWatcherObject.class);
            value_Creeper_DATA_IS_IGNITED = (DataWatcherObject)field_Creeper_DATA_IS_IGNITED.get(null);
            field_GoalSelector_availableGoals = ReflectionUtils.getFieldByPositionAndType(PathfinderGoalSelector.class, 0, Set.class);
            field_Mob_lookControl = ReflectionUtils.getFieldByPositionAndType(EntityInsentient.class, 0, ControllerLook.class);
            field_Mob_moveControl = ReflectionUtils.getFieldByPositionAndType(EntityInsentient.class, 0, ControllerMove.class);
            field_Mob_jumpControl = ReflectionUtils.getFieldByPositionAndType(EntityInsentient.class, 0, ControllerJump.class);
            field_LivingEntity_brain = ReflectionUtils.getFieldByPositionAndType(EntityLiving.class, 0, BehaviorController.class);
            field_ServerLevel_entityManager = ReflectionUtils.getFieldByPositionAndType(WorldServer.class, 0, PersistentEntitySectionManager.class);
            if (NMSUtil.isPaper()) {
                field_Entity_spawnReason = ReflectionUtils.getFieldByPositionAndType(net.minecraft.world.entity.Entity.class, 0, CreatureSpawnEvent.SpawnReason.class);
            }
            entityCounter = (AtomicInteger)ReflectionUtils.getFieldByPositionAndType(net.minecraft.world.entity.Entity.class, 0, AtomicInteger.class).get(null);
            Field field_SpawnerBlockEntity_spawner = ReflectionUtils.getFieldByPositionAndType(TileEntityMobSpawner.class, 0, MobSpawnerAbstract.class);
            Field unsafeField = Unsafe.class.getDeclaredField("theUnsafe");
            unsafeField.setAccessible(true);
            unsafe = (Unsafe)unsafeField.get(null);
            field_SpawnerBlockEntity_spawner_offset = unsafe.objectFieldOffset(field_SpawnerBlockEntity_spawner);
            field_AbstractVillager_offers = ReflectionUtils.getFieldByPositionAndType(EntityVillagerAbstract.class, 0, MerchantRecipeList.class);
        }
        catch (ReflectiveOperationException e) {
            e.printStackTrace();
        }
    }
}

