/*
 * Decompiled with CFR 0.152.
 */
package dev.rosewood.rosestacker.nms.v1_17_R1.hologram;

import dev.rosewood.rosestacker.nms.hologram.Hologram;
import dev.rosewood.rosestacker.nms.hologram.HologramLine;
import dev.rosewood.rosestacker.nms.v1_17_R1.entity.SynchedEntityDataWrapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.core.particles.ParticleParamBlock;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutEntityDestroy;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_17_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_17_R1.util.CraftChatMessage;
import org.bukkit.entity.Player;

public class HologramImpl
extends Hologram {
    private static final List<DataWatcher.Item<?>> DATA_ITEMS = List.of(new DataWatcher.Item(DataWatcherRegistry.c.a(8), (Object)Float.valueOf(0.5f)), new DataWatcher.Item(DataWatcherRegistry.i.a(10), (Object)true), new DataWatcher.Item(DataWatcherRegistry.j.a(11), (Object)new ParticleParamBlock(Particles.e, Blocks.a.getBlockData())));

    public HologramImpl(List<String> text, Location location, Supplier<Integer> entityIdSupplier) {
        super(text, location, entityIdSupplier);
    }

    @Override
    protected void create(Player player) {
        for (HologramLine line : this.hologramLines) {
            PacketPlayOutSpawnEntity packet = new PacketPlayOutSpawnEntity(line.getEntityId(), UUID.randomUUID(), line.getLocation().getX(), line.getLocation().getY(), line.getLocation().getZ(), 90.0f, 0.0f, EntityTypes.b, 1, Vec3D.a);
            ((CraftPlayer)player).getHandle().b.sendPacket((Packet)packet);
        }
    }

    @Override
    protected void update(Collection<Player> players, boolean force) {
        for (HologramLine line : this.hologramLines) {
            if (!force && !line.checkDirty()) continue;
            ArrayList dataItems = new ArrayList(DATA_ITEMS);
            Optional<IChatBaseComponent> chatMessage = Optional.of(CraftChatMessage.fromStringOrNull((String)line.getText()));
            dataItems.add(new DataWatcher.Item(DataWatcherRegistry.f.a(2), chatMessage));
            for (Player player : players) {
                Boolean visible = (Boolean)this.watchers.get(player);
                if (visible == null) {
                    return;
                }
                ArrayList allDataItems = new ArrayList(dataItems);
                allDataItems.add(new DataWatcher.Item(DataWatcherRegistry.i.a(3), (Object)visible));
                ((CraftPlayer)player).getHandle().b.sendPacket((Packet)new PacketPlayOutEntityMetadata(line.getEntityId(), (DataWatcher)new SynchedEntityDataWrapper(allDataItems), false));
            }
        }
    }

    @Override
    protected void delete(Player player) {
        PacketPlayOutEntityDestroy packet = new PacketPlayOutEntityDestroy(this.hologramLines.stream().mapToInt(HologramLine::getEntityId).toArray());
        ((CraftPlayer)player).getHandle().b.sendPacket((Packet)packet);
    }
}

