/*
 * Decompiled with CFR 0.152.
 */
package dev.rosewood.rosestacker.nms.v1_18_R2.spawner;

import dev.rosewood.rosestacker.config.SettingKey;
import dev.rosewood.rosestacker.nms.spawner.SpawnerType;
import dev.rosewood.rosestacker.nms.spawner.StackedSpawnerTile;
import dev.rosewood.rosestacker.nms.util.ExtraUtils;
import dev.rosewood.rosestacker.spawning.MobSpawningMethod;
import dev.rosewood.rosestacker.stack.StackedSpawner;
import dev.rosewood.rosestacker.stack.settings.SpawnerStackSettings;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.world.level.MobSpawnerAbstract;
import net.minecraft.world.level.MobSpawnerData;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntityMobSpawner;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.EntityType;
import org.bukkit.persistence.PersistentDataContainer;

public class StackedSpawnerTileImpl
extends MobSpawnerAbstract
implements StackedSpawnerTile {
    private final TileEntityMobSpawner blockEntity;
    private final BlockPosition blockPos;
    private final StackedSpawner stackedSpawner;
    private boolean redstoneDeactivated;
    private int redstoneTimeSinceLastCheck;
    private boolean playersNearby;
    private int playersTimeSinceLastCheck;
    private boolean checkedInitialConditions;

    public StackedSpawnerTileImpl(MobSpawnerAbstract old, TileEntityMobSpawner blockEntity, StackedSpawner stackedSpawner) {
        this.blockEntity = blockEntity;
        this.stackedSpawner = stackedSpawner;
        Location location = stackedSpawner.getLocation();
        this.blockPos = new BlockPosition(location.getBlockX(), location.getBlockY(), location.getBlockZ());
        this.loadOld(old);
    }

    public void a(WorldServer level, BlockPosition blockPos) {
        this.playersTimeSinceLastCheck = (this.playersTimeSinceLastCheck + 1) % SettingKey.SPAWNER_PLAYER_CHECK_FREQUENCY.get();
        if (this.playersTimeSinceLastCheck == 0) {
            this.playersNearby = this.isNearPlayer((World)level, blockPos);
        }
        if (!this.playersNearby) {
            return;
        }
        if (!this.checkedInitialConditions) {
            this.checkedInitialConditions = true;
            this.trySpawns(true);
        }
        SpawnerStackSettings stackSettings = this.stackedSpawner.getStackSettings();
        if (SettingKey.SPAWNER_DEACTIVATE_WHEN_POWERED.get().booleanValue()) {
            if (this.redstoneTimeSinceLastCheck == 0) {
                boolean hasSignal = level.q(this.blockPos);
                if (this.redstoneDeactivated && !hasSignal) {
                    this.redstoneDeactivated = false;
                    this.m = stackSettings.getPlayerActivationRange();
                    this.updateTile();
                } else if (!this.redstoneDeactivated && hasSignal) {
                    this.redstoneDeactivated = true;
                    this.m = 0;
                    this.updateTile();
                }
                if (this.redstoneDeactivated) {
                    return;
                }
            }
            this.redstoneTimeSinceLastCheck = (this.redstoneTimeSinceLastCheck + 1) % SettingKey.SPAWNER_POWERED_CHECK_FREQUENCY.get();
        }
        if (this.c > 0) {
            --this.c;
            return;
        }
        this.c = level.r_().nextInt(this.i - this.h + 1) + this.h;
        this.updateTile();
        this.trySpawns(false);
        this.d.b(level.r_()).map(WeightedEntry.b::b).ifPresent(x -> {
            this.e = x;
        });
    }

    private void trySpawns(boolean onlyCheckConditions) {
        try {
            EntityType entityType;
            String typeId;
            if (this.e != null && !(typeId = this.e.a().l("id")).isEmpty() && (entityType = ExtraUtils.getEntityTypeFromKey(NamespacedKey.fromString((String)typeId))) != null) {
                new MobSpawningMethod(entityType).spawn(this.stackedSpawner, onlyCheckConditions);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void updateTile() {
        World level = this.blockEntity.k();
        if (level != null) {
            level.o(this.blockPos);
            level.a(this.blockPos, this.blockEntity.q(), this.blockEntity.q(), 3);
        }
    }

    public void a(World level, BlockPosition blockPos, int eventId) {
        level.a(blockPos, Blocks.bV, eventId, 0);
    }

    public void a(World level, BlockPosition blockPos, MobSpawnerData spawnData) {
        super.a(level, blockPos, spawnData);
        if (level != null) {
            IBlockData var3 = level.a_(blockPos);
            level.a(blockPos, var3, var3, 4);
        }
    }

    private boolean isNearPlayer(World level, BlockPosition blockPos) {
        if (this.stackedSpawner.getStackSettings().hasUnlimitedPlayerActivationRange()) {
            return true;
        }
        return level.a((double)blockPos.u() + 0.5, (double)blockPos.v() + 0.5, (double)blockPos.w() + 0.5, Math.max((double)this.stackedSpawner.getStackSettings().getPlayerActivationRange(), 0.1));
    }

    private void loadOld(MobSpawnerAbstract baseSpawner) {
        this.c = baseSpawner.c;
        this.d = baseSpawner.d;
        this.e = baseSpawner.e;
        this.h = baseSpawner.h;
        this.i = baseSpawner.i;
        this.j = baseSpawner.j;
        this.l = baseSpawner.l;
        this.m = baseSpawner.m;
        this.n = baseSpawner.n;
        this.updateTile();
    }

    @Override
    public SpawnerType getSpawnerType() {
        if (this.d.d()) {
            if (this.e == null) {
                return SpawnerType.empty();
            }
            String typeId = this.e.a().l("id");
            if (typeId.isEmpty()) {
                return SpawnerType.empty();
            }
            return SpawnerType.of(ExtraUtils.getEntityTypeFromKey(NamespacedKey.fromString((String)typeId)));
        }
        return SpawnerType.of(this.d.e().stream().map(WeightedEntry.b::b).map(MobSpawnerData::a).map(x -> x.l("id")).map(NamespacedKey::fromString).map(ExtraUtils::getEntityTypeFromKey).toList());
    }

    @Override
    public void setSpawnerType(SpawnerType spawnerType) {
        if (spawnerType.size() == 1) {
            this.e = new MobSpawnerData();
            this.e.a().a("id", spawnerType.getOrThrow().getKey().getKey());
            this.d = SimpleWeightedRandomList.b();
            this.updateTile();
            return;
        }
        SimpleWeightedRandomList.a builder = SimpleWeightedRandomList.a();
        for (EntityType entityType : spawnerType.getEntityTypes()) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.a("id", entityType.getKey().getKey());
            builder.a((Object)new MobSpawnerData(tag, Optional.empty()), 1);
        }
        this.d = builder.a();
        this.d.b(new Random()).map(WeightedEntry.b::b).ifPresent(x -> {
            this.e = x;
        });
        this.updateTile();
    }

    @Override
    public int getDelay() {
        return this.c;
    }

    @Override
    public void setDelay(int delay) {
        this.c = delay;
        this.updateTile();
    }

    @Override
    public int getMinSpawnDelay() {
        return this.h;
    }

    @Override
    public void setMinSpawnDelay(int delay) {
        this.h = delay;
        this.updateTile();
    }

    @Override
    public int getMaxSpawnDelay() {
        return this.i;
    }

    @Override
    public void setMaxSpawnDelay(int delay) {
        this.i = delay;
        this.updateTile();
    }

    @Override
    public int getSpawnCount() {
        return this.j;
    }

    @Override
    public void setSpawnCount(int spawnCount) {
        this.j = spawnCount;
        this.updateTile();
    }

    @Override
    public int getMaxNearbyEntities() {
        return this.l;
    }

    @Override
    public void setMaxNearbyEntities(int maxNearbyEntities) {
        this.l = maxNearbyEntities;
        this.updateTile();
    }

    @Override
    public int getRequiredPlayerRange() {
        return this.m;
    }

    @Override
    public void setRequiredPlayerRange(int requiredPlayerRange) {
        this.m = requiredPlayerRange;
        this.updateTile();
    }

    @Override
    public int getSpawnRange() {
        return this.n;
    }

    @Override
    public void setSpawnRange(int spawnRange) {
        this.n = spawnRange;
        this.updateTile();
    }

    @Override
    public PersistentDataContainer getPersistentDataContainer() {
        return this.blockEntity.persistentDataContainer;
    }
}

