/*
 * Decompiled with CFR 0.152.
 */
package dev.rosewood.rosestacker.nms.v1_19_R3;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import dev.rosewood.rosestacker.lib.rosegarden.utils.NMSUtil;
import dev.rosewood.rosestacker.nms.NMSHandler;
import dev.rosewood.rosestacker.nms.hologram.Hologram;
import dev.rosewood.rosestacker.nms.spawner.StackedSpawnerTile;
import dev.rosewood.rosestacker.nms.storage.EntityDataEntry;
import dev.rosewood.rosestacker.nms.storage.StackedEntityDataStorage;
import dev.rosewood.rosestacker.nms.storage.StackedEntityDataStorageType;
import dev.rosewood.rosestacker.nms.storage.StorageMigrationType;
import dev.rosewood.rosestacker.nms.util.ReflectionUtils;
import dev.rosewood.rosestacker.nms.v1_19_R3.entity.SoloEntitySpider;
import dev.rosewood.rosestacker.nms.v1_19_R3.entity.SoloEntityStrider;
import dev.rosewood.rosestacker.nms.v1_19_R3.event.AsyncEntityDeathEventImpl;
import dev.rosewood.rosestacker.nms.v1_19_R3.hologram.HologramImpl;
import dev.rosewood.rosestacker.nms.v1_19_R3.spawner.StackedSpawnerTileImpl;
import dev.rosewood.rosestacker.nms.v1_19_R3.storage.NBTEntityDataEntry;
import dev.rosewood.rosestacker.nms.v1_19_R3.storage.NBTStackedEntityDataStorage;
import dev.rosewood.rosestacker.nms.v1_19_R3.storage.SimpleStackedEntityDataStorage;
import dev.rosewood.rosestacker.stack.StackedSpawner;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.control.ControllerJump;
import net.minecraft.world.entity.ai.control.ControllerLook;
import net.minecraft.world.entity.ai.control.ControllerMove;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalSelector;
import net.minecraft.world.entity.ai.goal.PathfinderGoalWrapped;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.animal.EntityRabbit;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.EntityCreeper;
import net.minecraft.world.entity.monster.EntityZombie;
import net.minecraft.world.entity.npc.EntityVillagerAbstract;
import net.minecraft.world.entity.raid.EntityRaider;
import net.minecraft.world.item.trading.MerchantRecipeList;
import net.minecraft.world.level.MobSpawnerAbstract;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityMobSpawner;
import net.minecraft.world.level.entity.EntityAccess;
import net.minecraft.world.level.entity.PersistentEntitySectionManager;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.ThreadSafeLegacyRandomSource;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_19_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftAbstractVillager;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftCreeper;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftItem;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_19_R3.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_19_R3.util.CraftChatMessage;
import org.bukkit.craftbukkit.v1_19_R3.util.CraftNamespacedKey;
import org.bukkit.entity.AbstractVillager;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import sun.misc.Unsafe;

public class NMSHandlerImpl
implements NMSHandler {
    private static boolean hijackedAnyRandomSources = false;
    private static DataWatcherObject<Boolean> value_Creeper_DATA_IS_IGNITED;
    private static Field field_GoalSelector_availableGoals;
    private static Field field_Mob_lookControl;
    private static Field field_Mob_moveControl;
    private static Field field_Mob_jumpControl;
    private static Field field_LivingEntity_brain;
    private static Field field_ServerLevel_entityManager;
    private static Field field_ServerLevel_entityLookup;
    private static Method method_EntityLookup_addNewEntity;
    private static Field field_Entity_spawnReason;
    private static AtomicInteger entityCounter;
    private static Unsafe unsafe;
    private static long field_SpawnerBlockEntity_spawner_offset;
    private static long field_Level_random_offset;
    private static Field field_LegacyRandomSource_seed;
    private static Field field_AbstractVillager_offers;
    private static Field field_Entity_spawnedViaMobSpawner;
    private static Field field_ItemEntity_despawnRate;

    @Override
    public LivingEntity createNewEntityUnspawned(EntityType entityType, Location location, CreatureSpawnEvent.SpawnReason spawnReason) {
        World world = location.getWorld();
        if (world == null) {
            return null;
        }
        Class entityClass = entityType.getEntityClass();
        if (entityClass == null || !LivingEntity.class.isAssignableFrom(entityClass)) {
            throw new IllegalArgumentException("EntityType must be of a LivingEntity");
        }
        EntityTypes nmsEntityType = (EntityTypes)BuiltInRegistries.h.a(CraftNamespacedKey.toMinecraft((NamespacedKey)entityType.getKey()));
        Object nmsEntity = this.createCreature(nmsEntityType, ((CraftWorld)world).getHandle(), null, new BlockPosition(location.getBlockX(), location.getBlockY(), location.getBlockZ()), this.toNmsSpawnReason(spawnReason));
        return nmsEntity == null ? null : (LivingEntity)nmsEntity.getBukkitEntity();
    }

    public <T extends net.minecraft.world.entity.Entity> T createCreature(EntityTypes<T> entityType, WorldServer world, NBTTagCompound nbt, BlockPosition blockPos, EnumMobSpawn mobSpawnType) {
        Object newEntity = entityType == EntityTypes.aS ? new SoloEntitySpider(entityType, (net.minecraft.world.level.World)world) : (entityType == EntityTypes.aV ? new SoloEntityStrider(entityType, (net.minecraft.world.level.World)world) : entityType.a((net.minecraft.world.level.World)world));
        if (newEntity == null) {
            return null;
        }
        if (field_Entity_spawnReason != null) {
            try {
                field_Entity_spawnReason.set(newEntity, this.toBukkitSpawnReason(mobSpawnType));
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        newEntity.b((double)blockPos.u() + 0.5, blockPos.v(), (double)blockPos.w() + 0.5, MathHelper.g((float)(world.z.i() * 360.0f)), 0.0f);
        if (newEntity instanceof EntityInsentient) {
            EntityInsentient mob = (EntityInsentient)newEntity;
            mob.aV = mob.dw();
            mob.aT = mob.dw();
            EntityZombie.GroupDataZombie groupDataEntity = null;
            if (entityType == EntityTypes.y || entityType == EntityTypes.Z || entityType == EntityTypes.br || entityType == EntityTypes.bs || entityType == EntityTypes.bp) {
                groupDataEntity = new EntityZombie.GroupDataZombie(EntityZombie.a((RandomSource)world.r_()), false);
            }
            mob.a((WorldAccess)world, world.d_(mob.dg()), mobSpawnType, (GroupDataEntity)groupDataEntity, nbt);
        }
        EntityTypes.a((net.minecraft.world.level.World)world, null, (net.minecraft.world.entity.Entity)newEntity, (NBTTagCompound)nbt);
        return (T)newEntity;
    }

    @Override
    public void spawnExistingEntity(LivingEntity entity, CreatureSpawnEvent.SpawnReason spawnReason, boolean bypassSpawnEvent) {
        Location location = entity.getLocation();
        World world = location.getWorld();
        if (world == null) {
            throw new IllegalArgumentException("Entity is not in a loaded world");
        }
        if (bypassSpawnEvent) {
            try {
                this.addEntityToWorld(((CraftWorld)world).getHandle(), ((CraftEntity)entity).getHandle());
            }
            catch (ReflectiveOperationException e) {
                e.printStackTrace();
            }
        } else {
            ((CraftWorld)world).addEntityToWorld(((CraftEntity)entity).getHandle(), spawnReason);
        }
    }

    @Override
    public void updateEntityNameTagForPlayer(Player player, Entity entity, String customName, boolean customNameVisible) {
        try {
            ArrayList<DataWatcher.b> dataValues = new ArrayList<DataWatcher.b>();
            Optional<IChatBaseComponent> nameComponent = Optional.ofNullable(CraftChatMessage.fromStringOrNull((String)customName));
            dataValues.add(DataWatcher.b.a((DataWatcherObject)DataWatcherRegistry.g.a(2), nameComponent));
            dataValues.add(DataWatcher.b.a((DataWatcherObject)DataWatcherRegistry.k.a(3), (Object)customNameVisible));
            PacketPlayOutEntityMetadata entityDataPacket = new PacketPlayOutEntityMetadata(entity.getEntityId(), dataValues);
            ((CraftPlayer)player).getHandle().b.a((Packet)entityDataPacket);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void updateEntityNameTagVisibilityForPlayer(Player player, Entity entity, boolean customNameVisible) {
        try {
            ArrayList dataValues = Lists.newArrayList((Object[])new DataWatcher.b[]{DataWatcher.b.a((DataWatcherObject)DataWatcherRegistry.k.a(3), (Object)customNameVisible)});
            PacketPlayOutEntityMetadata entityDataPacket = new PacketPlayOutEntityMetadata(entity.getEntityId(), (List)dataValues);
            ((CraftPlayer)player).getHandle().b.a((Packet)entityDataPacket);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void unigniteCreeper(Creeper creeper) {
        EntityCreeper nmsCreeper = ((CraftCreeper)creeper).getHandle();
        nmsCreeper.aj().b(value_Creeper_DATA_IS_IGNITED, (Object)false);
        if (!Bukkit.getBukkitVersion().contains("1.17-")) {
            nmsCreeper.bS = nmsCreeper.bT;
        }
    }

    @Override
    public void removeEntityGoals(LivingEntity livingEntity) {
        EntityLiving nmsEntity = ((CraftLivingEntity)livingEntity).getHandle();
        if (!(nmsEntity instanceof EntityInsentient)) {
            return;
        }
        try {
            EntityInsentient mob = (EntityInsentient)nmsEntity;
            Set goals = (Set)field_GoalSelector_availableGoals.get(mob.bN);
            Iterator goalsIterator = goals.iterator();
            while (goalsIterator.hasNext()) {
                PathfinderGoalWrapped goal = (PathfinderGoalWrapped)goalsIterator.next();
                if (goal.k() instanceof PathfinderGoalFloat) continue;
                goalsIterator.remove();
            }
            ((Set)field_GoalSelector_availableGoals.get(mob.bO)).clear();
            mob.i(null);
            field_Mob_lookControl.set(mob, new ControllerLook(mob){

                public void a() {
                }
            });
            field_Mob_moveControl.set(mob, new ControllerMove(mob){

                public void a() {
                }
            });
            if (mob instanceof EntityRabbit) {
                field_Mob_jumpControl.set(mob, new EntityRabbit.ControllerJumpRabbit((EntityRabbit)mob){

                    public void b() {
                    }

                    public boolean d() {
                        return false;
                    }

                    public boolean c() {
                        return false;
                    }
                });
            } else {
                field_Mob_jumpControl.set(mob, new ControllerJump(mob){

                    public void b() {
                    }
                });
            }
            field_LivingEntity_brain.set(mob, new BehaviorController(List.of(), List.of(), ImmutableList.of(), () -> BehaviorController.b(List.of(), List.of())){

                public Optional<?> c(MemoryModuleType var0) {
                    return Optional.empty();
                }
            });
        }
        catch (ReflectiveOperationException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public ItemStack setItemStackNBT(ItemStack itemStack, String key, String value) {
        net.minecraft.world.item.ItemStack nmsItem = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        NBTTagCompound tagCompound = nmsItem.v();
        tagCompound.a(key, value);
        return CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)nmsItem);
    }

    @Override
    public ItemStack setItemStackNBT(ItemStack itemStack, String key, int value) {
        net.minecraft.world.item.ItemStack nmsItem = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        NBTTagCompound tagCompound = nmsItem.v();
        tagCompound.a(key, value);
        return CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)nmsItem);
    }

    @Override
    public String getItemStackNBTString(ItemStack itemStack, String key) {
        net.minecraft.world.item.ItemStack nmsItem = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        NBTTagCompound tagCompound = nmsItem.v();
        return tagCompound.l(key);
    }

    @Override
    public int getItemStackNBTInt(ItemStack itemStack, String key) {
        net.minecraft.world.item.ItemStack nmsItem = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        NBTTagCompound tagCompound = nmsItem.v();
        return tagCompound.h(key);
    }

    @Override
    public String getItemStackNBTStringFromCompound(ItemStack itemStack, String compoundKey, String valueKey) {
        net.minecraft.world.item.ItemStack nmsItem = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        NBTTagCompound tagCompound = nmsItem.v();
        NBTTagCompound targetCompound = tagCompound.p(compoundKey);
        if (targetCompound == null) {
            return "";
        }
        return targetCompound.l(valueKey);
    }

    @Override
    public void setLastHurtBy(LivingEntity livingEntity, Player player) {
        if (player != null) {
            ((CraftLivingEntity)livingEntity).getHandle().aX = ((CraftPlayer)player).getHandle();
        }
    }

    @Override
    public boolean hasLineOfSight(LivingEntity entity1, Location location) {
        Vec3D target;
        EntityLiving nmsEntity1 = ((CraftLivingEntity)entity1).getHandle();
        Vec3D vec3d = new Vec3D(nmsEntity1.dl(), nmsEntity1.dp(), nmsEntity1.dr());
        return nmsEntity1.H.a(new RayTrace(vec3d, target = new Vec3D(location.getX(), location.getY(), location.getZ()), RayTrace.BlockCollisionOption.c, RayTrace.FluidCollisionOption.a, (net.minecraft.world.entity.Entity)nmsEntity1)).c() == MovingObjectPosition.EnumMovingObjectType.a;
    }

    @Override
    public boolean isActiveRaider(LivingEntity entity) {
        EntityRaider raider;
        EntityLiving entityLiving = ((CraftLivingEntity)entity).getHandle();
        return entityLiving instanceof EntityRaider && (raider = (EntityRaider)entityLiving).gg() != null;
    }

    @Override
    public EntityDataEntry createEntityDataEntry(LivingEntity livingEntity) {
        return new NBTEntityDataEntry(livingEntity);
    }

    @Override
    public StackedEntityDataStorage createEntityDataStorage(LivingEntity livingEntity, StackedEntityDataStorageType storageType) {
        return switch (storageType) {
            default -> throw new IncompatibleClassChangeError();
            case StackedEntityDataStorageType.NBT -> new NBTStackedEntityDataStorage(livingEntity);
            case StackedEntityDataStorageType.SIMPLE -> new SimpleStackedEntityDataStorage(livingEntity);
        };
    }

    @Override
    public StackedEntityDataStorage deserializeEntityDataStorage(LivingEntity livingEntity, byte[] data, StackedEntityDataStorageType storageType, Set<StorageMigrationType> migrations) {
        return switch (storageType) {
            default -> throw new IncompatibleClassChangeError();
            case StackedEntityDataStorageType.NBT -> new NBTStackedEntityDataStorage(livingEntity, data);
            case StackedEntityDataStorageType.SIMPLE -> new SimpleStackedEntityDataStorage(livingEntity, data);
        };
    }

    @Override
    public StackedSpawnerTile injectStackedSpawnerTile(Object stackedSpawnerObj) {
        BlockPosition blockPos;
        StackedSpawner stackedSpawner = (StackedSpawner)stackedSpawnerObj;
        Block block = stackedSpawner.getBlock();
        WorldServer level = ((CraftWorld)block.getWorld()).getHandle();
        TileEntity blockEntity = level.c_(blockPos = new BlockPosition(block.getX(), block.getY(), block.getZ()));
        if (!(blockEntity instanceof TileEntityMobSpawner)) {
            return null;
        }
        TileEntityMobSpawner spawnerBlockEntity = (TileEntityMobSpawner)blockEntity;
        StackedSpawnerTileImpl stackedSpawnerTile = new StackedSpawnerTileImpl(spawnerBlockEntity.d(), spawnerBlockEntity, stackedSpawner);
        unsafe.putObject(spawnerBlockEntity, field_SpawnerBlockEntity_spawner_offset, stackedSpawnerTile);
        return stackedSpawnerTile;
    }

    @Override
    public Hologram createHologram(Location location, List<String> text) {
        return new HologramImpl(text, location, entityCounter::incrementAndGet);
    }

    @Override
    public boolean supportsEmptySpawners() {
        return true;
    }

    @Override
    public void hijackRandomSource(World world) {
        WorldServer level = ((CraftWorld)world).getHandle();
        if (!(level.z instanceof LegacyRandomSource)) {
            return;
        }
        if (!hijackedAnyRandomSources) {
            hijackedAnyRandomSources = true;
            NMSHandlerImpl.sendInfoConsoleMessage("Hijacking world RandomSources to allow async mob creation...");
        }
        try {
            LegacyRandomSource originalRandomSource = (LegacyRandomSource)level.z;
            AtomicLong seed = (AtomicLong)field_LegacyRandomSource_seed.get(originalRandomSource);
            ThreadSafeLegacyRandomSource hijackedRandomSource = new ThreadSafeLegacyRandomSource(seed.get());
            unsafe.putObject(level, field_Level_random_offset, hijackedRandomSource);
        }
        catch (ReflectiveOperationException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setPaperFromMobSpawner(Entity entity) {
        if (field_Entity_spawnedViaMobSpawner == null) {
            return;
        }
        try {
            field_Entity_spawnedViaMobSpawner.set(((CraftEntity)entity).getHandle(), true);
        }
        catch (ReflectiveOperationException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setCustomNameUncapped(Entity entity, String customName) {
        ((CraftEntity)entity).getHandle().b(CraftChatMessage.fromStringOrNull((String)customName));
    }

    @Override
    public int getItemDespawnRate(Item item) {
        if (field_ItemEntity_despawnRate == null) {
            return ((CraftWorld)item.getWorld()).getHandle().spigotConfig.itemDespawnRate;
        }
        try {
            return (Integer)field_ItemEntity_despawnRate.get(((CraftItem)item).getHandle());
        }
        catch (ReflectiveOperationException e) {
            e.printStackTrace();
            throw new IllegalStateException("Unable to get item despawn rate");
        }
    }

    @Override
    public EntityDeathEvent createAsyncEntityDeathEvent(@NotNull LivingEntity what, @NotNull List<ItemStack> drops, int droppedExp) {
        return new AsyncEntityDeathEventImpl(what, drops, droppedExp);
    }

    @Override
    public List<Entity> getEntities(World world) {
        CraftWorld craftWorld = (CraftWorld)world;
        ArrayList<Entity> entities = new ArrayList<Entity>();
        for (net.minecraft.world.entity.Entity entity : craftWorld.getNMSEntities()) {
            entities.add((Entity)entity.getBukkitEntity());
        }
        return entities;
    }

    public void addEntityToWorld(WorldServer world, net.minecraft.world.entity.Entity entity) throws ReflectiveOperationException {
        if (field_ServerLevel_entityManager != null) {
            PersistentEntitySectionManager entityManager = (PersistentEntitySectionManager)field_ServerLevel_entityManager.get(world);
            entityManager.a((EntityAccess)entity);
        } else if (field_ServerLevel_entityLookup != null) {
            Object entityLookup = field_ServerLevel_entityLookup.get(world);
            if (method_EntityLookup_addNewEntity == null) {
                method_EntityLookup_addNewEntity = ReflectionUtils.getMethodByName(entityLookup.getClass(), "addNewEntity", net.minecraft.world.entity.Entity.class);
            }
            method_EntityLookup_addNewEntity.invoke(entityLookup, entity);
        } else {
            throw new IllegalStateException("Unable to spawn entities due to missing methods");
        }
    }

    private CreatureSpawnEvent.SpawnReason toBukkitSpawnReason(EnumMobSpawn mobSpawnType) {
        return switch (mobSpawnType) {
            case EnumMobSpawn.m -> CreatureSpawnEvent.SpawnReason.SPAWNER_EGG;
            case EnumMobSpawn.c -> CreatureSpawnEvent.SpawnReason.SPAWNER;
            default -> CreatureSpawnEvent.SpawnReason.CUSTOM;
        };
    }

    private EnumMobSpawn toNmsSpawnReason(CreatureSpawnEvent.SpawnReason spawnReason) {
        return switch (spawnReason) {
            case CreatureSpawnEvent.SpawnReason.SPAWNER_EGG -> EnumMobSpawn.m;
            case CreatureSpawnEvent.SpawnReason.SPAWNER -> EnumMobSpawn.c;
            default -> EnumMobSpawn.n;
        };
    }

    private static void sendInfoConsoleMessage(String message) {
        Bukkit.getPluginManager().getPlugin("RoseStacker").getLogger().info(message);
    }

    public void saveEntityToTag(LivingEntity livingEntity, NBTTagCompound compoundTag) {
        if (livingEntity instanceof AbstractVillager) {
            try {
                boolean bypassTrades;
                EntityVillagerAbstract villager = ((CraftAbstractVillager)livingEntity).getHandle();
                boolean bl = bypassTrades = field_AbstractVillager_offers.get(villager) == null;
                if (bypassTrades) {
                    field_AbstractVillager_offers.set(villager, new MerchantRecipeList());
                }
                ((CraftLivingEntity)livingEntity).getHandle().f(compoundTag);
                if (bypassTrades) {
                    field_AbstractVillager_offers.set(villager, null);
                    compoundTag.r("Offers");
                }
            }
            catch (ReflectiveOperationException e) {
                e.printStackTrace();
            }
        } else {
            ((CraftLivingEntity)livingEntity).getHandle().f(compoundTag);
        }
    }

    static {
        try {
            Field field_Creeper_DATA_IS_IGNITED = ReflectionUtils.getFieldByPositionAndType(EntityCreeper.class, 2, DataWatcherObject.class);
            value_Creeper_DATA_IS_IGNITED = (DataWatcherObject)field_Creeper_DATA_IS_IGNITED.get(null);
            field_GoalSelector_availableGoals = ReflectionUtils.getFieldByPositionAndType(PathfinderGoalSelector.class, 0, Set.class);
            field_Mob_lookControl = ReflectionUtils.getFieldByPositionAndType(EntityInsentient.class, 0, ControllerLook.class);
            field_Mob_moveControl = ReflectionUtils.getFieldByPositionAndType(EntityInsentient.class, 0, ControllerMove.class);
            field_Mob_jumpControl = ReflectionUtils.getFieldByPositionAndType(EntityInsentient.class, 0, ControllerJump.class);
            field_LivingEntity_brain = ReflectionUtils.getFieldByPositionAndType(EntityLiving.class, 0, BehaviorController.class);
            try {
                field_ServerLevel_entityManager = ReflectionUtils.getFieldByPositionAndType(WorldServer.class, 0, PersistentEntitySectionManager.class);
            }
            catch (IllegalStateException e) {
                field_ServerLevel_entityManager = null;
                NMSHandlerImpl.sendInfoConsoleMessage("Paper's new chunk system detected, using it to spawn entities");
                field_ServerLevel_entityLookup = ReflectionUtils.getFieldByName(WorldServer.class, "entityLookup");
            }
            if (NMSUtil.isPaper()) {
                field_Entity_spawnReason = ReflectionUtils.getFieldByPositionAndType(net.minecraft.world.entity.Entity.class, 0, CreatureSpawnEvent.SpawnReason.class);
            }
            entityCounter = (AtomicInteger)ReflectionUtils.getFieldByPositionAndType(net.minecraft.world.entity.Entity.class, 0, AtomicInteger.class).get(null);
            Field field_SpawnerBlockEntity_spawner = ReflectionUtils.getFieldByPositionAndType(TileEntityMobSpawner.class, 0, MobSpawnerAbstract.class);
            Field field_Level_random = ReflectionUtils.getFieldByPositionAndType(net.minecraft.world.level.World.class, 0, RandomSource.class);
            Field unsafeField = Unsafe.class.getDeclaredField("theUnsafe");
            unsafeField.setAccessible(true);
            unsafe = (Unsafe)unsafeField.get(null);
            field_SpawnerBlockEntity_spawner_offset = unsafe.objectFieldOffset(field_SpawnerBlockEntity_spawner);
            field_Level_random_offset = unsafe.objectFieldOffset(field_Level_random);
            field_LegacyRandomSource_seed = ReflectionUtils.getFieldByPositionAndType(LegacyRandomSource.class, 0, AtomicLong.class);
            field_AbstractVillager_offers = ReflectionUtils.getFieldByPositionAndType(EntityVillagerAbstract.class, 0, MerchantRecipeList.class);
            if (NMSUtil.isPaper()) {
                field_Entity_spawnedViaMobSpawner = ReflectionUtils.getFieldByName(net.minecraft.world.entity.Entity.class, "spawnedViaMobSpawner");
                field_ItemEntity_despawnRate = ReflectionUtils.getFieldByName(EntityItem.class, "despawnRate");
            }
        }
        catch (ReflectiveOperationException e) {
            e.printStackTrace();
        }
    }
}

