/*
 * Decompiled with CFR 0.152.
 */
package dev.rosewood.rosestacker.nms.v1_19_R3.storage;

import dev.rosewood.rosestacker.nms.NMSAdapter;
import dev.rosewood.rosestacker.nms.storage.EntityDataEntry;
import dev.rosewood.rosestacker.nms.v1_19_R3.NMSHandlerImpl;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_19_R3.CraftWorld;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;

public class NBTEntityDataEntry
implements EntityDataEntry {
    private final NBTTagCompound compoundTag;

    public NBTEntityDataEntry(LivingEntity livingEntity) {
        this.compoundTag = new NBTTagCompound();
        ((NMSHandlerImpl)NMSAdapter.getHandler()).saveEntityToTag(livingEntity, this.compoundTag);
    }

    public NBTEntityDataEntry(NBTTagCompound compoundTag) {
        this.compoundTag = compoundTag;
    }

    public NBTTagCompound get() {
        return this.compoundTag;
    }

    @Override
    public LivingEntity createEntity(Location location, boolean addToWorld, EntityType entityType) {
        try {
            NMSHandlerImpl nmsHandler = (NMSHandlerImpl)NMSAdapter.getHandler();
            NBTTagCompound nbt = this.compoundTag.h();
            NBTTagList positionTagList = nbt.c("Pos", 6);
            if (positionTagList == null) {
                positionTagList = new NBTTagList();
            }
            this.setTag(positionTagList, 0, (NBTBase)NBTTagDouble.a((double)location.getX()));
            this.setTag(positionTagList, 1, (NBTBase)NBTTagDouble.a((double)location.getY()));
            this.setTag(positionTagList, 2, (NBTBase)NBTTagDouble.a((double)location.getZ()));
            nbt.a("Pos", (NBTBase)positionTagList);
            NBTTagList rotationTagList = nbt.c("Rotation", 5);
            if (rotationTagList == null) {
                rotationTagList = new NBTTagList();
            }
            this.setTag(rotationTagList, 0, (NBTBase)NBTTagFloat.a((float)location.getYaw()));
            this.setTag(rotationTagList, 1, (NBTBase)NBTTagFloat.a((float)location.getPitch()));
            nbt.a("Rotation", (NBTBase)rotationTagList);
            nbt.a("UUID", UUID.randomUUID());
            Optional optionalEntity = EntityTypes.a((String)entityType.getKey().getKey());
            if (optionalEntity.isPresent()) {
                WorldServer world = ((CraftWorld)location.getWorld()).getHandle();
                Object entity = nmsHandler.createCreature((EntityTypes)optionalEntity.get(), world, nbt, new BlockPosition(location.getBlockX(), location.getBlockY(), location.getBlockZ()), EnumMobSpawn.n);
                if (entity == null) {
                    throw new NullPointerException("Unable to create entity from NBT");
                }
                entity.g(nbt);
                if (addToWorld) {
                    nmsHandler.addEntityToWorld(world, (Entity)entity);
                    ((Entity)entity).ak = 0;
                }
                return (LivingEntity)entity.getBukkitEntity();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private void setTag(NBTTagList tag, int index, NBTBase value) {
        if (index >= tag.size()) {
            tag.b(index, value);
        } else {
            tag.a(index, value);
        }
    }
}

