/*
 * Decompiled with CFR 0.152.
 */
package dev.rosewood.rosestacker.nms.v1_21_R4.spawner;

import dev.rosewood.rosestacker.config.SettingKey;
import dev.rosewood.rosestacker.nms.spawner.SpawnerType;
import dev.rosewood.rosestacker.nms.spawner.StackedSpawnerTile;
import dev.rosewood.rosestacker.nms.util.ExtraUtils;
import dev.rosewood.rosestacker.spawning.MobSpawningMethod;
import dev.rosewood.rosestacker.stack.StackedSpawner;
import dev.rosewood.rosestacker.stack.settings.SpawnerStackSettings;
import java.util.Optional;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.Weighted;
import net.minecraft.util.random.WeightedList;
import net.minecraft.world.level.MobSpawnerAbstract;
import net.minecraft.world.level.MobSpawnerData;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntityMobSpawner;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.EntityType;
import org.bukkit.persistence.PersistentDataContainer;

public class StackedSpawnerTileImpl
extends MobSpawnerAbstract
implements StackedSpawnerTile {
    private final TileEntityMobSpawner blockEntity;
    private final BlockPosition blockPos;
    private final StackedSpawner stackedSpawner;
    private boolean redstoneDeactivated;
    private int redstoneTimeSinceLastCheck;
    private boolean playersNearby;
    private int playersTimeSinceLastCheck;
    private boolean checkedInitialConditions;

    public StackedSpawnerTileImpl(MobSpawnerAbstract old, TileEntityMobSpawner blockEntity, StackedSpawner stackedSpawner) {
        this.blockEntity = blockEntity;
        this.stackedSpawner = stackedSpawner;
        Location location = stackedSpawner.getLocation();
        this.blockPos = new BlockPosition(location.getBlockX(), location.getBlockY(), location.getBlockZ());
        this.loadOld(old);
    }

    public void a(WorldServer level, BlockPosition blockPos) {
        this.playersTimeSinceLastCheck = (this.playersTimeSinceLastCheck + 1) % SettingKey.SPAWNER_PLAYER_CHECK_FREQUENCY.get();
        if (this.playersTimeSinceLastCheck == 0) {
            this.playersNearby = this.isNearPlayer((World)level, blockPos);
        }
        if (!this.playersNearby) {
            return;
        }
        if (!this.checkedInitialConditions) {
            this.checkedInitialConditions = true;
            this.trySpawns(true);
        }
        SpawnerStackSettings stackSettings = this.stackedSpawner.getStackSettings();
        if (SettingKey.SPAWNER_DEACTIVATE_WHEN_POWERED.get().booleanValue()) {
            if (this.redstoneTimeSinceLastCheck == 0) {
                boolean hasSignal = level.D(this.blockPos);
                if (this.redstoneDeactivated && !hasSignal) {
                    this.redstoneDeactivated = false;
                    this.t = stackSettings.getPlayerActivationRange();
                    this.updateTile();
                } else if (!this.redstoneDeactivated && hasSignal) {
                    this.redstoneDeactivated = true;
                    this.t = 0;
                    this.updateTile();
                }
                if (this.redstoneDeactivated) {
                    return;
                }
            }
            this.redstoneTimeSinceLastCheck = (this.redstoneTimeSinceLastCheck + 1) % SettingKey.SPAWNER_POWERED_CHECK_FREQUENCY.get();
        }
        if (this.j > 0) {
            --this.j;
            return;
        }
        this.j = level.G_().a(this.p - this.o + 1) + this.o;
        this.updateTile();
        this.trySpawns(false);
        this.k.a(level.G_()).ifPresent(x -> {
            this.l = x;
        });
    }

    private void trySpawns(boolean onlyCheckConditions) {
        try {
            EntityType entityType;
            String typeId;
            if (this.l != null && !(typeId = this.l.a().b("id", "")).isEmpty() && (entityType = ExtraUtils.getEntityTypeFromKey(NamespacedKey.fromString((String)typeId))) != null) {
                new MobSpawningMethod(entityType).spawn(this.stackedSpawner, onlyCheckConditions);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void updateTile() {
        World level = this.blockEntity.i();
        if (level != null) {
            level.q(this.blockPos);
            level.a(this.blockPos, this.blockEntity.m(), this.blockEntity.m(), 3);
        }
    }

    public void a(World level, BlockPosition blockPos, int eventId) {
        level.a(blockPos, Blocks.cD, eventId, 0);
    }

    public void a(World level, BlockPosition blockPos, MobSpawnerData spawnData) {
        super.a(level, blockPos, spawnData);
        if (level != null) {
            IBlockData var3 = level.a_(blockPos);
            level.a(blockPos, var3, var3, 4);
        }
    }

    private boolean isNearPlayer(World level, BlockPosition blockPos) {
        if (this.stackedSpawner.getStackSettings().hasUnlimitedPlayerActivationRange()) {
            return true;
        }
        return level.a((double)blockPos.u() + 0.5, (double)blockPos.v() + 0.5, (double)blockPos.w() + 0.5, Math.max((double)this.stackedSpawner.getStackSettings().getPlayerActivationRange(), 0.1));
    }

    private void loadOld(MobSpawnerAbstract baseSpawner) {
        this.j = baseSpawner.j;
        this.k = baseSpawner.k;
        this.l = baseSpawner.l;
        this.o = baseSpawner.o;
        this.p = baseSpawner.p;
        this.q = baseSpawner.q;
        this.s = baseSpawner.s;
        this.t = baseSpawner.t;
        this.u = baseSpawner.u;
        this.updateTile();
    }

    @Override
    public SpawnerType getSpawnerType() {
        if (this.k.c()) {
            if (this.l == null) {
                return SpawnerType.empty();
            }
            String typeId = this.l.a().b("id", "");
            if (typeId.isEmpty()) {
                return SpawnerType.empty();
            }
            return SpawnerType.of(ExtraUtils.getEntityTypeFromKey(NamespacedKey.fromString((String)typeId)));
        }
        return SpawnerType.of(this.k.d().stream().map(Weighted::a).map(MobSpawnerData::a).map(x -> x.b("id", "")).map(NamespacedKey::fromString).map(ExtraUtils::getEntityTypeFromKey).toList());
    }

    @Override
    public void setSpawnerType(SpawnerType spawnerType) {
        if (spawnerType.size() == 1) {
            this.l = new MobSpawnerData();
            this.l.a().a("id", spawnerType.getOrThrow().getKey().getKey());
            this.k = WeightedList.a();
            this.updateTile();
            return;
        }
        WeightedList.a builder = new WeightedList.a();
        for (EntityType entityType : spawnerType.getEntityTypes()) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.a("id", entityType.getKey().getKey());
            builder.a((Object)new MobSpawnerData(tag, Optional.empty(), Optional.empty()), 1);
        }
        this.k = builder.a();
        this.k.a(RandomSource.a()).ifPresent(x -> {
            this.l = x;
        });
        this.updateTile();
    }

    @Override
    public int getDelay() {
        return this.j;
    }

    @Override
    public void setDelay(int delay) {
        this.j = delay;
        this.updateTile();
    }

    @Override
    public int getMinSpawnDelay() {
        return this.o;
    }

    @Override
    public void setMinSpawnDelay(int delay) {
        this.o = delay;
        this.updateTile();
    }

    @Override
    public int getMaxSpawnDelay() {
        return this.p;
    }

    @Override
    public void setMaxSpawnDelay(int delay) {
        this.p = delay;
        this.updateTile();
    }

    @Override
    public int getSpawnCount() {
        return this.q;
    }

    @Override
    public void setSpawnCount(int spawnCount) {
        this.q = spawnCount;
        this.updateTile();
    }

    @Override
    public int getMaxNearbyEntities() {
        return this.s;
    }

    @Override
    public void setMaxNearbyEntities(int maxNearbyEntities) {
        this.s = maxNearbyEntities;
        this.updateTile();
    }

    @Override
    public int getRequiredPlayerRange() {
        return this.t;
    }

    @Override
    public void setRequiredPlayerRange(int requiredPlayerRange) {
        this.t = requiredPlayerRange;
        this.updateTile();
    }

    @Override
    public int getSpawnRange() {
        return this.u;
    }

    @Override
    public void setSpawnRange(int spawnRange) {
        this.u = spawnRange;
        this.updateTile();
    }

    @Override
    public PersistentDataContainer getPersistentDataContainer() {
        return this.blockEntity.persistentDataContainer;
    }
}

