/*
 * Decompiled with CFR 0.152.
 */
package dev.rosewood.rosestacker.nms.v1_21_R4.storage;

import dev.rosewood.rosestacker.nms.NMSAdapter;
import dev.rosewood.rosestacker.nms.NMSHandler;
import dev.rosewood.rosestacker.nms.storage.EntityDataEntry;
import dev.rosewood.rosestacker.nms.storage.StackedEntityDataIOException;
import dev.rosewood.rosestacker.nms.storage.StackedEntityDataStorage;
import dev.rosewood.rosestacker.nms.storage.StackedEntityDataStorageType;
import dev.rosewood.rosestacker.nms.storage.StorageMigrationType;
import dev.rosewood.rosestacker.nms.v1_21_R4.NMSHandlerImpl;
import dev.rosewood.rosestacker.nms.v1_21_R4.storage.NBTEntityDataEntry;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTCompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import org.bukkit.entity.LivingEntity;

public class NBTStackedEntityDataStorage
extends StackedEntityDataStorage {
    private final NBTTagCompound base;
    private final Queue<NBTTagCompound> data;

    public NBTStackedEntityDataStorage(LivingEntity livingEntity) {
        super(StackedEntityDataStorageType.NBT, livingEntity);
        this.base = new NBTTagCompound();
        ((NMSHandlerImpl)NMSAdapter.getHandler()).saveEntityToTag(livingEntity, this.base);
        this.stripUnneeded(this.base);
        this.stripAttributeUuids(this.base);
        this.data = NBTStackedEntityDataStorage.createBackingQueue();
    }

    public NBTStackedEntityDataStorage(LivingEntity livingEntity, byte[] data, Set<StorageMigrationType> migrations) {
        super(StackedEntityDataStorageType.NBT, livingEntity);
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(data);
             ObjectInputStream dataInput = new ObjectInputStream(inputStream);){
            this.base = this.migrate(migrations, NBTCompressedStreamTools.a((DataInput)dataInput));
            int length = dataInput.readInt();
            this.data = NBTStackedEntityDataStorage.createBackingQueue();
            for (int i = 0; i < length; ++i) {
                this.data.add(this.migrate(migrations, NBTCompressedStreamTools.a((DataInput)dataInput)));
            }
        }
        catch (Exception e) {
            throw new StackedEntityDataIOException(e);
        }
    }

    private NBTTagCompound migrate(Set<StorageMigrationType> migrations, NBTTagCompound tag) {
        if (migrations.isEmpty()) {
            return tag;
        }
        if (migrations.contains((Object)StorageMigrationType.STRIP_OLD_ATTRIBUTES)) {
            tag.r("attributes");
        }
        return tag;
    }

    @Override
    public void add(LivingEntity entity) {
        NBTTagCompound compoundTag = new NBTTagCompound();
        ((NMSHandlerImpl)NMSAdapter.getHandler()).saveEntityToTag(entity, compoundTag);
        this.stripUnneeded(compoundTag);
        this.stripAttributeUuids(compoundTag);
        this.removeDuplicates(compoundTag);
        this.data.add(compoundTag);
    }

    @Override
    public void addAll(StackedEntityDataStorage stackedEntityDataStorage) {
        stackedEntityDataStorage.getAll().forEach((? super T entry) -> {
            NBTTagCompound compoundTag = ((NBTEntityDataEntry)entry).get();
            this.stripUnneeded(compoundTag);
            this.stripAttributeUuids(compoundTag);
            this.removeDuplicates(compoundTag);
            this.data.add(compoundTag);
        });
    }

    @Override
    public void addClones(int amount) {
        for (int i = 0; i < amount; ++i) {
            this.data.add(this.base.l());
        }
    }

    @Override
    public NBTEntityDataEntry peek() {
        return new NBTEntityDataEntry(this.rebuild(this.data.element()));
    }

    @Override
    public NBTEntityDataEntry pop() {
        return new NBTEntityDataEntry(this.rebuild(this.data.remove()));
    }

    @Override
    public List<EntityDataEntry> pop(int amount) {
        amount = Math.min(amount, this.data.size());
        ArrayList<EntityDataEntry> popped = new ArrayList<EntityDataEntry>(amount);
        for (int i = 0; i < amount; ++i) {
            popped.add(new NBTEntityDataEntry(this.rebuild(this.data.remove())));
        }
        return popped;
    }

    @Override
    public int size() {
        return this.data.size();
    }

    @Override
    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    @Override
    public List<EntityDataEntry> getAll() {
        ArrayList<EntityDataEntry> wrapped = new ArrayList<EntityDataEntry>(this.data.size());
        for (NBTTagCompound compoundTag : new ArrayList<NBTTagCompound>(this.data)) {
            wrapped.add(new NBTEntityDataEntry(this.rebuild(compoundTag)));
        }
        return wrapped;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] serialize(int maxAmount) {
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            Object object;
            try (ObjectOutputStream dataOutput = new ObjectOutputStream(outputStream);){
                int targetAmount = Math.min(maxAmount, this.data.size());
                ArrayList<NBTTagCompound> tagsToSave = new ArrayList<NBTTagCompound>(targetAmount);
                Iterator iterator = this.data.iterator();
                for (int i = 0; i < targetAmount; ++i) {
                    tagsToSave.add((NBTTagCompound)iterator.next());
                }
                NBTCompressedStreamTools.a((NBTTagCompound)this.base, (DataOutput)dataOutput);
                dataOutput.writeInt(tagsToSave.size());
                for (NBTTagCompound compoundTag : tagsToSave) {
                    NBTCompressedStreamTools.a((NBTTagCompound)compoundTag, (DataOutput)dataOutput);
                }
                dataOutput.close();
                object = outputStream.toByteArray();
            }
            return object;
        }
        catch (Exception e) {
            throw new StackedEntityDataIOException(e);
        }
    }

    @Override
    public void forEach(Consumer<LivingEntity> consumer) {
        this.forEachCapped(Integer.MAX_VALUE, consumer);
    }

    @Override
    public void forEachCapped(int count, Consumer<LivingEntity> consumer) {
        LivingEntity thisEntity;
        if (count > this.data.size()) {
            count = this.data.size();
        }
        if ((thisEntity = (LivingEntity)this.entity.get()) == null) {
            return;
        }
        Iterator iterator = this.data.iterator();
        for (int i = 0; i < count; ++i) {
            NBTTagCompound compoundTag = (NBTTagCompound)iterator.next();
            LivingEntity entity = new NBTEntityDataEntry(this.rebuild(compoundTag)).createEntity(thisEntity.getLocation(), false, thisEntity.getType());
            consumer.accept(entity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forEachTransforming(Function<LivingEntity, Boolean> function) {
        LivingEntity thisEntity = (LivingEntity)this.entity.get();
        if (thisEntity == null) {
            return;
        }
        Queue<NBTTagCompound> queue = this.data;
        synchronized (queue) {
            ArrayList<NBTTagCompound> data = new ArrayList<NBTTagCompound>(this.data);
            ListIterator<NBTTagCompound> dataIterator = data.listIterator();
            while (dataIterator.hasNext()) {
                NBTTagCompound compoundTag = (NBTTagCompound)dataIterator.next();
                LivingEntity entity = new NBTEntityDataEntry(this.rebuild(compoundTag)).createEntity(thisEntity.getLocation(), false, thisEntity.getType());
                if (!function.apply(entity).booleanValue()) continue;
                NBTTagCompound replacementTag = new NBTTagCompound();
                ((NMSHandlerImpl)NMSAdapter.getHandler()).saveEntityToTag(entity, replacementTag);
                this.stripUnneeded(replacementTag);
                this.stripAttributeUuids(replacementTag);
                this.removeDuplicates(replacementTag);
                dataIterator.set(replacementTag);
            }
            this.data.clear();
            this.data.addAll(data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<LivingEntity> removeIf(Function<LivingEntity, Boolean> function) {
        ArrayList<LivingEntity> removedEntries = new ArrayList<LivingEntity>(this.data.size());
        LivingEntity thisEntity = (LivingEntity)this.entity.get();
        if (thisEntity == null) {
            return removedEntries;
        }
        Queue<NBTTagCompound> queue = this.data;
        synchronized (queue) {
            ArrayList<NBTTagCompound> data = new ArrayList<NBTTagCompound>(this.data);
            ListIterator<NBTTagCompound> dataIterator = data.listIterator();
            while (dataIterator.hasNext()) {
                NBTTagCompound compoundTag = (NBTTagCompound)dataIterator.next();
                LivingEntity entity = new NBTEntityDataEntry(this.rebuild(compoundTag)).createEntity(thisEntity.getLocation(), false, thisEntity.getType());
                if (function.apply(entity).booleanValue()) {
                    removedEntries.add(entity);
                    dataIterator.remove();
                    continue;
                }
                NBTTagCompound replacementTag = new NBTTagCompound();
                ((NMSHandlerImpl)NMSAdapter.getHandler()).saveEntityToTag(entity, replacementTag);
                this.stripUnneeded(replacementTag);
                this.stripAttributeUuids(replacementTag);
                this.removeDuplicates(replacementTag);
                dataIterator.set(replacementTag);
            }
            this.data.clear();
            this.data.addAll(data);
            return removedEntries;
        }
    }

    private void removeDuplicates(NBTTagCompound compoundTag) {
        for (String key : new ArrayList(compoundTag.e())) {
            NBTBase baseValue = this.base.a(key);
            NBTBase thisValue = compoundTag.a(key);
            if (baseValue == null || !baseValue.equals((Object)thisValue)) continue;
            compoundTag.r(key);
        }
    }

    private NBTTagCompound rebuild(NBTTagCompound compoundTag) {
        NBTTagCompound merged = new NBTTagCompound();
        merged.a(this.base);
        merged.a(compoundTag);
        this.fillAttributeUuids(merged);
        return merged;
    }

    private void stripUnneeded(NBTTagCompound compoundTag) {
        NMSHandler.REMOVABLE_NBT_KEYS.forEach(arg_0 -> ((NBTTagCompound)compoundTag).r(arg_0));
        NBTTagCompound bukkitValues = compoundTag.n("BukkitValues");
        bukkitValues.r("rosestacker:stacked_entity_data");
    }

    private void stripAttributeUuids(NBTTagCompound compoundTag) {
        NBTTagList attributes = compoundTag.p("Attributes");
        for (int i = 0; i < attributes.size(); ++i) {
            NBTTagCompound attribute = attributes.b(i);
            attribute.r("UUID");
            NBTTagList modifiers = attribute.p("Modifiers");
            for (int j = 0; j < modifiers.size(); ++j) {
                NBTTagCompound modifier = modifiers.b(j);
                if (modifier.b("Name", "").equals("Random spawn bonus")) {
                    modifiers.d(j);
                    --j;
                    continue;
                }
                modifier.r("UUID");
            }
        }
    }

    private void fillAttributeUuids(NBTTagCompound compoundTag) {
        NBTTagList attributes = compoundTag.p("Attributes");
        for (int i = 0; i < attributes.size(); ++i) {
            NBTTagCompound attribute = attributes.b(i);
            attribute.a("UUID", UUIDUtil.a, (Object)UUID.randomUUID());
            NBTTagList modifiers = attribute.p("Modifiers");
            for (int j = 0; j < modifiers.size(); ++j) {
                NBTTagCompound modifier = modifiers.b(j);
                modifier.a("UUID", UUIDUtil.a, (Object)UUID.randomUUID());
            }
            if (!modifiers.isEmpty()) continue;
            attribute.r("Modifiers");
        }
    }
}

