/*
 * Decompiled with CFR 0.152.
 */
package dev.rosewood.rosestacker.nms.v1_21_R6;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import dev.rosewood.rosestacker.RoseStacker;
import dev.rosewood.rosestacker.lib.rosegarden.utils.NMSUtil;
import dev.rosewood.rosestacker.nms.NMSHandler;
import dev.rosewood.rosestacker.nms.hologram.Hologram;
import dev.rosewood.rosestacker.nms.spawner.StackedSpawnerTile;
import dev.rosewood.rosestacker.nms.storage.EntityDataEntry;
import dev.rosewood.rosestacker.nms.storage.StackedEntityDataStorage;
import dev.rosewood.rosestacker.nms.storage.StackedEntityDataStorageType;
import dev.rosewood.rosestacker.nms.storage.StorageMigrationType;
import dev.rosewood.rosestacker.nms.util.ReflectionUtils;
import dev.rosewood.rosestacker.nms.v1_21_R6.entity.SoloEntitySpider;
import dev.rosewood.rosestacker.nms.v1_21_R6.entity.SoloEntityStrider;
import dev.rosewood.rosestacker.nms.v1_21_R6.event.AsyncEntityDeathEventImpl;
import dev.rosewood.rosestacker.nms.v1_21_R6.hologram.HologramImpl;
import dev.rosewood.rosestacker.nms.v1_21_R6.spawner.StackedSpawnerTileImpl;
import dev.rosewood.rosestacker.nms.v1_21_R6.storage.NBTEntityDataEntry;
import dev.rosewood.rosestacker.nms.v1_21_R6.storage.NBTStackedEntityDataStorage;
import dev.rosewood.rosestacker.nms.v1_21_R6.storage.SimpleStackedEntityDataStorage;
import dev.rosewood.rosestacker.stack.StackedSpawner;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ProblemReporter;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityReference;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.control.ControllerJump;
import net.minecraft.world.entity.ai.control.ControllerLook;
import net.minecraft.world.entity.ai.control.ControllerMove;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalSelector;
import net.minecraft.world.entity.ai.goal.PathfinderGoalWrapped;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.animal.EntityRabbit;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.EntityCreeper;
import net.minecraft.world.entity.monster.EntityZombie;
import net.minecraft.world.entity.npc.EntityVillagerAbstract;
import net.minecraft.world.entity.raid.EntityRaider;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.trading.MerchantRecipeList;
import net.minecraft.world.level.MobSpawnerAbstract;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityMobSpawner;
import net.minecraft.world.level.entity.EntityAccess;
import net.minecraft.world.level.entity.PersistentEntitySectionManager;
import net.minecraft.world.level.entity.UniquelyIdentifyable;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.ThreadSafeLegacyRandomSource;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_21_R6.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftCreeper;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftItem;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftChatMessage;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftNamespacedKey;
import org.bukkit.entity.AbstractVillager;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import sun.misc.Unsafe;

public class NMSHandlerImpl
implements NMSHandler {
    private static boolean hijackedAnyRandomSources = false;
    private static DataWatcherObject<Boolean> value_Creeper_DATA_IS_IGNITED;
    private static Field field_GoalSelector_availableGoals;
    private static Field field_Mob_lookControl;
    private static Field field_Mob_moveControl;
    private static Field field_Mob_jumpControl;
    private static Field field_LivingEntity_brain;
    private static Field field_ServerLevel_entityManager;
    private static Field field_ServerLevel_entityLookup;
    private static Method method_EntityLookup_addNewEntity;
    private static Field field_Entity_spawnReason;
    private static AtomicInteger entityCounter;
    private static Unsafe unsafe;
    private static long field_SpawnerBlockEntity_spawner_offset;
    private static long field_Level_random_offset;
    private static Field field_LegacyRandomSource_seed;
    private static Field field_AbstractVillager_offers;
    private static Field field_Entity_spawnedViaMobSpawner;
    private static Field field_ItemEntity_despawnRate;

    @Override
    public LivingEntity createNewEntityUnspawned(EntityType entityType, Location location, CreatureSpawnEvent.SpawnReason spawnReason) {
        World world = location.getWorld();
        if (world == null) {
            return null;
        }
        Class entityClass = entityType.getEntityClass();
        if (entityClass == null || !LivingEntity.class.isAssignableFrom(entityClass)) {
            throw new IllegalArgumentException("EntityType must be of a LivingEntity");
        }
        Optional typeOptional = BuiltInRegistries.g.c(CraftNamespacedKey.toMinecraft((NamespacedKey)entityType.getKey()));
        Holder.c typeReference = (Holder.c)typeOptional.orElseThrow(() -> new IllegalStateException("Entity type did not exist"));
        EntityTypes nmsEntityType = (EntityTypes)typeReference.a();
        Object nmsEntity = this.createCreature(nmsEntityType, ((CraftWorld)world).getHandle(), new BlockPosition(location.getBlockX(), location.getBlockY(), location.getBlockZ()), this.toNmsSpawnReason(spawnReason));
        return nmsEntity == null ? null : (LivingEntity)nmsEntity.getBukkitEntity();
    }

    public <T extends net.minecraft.world.entity.Entity> T createCreature(EntityTypes<T> entityType, WorldServer world, BlockPosition blockPos, EntitySpawnReason mobSpawnType) {
        Object newEntity = entityType == EntityTypes.bt ? new SoloEntitySpider(entityType, (net.minecraft.world.level.World)world) : (entityType == EntityTypes.by ? new SoloEntityStrider(entityType, (net.minecraft.world.level.World)world) : entityType.a((net.minecraft.world.level.World)world, mobSpawnType));
        if (newEntity == null) {
            return null;
        }
        if (field_Entity_spawnReason != null) {
            try {
                field_Entity_spawnReason.set(newEntity, this.toBukkitSpawnReason(mobSpawnType));
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        newEntity.b((double)blockPos.u() + 0.5, blockPos.v(), (double)blockPos.w() + 0.5, MathHelper.h((float)(world.z.i() * 360.0f)), 0.0f);
        if (newEntity instanceof EntityInsentient) {
            EntityInsentient mob = (EntityInsentient)newEntity;
            mob.bD = mob.dX();
            mob.bB = mob.dX();
            EntityZombie.GroupDataZombie groupDataEntity = null;
            if (entityType == EntityTypes.N || entityType == EntityTypes.aq || entityType == EntityTypes.bV || entityType == EntityTypes.bW || entityType == EntityTypes.bT) {
                groupDataEntity = new EntityZombie.GroupDataZombie(EntityZombie.a((RandomSource)world.I_()), false);
            }
            mob.a((WorldAccess)world, world.d_(mob.dF()), mobSpawnType, (GroupDataEntity)groupDataEntity);
        }
        return (T)newEntity;
    }

    @Override
    public void spawnExistingEntity(LivingEntity entity, CreatureSpawnEvent.SpawnReason spawnReason, boolean bypassSpawnEvent) {
        Location location = entity.getLocation();
        World world = location.getWorld();
        if (world == null) {
            throw new IllegalArgumentException("Entity is not in a loaded world");
        }
        if (bypassSpawnEvent) {
            try {
                this.addEntityToWorld(((CraftWorld)world).getHandle(), ((CraftEntity)entity).getHandle());
            }
            catch (ReflectiveOperationException e) {
                e.printStackTrace();
            }
        } else {
            ((CraftWorld)world).addEntityToWorld(((CraftEntity)entity).getHandle(), spawnReason);
        }
    }

    @Override
    public void updateEntityNameTagForPlayer(Player player, Entity entity, String customName, boolean customNameVisible) {
        try {
            ArrayList<DataWatcher.c> dataValues = new ArrayList<DataWatcher.c>();
            Optional<IChatBaseComponent> nameComponent = Optional.ofNullable(CraftChatMessage.fromStringOrNull((String)customName));
            dataValues.add(DataWatcher.c.a((DataWatcherObject)DataWatcherRegistry.g.a(2), nameComponent));
            dataValues.add(DataWatcher.c.a((DataWatcherObject)DataWatcherRegistry.k.a(3), (Object)customNameVisible));
            PacketPlayOutEntityMetadata entityDataPacket = new PacketPlayOutEntityMetadata(entity.getEntityId(), dataValues);
            ((CraftPlayer)player).getHandle().g.b((Packet)entityDataPacket);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void updateEntityNameTagVisibilityForPlayer(Player player, Entity entity, boolean customNameVisible) {
        try {
            ArrayList dataValues = Lists.newArrayList((Object[])new DataWatcher.c[]{DataWatcher.c.a((DataWatcherObject)DataWatcherRegistry.k.a(3), (Object)customNameVisible)});
            PacketPlayOutEntityMetadata entityDataPacket = new PacketPlayOutEntityMetadata(entity.getEntityId(), (List)dataValues);
            ((CraftPlayer)player).getHandle().g.b((Packet)entityDataPacket);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void unigniteCreeper(Creeper creeper) {
        EntityCreeper nmsCreeper = ((CraftCreeper)creeper).getHandle();
        nmsCreeper.aC().a(value_Creeper_DATA_IS_IGNITED, (Object)false);
        if (!Bukkit.getBukkitVersion().contains("1.17-")) {
            nmsCreeper.cv = nmsCreeper.cw;
        }
    }

    @Override
    public void removeEntityGoals(LivingEntity livingEntity) {
        EntityLiving nmsEntity = ((CraftLivingEntity)livingEntity).getHandle();
        if (!(nmsEntity instanceof EntityInsentient)) {
            return;
        }
        try {
            EntityInsentient mob = (EntityInsentient)nmsEntity;
            Set goals = (Set)field_GoalSelector_availableGoals.get(mob.cq);
            Iterator goalsIterator = goals.iterator();
            while (goalsIterator.hasNext()) {
                PathfinderGoalWrapped goal = (PathfinderGoalWrapped)goalsIterator.next();
                if (goal.k() instanceof PathfinderGoalFloat) continue;
                goalsIterator.remove();
            }
            ((Set)field_GoalSelector_availableGoals.get(mob.cr)).clear();
            mob.g(null);
            field_Mob_lookControl.set(mob, new ControllerLook(mob){

                public void a() {
                }
            });
            field_Mob_moveControl.set(mob, new ControllerMove(mob){

                public void a() {
                }
            });
            if (mob instanceof EntityRabbit) {
                field_Mob_jumpControl.set(mob, new EntityRabbit.ControllerJumpRabbit((EntityRabbit)mob){

                    public void b() {
                    }

                    public boolean d() {
                        return false;
                    }

                    public boolean c() {
                        return false;
                    }
                });
            } else {
                field_Mob_jumpControl.set(mob, new ControllerJump(mob){

                    public void b() {
                    }
                });
            }
            field_LivingEntity_brain.set(mob, new BehaviorController(List.of(), List.of(), ImmutableList.of(), () -> BehaviorController.b(List.of(), List.of())){

                public Optional<?> c(MemoryModuleType var0) {
                    return Optional.empty();
                }
            });
        }
        catch (ReflectiveOperationException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public ItemStack setItemStackNBT(ItemStack itemStack, String key, String value) {
        net.minecraft.world.item.ItemStack nmsItem = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        nmsItem.a(DataComponents.b, (Object)CustomData.a, comp -> comp.a(currentNbt -> currentNbt.a(key, value)));
        return CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)nmsItem);
    }

    @Override
    public ItemStack setItemStackNBT(ItemStack itemStack, String key, int value) {
        net.minecraft.world.item.ItemStack nmsItem = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        nmsItem.a(DataComponents.b, (Object)CustomData.a, comp -> comp.a(currentNbt -> currentNbt.a(key, value)));
        return CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)nmsItem);
    }

    @Override
    public String getItemStackNBTString(ItemStack itemStack, String key) {
        net.minecraft.world.item.ItemStack nmsItem = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        NBTTagCompound tagCompound = ((CustomData)nmsItem.a(DataComponents.b, (Object)CustomData.a)).b();
        return tagCompound.b(key, "");
    }

    @Override
    public int getItemStackNBTInt(ItemStack itemStack, String key) {
        net.minecraft.world.item.ItemStack nmsItem = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        NBTTagCompound tagCompound = ((CustomData)nmsItem.a(DataComponents.b, (Object)CustomData.a)).b();
        return tagCompound.b(key, 0);
    }

    @Override
    public String getItemStackNBTStringFromCompound(ItemStack itemStack, String compoundKey, String valueKey) {
        net.minecraft.world.item.ItemStack nmsItem = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        NBTTagCompound tagCompound = ((CustomData)nmsItem.a(DataComponents.b, (Object)CustomData.a)).b();
        NBTTagCompound targetCompound = tagCompound.n(compoundKey);
        return targetCompound.b(valueKey, "");
    }

    @Override
    public void setLastHurtBy(LivingEntity livingEntity, Player player) {
        if (player != null) {
            ((CraftLivingEntity)livingEntity).getHandle().bG = EntityReference.a((UniquelyIdentifyable)((CraftPlayer)player).getHandle());
        }
    }

    @Override
    public boolean hasLineOfSight(LivingEntity entity1, Location location) {
        EntityLiving nmsEntity1 = ((CraftLivingEntity)entity1).getHandle();
        Vec3D vec3d = new Vec3D(nmsEntity1.dK(), nmsEntity1.dO(), nmsEntity1.dQ());
        Vec3D target = new Vec3D(location.getX(), location.getY(), location.getZ());
        return nmsEntity1.an().a(new RayTrace(vec3d, target, RayTrace.BlockCollisionOption.c, RayTrace.FluidCollisionOption.a, (net.minecraft.world.entity.Entity)nmsEntity1)).d() == MovingObjectPosition.EnumMovingObjectType.a;
    }

    @Override
    public boolean isActiveRaider(LivingEntity entity) {
        EntityRaider raider;
        EntityLiving entityLiving = ((CraftLivingEntity)entity).getHandle();
        return entityLiving instanceof EntityRaider && (raider = (EntityRaider)entityLiving).gV() != null;
    }

    @Override
    public EntityDataEntry createEntityDataEntry(LivingEntity livingEntity) {
        return new NBTEntityDataEntry(livingEntity);
    }

    @Override
    public StackedEntityDataStorage createEntityDataStorage(LivingEntity livingEntity, StackedEntityDataStorageType storageType) {
        return switch (storageType) {
            default -> throw new IncompatibleClassChangeError();
            case StackedEntityDataStorageType.NBT -> new NBTStackedEntityDataStorage(livingEntity);
            case StackedEntityDataStorageType.SIMPLE -> new SimpleStackedEntityDataStorage(livingEntity);
        };
    }

    @Override
    public StackedEntityDataStorage deserializeEntityDataStorage(LivingEntity livingEntity, byte[] data, StackedEntityDataStorageType storageType, Set<StorageMigrationType> migrations) {
        return switch (storageType) {
            default -> throw new IncompatibleClassChangeError();
            case StackedEntityDataStorageType.NBT -> new NBTStackedEntityDataStorage(livingEntity, data, migrations);
            case StackedEntityDataStorageType.SIMPLE -> new SimpleStackedEntityDataStorage(livingEntity, data);
        };
    }

    @Override
    public StackedSpawnerTile injectStackedSpawnerTile(Object stackedSpawnerObj) {
        BlockPosition blockPos;
        StackedSpawner stackedSpawner = (StackedSpawner)stackedSpawnerObj;
        Block block = stackedSpawner.getBlock();
        WorldServer level = ((CraftWorld)block.getWorld()).getHandle();
        TileEntity blockEntity = level.c_(blockPos = new BlockPosition(block.getX(), block.getY(), block.getZ()));
        if (!(blockEntity instanceof TileEntityMobSpawner)) {
            return null;
        }
        TileEntityMobSpawner spawnerBlockEntity = (TileEntityMobSpawner)blockEntity;
        StackedSpawnerTileImpl stackedSpawnerTile = new StackedSpawnerTileImpl(spawnerBlockEntity.c(), spawnerBlockEntity, stackedSpawner);
        unsafe.putObject(spawnerBlockEntity, field_SpawnerBlockEntity_spawner_offset, stackedSpawnerTile);
        return stackedSpawnerTile;
    }

    @Override
    public Hologram createHologram(Location location, List<String> text) {
        return new HologramImpl(text, location, entityCounter::incrementAndGet);
    }

    @Override
    public boolean supportsEmptySpawners() {
        return true;
    }

    @Override
    public void hijackRandomSource(World world) {
        WorldServer level = ((CraftWorld)world).getHandle();
        if (!(level.z instanceof LegacyRandomSource)) {
            return;
        }
        if (!hijackedAnyRandomSources) {
            hijackedAnyRandomSources = true;
        }
        try {
            LegacyRandomSource originalRandomSource = (LegacyRandomSource)level.z;
            AtomicLong seed = (AtomicLong)field_LegacyRandomSource_seed.get(originalRandomSource);
            ThreadSafeLegacyRandomSource hijackedRandomSource = new ThreadSafeLegacyRandomSource(seed.get());
            unsafe.putObject(level, field_Level_random_offset, hijackedRandomSource);
        }
        catch (ReflectiveOperationException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setPaperFromMobSpawner(Entity entity) {
        if (field_Entity_spawnedViaMobSpawner == null) {
            return;
        }
        try {
            field_Entity_spawnedViaMobSpawner.set(((CraftEntity)entity).getHandle(), true);
        }
        catch (ReflectiveOperationException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setCustomNameUncapped(Entity entity, String customName) {
        ((CraftEntity)entity).getHandle().b(CraftChatMessage.fromStringOrNull((String)customName));
    }

    @Override
    public int getItemDespawnRate(Item item) {
        if (field_ItemEntity_despawnRate == null) {
            return ((CraftWorld)item.getWorld()).getHandle().spigotConfig.itemDespawnRate;
        }
        try {
            return (Integer)field_ItemEntity_despawnRate.get(((CraftItem)item).getHandle());
        }
        catch (ReflectiveOperationException e) {
            e.printStackTrace();
            throw new IllegalStateException("Unable to get item despawn rate");
        }
    }

    @Override
    public EntityDeathEvent createAsyncEntityDeathEvent(@NotNull LivingEntity what, @NotNull List<ItemStack> drops, int droppedExp) {
        return new AsyncEntityDeathEventImpl(what, drops, droppedExp);
    }

    @Override
    public List<Entity> getEntities(World world) {
        CraftWorld craftWorld = (CraftWorld)world;
        ArrayList<Entity> entities = new ArrayList<Entity>();
        for (net.minecraft.world.entity.Entity entity : craftWorld.getNMSEntities()) {
            entities.add((Entity)entity.getBukkitEntity());
        }
        return entities;
    }

    public void addEntityToWorld(WorldServer world, net.minecraft.world.entity.Entity entity) throws ReflectiveOperationException {
        if (field_ServerLevel_entityManager != null) {
            PersistentEntitySectionManager entityManager = (PersistentEntitySectionManager)field_ServerLevel_entityManager.get(world);
            entityManager.a((EntityAccess)entity);
        } else if (field_ServerLevel_entityLookup != null) {
            Object entityLookup = field_ServerLevel_entityLookup.get(world);
            if (method_EntityLookup_addNewEntity == null) {
                method_EntityLookup_addNewEntity = ReflectionUtils.getMethodByName(entityLookup.getClass(), "addNewEntity", net.minecraft.world.entity.Entity.class);
            }
            method_EntityLookup_addNewEntity.invoke(entityLookup, entity);
        } else {
            throw new IllegalStateException("Unable to spawn entities due to missing methods");
        }
    }

    private CreatureSpawnEvent.SpawnReason toBukkitSpawnReason(EntitySpawnReason mobSpawnType) {
        return switch (mobSpawnType) {
            case EntitySpawnReason.m -> CreatureSpawnEvent.SpawnReason.SPAWNER_EGG;
            case EntitySpawnReason.c -> CreatureSpawnEvent.SpawnReason.SPAWNER;
            default -> CreatureSpawnEvent.SpawnReason.CUSTOM;
        };
    }

    private EntitySpawnReason toNmsSpawnReason(CreatureSpawnEvent.SpawnReason spawnReason) {
        return switch (spawnReason) {
            case CreatureSpawnEvent.SpawnReason.SPAWNER_EGG -> EntitySpawnReason.m;
            case CreatureSpawnEvent.SpawnReason.SPAWNER -> EntitySpawnReason.c;
            default -> EntitySpawnReason.n;
        };
    }

    public NBTTagCompound saveEntityToTag(LivingEntity livingEntity) {
        net.minecraft.world.entity.Entity nmsEntity = ((CraftEntity)livingEntity).getHandle();
        if (livingEntity instanceof AbstractVillager) {
            try {
                boolean bypassTrades;
                EntityVillagerAbstract villager = (EntityVillagerAbstract)nmsEntity;
                boolean bl = bypassTrades = field_AbstractVillager_offers.get(villager) == null;
                if (bypassTrades) {
                    field_AbstractVillager_offers.set(villager, new MerchantRecipeList());
                }
                ProblemReporter.a reporter = new ProblemReporter.a();
                TagValueOutput valueOutput = TagValueOutput.a((ProblemReporter)reporter, (HolderLookup.a)villager.ej());
                ((CraftLivingEntity)livingEntity).getHandle().d((ValueOutput)valueOutput);
                if (!reporter.a()) {
                    RoseStacker.getInstance().getLogger().severe(reporter.c());
                }
                NBTTagCompound compoundTag = valueOutput.b();
                if (bypassTrades) {
                    field_AbstractVillager_offers.set(villager, null);
                    compoundTag.r("Offers");
                }
                return compoundTag;
            }
            catch (ReflectiveOperationException e) {
                e.printStackTrace();
                return new NBTTagCompound();
            }
        }
        ProblemReporter.a reporter = new ProblemReporter.a();
        TagValueOutput valueOutput = TagValueOutput.a((ProblemReporter)reporter, (HolderLookup.a)nmsEntity.ej());
        if (!reporter.a()) {
            RoseStacker.getInstance().getLogger().severe(reporter.c());
        }
        ((CraftLivingEntity)livingEntity).getHandle().d((ValueOutput)valueOutput);
        return valueOutput.b();
    }

    static {
        try {
            Field field_Creeper_DATA_IS_IGNITED = ReflectionUtils.getFieldByPositionAndType(EntityCreeper.class, 2, DataWatcherObject.class);
            value_Creeper_DATA_IS_IGNITED = (DataWatcherObject)field_Creeper_DATA_IS_IGNITED.get(null);
            field_GoalSelector_availableGoals = ReflectionUtils.getFieldByPositionAndType(PathfinderGoalSelector.class, 0, Set.class);
            field_Mob_lookControl = ReflectionUtils.getFieldByPositionAndType(EntityInsentient.class, 0, ControllerLook.class);
            field_Mob_moveControl = ReflectionUtils.getFieldByPositionAndType(EntityInsentient.class, 0, ControllerMove.class);
            field_Mob_jumpControl = ReflectionUtils.getFieldByPositionAndType(EntityInsentient.class, 0, ControllerJump.class);
            field_LivingEntity_brain = ReflectionUtils.getFieldByPositionAndType(EntityLiving.class, 0, BehaviorController.class);
            try {
                field_ServerLevel_entityManager = ReflectionUtils.getFieldByPositionAndType(WorldServer.class, 0, PersistentEntitySectionManager.class);
            }
            catch (IllegalStateException e) {
                field_ServerLevel_entityManager = null;
                field_ServerLevel_entityLookup = ReflectionUtils.getFieldByName(net.minecraft.world.level.World.class, "entityLookup");
            }
            if (NMSUtil.isPaper()) {
                field_Entity_spawnReason = ReflectionUtils.getFieldByPositionAndType(net.minecraft.world.entity.Entity.class, 0, CreatureSpawnEvent.SpawnReason.class);
            }
            entityCounter = (AtomicInteger)ReflectionUtils.getFieldByPositionAndType(net.minecraft.world.entity.Entity.class, 0, AtomicInteger.class).get(null);
            Field field_SpawnerBlockEntity_spawner = ReflectionUtils.getFieldByPositionAndType(TileEntityMobSpawner.class, 0, MobSpawnerAbstract.class);
            Field field_Level_random = ReflectionUtils.getFieldByPositionAndType(net.minecraft.world.level.World.class, 0, RandomSource.class);
            Field unsafeField = Unsafe.class.getDeclaredField("theUnsafe");
            unsafeField.setAccessible(true);
            unsafe = (Unsafe)unsafeField.get(null);
            field_SpawnerBlockEntity_spawner_offset = unsafe.objectFieldOffset(field_SpawnerBlockEntity_spawner);
            field_Level_random_offset = unsafe.objectFieldOffset(field_Level_random);
            field_LegacyRandomSource_seed = ReflectionUtils.getFieldByPositionAndType(LegacyRandomSource.class, 0, AtomicLong.class);
            field_AbstractVillager_offers = ReflectionUtils.getFieldByPositionAndType(EntityVillagerAbstract.class, 0, MerchantRecipeList.class);
            if (NMSUtil.isPaper()) {
                field_Entity_spawnedViaMobSpawner = ReflectionUtils.getFieldByName(net.minecraft.world.entity.Entity.class, "spawnedViaMobSpawner");
                field_ItemEntity_despawnRate = ReflectionUtils.getFieldByName(EntityItem.class, "despawnRate");
            }
        }
        catch (ReflectiveOperationException e) {
            e.printStackTrace();
        }
    }
}

