/*
 * Decompiled with CFR 0.152.
 */
package dev.rosewood.rosestacker.stack;

import dev.rosewood.rosestacker.stack.settings.StackSettings;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;

public abstract class Stack<T extends StackSettings> {
    public abstract int getStackSize();

    public abstract Location getLocation();

    public abstract void updateDisplay();

    public abstract T getStackSettings();

    public World getWorld() {
        Location location = this.getLocation();
        World world = location.getWorld();
        if (world == null) {
            throw new IllegalStateException("Stack world is null");
        }
        return world;
    }

    protected Set<Player> getPlayersInVisibleRange() {
        HashSet<Player> players = new HashSet<Player>();
        Location location = this.getLocation();
        World world = location.getWorld();
        if (world == null) {
            return players;
        }
        for (Player player : world.getPlayers()) {
            if (!player.getWorld().equals((Object)world) || !(player.getLocation().distanceSquared(location) <= 5625.0)) continue;
            players.add(player);
        }
        return players;
    }
}

