/*
 * Decompiled with CFR 0.152.
 */
package dev.rosewood.rosestacker.stack;

import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import dev.rosewood.rosestacker.RoseStacker;
import dev.rosewood.rosestacker.api.RoseStackerAPI;
import dev.rosewood.rosestacker.config.SettingKey;
import dev.rosewood.rosestacker.event.EntityStackMultipleDeathEvent;
import dev.rosewood.rosestacker.hook.NPCsHook;
import dev.rosewood.rosestacker.hook.SpawnerFlagPersistenceHook;
import dev.rosewood.rosestacker.hook.WorldGuardHook;
import dev.rosewood.rosestacker.lib.rosegarden.utils.EntitySpawnUtil;
import dev.rosewood.rosestacker.lib.rosegarden.utils.NMSUtil;
import dev.rosewood.rosestacker.lib.rosegarden.utils.StringPlaceholders;
import dev.rosewood.rosestacker.manager.EntityCacheManager;
import dev.rosewood.rosestacker.manager.LocaleManager;
import dev.rosewood.rosestacker.manager.StackManager;
import dev.rosewood.rosestacker.manager.StackSettingManager;
import dev.rosewood.rosestacker.nms.NMSAdapter;
import dev.rosewood.rosestacker.nms.NMSHandler;
import dev.rosewood.rosestacker.nms.storage.EntityDataEntry;
import dev.rosewood.rosestacker.nms.storage.StackedEntityDataStorage;
import dev.rosewood.rosestacker.stack.Stack;
import dev.rosewood.rosestacker.stack.settings.EntityStackSettings;
import dev.rosewood.rosestacker.utils.DataUtils;
import dev.rosewood.rosestacker.utils.EntityUtils;
import dev.rosewood.rosestacker.utils.ItemUtils;
import dev.rosewood.rosestacker.utils.PersistentDataUtils;
import dev.rosewood.rosestacker.utils.StackerUtils;
import dev.rosewood.rosestacker.utils.ThreadUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Statistic;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.Animals;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.Frog;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.MagmaCube;
import org.bukkit.entity.Player;
import org.bukkit.entity.Slime;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StackedEntity
extends Stack<EntityStackSettings>
implements Comparable<StackedEntity> {
    private LivingEntity entity;
    private StackedEntityDataStorage stackedEntityDataStorage;
    private int npcCheckCounter;
    private boolean npc;
    private String displayName;
    private boolean displayNameVisible;
    private double x;
    private double y;
    private double z;
    private EntityStackSettings stackSettings;

    public StackedEntity(LivingEntity entity, StackedEntityDataStorage stackedEntityDataStorage, boolean updateDisplay) {
        this.entity = entity;
        this.stackedEntityDataStorage = stackedEntityDataStorage;
        this.npcCheckCounter = NPCsHook.anyEnabled() ? 5 : 0;
        this.displayName = null;
        this.displayNameVisible = false;
        if (this.entity != null) {
            this.stackSettings = RoseStacker.getInstance().getManager(StackSettingManager.class).getEntityStackSettings(this.entity);
            if (updateDisplay) {
                this.updateDisplay();
            }
        }
    }

    public StackedEntity(LivingEntity entity, StackedEntityDataStorage stackedEntityDataStorage) {
        this(entity, stackedEntityDataStorage, true);
    }

    public StackedEntity(LivingEntity entity) {
        this(entity, NMSAdapter.getHandler().createEntityDataStorage(entity, RoseStacker.getInstance().getManager(StackManager.class).getEntityDataStorageType(entity.getType())), true);
    }

    public boolean checkNPC() {
        if (!this.npc && this.npcCheckCounter > 0) {
            if (NPCsHook.isNPC(this.entity)) {
                this.npc = true;
            }
            --this.npcCheckCounter;
        }
        return this.npc;
    }

    public LivingEntity getEntity() {
        return this.entity;
    }

    public void updateEntity() {
        LivingEntity entity = (LivingEntity)Bukkit.getEntity((UUID)this.entity.getUniqueId());
        if (entity == null || entity == this.entity) {
            return;
        }
        this.entity = entity;
        this.stackedEntityDataStorage.updateEntity(entity);
        this.resetHasMoved();
        this.updateDisplay();
    }

    public void increaseStackSize(LivingEntity entity) {
        this.increaseStackSize(entity, true);
    }

    public void increaseStackSize(LivingEntity entity, boolean updateDisplay) {
        Runnable task = () -> {
            this.stackedEntityDataStorage.add(entity);
            if (updateDisplay) {
                this.updateDisplay();
            }
        };
        if (!Bukkit.isPrimaryThread() && entity instanceof EnderDragon) {
            ThreadUtils.runSync(task);
        } else {
            task.run();
        }
    }

    public void increaseStackSize(int amount, boolean updateDisplay) {
        this.stackedEntityDataStorage.addClones(amount);
        if (updateDisplay) {
            this.updateDisplay();
        }
    }

    public void increaseStackSize(StackedEntityDataStorage serializedStackedEntities) {
        this.stackedEntityDataStorage.addAll(serializedStackedEntities);
        this.updateDisplay();
    }

    public StackedEntity decreaseStackSize() {
        if (this.stackedEntityDataStorage.isEmpty()) {
            return null;
        }
        StackManager stackManager = RoseStacker.getInstance().getManager(StackManager.class);
        EntityCacheManager entityCacheManager = RoseStacker.getInstance().getManager(EntityCacheManager.class);
        LivingEntity oldEntity = this.entity;
        stackManager.setEntityStackingTemporarilyDisabled(true);
        this.entity = this.stackedEntityDataStorage.pop().createEntity(oldEntity.getLocation(), true, oldEntity.getType());
        stackManager.setEntityStackingTemporarilyDisabled(false);
        this.stackSettings.applyUnstackProperties(this.entity, oldEntity);
        stackManager.updateStackedEntityKey(oldEntity, this);
        entityCacheManager.preCacheEntity((Entity)this.entity);
        this.entity.setVelocity(this.entity.getVelocity().add(Vector.getRandom().subtract(new Vector(0.5, 0.5, 0.5)).multiply(0.01)));
        if (oldEntity instanceof Ageable) {
            Ageable ageable1 = (Ageable)oldEntity;
            LivingEntity livingEntity = this.entity;
            if (livingEntity instanceof Ageable) {
                Ageable ageable2 = (Ageable)livingEntity;
                if (!ageable1.isAdult() && ageable2.isAdult()) {
                    Location centered = ageable1.getLocation();
                    centered.setX((double)centered.getBlockX() + 0.5);
                    centered.setZ((double)centered.getBlockZ() + 0.5);
                    ageable2.teleport(centered);
                }
            }
        }
        this.stackedEntityDataStorage.updateEntity(this.entity);
        this.updateDisplay();
        PersistentDataUtils.applyDisabledAi(this.entity);
        DataUtils.clearStackedEntityData(oldEntity);
        return new StackedEntity(oldEntity, NMSAdapter.getHandler().createEntityDataStorage(oldEntity, RoseStacker.getInstance().getManager(StackManager.class).getEntityDataStorageType(oldEntity.getType())));
    }

    @Deprecated(forRemoval=true)
    public StackedEntityDataStorage getStackedEntityNBT() {
        return this.getDataStorage();
    }

    public StackedEntityDataStorage getDataStorage() {
        return this.stackedEntityDataStorage;
    }

    @Deprecated(forRemoval=true)
    public void setStackedEntityNBT(StackedEntityDataStorage stackedEntityDataStorage) {
        this.setDataStorage(stackedEntityDataStorage);
    }

    public void setDataStorage(StackedEntityDataStorage stackedEntityDataStorage) {
        stackedEntityDataStorage.updateEntity(this.entity);
        this.stackedEntityDataStorage = stackedEntityDataStorage;
        this.updateDisplay();
    }

    public void dropStackLoot(Collection<ItemStack> existingLoot, int droppedExp) {
        this.dropPartialStackLoot(this.getStackSize(), existingLoot, droppedExp);
    }

    public void dropPartialStackLoot(int count, Collection<ItemStack> existingLoot, int droppedExp) {
        int originalStackSize = this.getStackSize();
        this.calculateAndDropPartialStackLoot(() -> this.calculateEntityDrops(count - 1, false, droppedExp, null, null, new EntityStackMultipleDeathEvent.EntityDrops(new ArrayList<ItemStack>(existingLoot), droppedExp), (Integer)originalStackSize, (Integer)count));
    }

    @Deprecated
    public void dropPartialStackLoot(Collection<LivingEntity> internalEntities) {
        int killedEntities = internalEntities.size();
        int originalStackSize = this.getStackSize() + killedEntities;
        this.calculateAndDropPartialStackLoot(() -> {
            List<EntityDataEntry> entityDataEntries = internalEntities.stream().map(EntityDataEntry::createFromEntity).toList();
            return this.calculateEntityDrops(entityDataEntries, EntityUtils.getApproximateExperience(this.entity), null, null, null, originalStackSize, killedEntities);
        });
    }

    @Deprecated
    public void dropPartialStackLoot(Collection<EntityDataEntry> internalEntityData, Collection<ItemStack> existingLoot, int droppedExp) {
        LivingEntity thisEntity = this.entity;
        int killedEntities = internalEntityData.size() + 1;
        int originalStackSize = this.getStackSize() + internalEntityData.size() + 1;
        this.calculateAndDropPartialStackLoot(() -> this.calculateEntityDrops(internalEntityData, droppedExp, null, thisEntity, new EntityStackMultipleDeathEvent.EntityDrops(new ArrayList<ItemStack>(existingLoot), droppedExp), originalStackSize, killedEntities));
    }

    private void calculateAndDropPartialStackLoot(Supplier<EntityStackMultipleDeathEvent.EntityDrops> calculator) {
        Player killer = this.entity.getKiller();
        boolean async = SettingKey.ENTITY_DEATH_EVENT_RUN_ASYNC.get();
        Runnable mainTask = () -> {
            EntityStackMultipleDeathEvent.EntityDrops drops = (EntityStackMultipleDeathEvent.EntityDrops)calculator.get();
            Runnable finishTask = () -> {
                Location location = this.entity.getLocation();
                RoseStacker.getInstance().getManager(StackManager.class).preStackItems(drops.getDrops(), location, false);
                int finalDroppedExp = drops.getExperience();
                if (SettingKey.ENTITY_DROP_ACCURATE_EXP.get().booleanValue() && finalDroppedExp > 0 && WorldGuardHook.testCanDropExperience(killer, location)) {
                    StackerUtils.dropExperience(location, finalDroppedExp, finalDroppedExp, finalDroppedExp / 2);
                }
            };
            if (!Bukkit.isPrimaryThread()) {
                ThreadUtils.runSync(finishTask);
            } else {
                finishTask.run();
            }
        };
        if (async && Bukkit.isPrimaryThread()) {
            ThreadUtils.runAsync(mainTask);
        } else if (!async && !Bukkit.isPrimaryThread()) {
            ThreadUtils.runSync(mainTask);
        } else {
            mainTask.run();
        }
    }

    @ApiStatus.Internal
    public EntityStackMultipleDeathEvent.EntityDrops calculateEntityDrops(int count, boolean includeMainEntity, int entityExpValue) {
        return this.calculateEntityDrops(count, includeMainEntity, entityExpValue, null);
    }

    @ApiStatus.Internal
    public EntityStackMultipleDeathEvent.EntityDrops calculateEntityDrops(int count, boolean includeMainEntity, int entityExpValue, Integer lootingModifier) {
        return this.calculateEntityDrops(count, includeMainEntity, entityExpValue, lootingModifier, null, null, null, null);
    }

    @ApiStatus.Internal
    public EntityStackMultipleDeathEvent.EntityDrops calculateEntityDrops(Collection<EntityDataEntry> internalEntities, int entityExpValue, Integer lootingModifier, LivingEntity mainEntity, EntityStackMultipleDeathEvent.EntityDrops mainEntityDrops, Integer originalStackSize, Integer entityKillCount) {
        if (mainEntity == null) {
            mainEntity = this.entity;
        }
        int count = internalEntities.size();
        Location location = this.entity.getLocation();
        EntityType type = this.entity.getType();
        ArrayList<LivingEntity> finalEntities = new ArrayList<LivingEntity>();
        double multiplier = 1.0;
        int threshold = SettingKey.ENTITY_LOOT_APPROXIMATION_THRESHOLD.get();
        int approximationAmount = SettingKey.ENTITY_LOOT_APPROXIMATION_AMOUNT.get();
        if (SettingKey.ENTITY_LOOT_APPROXIMATION_ENABLED.get().booleanValue() && count > threshold) {
            int offset;
            Iterator<EntityDataEntry> entryIterator = internalEntities.iterator();
            int n = offset = mainEntityDrops != null ? 1 : 0;
            while (entryIterator.hasNext() && finalEntities.size() < approximationAmount - offset) {
                finalEntities.add(entryIterator.next().createEntity(location, false, type));
            }
            multiplier = (double)(internalEntities.size() + offset) / (double)approximationAmount;
        } else {
            finalEntities.addAll(internalEntities.stream().map(x -> x.createEntity(location, false, type)).toList());
        }
        return this.calculateEntityDrops(finalEntities, multiplier, entityExpValue, lootingModifier, mainEntity, mainEntityDrops, originalStackSize, entityKillCount);
    }

    @ApiStatus.Internal
    public EntityStackMultipleDeathEvent.EntityDrops calculateEntityDrops(int count, boolean includeMainEntity, int entityExpValue, Integer lootingModifier, LivingEntity mainEntity, EntityStackMultipleDeathEvent.EntityDrops mainEntityDrops, Integer originalStackSize, Integer entityKillCount) {
        if (mainEntity == null) {
            mainEntity = this.entity;
        }
        count = Math.min(count, this.getStackSize() - 1);
        ArrayList<LivingEntity> finalEntities = new ArrayList<LivingEntity>();
        if (includeMainEntity && mainEntityDrops == null) {
            finalEntities.add(mainEntity);
            ++count;
        }
        double multiplier = 1.0;
        int threshold = SettingKey.ENTITY_LOOT_APPROXIMATION_THRESHOLD.get();
        int approximationAmount = SettingKey.ENTITY_LOOT_APPROXIMATION_AMOUNT.get();
        if (SettingKey.ENTITY_LOOT_APPROXIMATION_ENABLED.get().booleanValue() && count > threshold) {
            int offset = mainEntityDrops != null ? 1 : 0;
            this.stackedEntityDataStorage.forEachCapped(approximationAmount - offset, finalEntities::add);
            multiplier = (double)(count + offset) / (double)approximationAmount;
        } else {
            this.stackedEntityDataStorage.forEachCapped(count, finalEntities::add);
        }
        return this.calculateEntityDrops(finalEntities, multiplier, entityExpValue, lootingModifier, mainEntity, mainEntityDrops, originalStackSize, entityKillCount);
    }

    private EntityStackMultipleDeathEvent.EntityDrops calculateEntityDrops(List<LivingEntity> stackEntities, double multiplier, int entityExpValue, Integer lootingModifier, LivingEntity mainEntity, EntityStackMultipleDeathEvent.EntityDrops mainEntityDrops, Integer originalStackSize, Integer entityKillCount) {
        EntityDamageByEntityEvent damageEvent;
        EntityDamageByEntityEvent damageEvent2;
        EntityDamageEvent entityDamageEvent;
        if (originalStackSize == null) {
            originalStackSize = this.getStackSize();
        }
        if (entityKillCount == null) {
            entityKillCount = stackEntities.size() + (mainEntityDrops != null ? 1 : 0);
        }
        boolean propagateKiller = SettingKey.ENTITY_LOOT_PROPAGATE_KILLER.get();
        boolean fromSpawner = PersistentDataUtils.isSpawnedFromSpawner((Entity)this.entity);
        Location location = mainEntity.getLocation();
        Player killer = propagateKiller ? mainEntity.getKiller() : null;
        Entity froglightKiller = NMSUtil.getVersionNumber() >= 19 && mainEntity.getType() == EntityType.MAGMA_CUBE && (entityDamageEvent = mainEntity.getLastDamageCause()) instanceof EntityDamageByEntityEvent && (damageEvent2 = (EntityDamageByEntityEvent)entityDamageEvent).getDamager().getType() == EntityType.FROG ? damageEvent2.getDamager() : null;
        boolean callEvents = !RoseStackerAPI.getInstance().isEntityStackMultipleDeathEventCalled();
        boolean isAnimal = mainEntity instanceof Animals;
        boolean isWither = mainEntity.getType() == EntityType.WITHER;
        EntityDamageEvent entityDamageEvent2 = mainEntity.getLastDamageCause();
        boolean killedByWither = entityDamageEvent2 instanceof EntityDamageByEntityEvent && ((damageEvent = (EntityDamageByEntityEvent)entityDamageEvent2).getDamager().getType() == EntityType.WITHER || damageEvent.getDamager().getType() == EntityType.WITHER_SKULL);
        boolean isSlime = mainEntity instanceof Slime;
        boolean isAccurateSlime = isSlime && this.stackSettings.getSettingValue("accurate-drops-with-kill-entire-stack-on-death").getBoolean();
        ListMultimap entityDrops = MultimapBuilder.linkedHashKeys().arrayListValues().build();
        if (mainEntityDrops != null) {
            entityDrops.put((Object)mainEntity, (Object)mainEntityDrops);
        }
        NMSHandler nmsHandler = NMSAdapter.getHandler();
        for (LivingEntity entity : stackEntities) {
            entity.setFireTicks(mainEntity.getFireTicks());
            if (fromSpawner) {
                SpawnerFlagPersistenceHook.flagSpawnerSpawned(entity);
            }
            nmsHandler.setLastHurtBy(entity, killer);
            entity.setLastDamageCause(propagateKiller ? mainEntity.getLastDamageCause() : null);
            int iterations = 1;
            if (isSlime) {
                Slime slime = (Slime)entity;
                if (isAccurateSlime) {
                    int totalSlimes = 1;
                    for (int size = slime.getSize(); size > 1; size /= 2) {
                        int currentSlimes = totalSlimes;
                        totalSlimes = StackerUtils.randomInRange(currentSlimes * 2, currentSlimes * 4);
                    }
                    iterations = totalSlimes;
                }
                slime.setSize(slime.getType() == EntityType.SLIME ? 1 : 2);
            }
            boolean isBaby = isAnimal && !((Animals)entity).isAdult();
            int desiredExp = isBaby ? 0 : entityExpValue;
            for (int i = 0; i < iterations; ++i) {
                int entityExperience;
                ArrayList<ItemStack> entityItems = isBaby ? new ArrayList<ItemStack>() : (lootingModifier != null ? new ArrayList<ItemStack>(EntityUtils.getEntityLoot(entity, killer, location, lootingModifier)) : new ArrayList<ItemStack>(EntityUtils.getEntityLoot(entity, killer, location)));
                if (isWither) {
                    entityItems.add(new ItemStack(Material.NETHER_STAR));
                }
                if (killedByWither) {
                    entityItems.add(new ItemStack(Material.WITHER_ROSE));
                }
                if (froglightKiller != null) {
                    Material froglightType;
                    Frog frog = (Frog)froglightKiller;
                    switch (frog.getVariant().getKey().getKey()) {
                        case "cold": {
                            Material material = Material.VERDANT_FROGLIGHT;
                            break;
                        }
                        case "temperate": {
                            Material material = Material.OCHRE_FROGLIGHT;
                            break;
                        }
                        case "warm": {
                            Material material = Material.PEARLESCENT_FROGLIGHT;
                            break;
                        }
                        default: {
                            RoseStacker.getInstance().getLogger().warning("Unhandled frog type: " + String.valueOf(frog.getVariant().getKey()));
                            Material material = froglightType = null;
                        }
                    }
                    if (froglightType != null) {
                        entityItems.add(new ItemStack(froglightType));
                    }
                }
                if (callEvents) {
                    EntityDeathEvent deathEvent = nmsHandler.createAsyncEntityDeathEvent(entity, entityItems, desiredExp);
                    Bukkit.getPluginManager().callEvent((Event)deathEvent);
                    entityExperience = deathEvent.getDroppedExp();
                } else {
                    entityExperience = desiredExp;
                }
                entityDrops.put((Object)entity, (Object)new EntityStackMultipleDeathEvent.EntityDrops(entityItems, entityExperience));
            }
            if (isSlime && entity.getType() == EntityType.MAGMA_CUBE) {
                ((MagmaCube)entity).setSize(1);
            }
            if (!fromSpawner) continue;
            SpawnerFlagPersistenceHook.unflagSpawnerSpawned(entity);
        }
        if (!callEvents) {
            EntityStackMultipleDeathEvent event = new EntityStackMultipleDeathEvent(this, (Multimap<LivingEntity, EntityStackMultipleDeathEvent.EntityDrops>)entityDrops, originalStackSize, entityKillCount, multiplier, mainEntity, killer, this::calculateFinalEntityDrops);
            Bukkit.getPluginManager().callEvent((Event)event);
        }
        return this.calculateFinalEntityDrops((Multimap<LivingEntity, EntityStackMultipleDeathEvent.EntityDrops>)entityDrops, multiplier);
    }

    private EntityStackMultipleDeathEvent.EntityDrops calculateFinalEntityDrops(Multimap<LivingEntity, EntityStackMultipleDeathEvent.EntityDrops> entityDrops, double multiplier) {
        List<ItemStack> finalItems = new ArrayList<ItemStack>();
        int finalExp = 0;
        for (EntityStackMultipleDeathEvent.EntityDrops drops : entityDrops.values()) {
            finalItems.addAll(drops.getDrops());
            finalExp += drops.getExperience();
        }
        if (multiplier > 1.0) {
            finalItems = ItemUtils.getMultipliedItemStacks(finalItems, multiplier, true);
            finalExp = (int)Math.min(Math.round((double)finalExp * multiplier), Integer.MAX_VALUE);
        }
        return new EntityStackMultipleDeathEvent.EntityDrops(finalItems, finalExp);
    }

    public boolean shouldStayStacked() {
        if (this.entity == null || this.stackSettings == null || this.stackedEntityDataStorage.isEmpty()) {
            return true;
        }
        if (this.entity instanceof EnderDragon) {
            return true;
        }
        NMSHandler nmsHandler = NMSAdapter.getHandler();
        LivingEntity entity = this.stackedEntityDataStorage.peek().createEntity(this.entity.getLocation(), false, this.entity.getType());
        StackedEntity stackedEntity = new StackedEntity(entity, nmsHandler.createEntityDataStorage(entity, RoseStacker.getInstance().getManager(StackManager.class).getEntityDataStorageType(entity.getType())));
        return this.stackSettings.testCanStackWith(this, stackedEntity, true);
    }

    @Override
    public int getStackSize() {
        return this.stackedEntityDataStorage.size() + 1;
    }

    @Override
    public Location getLocation() {
        return this.entity.getLocation();
    }

    public String getDisplayName() {
        if (this.displayName != null) {
            return this.displayName;
        }
        if (!SettingKey.ENTITY_DISPLAY_TAGS.get().booleanValue() || this.stackSettings == null || this.entity == null) {
            this.displayNameVisible = false;
            this.displayName = this.entity == null ? null : this.entity.getCustomName();
            return this.displayName;
        }
        if (this.entity.isDead()) {
            this.displayNameVisible = false;
            return null;
        }
        String customName = this.entity.getCustomName();
        if (this.getStackSize() > 1 || SettingKey.ENTITY_DISPLAY_TAGS_SINGLE.get().booleanValue()) {
            String displayString;
            StringPlaceholders.Builder placeholders = StringPlaceholders.builder("amount", StackerUtils.formatNumber(this.getStackSize()));
            NPCsHook.addCustomPlaceholders(this.entity, placeholders);
            if (customName != null && SettingKey.ENTITY_DISPLAY_TAGS_CUSTOM_NAME.get().booleanValue()) {
                placeholders.add("name", customName);
                displayString = RoseStacker.getInstance().getManager(LocaleManager.class).getLocaleMessage("entity-stack-display-custom-name", placeholders.build());
            } else {
                placeholders.add("name", this.stackSettings.getDisplayName());
                displayString = RoseStacker.getInstance().getManager(LocaleManager.class).getLocaleMessage("entity-stack-display", placeholders.build());
            }
            this.displayNameVisible = SettingKey.ENTITY_DISPLAY_TAGS_HOVER.get() == false;
            this.displayName = displayString;
            return this.displayName;
        }
        if (this.getStackSize() == 1 && customName != null) {
            this.displayNameVisible = false;
            this.displayName = this.entity.getCustomName();
            return this.displayName;
        }
        this.displayNameVisible = false;
        return null;
    }

    public boolean isDisplayNameVisible() {
        return this.displayNameVisible;
    }

    @Override
    public void updateDisplay() {
        this.displayName = null;
        String displayName = this.getDisplayName();
        NMSHandler nmsHandler = NMSAdapter.getHandler();
        for (Player player : this.getPlayersInVisibleRange()) {
            nmsHandler.updateEntityNameTagForPlayer(player, (Entity)this.entity, displayName, this.displayNameVisible);
        }
    }

    @Override
    public EntityStackSettings getStackSettings() {
        return this.stackSettings;
    }

    @Override
    public int compareTo(StackedEntity stack2) {
        LivingEntity entity1 = this.getEntity();
        LivingEntity entity2 = stack2.getEntity();
        if (this == stack2) {
            return 0;
        }
        if (SettingKey.ENTITY_STACK_FLYING_DOWNWARDS.get().booleanValue() && this.stackSettings.getEntityTypeData().flyingMob()) {
            return entity1.getLocation().getY() < entity2.getLocation().getY() ? 3 : -3;
        }
        if (this.getStackSize() == stack2.getStackSize()) {
            return entity1.getTicksLived() > entity2.getTicksLived() ? 2 : -2;
        }
        return this.getStackSize() > stack2.getStackSize() ? 1 : -1;
    }

    public boolean isEntireStackKilledOnDeath(@Nullable Player overrideKiller) {
        EntityDamageEvent lastDamageCause = this.entity.getLastDamageCause();
        if (overrideKiller == null) {
            overrideKiller = this.entity.getKiller();
        }
        return this.stackSettings.shouldKillEntireStackOnDeath() || SettingKey.SPAWNER_DISABLE_MOB_AI_OPTIONS_KILL_ENTIRE_STACK_ON_DEATH.get() != false && PersistentDataUtils.isAiDisabled(this.entity) || lastDamageCause != null && SettingKey.ENTITY_KILL_ENTIRE_STACK_CONDITIONS.get().stream().anyMatch(x -> x.equalsIgnoreCase(lastDamageCause.getCause().name())) || overrideKiller != null && SettingKey.ENTITY_KILL_ENTIRE_STACK_ON_DEATH_PERMISSION.get() != false && overrideKiller.hasPermission("rosestacker.killentirestack");
    }

    public boolean isEntireStackKilledOnDeath() {
        return this.isEntireStackKilledOnDeath(null);
    }

    public void killEntireStack(@Nullable EntityDeathEvent event) {
        Player killer;
        int experience;
        int amount = this.getStackSize();
        int n = experience = event != null ? event.getDroppedExp() : EntityUtils.getApproximateExperience(this.entity);
        if (SettingKey.ENTITY_DROP_ACCURATE_ITEMS.get().booleanValue()) {
            if (this.entity.getType() == EntityType.SLIME) {
                ((Slime)this.entity).setSize(1);
            } else if (this.entity.getType() == EntityType.MAGMA_CUBE) {
                ((MagmaCube)this.entity).setSize(2);
            }
            if (event == null) {
                this.dropStackLoot(new ArrayList<ItemStack>(), experience);
            } else {
                this.dropStackLoot(new ArrayList<ItemStack>(event.getDrops()), experience);
                event.getDrops().clear();
            }
            if (this.entity.getType() == EntityType.MAGMA_CUBE) {
                ((MagmaCube)this.entity).setSize(1);
            }
        } else if (SettingKey.ENTITY_DROP_ACCURATE_EXP.get().booleanValue()) {
            if (event == null) {
                EntitySpawnUtil.spawn(this.entity.getLocation(), ExperienceOrb.class, x -> x.setExperience(experience));
            } else {
                event.setDroppedExp(experience * amount);
            }
        }
        if ((killer = this.entity.getKiller()) != null && amount - 1 > 0 && SettingKey.MISC_STACK_STATISTICS.get().booleanValue()) {
            killer.incrementStatistic(Statistic.KILL_ENTITY, this.entity.getType(), amount - 1);
        }
        RoseStacker.getInstance().getManager(StackManager.class).removeEntityStack(this);
        if (!this.entity.isDead()) {
            this.entity.remove();
        }
    }

    public void killEntireStack() {
        this.killEntireStack(null);
    }

    public void killPartialStack(@Nullable EntityDeathEvent event, int amount) {
        Player killer;
        if (amount == 1) {
            if (this.getStackSize() == 1) {
                RoseStacker.getInstance().getManager(StackManager.class).removeEntityStack(this);
            } else {
                this.decreaseStackSize();
            }
            return;
        }
        List<EntityDataEntry> killedEntities = this.stackedEntityDataStorage.pop(amount - 1);
        if (SettingKey.ENTITY_DROP_ACCURATE_ITEMS.get().booleanValue()) {
            if (event == null) {
                this.dropPartialStackLoot(killedEntities, new ArrayList<ItemStack>(), EntityUtils.getApproximateExperience(this.entity));
            } else {
                this.dropPartialStackLoot(killedEntities, new ArrayList<ItemStack>(event.getDrops()), event.getDroppedExp());
                event.getDrops().clear();
                event.setDroppedExp(0);
            }
        } else if (SettingKey.ENTITY_DROP_ACCURATE_EXP.get().booleanValue()) {
            if (event == null) {
                EntitySpawnUtil.spawn(this.entity.getLocation(), ExperienceOrb.class, x -> x.setExperience(EntityUtils.getApproximateExperience(this.entity)));
            } else {
                event.setDroppedExp(event.getDroppedExp() * (killedEntities.size() + 1));
            }
        }
        LivingEntity originalEntity = this.entity;
        this.decreaseStackSize();
        if (originalEntity instanceof Slime) {
            Slime slime = (Slime)originalEntity;
            slime.setSize(1);
        }
        if ((killer = originalEntity.getKiller()) != null && amount - 1 > 0 && SettingKey.MISC_STACK_STATISTICS.get().booleanValue()) {
            killer.incrementStatistic(Statistic.KILL_ENTITY, this.entity.getType(), amount - 1);
        }
    }

    public boolean areMultipleEntitiesDying(@NotNull EntityDeathEvent event) {
        if (SettingKey.ENTITY_TRIGGER_DEATH_EVENT_FOR_ENTIRE_STACK_KILL.get().booleanValue() || !SettingKey.ENTITY_DROP_ACCURATE_ITEMS.get().booleanValue() || this.getStackSize() == 1) {
            return false;
        }
        if (this.isEntireStackKilledOnDeath()) {
            return true;
        }
        Player killer = event.getEntity().getKiller();
        if (!SettingKey.ENTITY_MULTIKILL_ENABLED.get().booleanValue()) {
            return false;
        }
        if (SettingKey.ENTITY_MULTIKILL_PLAYER_ONLY.get().booleanValue() && killer == null) {
            return false;
        }
        if (!SettingKey.ENTITY_MULTIKILL_ENCHANTMENT_ENABLED.get().booleanValue()) {
            return true;
        }
        if (killer == null) {
            return false;
        }
        Enchantment requiredEnchantment = Enchantment.getByKey((NamespacedKey)NamespacedKey.fromString((String)SettingKey.ENTITY_MULTIKILL_ENCHANTMENT_TYPE.get()));
        if (requiredEnchantment == null) {
            return false;
        }
        return killer.getInventory().getItemInMainHand().getEnchantmentLevel(requiredEnchantment) > 0;
    }

    public boolean hasMoved() {
        boolean moved;
        Location location = this.entity.getLocation();
        boolean bl = moved = location.getX() != this.x || location.getY() != this.y || location.getZ() != this.z;
        if (moved) {
            this.x = location.getX();
            this.y = location.getY();
            this.z = location.getZ();
        }
        return moved;
    }

    public void resetHasMoved() {
        this.z = 0.0;
        this.y = 0.0;
        this.x = 0.0;
    }
}

