/*
 * Decompiled with CFR 0.152.
 */
package dev.rosewood.rosestacker.stack;

import dev.rosewood.rosestacker.stack.Stack;
import dev.rosewood.rosestacker.stack.StackedBlock;
import dev.rosewood.rosestacker.stack.StackedEntity;
import dev.rosewood.rosestacker.stack.StackedItem;
import dev.rosewood.rosestacker.stack.StackedSpawner;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface StackingLogic {
    @NotNull
    public Map<UUID, StackedEntity> getStackedEntities();

    @NotNull
    public Map<UUID, StackedItem> getStackedItems();

    @NotNull
    public Map<Block, StackedBlock> getStackedBlocks();

    @NotNull
    public Map<Block, StackedSpawner> getStackedSpawners();

    @Nullable
    public StackedEntity getStackedEntity(LivingEntity var1);

    @Nullable
    public StackedItem getStackedItem(Item var1);

    @Nullable
    public StackedBlock getStackedBlock(Block var1);

    @Nullable
    public StackedSpawner getStackedSpawner(Block var1);

    public boolean isEntityStacked(LivingEntity var1);

    public boolean isItemStacked(Item var1);

    public boolean isBlockStacked(Block var1);

    public boolean isSpawnerStacked(Block var1);

    public void removeEntityStack(StackedEntity var1);

    public void removeItemStack(StackedItem var1);

    public void removeBlockStack(StackedBlock var1);

    public void removeSpawnerStack(StackedSpawner var1);

    public int removeAllEntityStacks();

    public int removeAllItemStacks();

    public void updateStackedEntityKey(LivingEntity var1, StackedEntity var2);

    @Nullable
    public StackedEntity splitEntityStack(StackedEntity var1);

    @Nullable
    public StackedItem splitItemStack(StackedItem var1, int var2);

    @Nullable
    public StackedEntity createEntityStack(LivingEntity var1, boolean var2);

    @Nullable
    public StackedItem createItemStack(Item var1, boolean var2);

    @Nullable
    public StackedBlock createBlockStack(Block var1, int var2);

    @Nullable
    public StackedSpawner createSpawnerStack(Block var1, int var2, boolean var3);

    public void addEntityStack(StackedEntity var1);

    public void addItemStack(StackedItem var1);

    public void preStackEntities(EntityType var1, int var2, Location var3, CreatureSpawnEvent.SpawnReason var4);

    public void preStackEntities(EntityType var1, int var2, Location var3);

    default public void preStackItems(Collection<ItemStack> items, Location location) {
        this.preStackItems(items, location, true);
    }

    public void preStackItems(Collection<ItemStack> var1, Location var2, boolean var3);

    @Nullable
    public StackedItem dropItemStack(ItemStack var1, int var2, Location var3, boolean var4);

    public void loadChunkBlocks(Chunk var1);

    public void loadChunkEntities(List<Entity> var1);

    public void saveChunkBlocks(Chunk var1, boolean var2);

    public void saveChunkEntities(List<Entity> var1, boolean var2);

    public <T extends Stack<?>> void saveChunkEntityStacks(List<T> var1, boolean var2);

    public void saveAllData(boolean var1);

    public void tryStackEntity(StackedEntity var1);

    public void tryStackItem(StackedItem var1);

    public void tryUnstackEntity(StackedEntity var1);
}

