/*
 * Decompiled with CFR 0.152.
 */
package dev.rosewood.rosestacker.stack;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import dev.rosewood.rosestacker.config.SettingKey;
import dev.rosewood.rosestacker.event.EntityStackClearEvent;
import dev.rosewood.rosestacker.event.EntityStackEvent;
import dev.rosewood.rosestacker.event.EntityUnstackEvent;
import dev.rosewood.rosestacker.event.ItemStackClearEvent;
import dev.rosewood.rosestacker.event.ItemStackEvent;
import dev.rosewood.rosestacker.event.PreDropStackedItemsEvent;
import dev.rosewood.rosestacker.hook.NPCsHook;
import dev.rosewood.rosestacker.hook.WorldGuardHook;
import dev.rosewood.rosestacker.lib.rosegarden.RosePlugin;
import dev.rosewood.rosestacker.lib.rosegarden.compatibility.CompatibilityAdapter;
import dev.rosewood.rosestacker.lib.rosegarden.scheduler.task.ScheduledTask;
import dev.rosewood.rosestacker.manager.EntityCacheManager;
import dev.rosewood.rosestacker.manager.HologramManager;
import dev.rosewood.rosestacker.manager.StackManager;
import dev.rosewood.rosestacker.manager.StackSettingManager;
import dev.rosewood.rosestacker.nms.NMSAdapter;
import dev.rosewood.rosestacker.nms.NMSHandler;
import dev.rosewood.rosestacker.nms.storage.EntityDataEntry;
import dev.rosewood.rosestacker.nms.storage.StackedEntityDataStorage;
import dev.rosewood.rosestacker.stack.Stack;
import dev.rosewood.rosestacker.stack.StackChunkData;
import dev.rosewood.rosestacker.stack.StackedBlock;
import dev.rosewood.rosestacker.stack.StackedEntity;
import dev.rosewood.rosestacker.stack.StackedItem;
import dev.rosewood.rosestacker.stack.StackedSpawner;
import dev.rosewood.rosestacker.stack.StackingLogic;
import dev.rosewood.rosestacker.stack.settings.EntityStackSettings;
import dev.rosewood.rosestacker.stack.settings.ItemStackSettings;
import dev.rosewood.rosestacker.utils.DataUtils;
import dev.rosewood.rosestacker.utils.EntityUtils;
import dev.rosewood.rosestacker.utils.ItemUtils;
import dev.rosewood.rosestacker.utils.PersistentDataUtils;
import dev.rosewood.rosestacker.utils.StackerUtils;
import dev.rosewood.rosestacker.utils.ThreadUtils;
import dev.rosewood.rosestacker.utils.VersionUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class StackingThread
implements StackingLogic,
AutoCloseable {
    private static final String NEW_METADATA = "RS_new";
    private static final Cache<UUID, Boolean> REMOVED_ENTITIES = CacheBuilder.newBuilder().expireAfterWrite(5L, TimeUnit.SECONDS).build();
    private final RosePlugin rosePlugin;
    private final StackManager stackManager;
    private final EntityCacheManager entityCacheManager;
    private final HologramManager hologramManager;
    private final World targetWorld;
    private final boolean disabled;
    private ScheduledTask entityStackTask;
    private ScheduledTask itemStackTask;
    private ScheduledTask nametagTask;
    private ScheduledTask hologramTask;
    private ScheduledTask entityUnstackTask;
    private ScheduledTask entityCleanupTask;
    private final Map<UUID, StackedEntity> stackedEntities;
    private final Map<UUID, StackedItem> stackedItems;
    private final Map<Chunk, StackChunkData> stackChunkData;
    private final boolean dynamicEntityTags;
    private final boolean dynamicItemTags;
    private final double entityDynamicViewRangeSqrd;
    private final double itemDynamicViewRangeSqrd;
    private final boolean entityDynamicWallDetection;
    private final boolean itemDynamicWallDetection;

    public StackingThread(RosePlugin rosePlugin, StackManager stackManager, World targetWorld) {
        this.rosePlugin = rosePlugin;
        this.stackManager = stackManager;
        this.entityCacheManager = this.rosePlugin.getManager(EntityCacheManager.class);
        this.hologramManager = this.rosePlugin.getManager(HologramManager.class);
        this.targetWorld = targetWorld;
        this.disabled = this.stackManager.isWorldDisabled(targetWorld);
        if (!this.disabled) {
            long cleanupFrequency;
            this.entityStackTask = rosePlugin.getScheduler().runTaskTimerAsync(this::stackEntities, 5L, SettingKey.STACK_FREQUENCY.get());
            this.itemStackTask = rosePlugin.getScheduler().runTaskTimerAsync(this::stackItems, 5L, SettingKey.ITEM_STACK_FREQUENCY.get());
            this.nametagTask = rosePlugin.getScheduler().runTaskTimerAsync(this::processNametags, 5L, SettingKey.NAMETAG_UPDATE_FREQUENCY.get());
            this.hologramTask = rosePlugin.getScheduler().runTaskTimerAsync(this::updateHolograms, 5L, SettingKey.HOLOGRAM_UPDATE_FREQUENCY.get());
            long unstackFrequency = SettingKey.UNSTACK_FREQUENCY.get();
            if (unstackFrequency > 0L) {
                this.entityUnstackTask = rosePlugin.getScheduler().runTaskTimerAsync(this::unstackEntities, 5L, unstackFrequency);
            }
            if ((cleanupFrequency = SettingKey.ENTITY_RESCAN_FREQUENCY.get().longValue()) > 0L) {
                this.entityCleanupTask = rosePlugin.getScheduler().runTaskTimer(this::cleanupOrphanedEntities, 5L, cleanupFrequency);
            }
        }
        this.stackedEntities = new ConcurrentHashMap<UUID, StackedEntity>();
        this.stackedItems = new ConcurrentHashMap<UUID, StackedItem>();
        this.stackChunkData = new ConcurrentHashMap<Chunk, StackChunkData>();
        this.dynamicEntityTags = SettingKey.ENTITY_DISPLAY_TAGS.get() != false && SettingKey.ENTITY_DYNAMIC_TAG_VIEW_RANGE_ENABLED.get() != false;
        this.dynamicItemTags = SettingKey.ITEM_DISPLAY_TAGS.get() != false && SettingKey.ITEM_DYNAMIC_TAG_VIEW_RANGE_ENABLED.get() != false;
        double entityDynamicViewRange = SettingKey.ENTITY_DYNAMIC_TAG_VIEW_RANGE.get().intValue();
        double itemDynamicViewRange = SettingKey.ITEM_DYNAMIC_TAG_VIEW_RANGE.get().intValue();
        this.entityDynamicViewRangeSqrd = entityDynamicViewRange * entityDynamicViewRange;
        this.itemDynamicViewRangeSqrd = itemDynamicViewRange * itemDynamicViewRange;
        this.entityDynamicWallDetection = SettingKey.ENTITY_DYNAMIC_TAG_VIEW_RANGE_WALL_DETECTION_ENABLED.get();
        this.itemDynamicWallDetection = SettingKey.ITEM_DYNAMIC_TAG_VIEW_RANGE_WALL_DETECTION_ENABLED.get();
        if (this.disabled) {
            return;
        }
        NMSAdapter.getHandler().hijackRandomSource(targetWorld);
        for (Chunk chunk : this.targetWorld.getLoadedChunks()) {
            this.loadChunkEntities(Arrays.asList(chunk.getEntities()));
            this.loadChunkBlocks(chunk);
        }
        this.targetWorld.getLivingEntities().forEach(PersistentDataUtils::applyDisabledAi);
    }

    private void stackEntities() {
        boolean entityStackingEnabled = this.stackManager.isEntityStackingEnabled();
        if (!entityStackingEnabled || this.stackManager.isEntityStackingTemporarilyDisabled()) {
            return;
        }
        for (StackedEntity stackedEntity : this.stackedEntities.values()) {
            LivingEntity livingEntity = stackedEntity.getEntity();
            if (this.isRemoved((Entity)livingEntity)) {
                this.removeEntityStack(stackedEntity);
                continue;
            }
            this.tryStackEntity(stackedEntity);
        }
    }

    private void unstackEntities() {
        boolean entityStackingEnabled = this.stackManager.isEntityStackingEnabled();
        if (!entityStackingEnabled || this.stackManager.isEntityUnstackingTemporarilyDisabled()) {
            return;
        }
        for (StackedEntity stackedEntity : this.stackedEntities.values()) {
            this.tryUnstackEntity(stackedEntity);
        }
    }

    @Override
    public void tryUnstackEntity(StackedEntity stackedEntity) {
        LivingEntity entity = stackedEntity.getEntity();
        if (entity == null || stackedEntity.getStackSize() <= 1 || !entity.isValid()) {
            return;
        }
        if (!stackedEntity.shouldStayStacked()) {
            ThreadUtils.runSync(() -> {
                if (stackedEntity.getStackSize() > 1) {
                    this.splitEntityStack(stackedEntity);
                }
            });
        } else if (SettingKey.ENTITY_MIN_SPLIT_IF_LOWER.get().booleanValue() && stackedEntity.getStackSize() < stackedEntity.getStackSettings().getMinStackSize()) {
            this.splitEntireStack(stackedEntity);
        }
    }

    private void splitEntireStack(StackedEntity stackedEntity) {
        LivingEntity entity = stackedEntity.getEntity();
        NMSHandler nmsHandler = NMSAdapter.getHandler();
        StackedEntityDataStorage nbt = stackedEntity.getDataStorage();
        stackedEntity.setDataStorage(nmsHandler.createEntityDataStorage(entity, this.stackManager.getEntityDataStorageType(entity.getType())));
        ThreadUtils.runSync(() -> {
            for (EntityDataEntry entityDataEntry : nbt.getAll()) {
                entityDataEntry.createEntity(stackedEntity.getLocation(), true, entity.getType());
            }
        });
    }

    private void cleanupOrphanedEntities() {
        for (Entity entity : this.targetWorld.getEntities()) {
            Item item;
            if (this.isRemoved(entity)) continue;
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                if (entity.getType() != EntityType.ARMOR_STAND && entity.getType() != EntityType.PLAYER && !this.isEntityStacked(livingEntity)) {
                    if (this.stackManager.isAreaDisabled(entity.getLocation())) continue;
                    this.createEntityStack(livingEntity, false);
                    continue;
                }
            }
            if (entity.getType() != VersionUtils.ITEM || this.isItemStacked(item = (Item)entity) || this.stackManager.isAreaDisabled(entity.getLocation())) continue;
            this.createItemStack(item, false);
        }
    }

    private void stackItems() {
        boolean itemStackingEnabled = this.stackManager.isItemStackingEnabled();
        if (!itemStackingEnabled) {
            return;
        }
        boolean updateItemNametags = SettingKey.ITEM_DISPLAY_DESPAWN_TIMER_PLACEHOLDER.get();
        for (StackedItem stackedItem : this.stackedItems.values()) {
            Item item = stackedItem.getItem();
            if (item == null || this.isRemoved((Entity)item)) {
                this.removeItemStack(stackedItem);
                continue;
            }
            if (updateItemNametags) {
                stackedItem.updateDisplay();
            }
            this.tryStackItem(stackedItem);
        }
    }

    public void processNametags() {
        if (!this.dynamicEntityTags && !this.dynamicItemTags) {
            return;
        }
        List players = this.targetWorld.getPlayers();
        if (players.isEmpty()) {
            return;
        }
        NMSHandler nmsHandler = NMSAdapter.getHandler();
        List<LivingEntity> entities = null;
        if (this.dynamicEntityTags) {
            entities = this.stackedEntities.values().stream().map(StackedEntity::getEntity).filter(Objects::nonNull).toList();
        }
        List<Item> items = null;
        if (this.dynamicItemTags) {
            items = this.stackedItems.values().stream().map(StackedItem::getItem).toList();
        }
        for (Player player : players) {
            double distanceSqrd;
            if (!player.getWorld().equals((Object)this.targetWorld)) continue;
            ItemStack itemStack = player.getInventory().getItemInMainHand();
            boolean displayStackingToolParticles = ItemUtils.isStackingTool(itemStack);
            if (this.dynamicEntityTags) {
                for (LivingEntity entity : entities) {
                    StackedEntity stackedEntity;
                    boolean visible;
                    try {
                        distanceSqrd = player.getLocation().distanceSquared(entity.getLocation());
                    }
                    catch (Exception e) {
                        continue;
                    }
                    if (distanceSqrd > 5625.0) continue;
                    boolean bl = visible = distanceSqrd < this.entityDynamicViewRangeSqrd;
                    if (this.entityDynamicWallDetection) {
                        visible &= EntityUtils.hasLineOfSight((Entity)player, (Entity)entity, 0.75, true);
                    }
                    if ((stackedEntity = this.getStackedEntity(entity)) != null) {
                        nmsHandler.updateEntityNameTagForPlayer(player, (Entity)entity, stackedEntity.getDisplayName(), stackedEntity.isDisplayNameVisible() && visible);
                    }
                    if (!visible || !displayStackingToolParticles) continue;
                    Location location = entity.getLocation().add(0.0, entity.getEyeHeight(true) + 0.75, 0.0);
                    Particle.DustOptions dustOptions = PersistentDataUtils.isUnstackable((Entity)entity) ? StackerUtils.UNSTACKABLE_DUST_OPTIONS : StackerUtils.STACKABLE_DUST_OPTIONS;
                    player.spawnParticle(VersionUtils.DUST, location, 1, 0.0, 0.0, 0.0, 0.0, (Object)dustOptions);
                }
            }
            if (!this.dynamicItemTags) continue;
            for (Item item : items) {
                boolean visible;
                if (!item.isCustomNameVisible()) continue;
                try {
                    distanceSqrd = player.getLocation().distanceSquared(item.getLocation());
                }
                catch (Exception e) {
                    continue;
                }
                if (distanceSqrd > 5625.0) continue;
                boolean bl = visible = distanceSqrd < this.itemDynamicViewRangeSqrd;
                if (this.itemDynamicWallDetection) {
                    visible &= EntityUtils.hasLineOfSight((Entity)player, (Entity)item, 0.75, true);
                }
                nmsHandler.updateEntityNameTagVisibilityForPlayer(player, (Entity)item, visible);
            }
        }
    }

    private void updateHolograms() {
        this.stackChunkData.values().stream().flatMap(x -> x.getSpawners().values().stream()).forEach(StackedSpawner::updateDisplay);
    }

    @Override
    public void close() {
        if (this.entityStackTask != null) {
            this.entityStackTask.cancel();
        }
        if (this.itemStackTask != null) {
            this.itemStackTask.cancel();
        }
        if (this.nametagTask != null) {
            this.nametagTask.cancel();
        }
        if (this.hologramTask != null) {
            this.hologramTask.cancel();
        }
        if (this.entityUnstackTask != null) {
            this.entityUnstackTask.cancel();
        }
        if (this.entityCleanupTask != null) {
            this.entityCleanupTask.cancel();
        }
        this.saveAllData(true);
    }

    @Override
    public Map<UUID, StackedEntity> getStackedEntities() {
        return this.stackedEntities;
    }

    @Override
    public Map<UUID, StackedItem> getStackedItems() {
        return this.stackedItems;
    }

    @Override
    public Map<Block, StackedBlock> getStackedBlocks() {
        HashMap<Block, StackedBlock> stackedBlocks = new HashMap<Block, StackedBlock>();
        for (StackChunkData stackChunkData : this.stackChunkData.values()) {
            stackedBlocks.putAll(stackChunkData.getBlocks());
        }
        return stackedBlocks;
    }

    @Override
    public Map<Block, StackedSpawner> getStackedSpawners() {
        HashMap<Block, StackedSpawner> stackedSpawners = new HashMap<Block, StackedSpawner>();
        for (StackChunkData stackChunkData : this.stackChunkData.values()) {
            stackedSpawners.putAll(stackChunkData.getSpawners());
        }
        return stackedSpawners;
    }

    @Override
    public StackedEntity getStackedEntity(LivingEntity livingEntity) {
        return this.stackedEntities.get(livingEntity.getUniqueId());
    }

    @Override
    public StackedItem getStackedItem(Item item) {
        return this.stackedItems.get(item.getUniqueId());
    }

    @Override
    public StackedBlock getStackedBlock(Block block) {
        StackChunkData stackChunkData = this.stackChunkData.get(block.getChunk());
        if (stackChunkData == null) {
            return null;
        }
        return stackChunkData.getBlock(block);
    }

    @Override
    public StackedSpawner getStackedSpawner(Block block) {
        StackChunkData stackChunkData = this.stackChunkData.get(block.getChunk());
        if (stackChunkData == null) {
            return null;
        }
        return stackChunkData.getSpawner(block);
    }

    @Override
    public boolean isEntityStacked(LivingEntity livingEntity) {
        return this.getStackedEntity(livingEntity) != null;
    }

    @Override
    public boolean isItemStacked(Item item) {
        return this.getStackedItem(item) != null;
    }

    @Override
    public boolean isBlockStacked(Block block) {
        return this.getStackedBlock(block) != null;
    }

    @Override
    public boolean isSpawnerStacked(Block block) {
        return this.getStackedSpawner(block) != null;
    }

    @Override
    public void removeEntityStack(StackedEntity stackedEntity) {
        LivingEntity entity = stackedEntity.getEntity();
        if (entity != null) {
            UUID key = stackedEntity.getEntity().getUniqueId();
            this.stackedEntities.remove(key);
            this.setRemoved((Entity)entity);
        } else {
            for (Map.Entry<UUID, StackedEntity> entry : this.stackedEntities.entrySet()) {
                if (entry.getValue() != stackedEntity) continue;
                this.stackedEntities.remove(entry.getKey());
                break;
            }
        }
    }

    @Override
    public void removeItemStack(StackedItem stackedItem) {
        Item item = stackedItem.getItem();
        if (item != null) {
            UUID key = stackedItem.getItem().getUniqueId();
            this.stackedItems.remove(key);
            this.setRemoved((Entity)item);
        } else {
            for (Map.Entry<UUID, StackedItem> entry : this.stackedItems.entrySet()) {
                if (entry.getValue() != stackedItem) continue;
                this.stackedItems.remove(entry.getKey());
                break;
            }
        }
    }

    @Override
    public void removeBlockStack(StackedBlock stackedBlock) {
        Block key = stackedBlock.getBlock();
        stackedBlock.kickOutGuiViewers();
        StackChunkData stackChunkData = this.stackChunkData.get(key.getChunk());
        if (stackChunkData != null) {
            stackChunkData.removeBlock(stackedBlock);
        }
    }

    @Override
    public void removeSpawnerStack(StackedSpawner stackedSpawner) {
        Block key = stackedSpawner.getBlock();
        stackedSpawner.kickOutGuiViewers();
        StackChunkData stackChunkData = this.stackChunkData.get(key.getChunk());
        if (stackChunkData != null) {
            stackChunkData.removeSpawner(stackedSpawner);
        }
    }

    @Override
    public int removeAllEntityStacks() {
        List<StackedEntity> toRemove = this.stackedEntities.values().stream().filter(x -> x.getEntity() != null && x.getEntity().getType() != EntityType.PLAYER).filter(x -> x.getStackSize() != 1 || SettingKey.MISC_CLEARALL_REMOVE_SINGLE.get() != false).toList();
        EntityStackClearEvent entityStackClearEvent = new EntityStackClearEvent(this.targetWorld, toRemove);
        Bukkit.getPluginManager().callEvent((Event)entityStackClearEvent);
        if (entityStackClearEvent.isCancelled()) {
            return 0;
        }
        toRemove.stream().map(StackedEntity::getEntity).forEach(this::setRemoved);
        toRemove.stream().map(StackedEntity::getEntity).forEach(Entity::remove);
        this.stackedEntities.values().removeIf(toRemove::contains);
        return toRemove.size();
    }

    @Override
    public int removeAllItemStacks() {
        ArrayList<StackedItem> toRemove = new ArrayList<StackedItem>(this.stackedItems.values());
        ItemStackClearEvent itemStackClearEvent = new ItemStackClearEvent(this.targetWorld, (List<StackedItem>)toRemove);
        Bukkit.getPluginManager().callEvent((Event)itemStackClearEvent);
        if (itemStackClearEvent.isCancelled()) {
            return 0;
        }
        toRemove.stream().map(StackedItem::getItem).forEach(this::setRemoved);
        toRemove.stream().map(StackedItem::getItem).forEach(Entity::remove);
        this.stackedItems.values().removeIf(toRemove::contains);
        return toRemove.size();
    }

    @Override
    public void updateStackedEntityKey(LivingEntity oldKey, StackedEntity stackedEntity) {
        this.stackedEntities.remove(oldKey.getUniqueId());
        this.stackedEntities.put(stackedEntity.getEntity().getUniqueId(), stackedEntity);
    }

    @Override
    public StackedEntity splitEntityStack(StackedEntity stackedEntity) {
        EntityUnstackEvent entityUnstackEvent = new EntityUnstackEvent(stackedEntity, new StackedEntity(stackedEntity.getEntity()));
        Bukkit.getPluginManager().callEvent((Event)entityUnstackEvent);
        if (entityUnstackEvent.isCancelled()) {
            return null;
        }
        LivingEntity oldEntity = stackedEntity.getEntity();
        if (SettingKey.SPAWNER_DISABLE_MOB_AI_OPTIONS_REENABLE_AI_ON_SPLIT.get().booleanValue()) {
            PersistentDataUtils.reenableEntityAi(oldEntity);
        }
        StackedEntity newlySplit = stackedEntity.decreaseStackSize();
        this.stackedEntities.put(newlySplit.getEntity().getUniqueId(), newlySplit);
        this.tryStackEntity(newlySplit);
        return newlySplit;
    }

    @Override
    public StackedItem splitItemStack(StackedItem stackedItem, int newSize) {
        World world = stackedItem.getLocation().getWorld();
        if (world == null) {
            return null;
        }
        ItemStack oldItemStack = stackedItem.getItem().getItemStack();
        ItemStack newItemStack = oldItemStack.clone();
        newItemStack.setAmount(newSize);
        stackedItem.getItem().setPickupDelay(60);
        stackedItem.getItem().setTicksLived(1);
        Item newItem = world.dropItemNaturally(stackedItem.getLocation(), newItemStack);
        newItem.setPickupDelay(0);
        StackedItem newStackedItem = new StackedItem(newSize, newItem);
        this.stackedItems.put(newItem.getUniqueId(), newStackedItem);
        stackedItem.increaseStackSize(-newSize, true);
        return newStackedItem;
    }

    @Override
    public StackedEntity createEntityStack(LivingEntity livingEntity, boolean tryStack) {
        if (!this.stackManager.isEntityStackingEnabled()) {
            return null;
        }
        if (livingEntity instanceof Player || livingEntity instanceof ArmorStand || NPCsHook.isNPC(livingEntity)) {
            return null;
        }
        StackedEntity newStackedEntity = new StackedEntity(livingEntity);
        this.stackedEntities.put(livingEntity.getUniqueId(), newStackedEntity);
        if (tryStack && this.canEntityInstantStack()) {
            livingEntity.setMetadata(NEW_METADATA, (MetadataValue)new FixedMetadataValue((Plugin)this.rosePlugin, (Object)true));
            this.tryStackEntity(newStackedEntity);
            livingEntity.removeMetadata(NEW_METADATA, (Plugin)this.rosePlugin);
        }
        return newStackedEntity;
    }

    private boolean canEntityInstantStack() {
        return SettingKey.ENTITY_INSTANT_STACK.get() != false && (!NPCsHook.mythicMobsEnabled() || SettingKey.MISC_MYTHICMOBS_ALLOW_STACKING.get() != false);
    }

    @Override
    public StackedItem createItemStack(Item item, boolean tryStack) {
        if (!this.stackManager.isItemStackingEnabled()) {
            return null;
        }
        ItemStackSettings itemStackSettings = this.rosePlugin.getManager(StackSettingManager.class).getItemStackSettings(item);
        if (itemStackSettings != null && !itemStackSettings.isStackingEnabled()) {
            return null;
        }
        StackedItem newStackedItem = new StackedItem(item.getItemStack().getAmount(), item, false);
        this.stackedItems.put(item.getUniqueId(), newStackedItem);
        if (tryStack && SettingKey.ITEM_INSTANT_STACK.get().booleanValue()) {
            item.setMetadata(NEW_METADATA, (MetadataValue)new FixedMetadataValue((Plugin)this.rosePlugin, (Object)true));
            this.tryStackItem(newStackedItem);
            item.removeMetadata(NEW_METADATA, (Plugin)this.rosePlugin);
        }
        if (newStackedItem.getStackSize() > 0) {
            newStackedItem.updateDisplay();
        }
        return newStackedItem;
    }

    @Override
    public StackedBlock createBlockStack(Block block, int amount) {
        if (!this.stackManager.isBlockStackingEnabled() || !this.stackManager.isBlockTypeStackable(block)) {
            return null;
        }
        StackChunkData stackChunkData = this.stackChunkData.computeIfAbsent(block.getChunk(), x -> new StackChunkData());
        StackedBlock newStackedBlock = new StackedBlock(amount, block);
        stackChunkData.addBlock(newStackedBlock);
        return newStackedBlock;
    }

    @Override
    public StackedSpawner createSpawnerStack(Block block, int amount, boolean placedByPlayer) {
        if (block.getType() != Material.SPAWNER) {
            return null;
        }
        CreatureSpawner creatureSpawner = (CreatureSpawner)block.getState();
        EntityType spawnedType = CompatibilityAdapter.getCreatureSpawnerHandler().getSpawnedType(creatureSpawner);
        if (!this.stackManager.isSpawnerStackingEnabled() || !this.stackManager.isSpawnerTypeStackable(spawnedType)) {
            return null;
        }
        StackChunkData stackChunkData = this.stackChunkData.computeIfAbsent(block.getChunk(), x -> new StackChunkData());
        StackedSpawner newStackedSpawner = new StackedSpawner(amount, block, placedByPlayer);
        stackChunkData.addSpawner(newStackedSpawner);
        return newStackedSpawner;
    }

    @Override
    public void addEntityStack(StackedEntity stackedEntity) {
        if (!this.stackManager.isEntityStackingEnabled() || NPCsHook.isNPC(stackedEntity.getEntity())) {
            return;
        }
        this.stackedEntities.put(stackedEntity.getEntity().getUniqueId(), stackedEntity);
        if (this.canEntityInstantStack()) {
            this.tryStackEntity(stackedEntity);
        }
    }

    @Override
    public void addItemStack(StackedItem stackedItem) {
        if (!this.stackManager.isItemStackingEnabled()) {
            return;
        }
        this.stackedItems.put(stackedItem.getItem().getUniqueId(), stackedItem);
        this.tryStackItem(stackedItem);
    }

    @Override
    public void preStackEntities(EntityType entityType, int amount, Location location, CreatureSpawnEvent.SpawnReason spawnReason) {
        World world = location.getWorld();
        if (world == null) {
            return;
        }
        ThreadUtils.runAsync(() -> {
            EntityStackSettings stackSettings = this.rosePlugin.getManager(StackSettingManager.class).getEntityStackSettings(entityType);
            NMSHandler nmsHandler = NMSAdapter.getHandler();
            boolean removeAi = stackSettings.isMobAIDisabled();
            Collection<Entity> nearbyEntities = this.entityCacheManager.getNearbyEntities(location, stackSettings.getMergeRadius(), x -> x.getType() == entityType);
            HashSet<StackedEntity> nearbyStackedEntities = new HashSet<StackedEntity>();
            for (Entity entity : nearbyEntities) {
                StackedEntity stackedEntity = this.stackManager.getStackedEntity((LivingEntity)entity);
                if (stackedEntity == null) continue;
                nearbyStackedEntities.add(stackedEntity);
            }
            HashSet<StackedEntity> updatedEntities = new HashSet<StackedEntity>();
            HashSet<StackedEntity> newStackedEntities = new HashSet<StackedEntity>();
            switch (this.stackManager.getEntityDataStorageType(entityType)) {
                case NBT: {
                    for (int i = 0; i < amount; ++i) {
                        StackedEntity newStack = this.createNewEntity(nmsHandler, entityType, location, spawnReason, removeAi);
                        Optional<StackedEntity> matchingEntity = nearbyStackedEntities.stream().filter(x -> stackSettings.testCanStackWith((StackedEntity)x, newStack, false, true)).findFirst();
                        if (matchingEntity.isPresent()) {
                            matchingEntity.get().increaseStackSize(newStack.getEntity(), false);
                            updatedEntities.add(matchingEntity.get());
                            continue;
                        }
                        nearbyStackedEntities.add(newStack);
                        newStackedEntities.add(newStack);
                    }
                    break;
                }
                case SIMPLE: {
                    for (int i = amount; i > 0; --i) {
                        Optional<StackedEntity> matchingEntity = nearbyStackedEntities.stream().filter(x -> stackSettings.testCanStackWith((StackedEntity)x, (StackedEntity)x, false, true)).findFirst();
                        if (matchingEntity.isPresent()) {
                            int amountToIncrease = Math.min(i, stackSettings.getMaxStackSize() - matchingEntity.get().getStackSize());
                            matchingEntity.get().increaseStackSize(amountToIncrease, false);
                            updatedEntities.add(matchingEntity.get());
                            i -= amountToIncrease;
                            continue;
                        }
                        StackedEntity newStack = this.createNewEntity(nmsHandler, entityType, location, spawnReason, removeAi);
                        nearbyStackedEntities.add(newStack);
                        newStackedEntities.add(newStack);
                    }
                    break;
                }
            }
            updatedEntities.forEach(StackedEntity::updateDisplay);
            ThreadUtils.runSync(() -> {
                this.stackManager.setEntityStackingTemporarilyDisabled(true);
                for (StackedEntity stackedEntity : newStackedEntities) {
                    LivingEntity entity = stackedEntity.getEntity();
                    this.entityCacheManager.preCacheEntity((Entity)entity);
                    nmsHandler.spawnExistingEntity(stackedEntity.getEntity(), spawnReason, SettingKey.SPAWNER_BYPASS_REGION_SPAWNING_RULES.get());
                    if (removeAi) {
                        PersistentDataUtils.removeEntityAi(entity);
                    }
                    entity.setVelocity(Vector.getRandom().multiply(0.01));
                    this.addEntityStack(stackedEntity);
                    stackedEntity.updateDisplay();
                }
                this.stackManager.setEntityStackingTemporarilyDisabled(false);
            });
        });
    }

    private StackedEntity createNewEntity(NMSHandler nmsHandler, EntityType entityType, Location location, CreatureSpawnEvent.SpawnReason spawnReason, boolean removeAi) {
        LivingEntity entity = nmsHandler.createNewEntityUnspawned(entityType, location, spawnReason);
        if (removeAi) {
            PersistentDataUtils.removeEntityAi(entity);
        }
        return new StackedEntity(entity);
    }

    @Override
    public void preStackEntities(EntityType entityType, int amount, Location location) {
        this.preStackEntities(entityType, amount, location, CreatureSpawnEvent.SpawnReason.CUSTOM);
    }

    @Override
    public void preStackItems(Collection<ItemStack> items, Location location, boolean dropNaturally) {
        if (location.getWorld() == null) {
            return;
        }
        Map<ItemStack, Integer> itemStackAmounts = ItemUtils.reduceItemsByCounts(items);
        PreDropStackedItemsEvent event = new PreDropStackedItemsEvent(itemStackAmounts, location);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        if (itemStackAmounts.isEmpty()) {
            return;
        }
        if (!this.stackManager.isItemStackingEnabled()) {
            for (Map.Entry<ItemStack, Integer> entry : itemStackAmounts.entrySet()) {
                int stackSize;
                ItemStack itemStack = entry.getKey();
                for (int amount = entry.getValue().intValue(); amount > 0; amount -= stackSize) {
                    int maxStackSize = itemStack.getMaxStackSize();
                    stackSize = Math.min(amount, maxStackSize);
                    ItemStack toDrop = itemStack.clone();
                    toDrop.setAmount(stackSize);
                    if (dropNaturally) {
                        location.getWorld().dropItemNaturally(location, toDrop);
                        continue;
                    }
                    location.getWorld().dropItem(location, toDrop);
                }
            }
            return;
        }
        this.stackManager.setEntityStackingTemporarilyDisabled(true);
        for (Map.Entry<ItemStack, Integer> entry : itemStackAmounts.entrySet()) {
            if (entry.getValue() <= 0) continue;
            Item item = dropNaturally ? location.getWorld().dropItemNaturally(location, entry.getKey()) : location.getWorld().dropItem(location, entry.getKey());
            StackedItem stackedItem = new StackedItem(entry.getValue(), item);
            this.addItemStack(stackedItem);
            stackedItem.updateDisplay();
        }
        this.stackManager.setEntityStackingTemporarilyDisabled(false);
    }

    @Override
    public StackedItem dropItemStack(ItemStack itemStack, int amount, Location location, boolean dropNaturally) {
        if (location.getWorld() == null) {
            return null;
        }
        if (!this.stackManager.isItemStackingEnabled()) {
            ItemStack clone = itemStack.clone();
            clone.setAmount(amount);
            this.preStackItems(List.of(clone), location, dropNaturally);
            return null;
        }
        this.stackManager.setEntityStackingTemporarilyDisabled(true);
        Item item = dropNaturally ? location.getWorld().dropItemNaturally(location, itemStack) : location.getWorld().dropItem(location, itemStack);
        StackedItem stackedItem = this.createItemStack(item, false);
        if (stackedItem != null) {
            stackedItem.setStackSize(amount);
        }
        this.stackManager.setEntityStackingTemporarilyDisabled(false);
        return stackedItem;
    }

    @Override
    public void loadChunkBlocks(Chunk chunk) {
        if (!chunk.isLoaded()) {
            return;
        }
        ConcurrentHashMap<Block, StackedSpawner> stackedSpawners = new ConcurrentHashMap<Block, StackedSpawner>();
        if (this.stackManager.isSpawnerStackingEnabled()) {
            for (StackedSpawner stackedSpawner : DataUtils.readStackedSpawners(chunk)) {
                stackedSpawners.put(stackedSpawner.getBlock(), stackedSpawner);
            }
        }
        ConcurrentHashMap<Block, StackedBlock> stackedBlocks = new ConcurrentHashMap<Block, StackedBlock>();
        if (this.stackManager.isBlockStackingEnabled()) {
            for (StackedBlock stackedBlock : DataUtils.readStackedBlocks(chunk)) {
                stackedBlocks.put(stackedBlock.getBlock(), stackedBlock);
            }
        }
        if (!stackedSpawners.isEmpty() || !stackedBlocks.isEmpty()) {
            this.stackChunkData.put(chunk, new StackChunkData(stackedSpawners, stackedBlocks));
            ThreadUtils.runAsync(() -> {
                stackedSpawners.values().forEach(StackedSpawner::updateDisplay);
                stackedBlocks.values().forEach(StackedBlock::updateDisplay);
            });
        }
    }

    @Override
    public void loadChunkEntities(List<Entity> entities) {
        if (entities.isEmpty()) {
            return;
        }
        ArrayList<StackedEntity> stackedEntities = new ArrayList<StackedEntity>();
        if (this.stackManager.isEntityStackingEnabled()) {
            for (Entity entity : entities) {
                if (!(entity instanceof LivingEntity)) continue;
                LivingEntity livingEntity = (LivingEntity)entity;
                if (entity.getType() == EntityType.ARMOR_STAND || entity.getType() == EntityType.PLAYER) continue;
                StackedEntity stackedEntity = DataUtils.readStackedEntity(livingEntity, this.stackManager.getEntityDataStorageType(entity.getType()));
                if (stackedEntity != null) {
                    this.stackedEntities.put(stackedEntity.getEntity().getUniqueId(), stackedEntity);
                    stackedEntities.add(stackedEntity);
                    continue;
                }
                this.createEntityStack(livingEntity, true);
            }
        }
        ArrayList<StackedItem> stackedItems = new ArrayList<StackedItem>();
        if (this.stackManager.isItemStackingEnabled()) {
            for (Entity entity : entities) {
                if (entity.getType() != VersionUtils.ITEM) continue;
                Item item = (Item)entity;
                StackedItem stackedItem = DataUtils.readStackedItem(item);
                if (stackedItem != null) {
                    this.stackedItems.put(stackedItem.getItem().getUniqueId(), stackedItem);
                    stackedItems.add(stackedItem);
                    continue;
                }
                this.createItemStack(item, true);
            }
        }
        if (!stackedEntities.isEmpty() || !stackedItems.isEmpty()) {
            ThreadUtils.runAsync(() -> {
                stackedEntities.forEach(StackedEntity::updateDisplay);
                stackedItems.forEach(StackedItem::updateDisplay);
            });
        }
    }

    @Override
    public void saveChunkBlocks(Chunk chunk, boolean clearStored) {
        StackChunkData stackChunkData = this.stackChunkData.get(chunk);
        if (stackChunkData == null) {
            return;
        }
        if (this.stackManager.isSpawnerStackingEnabled()) {
            DataUtils.writeStackedSpawners(stackChunkData.getSpawners().values(), chunk);
            if (clearStored) {
                stackChunkData.getSpawners().values().stream().map(StackedSpawner::getHologramLocation).forEach(this.hologramManager::deleteHologram);
            }
        }
        if (this.stackManager.isBlockStackingEnabled()) {
            DataUtils.writeStackedBlocks(stackChunkData.getBlocks().values(), chunk);
            if (clearStored) {
                stackChunkData.getBlocks().values().stream().map(StackedBlock::getHologramLocation).forEach(this.hologramManager::deleteHologram);
            }
        }
        if (clearStored) {
            this.stackChunkData.remove(chunk);
        }
    }

    @Override
    public void saveChunkEntities(List<Entity> entities, boolean clearStored) {
        ArrayList<Stack> stacks = new ArrayList<Stack>(entities.size());
        if (this.stackManager.isEntityStackingEnabled()) {
            stacks.addAll(entities.stream().filter(x -> x instanceof LivingEntity && x.getType() != EntityType.ARMOR_STAND && x.getType() != EntityType.PLAYER).map(x -> this.stackedEntities.get(x.getUniqueId())).filter(Objects::nonNull).toList());
        }
        if (this.stackManager.isItemStackingEnabled()) {
            stacks.addAll(entities.stream().filter(x -> x.getType() == VersionUtils.ITEM).map(x -> this.stackedItems.get(x.getUniqueId())).filter(Objects::nonNull).toList());
        }
        this.saveChunkEntityStacks(stacks, clearStored);
    }

    @Override
    public <T extends Stack<?>> void saveChunkEntityStacks(List<T> stacks, boolean clearStored) {
        if (this.stackManager.isEntityStackingEnabled()) {
            List<StackedEntity> stackedEntities = stacks.stream().filter(x -> x instanceof StackedEntity).map(x -> (StackedEntity)x).toList();
            stackedEntities.forEach(DataUtils::writeStackedEntity);
            if (clearStored) {
                stackedEntities.stream().map(StackedEntity::getEntity).map(Entity::getUniqueId).forEach(this.stackedEntities::remove);
            }
        }
        if (this.stackManager.isItemStackingEnabled()) {
            List<StackedItem> stackedItems = stacks.stream().filter(x -> x instanceof StackedItem).map(x -> (StackedItem)x).toList();
            stackedItems.forEach(DataUtils::writeStackedItem);
            if (clearStored) {
                stackedItems.stream().map(StackedItem::getItem).map(Entity::getUniqueId).forEach(this.stackedItems::remove);
            }
        }
    }

    @Override
    public void saveAllData(boolean clearStored) {
        for (Chunk chunk : this.stackChunkData.keySet()) {
            this.saveChunkBlocks(chunk, false);
        }
        ArrayList<Stack> stacks = new ArrayList<Stack>(this.stackedEntities.size() + this.stackedItems.size());
        stacks.addAll(this.stackedEntities.values());
        stacks.addAll(this.stackedItems.values());
        this.saveChunkEntityStacks(stacks, false);
        if (clearStored) {
            this.stackChunkData.clear();
            this.stackedEntities.clear();
            this.stackedItems.clear();
        }
    }

    @Override
    public void tryStackEntity(StackedEntity stackedEntity) {
        int totalSize;
        StackedEntity increased;
        if (this.disabled) {
            return;
        }
        EntityStackSettings stackSettings = stackedEntity.getStackSettings();
        if (stackSettings == null) {
            return;
        }
        if (stackedEntity.checkNPC()) {
            return;
        }
        LivingEntity entity = stackedEntity.getEntity();
        if (this.isRemoved((Entity)entity) || !stackedEntity.hasMoved()) {
            return;
        }
        if (!WorldGuardHook.testLocation(entity.getLocation())) {
            return;
        }
        Predicate<Entity> predicate = x -> x.getType() == entity.getType();
        Collection<Entity> nearbyEntities = SettingKey.ENTITY_MERGE_ENTIRE_CHUNK.get() == false ? this.entityCacheManager.getNearbyEntities(entity.getLocation(), stackSettings.getMergeRadius(), predicate) : this.entityCacheManager.getEntitiesInChunk(entity.getLocation(), predicate);
        HashSet<StackedEntity> targetEntities = new HashSet<StackedEntity>();
        targetEntities.add(stackedEntity);
        for (Entity otherEntity : nearbyEntities) {
            StackedEntity other;
            if (entity == otherEntity || this.isRemoved(otherEntity) || (other = this.stackedEntities.get(otherEntity.getUniqueId())) == null || !stackSettings.testCanStackWith(stackedEntity, other, false) || SettingKey.ENTITY_REQUIRE_LINE_OF_SIGHT.get().booleanValue() && !EntityUtils.hasLineOfSight((Entity)entity, otherEntity, 0.75, false) || !WorldGuardHook.testLocation(otherEntity.getLocation())) continue;
            targetEntities.add(other);
        }
        ArrayList<StackedEntity> removable = new ArrayList<StackedEntity>(targetEntities.size());
        if (!SettingKey.ENTITY_MIN_STACK_COUNT_ONLY_INDIVIDUALS.get().booleanValue()) {
            increased = targetEntities.stream().max(StackedEntity::compareTo).orElse(stackedEntity);
            targetEntities.remove(increased);
            totalSize = increased.getStackSize();
            for (StackedEntity target : targetEntities) {
                if (totalSize + target.getStackSize() > stackSettings.getMaxStackSize()) continue;
                totalSize += target.getStackSize();
                removable.add(target);
            }
        } else {
            increased = stackedEntity;
            targetEntities.remove(increased);
            totalSize = 1;
            int totalStackSize = increased.getStackSize();
            for (StackedEntity target : targetEntities) {
                if (totalStackSize + target.getStackSize() > stackSettings.getMaxStackSize()) continue;
                ++totalSize;
                totalStackSize += target.getStackSize();
                removable.add(target);
            }
        }
        if (removable.isEmpty() || totalSize < stackSettings.getMinStackSize()) {
            return;
        }
        EntityStackEvent entityStackEvent = new EntityStackEvent(removable, increased);
        Bukkit.getPluginManager().callEvent((Event)entityStackEvent);
        if (entityStackEvent.isCancelled()) {
            return;
        }
        for (StackedEntity toStack : removable) {
            stackSettings.applyStackProperties(toStack.getEntity(), increased.getEntity());
            increased.increaseStackSize(toStack.getEntity());
            increased.increaseStackSize(toStack.getDataStorage());
            this.removeEntityStack(toStack);
        }
        ThreadUtils.runOnPrimary(() -> removable.stream().map(StackedEntity::getEntity).forEach(Entity::remove));
    }

    @Override
    public void tryStackItem(StackedItem stackedItem) {
        if (this.disabled) {
            return;
        }
        ItemStackSettings stackSettings = stackedItem.getStackSettings();
        Item item = stackedItem.getItem();
        if (stackSettings == null || !stackSettings.isStackingEnabled() || item.getPickupDelay() > 40 || !stackedItem.hasMoved() || PersistentDataUtils.isUnstackable((Entity)item)) {
            return;
        }
        if (this.isRemoved((Entity)item)) {
            return;
        }
        Predicate<Entity> predicate = x -> x.getType() == VersionUtils.ITEM;
        Set nearbyItems = this.entityCacheManager.getNearbyEntities(stackedItem.getLocation(), SettingKey.ITEM_MERGE_RADIUS.get(), predicate).stream().map(x -> (Item)x).collect(Collectors.toSet());
        HashSet<Object> targetItems = new HashSet<Object>();
        for (Item otherItem : nearbyItems) {
            Object other;
            if (item == otherItem || otherItem.getPickupDelay() > 40 || !item.getItemStack().isSimilar(otherItem.getItemStack()) || !Objects.equals(item.getOwner(), otherItem.getOwner()) || PersistentDataUtils.isUnstackable((Entity)otherItem) || this.isRemoved((Entity)otherItem) || (other = this.stackedItems.get(otherItem.getUniqueId())) == null) continue;
            targetItems.add(other);
        }
        if (targetItems.isEmpty()) {
            return;
        }
        int totalSize = stackedItem.getStackSize();
        HashSet<StackedItem> removable = new HashSet<StackedItem>();
        for (StackedItem stackedItem2 : targetItems) {
            if (totalSize + stackedItem2.getStackSize() > stackSettings.getMaxStackSize()) continue;
            totalSize += stackedItem2.getStackSize();
            removable.add(stackedItem2);
        }
        StackedItem headStack = stackedItem;
        for (StackedItem other : removable) {
            StackedItem increased = headStack.compareTo(other) > 0 ? headStack : other;
            StackedItem removed = increased == headStack ? other : headStack;
            headStack = increased;
            ItemStackEvent itemStackEvent = new ItemStackEvent(removed, increased);
            Bukkit.getPluginManager().callEvent((Event)itemStackEvent);
            if (itemStackEvent.isCancelled()) continue;
            increased.increaseStackSize(removed.getStackSize(), false);
            removed.increaseStackSize(-removed.getStackSize(), false);
            if (SettingKey.ITEM_RESET_DESPAWN_TIMER_ON_MERGE.get().booleanValue()) {
                increased.getItem().setTicksLived(1);
            }
            increased.getItem().setPickupDelay(Math.max(increased.getItem().getPickupDelay(), removed.getItem().getPickupDelay()));
            removed.getItem().setPickupDelay(100);
            ThreadUtils.runOnPrimary(() -> removed.getItem().remove());
            this.removeItemStack(removed);
        }
        headStack.updateDisplay();
    }

    public void transferExistingEntityStack(UUID entityUUID, StackedEntity stackedEntity, StackingThread toThread) {
        this.stackedEntities.remove(entityUUID);
        toThread.loadExistingEntityStack(entityUUID, stackedEntity);
    }

    public void transferExistingItemStack(UUID entityUUID, StackedItem stackedItem, StackingThread toThread) {
        this.stackedItems.remove(entityUUID);
        toThread.loadExistingItemStack(entityUUID, stackedItem);
    }

    private void loadExistingEntityStack(UUID entityUUID, StackedEntity stackedEntity) {
        stackedEntity.updateEntity();
        this.stackedEntities.put(entityUUID, stackedEntity);
    }

    private void loadExistingItemStack(UUID entityUUID, StackedItem stackedItem) {
        stackedItem.updateItem();
        this.stackedItems.put(entityUUID, stackedItem);
    }

    private boolean isRemoved(Entity entity) {
        return entity == null || !entity.hasMetadata(NEW_METADATA) && !entity.isValid() || REMOVED_ENTITIES.getIfPresent((Object)entity.getUniqueId()) != null;
    }

    private void setRemoved(Entity entity) {
        REMOVED_ENTITIES.put((Object)entity.getUniqueId(), (Object)true);
    }

    public World getTargetWorld() {
        return this.targetWorld;
    }
}

