/*
 * Decompiled with CFR 0.152.
 */
package dev.rosewood.rosestacker.stack.settings.conditions.entity;

import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import dev.rosewood.rosestacker.config.SettingKey;
import dev.rosewood.rosestacker.lib.rosegarden.compatibility.CompatibilityAdapter;
import dev.rosewood.rosestacker.lib.rosegarden.compatibility.handler.OldEnumHandler;
import dev.rosewood.rosestacker.lib.rosegarden.compatibility.handler.ShearedHandler;
import dev.rosewood.rosestacker.lib.rosegarden.compatibility.wrapper.WrappedKeyed;
import dev.rosewood.rosestacker.lib.rosegarden.utils.NMSUtil;
import dev.rosewood.rosestacker.nms.NMSAdapter;
import dev.rosewood.rosestacker.nms.NMSHandler;
import dev.rosewood.rosestacker.stack.EntityStackComparisonResult;
import dev.rosewood.rosestacker.stack.StackedEntity;
import dev.rosewood.rosestacker.stack.settings.EntityStackSettings;
import dev.rosewood.rosestacker.utils.PersistentDataUtils;
import dev.rosewood.rosestacker.utils.VersionUtils;
import java.util.List;
import java.util.Objects;
import org.bukkit.Material;
import org.bukkit.entity.AbstractHorse;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.Allay;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Axolotl;
import org.bukkit.entity.Bat;
import org.bukkit.entity.Bee;
import org.bukkit.entity.Bogged;
import org.bukkit.entity.Camel;
import org.bukkit.entity.Cat;
import org.bukkit.entity.ChestedHorse;
import org.bukkit.entity.Chicken;
import org.bukkit.entity.CopperGolem;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Fox;
import org.bukkit.entity.Frog;
import org.bukkit.entity.GlowSquid;
import org.bukkit.entity.Goat;
import org.bukkit.entity.Hoglin;
import org.bukkit.entity.Horse;
import org.bukkit.entity.IronGolem;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Llama;
import org.bukkit.entity.MushroomCow;
import org.bukkit.entity.Panda;
import org.bukkit.entity.Parrot;
import org.bukkit.entity.Phantom;
import org.bukkit.entity.Pig;
import org.bukkit.entity.PigZombie;
import org.bukkit.entity.Piglin;
import org.bukkit.entity.PiglinAbstract;
import org.bukkit.entity.PufferFish;
import org.bukkit.entity.Rabbit;
import org.bukkit.entity.Raider;
import org.bukkit.entity.Salmon;
import org.bukkit.entity.Sheep;
import org.bukkit.entity.Sittable;
import org.bukkit.entity.Slime;
import org.bukkit.entity.Snowman;
import org.bukkit.entity.Strider;
import org.bukkit.entity.Tameable;
import org.bukkit.entity.TropicalFish;
import org.bukkit.entity.Turtle;
import org.bukkit.entity.Vex;
import org.bukkit.entity.Villager;
import org.bukkit.entity.Wolf;
import org.bukkit.entity.Zombie;
import org.bukkit.entity.ZombieVillager;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Merchant;
import org.bukkit.material.Colorable;

public final class StackConditions {
    private static final Multimap<Class<?>, StackCondition<?>> CLASS_STACK_EVALUATION_MAP;
    private static final NMSHandler NMS_HANDLER;

    private StackConditions() {
    }

    public static List<StackCondition<?>> getEligibleConditions(Class<? extends Entity> entityClass) {
        return CLASS_STACK_EVALUATION_MAP.keySet().stream().filter(x -> x.isAssignableFrom(entityClass)).flatMap(x -> CLASS_STACK_EVALUATION_MAP.get(x).stream()).toList();
    }

    public static <T> void registerConfig(Class<T> assignableClass, String key, boolean defaultEnabled, EntityStackComparisonResult failureReason, StackValidationPredicate<T> validationPredicate) {
        StackConditions.registerInternal(assignableClass, new ConfigProperties("dont-stack-if-" + key, defaultEnabled), (stackSettings, stack1, stack2, entity1, entity2, comparingForUnstack, ignorePositions) -> validationPredicate.test(entity1, entity2) ? failureReason : EntityStackComparisonResult.CAN_STACK);
    }

    public static <T> void register(Class<T> assignableClass, StackValidationFunction<T> validationFunction) {
        StackConditions.registerInternal(assignableClass, null, validationFunction);
    }

    private static <T, P extends StackValidationFunction<T>> void registerInternal(Class<T> assignableClass, ConfigProperties configProperties, P validationFunction) {
        CLASS_STACK_EVALUATION_MAP.put(assignableClass, new StackCondition<T>(assignableClass, configProperties, validationFunction));
    }

    static {
        NMS_HANDLER = NMSAdapter.getHandler();
        CLASS_STACK_EVALUATION_MAP = MultimapBuilder.linkedHashKeys().arrayListValues().build();
        ShearedHandler shearedHandler = CompatibilityAdapter.getShearedHandler();
        OldEnumHandler oldEnumHandler = CompatibilityAdapter.getOldEnumHandler();
        StackConditions.register(Entity.class, (stackSettings, stack1, stack2, entity1, entity2, comparingForUnstack, ignorePositions) -> {
            int offset;
            int n = offset = comparingForUnstack ? -1 : 0;
            if (entity1 == entity2) {
                if (stack1.getStackSize() + 1 + offset > stackSettings.getMaxStackSize()) {
                    return EntityStackComparisonResult.STACK_SIZE_TOO_LARGE;
                }
            } else {
                if (entity1.getType() != entity2.getType()) {
                    return EntityStackComparisonResult.DIFFERENT_ENTITY_TYPES;
                }
                if (stack1.getStackSize() + stack2.getStackSize() + offset > stackSettings.getMaxStackSize()) {
                    return EntityStackComparisonResult.STACK_SIZE_TOO_LARGE;
                }
            }
            if (!stackSettings.isStackingEnabled()) {
                return EntityStackComparisonResult.STACKING_NOT_ENABLED;
            }
            if (PersistentDataUtils.isUnstackable(entity1) || PersistentDataUtils.isUnstackable(entity2)) {
                return EntityStackComparisonResult.MARKED_UNSTACKABLE;
            }
            if (!(!SettingKey.ENTITY_DONT_STACK_CUSTOM_NAMED.get().booleanValue() || entity1.getCustomName() == null && entity2.getCustomName() == null || entity1.getType() == VersionUtils.SNOW_GOLEM && stackSettings.getSettingValue("force-custom-named-stacking").getBoolean())) {
                return EntityStackComparisonResult.CUSTOM_NAMED;
            }
            if (!(comparingForUnstack || ignorePositions || stackSettings.getEntityTypeData().swimmingMob() || stackSettings.getEntityTypeData().flyingMob())) {
                if (!(!SettingKey.ENTITY_ONLY_STACK_ON_GROUND.get().booleanValue() || entity1.isOnGround() && entity2.isOnGround())) {
                    return EntityStackComparisonResult.NOT_ON_GROUND;
                }
                if (SettingKey.ENTITY_DONT_STACK_IF_IN_WATER.get().booleanValue() && (entity1.getLocation().getBlock().getType() == Material.WATER || entity2.getLocation().getBlock().getType() == Material.WATER)) {
                    return EntityStackComparisonResult.IN_WATER;
                }
            }
            if (!(comparingForUnstack || !stackSettings.shouldOnlyStackFromSpawners() || PersistentDataUtils.isSpawnedFromSpawner(entity1) && PersistentDataUtils.isSpawnedFromSpawner(entity2))) {
                return EntityStackComparisonResult.NOT_SPAWNED_FROM_SPAWNER;
            }
            if (!(comparingForUnstack || entity1.getPassengers().isEmpty() && entity2.getPassengers().isEmpty() && !entity1.isInsideVehicle() && !entity2.isInsideVehicle())) {
                return EntityStackComparisonResult.PART_OF_VEHICLE;
            }
            if (SettingKey.ENTITY_DONT_STACK_IF_INVULNERABLE.get().booleanValue() && (entity1.isInvulnerable() || entity2.isInvulnerable())) {
                return EntityStackComparisonResult.INVULNERABLE;
            }
            return EntityStackComparisonResult.CAN_STACK;
        });
        StackConditions.register(LivingEntity.class, (stackSettings, stack1, stack2, entity1, entity2, comparingForUnstack, ignorePositions) -> {
            if (!comparingForUnstack && SettingKey.ENTITY_DONT_STACK_IF_LEASHED.get().booleanValue() && (entity1.isLeashed() || entity2.isLeashed())) {
                return EntityStackComparisonResult.LEASHED;
            }
            if (SettingKey.ENTITY_DONT_STACK_IF_HAS_EQUIPMENT.get().booleanValue()) {
                ItemStack item;
                EntityEquipment equipment1 = entity1.getEquipment();
                EntityEquipment equipment2 = entity2.getEquipment();
                if (equipment1 != null) {
                    for (EquipmentSlot equipmentSlot : EquipmentSlot.values()) {
                        item = equipment1.getItem(equipmentSlot);
                        if (item.getType() == Material.AIR || stackSettings.getEntityTypeData().isStandardEquipment(item)) continue;
                        return EntityStackComparisonResult.HAS_EQUIPMENT;
                    }
                }
                if (equipment2 != null) {
                    for (EquipmentSlot equipmentSlot : EquipmentSlot.values()) {
                        item = equipment2.getItem(equipmentSlot);
                        if (item.getType() == Material.AIR || stackSettings.getEntityTypeData().isStandardEquipment(item)) continue;
                        return EntityStackComparisonResult.HAS_EQUIPMENT;
                    }
                }
            }
            if (!comparingForUnstack && SettingKey.ENTITY_DONT_STACK_FROM_TRIAL_SPAWNERS.get().booleanValue() && NMSUtil.getVersionNumber() >= 21 && (PersistentDataUtils.isSpawnedFromTrialSpawner((Entity)entity1) || PersistentDataUtils.isSpawnedFromTrialSpawner((Entity)entity2))) {
                return EntityStackComparisonResult.FROM_TRIAL_SPAWNER;
            }
            if (SettingKey.ENTITY_DONT_STACK_IF_ACTIVE_RAIDER.get().booleanValue() && (NMS_HANDLER.isActiveRaider((LivingEntity)entity1) || NMS_HANDLER.isActiveRaider((LivingEntity)entity2))) {
                return EntityStackComparisonResult.PART_OF_ACTIVE_RAID;
            }
            if (stack1.checkNPC() || stack2.checkNPC()) {
                return EntityStackComparisonResult.CUSTOM_MOB;
            }
            return EntityStackComparisonResult.CAN_STACK;
        });
        StackConditions.registerConfig(LivingEntity.class, "different-custom-name", false, EntityStackComparisonResult.DIFFERENT_CUSTOM_NAME, (entity1, entity2) -> {
            if (NMSUtil.isPaper()) {
                return !Objects.equals(entity1.customName(), entity2.customName());
            }
            return !Objects.equals(entity1.getCustomName(), entity2.getCustomName());
        });
        StackConditions.registerConfig(Colorable.class, "different-color", false, EntityStackComparisonResult.DIFFERENT_COLORS, (entity1, entity2) -> entity1.getColor() != entity2.getColor());
        StackConditions.registerConfig(Sittable.class, "sitting", false, EntityStackComparisonResult.SITTING, (entity1, entity2) -> entity1.isSitting() || entity2.isSitting());
        StackConditions.registerConfig(Tameable.class, "tamed", false, EntityStackComparisonResult.TAMED, (entity1, entity2) -> entity1.isTamed() || entity2.isTamed());
        StackConditions.registerConfig(Tameable.class, "different-owners", false, EntityStackComparisonResult.DIFFERENT_OWNERS, (entity1, entity2) -> {
            AnimalTamer tamer1 = entity1.getOwner();
            AnimalTamer tamer2 = entity2.getOwner();
            return tamer1 != null && tamer2 != null && !tamer1.getUniqueId().equals(tamer2.getUniqueId());
        });
        StackConditions.registerConfig(Animals.class, "breeding", false, EntityStackComparisonResult.BREEDING, (entity1, entity2) -> {
            if (entity1.getType() == EntityType.TURTLE) {
                Turtle turtle1 = (Turtle)entity1;
                Turtle turtle2 = (Turtle)entity2;
                if (turtle1.hasEgg() || turtle1.isLayingEgg() || turtle2.hasEgg() || turtle2.isLayingEgg()) {
                    return true;
                }
            }
            return entity1.isLoveMode() || entity2.isLoveMode() || !entity1.canBreed() && entity1.isAdult() || !entity2.canBreed() && entity2.isAdult();
        });
        StackConditions.registerConfig(Ageable.class, "different-age", true, EntityStackComparisonResult.DIFFERENT_AGES, (entity1, entity2) -> entity1.isAdult() != entity2.isAdult());
        StackConditions.registerConfig(Ageable.class, "baby", false, EntityStackComparisonResult.BABY, (entity1, entity2) -> !entity1.isAdult() || !entity2.isAdult());
        StackConditions.registerConfig(AbstractHorse.class, "saddled", false, EntityStackComparisonResult.SADDLED, (entity1, entity2) -> entity1.getInventory().getSaddle() != null || entity2.getInventory().getSaddle() != null);
        StackConditions.registerConfig(ChestedHorse.class, "chested", false, EntityStackComparisonResult.HAS_CHEST, (entity1, entity2) -> entity1.isCarryingChest() || entity2.isCarryingChest());
        StackConditions.registerConfig(Raider.class, "patrol-leader", false, EntityStackComparisonResult.PATROL_LEADER, (entity1, entity2) -> entity1.isPatrolLeader() || entity2.isPatrolLeader());
        StackConditions.registerConfig(Merchant.class, "trading", false, EntityStackComparisonResult.TRADING, (entity1, entity2) -> entity1.isTrading() || entity2.isTrading());
        int versionNumber = NMSUtil.getVersionNumber();
        int minorVersionNumber = NMSUtil.getMinorVersionNumber();
        if ((versionNumber > 21 || versionNumber == 21 && minorVersionNumber >= 9) && NMSUtil.isPaper()) {
            StackConditions.registerConfig(CopperGolem.class, "different-oxidization", false, EntityStackComparisonResult.DIFFERENT_WEATHERING, (entity1, entity2) -> entity1.getWeatheringState() != entity2.getWeatheringState());
            StackConditions.registerConfig(CopperGolem.class, "different-weathering", false, EntityStackComparisonResult.DIFFERENT_OXIDIZATION, (entity1, entity2) -> entity1.getOxidizing() == CopperGolem.Oxidizing.waxed() ^ entity2.getOxidizing() == CopperGolem.Oxidizing.waxed());
        }
        if (versionNumber > 21 || versionNumber == 21 && minorVersionNumber >= 5) {
            StackConditions.registerConfig(Chicken.class, "different-types", false, EntityStackComparisonResult.DIFFERENT_TYPES, (entity1, entity2) -> entity1.getVariant() != entity2.getVariant());
            StackConditions.registerConfig(Pig.class, "different-types", false, EntityStackComparisonResult.DIFFERENT_TYPES, (entity1, entity2) -> entity1.getVariant() != entity2.getVariant());
        }
        if (versionNumber > 21 || versionNumber == 21 && minorVersionNumber >= 3) {
            StackConditions.registerConfig(Salmon.class, "different-size", true, EntityStackComparisonResult.DIFFERENT_SIZES, (entity1, entity2) -> entity1.getVariant() != entity2.getVariant());
        }
        if (versionNumber >= 21) {
            StackConditions.registerConfig(Wolf.class, "different-type", false, EntityStackComparisonResult.DIFFERENT_TYPES, (entity1, entity2) -> entity1.getVariant() != entity2.getVariant());
        }
        if (versionNumber > 20 || versionNumber == 20 && minorVersionNumber >= 5) {
            StackConditions.registerConfig(Bogged.class, "sheared", false, EntityStackComparisonResult.SHEARED, (entity1, entity2) -> shearedHandler.isSheared((LivingEntity)entity1) || shearedHandler.isSheared((LivingEntity)entity2));
        }
        if (versionNumber >= 19) {
            StackConditions.registerConfig(Allay.class, "holding-items", false, EntityStackComparisonResult.HOLDING_ITEMS, (entity1, entity2) -> !entity1.getInventory().isEmpty() || !entity2.getInventory().isEmpty());
            StackConditions.registerConfig(Frog.class, "different-type", false, EntityStackComparisonResult.DIFFERENT_TYPES, (entity1, entity2) -> entity1.getVariant() != entity2.getVariant());
            StackConditions.registerConfig(Goat.class, "different-horns", false, EntityStackComparisonResult.DIFFERENT_HORNS, (entity1, entity2) -> entity1.hasLeftHorn() != entity2.hasLeftHorn() || entity1.hasRightHorn() != entity2.hasRightHorn());
            if (NMSAdapter.getHandler().supportsEmptySpawners()) {
                StackConditions.registerConfig(Camel.class, "dashing", false, EntityStackComparisonResult.DASHING, (entity1, entity2) -> entity1.isDashing() || entity2.isDashing());
            }
        }
        if (versionNumber >= 17) {
            StackConditions.registerConfig(Axolotl.class, "different-color", false, EntityStackComparisonResult.DIFFERENT_COLORS, (entity1, entity2) -> entity1.getVariant() != entity2.getVariant());
            StackConditions.registerConfig(Axolotl.class, "playing-dead", false, EntityStackComparisonResult.PLAYING_DEAD, (entity1, entity2) -> entity1.isPlayingDead() || entity2.isPlayingDead());
            StackConditions.registerConfig(GlowSquid.class, "dark", false, EntityStackComparisonResult.BRAVO_SIX_GOING_DARK, (entity1, entity2) -> entity1.getDarkTicksRemaining() > 0 || entity2.getDarkTicksRemaining() > 0);
            StackConditions.registerConfig(Goat.class, "screaming", false, EntityStackComparisonResult.SCREAMING, (entity1, entity2) -> entity1.isScreaming() || entity2.isScreaming());
        }
        StackConditions.registerConfig(Bat.class, "sleeping", false, EntityStackComparisonResult.SLEEPING, (entity1, entity2) -> !entity1.isAwake() || !entity2.isAwake());
        StackConditions.registerConfig(Bee.class, "angry", false, EntityStackComparisonResult.ANGRY, (entity1, entity2) -> entity1.getAnger() > 0 || entity2.getAnger() > 0);
        StackConditions.registerConfig(Bee.class, "has-hive", false, EntityStackComparisonResult.HAS_HIVE, (entity1, entity2) -> entity1.getHive() != null || entity2.getHive() != null);
        StackConditions.registerConfig(Bee.class, "different-hives", false, EntityStackComparisonResult.DIFFERENT_HIVES, (entity1, entity2) -> entity1.getHive() != null && entity2.getHive() != null && !entity1.getHive().equals((Object)entity2.getHive()));
        StackConditions.registerConfig(Bee.class, "stung", false, EntityStackComparisonResult.HAS_STUNG, (entity1, entity2) -> entity1.hasStung() || entity2.hasStung());
        StackConditions.registerConfig(Bee.class, "has-flower", false, EntityStackComparisonResult.HAS_FLOWER, (entity1, entity2) -> entity1.getFlower() != null || entity2.getFlower() != null);
        StackConditions.registerConfig(Bee.class, "has-nectar", false, EntityStackComparisonResult.HAS_NECTAR, (entity1, entity2) -> entity1.hasNectar() || entity2.hasNectar());
        StackConditions.registerConfig(Cat.class, "different-type", false, EntityStackComparisonResult.DIFFERENT_TYPES, (entity1, entity2) -> entity1.getCatType() != entity2.getCatType());
        StackConditions.registerConfig(Cat.class, "different-collar-color", false, EntityStackComparisonResult.DIFFERENT_COLLAR_COLORS, (entity1, entity2) -> entity1.getCollarColor() != entity2.getCollarColor());
        StackConditions.registerConfig(Creeper.class, "charged", false, EntityStackComparisonResult.CHARGED, (entity1, entity2) -> entity1.isPowered() || entity2.isPowered());
        StackConditions.registerConfig(Enderman.class, "holding-block", false, EntityStackComparisonResult.HOLDING_BLOCK, (entity1, entity2) -> entity1.getCarriedBlock() != null || entity2.getCarriedBlock() != null);
        StackConditions.registerConfig(Fox.class, "different-type", false, EntityStackComparisonResult.DIFFERENT_TYPES, (entity1, entity2) -> entity1.getFoxType() != entity2.getFoxType());
        StackConditions.registerConfig(Hoglin.class, "unhuntable", false, EntityStackComparisonResult.UNHUNTABLE, (entity1, entity2) -> !entity1.isAbleToBeHunted() || entity2.isAbleToBeHunted());
        StackConditions.registerConfig(Horse.class, "armored", false, EntityStackComparisonResult.HAS_ARMOR, (entity1, entity2) -> entity1.getInventory().getArmor() != null || entity2.getInventory().getArmor() != null);
        StackConditions.registerConfig(Horse.class, "different-style", false, EntityStackComparisonResult.DIFFERENT_STYLES, (entity1, entity2) -> entity1.getStyle() != entity2.getStyle());
        StackConditions.registerConfig(Horse.class, "different-color", false, EntityStackComparisonResult.DIFFERENT_COLORS, (entity1, entity2) -> entity1.getColor() != entity2.getColor());
        StackConditions.registerConfig(IronGolem.class, "player-created", false, EntityStackComparisonResult.SPAWNED_BY_PLAYER, (entity1, entity2) -> entity1.isPlayerCreated() || entity2.isPlayerCreated());
        StackConditions.registerConfig(Llama.class, "different-decor", false, EntityStackComparisonResult.DIFFERENT_DECORS, (entity1, entity2) -> entity1.getInventory().getDecor() != entity2.getInventory().getDecor());
        StackConditions.registerConfig(Llama.class, "different-color", false, EntityStackComparisonResult.DIFFERENT_COLORS, (entity1, entity2) -> entity1.getColor() != entity2.getColor());
        StackConditions.registerConfig(MushroomCow.class, "different-type", false, EntityStackComparisonResult.DIFFERENT_TYPES, (entity1, entity2) -> entity1.getVariant() != entity2.getVariant());
        StackConditions.registerConfig(Panda.class, "different-main-gene", false, EntityStackComparisonResult.DIFFERENT_MAIN_GENES, (entity1, entity2) -> entity1.getMainGene() != entity2.getMainGene());
        StackConditions.registerConfig(Panda.class, "different-recessive-gene", false, EntityStackComparisonResult.DIFFERENT_RECESSIVE_GENES, (entity1, entity2) -> entity1.getHiddenGene() != entity2.getHiddenGene());
        StackConditions.registerConfig(Parrot.class, "different-type", false, EntityStackComparisonResult.DIFFERENT_TYPES, (entity1, entity2) -> entity1.getVariant() != entity2.getVariant());
        StackConditions.registerConfig(Phantom.class, "different-size", true, EntityStackComparisonResult.DIFFERENT_SIZES, (entity1, entity2) -> entity1.getSize() != entity2.getSize());
        StackConditions.registerConfig(PiglinAbstract.class, "converting", false, EntityStackComparisonResult.CONVERTING, (entity1, entity2) -> entity1.isConverting() || entity2.isConverting());
        StackConditions.registerConfig(PiglinAbstract.class, "immune-to-zombification", false, EntityStackComparisonResult.IMMUNE_TO_ZOMBIFICATION, (entity1, entity2) -> entity1.isImmuneToZombification() != entity2.isImmuneToZombification());
        StackConditions.registerConfig(Piglin.class, "unable-to-hunt", false, EntityStackComparisonResult.UNABLE_TO_HUNT, (entity1, entity2) -> !entity1.isAbleToHunt() || !entity2.isAbleToHunt());
        StackConditions.registerConfig(PigZombie.class, "angry", false, EntityStackComparisonResult.ANGRY, (entity1, entity2) -> entity1.isAngry() || entity2.isAngry());
        StackConditions.registerConfig(Pig.class, "saddled", false, EntityStackComparisonResult.SADDLED, (entity1, entity2) -> entity1.hasSaddle() || entity2.hasSaddle());
        StackConditions.registerConfig(PufferFish.class, "different-inflation", false, EntityStackComparisonResult.DIFFERENT_INFLATIONS, (entity1, entity2) -> entity1.getPuffState() != entity2.getPuffState());
        StackConditions.registerConfig(Rabbit.class, "different-type", false, EntityStackComparisonResult.DIFFERENT_TYPES, (entity1, entity2) -> entity1.getRabbitType() != entity2.getRabbitType());
        StackConditions.registerConfig(Sheep.class, "sheared", false, EntityStackComparisonResult.SHEARED, (entity1, entity2) -> shearedHandler.isSheared((LivingEntity)entity1) || shearedHandler.isSheared((LivingEntity)entity2));
        StackConditions.registerConfig(Sheep.class, "different-shear-state", false, EntityStackComparisonResult.SHEARED_STATE_DIFFERENT, (entity1, entity2) -> shearedHandler.isSheared((LivingEntity)entity1) != shearedHandler.isSheared((LivingEntity)entity2));
        StackConditions.registerConfig(Slime.class, "different-size", true, EntityStackComparisonResult.DIFFERENT_SIZES, (entity1, entity2) -> entity1.getSize() != entity2.getSize());
        StackConditions.registerConfig(Snowman.class, "no-pumpkin", false, EntityStackComparisonResult.NO_PUMPKIN, (entity1, entity2) -> entity1.isDerp() || entity2.isDerp());
        StackConditions.registerConfig(Strider.class, "shivering", false, EntityStackComparisonResult.SHIVERING, (entity1, entity2) -> entity1.isShivering() || entity2.isShivering());
        StackConditions.registerConfig(Strider.class, "saddled", false, EntityStackComparisonResult.SADDLED, (entity1, entity2) -> entity1.hasSaddle() || entity2.hasSaddle());
        StackConditions.registerConfig(TropicalFish.class, "different-body-color", false, EntityStackComparisonResult.DIFFERENT_BODY_COLORS, (entity1, entity2) -> entity1.getBodyColor() != entity2.getBodyColor());
        StackConditions.registerConfig(TropicalFish.class, "different-pattern", false, EntityStackComparisonResult.DIFFERENT_PATTERNS, (entity1, entity2) -> entity1.getPattern() != entity2.getPattern());
        StackConditions.registerConfig(TropicalFish.class, "different-pattern-color", false, EntityStackComparisonResult.DIFFERENT_PATTERN_COLORS, (entity1, entity2) -> entity1.getPatternColor() != entity2.getPatternColor());
        StackConditions.registerConfig(Vex.class, "charging", false, EntityStackComparisonResult.CHARGING, (entity1, entity2) -> entity1.isCharging() || entity2.isCharging());
        StackConditions.registerConfig(Villager.class, "professioned", false, EntityStackComparisonResult.PROFESSIONED, (entity1, entity2) -> {
            List<String> professionValues = List.of("none", "nitwit");
            WrappedKeyed profession1 = oldEnumHandler.getProfession((Villager)entity1);
            WrappedKeyed profession2 = oldEnumHandler.getProfession((Villager)entity2);
            return !professionValues.contains(profession1.getKey().getKey()) || !professionValues.contains(profession2.getKey().getKey());
        });
        StackConditions.registerConfig(Villager.class, "different-profession", false, EntityStackComparisonResult.DIFFERENT_PROFESSIONS, (entity1, entity2) -> entity1.getProfession() != entity2.getProfession());
        StackConditions.registerConfig(Villager.class, "different-type", false, EntityStackComparisonResult.DIFFERENT_TYPES, (entity1, entity2) -> entity1.getVillagerType() != entity2.getVillagerType());
        StackConditions.registerConfig(Villager.class, "different-level", false, EntityStackComparisonResult.DIFFERENT_LEVELS, (entity1, entity2) -> entity1.getVillagerLevel() != entity2.getVillagerLevel());
        StackConditions.registerConfig(Wolf.class, "angry", false, EntityStackComparisonResult.ANGRY, (entity1, entity2) -> entity1.isAngry() || entity2.isAngry());
        StackConditions.registerConfig(Wolf.class, "different-collar-color", false, EntityStackComparisonResult.DIFFERENT_COLLAR_COLORS, (entity1, entity2) -> entity1.getCollarColor() != entity2.getCollarColor());
        StackConditions.registerConfig(Zombie.class, "converting", false, EntityStackComparisonResult.CONVERTING, (entity1, entity2) -> entity1.isConverting() || entity2.isConverting());
        StackConditions.registerConfig(ZombieVillager.class, "different-profession", false, EntityStackComparisonResult.DIFFERENT_PROFESSIONS, (entity1, entity2) -> entity1.getVillagerProfession() != entity2.getVillagerProfession());
        StackConditions.registerConfig(ZombieVillager.class, "converting", false, EntityStackComparisonResult.CONVERTING, (entity1, entity2) -> entity1.isConverting() || entity2.isConverting());
    }

    public record ConfigProperties(String key, boolean defaultValue) {
    }

    @FunctionalInterface
    public static interface StackValidationPredicate<T> {
        public boolean test(T var1, T var2);
    }

    @FunctionalInterface
    public static interface StackValidationFunction<T> {
        public EntityStackComparisonResult apply(EntityStackSettings var1, StackedEntity var2, StackedEntity var3, T var4, T var5, boolean var6, boolean var7);
    }

    public record StackCondition<T>(Class<T> clazz, ConfigProperties configProperties, StackValidationFunction<T> function) {
    }
}

