/*
 * Decompiled with CFR 0.152.
 */
package dev.rosewood.rosestacker.stack.settings.conditions.spawner;

import dev.rosewood.rosestacker.lib.rosegarden.utils.StringPlaceholders;
import dev.rosewood.rosestacker.manager.LocaleManager;
import dev.rosewood.rosestacker.stack.StackedSpawner;
import dev.rosewood.rosestacker.stack.settings.conditions.spawner.ConditionTags;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.block.Block;

public abstract class ConditionTag {
    private final String tag;
    private final boolean perSpawn;

    public ConditionTag(String tag, boolean perSpawn) {
        String[] values;
        String prefix;
        if (tag == null || tag.trim().isEmpty()) {
            throw new IllegalArgumentException("Empty or null tag");
        }
        this.tag = tag;
        this.perSpawn = perSpawn;
        int index = tag.indexOf(58);
        if (index == -1) {
            prefix = tag;
            values = new String[]{};
        } else {
            String[] pieces = tag.split(":", 2);
            prefix = pieces[0];
            values = pieces[1].split(",");
            for (int i = 0; i < values.length; ++i) {
                values[i] = values[i].trim();
            }
        }
        if (!this.parseValues(values)) {
            throw new IllegalArgumentException(String.format("Invalid tag arguments for %s", prefix));
        }
    }

    public abstract boolean check(StackedSpawner var1, Block var2);

    public abstract boolean parseValues(String[] var1);

    protected abstract List<String> getInfoMessageValues(LocaleManager var1);

    public List<String> getInfoMessage(LocaleManager localeManager) {
        ArrayList<String> messages = new ArrayList<String>();
        String prefix = ConditionTags.getPrefix(this.getClass());
        List<String> values = this.getInfoMessageValues(localeManager);
        String info = localeManager.getLocaleMessage("spawner-condition-" + prefix + "-info");
        if (values.size() == 0) {
            messages.add(localeManager.getLocaleMessage("spawner-condition-info", StringPlaceholders.of("condition", info)));
        } else if (values.size() == 1) {
            StringPlaceholders placeholders = StringPlaceholders.builder("condition", info).add("value", values.get(0)).build();
            messages.add(localeManager.getLocaleMessage("spawner-condition-single", placeholders));
        } else {
            messages.add(localeManager.getLocaleMessage("spawner-condition-list", StringPlaceholders.of("condition", info)));
            for (String value : values) {
                StringPlaceholders placeholders = StringPlaceholders.builder("condition", info).add("message", value).build();
                messages.add(localeManager.getLocaleMessage("spawner-condition-list-item", placeholders));
            }
        }
        return messages;
    }

    public boolean isRequiredPerSpawn() {
        return this.perSpawn;
    }

    public String toString() {
        return this.tag;
    }
}

