/*
 * Decompiled with CFR 0.152.
 */
package dev.rosewood.rosestacker.utils;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import dev.rosewood.rosestacker.RoseStacker;
import dev.rosewood.rosestacker.config.SettingKey;
import dev.rosewood.rosestacker.lib.rosegarden.compatibility.CompatibilityAdapter;
import dev.rosewood.rosestacker.lib.rosegarden.utils.HexUtils;
import dev.rosewood.rosestacker.lib.rosegarden.utils.NMSUtil;
import dev.rosewood.rosestacker.lib.rosegarden.utils.StringPlaceholders;
import dev.rosewood.rosestacker.manager.LocaleManager;
import dev.rosewood.rosestacker.manager.StackManager;
import dev.rosewood.rosestacker.manager.StackSettingManager;
import dev.rosewood.rosestacker.nms.NMSAdapter;
import dev.rosewood.rosestacker.nms.NMSHandler;
import dev.rosewood.rosestacker.nms.spawner.SpawnerType;
import dev.rosewood.rosestacker.stack.settings.BlockStackSettings;
import dev.rosewood.rosestacker.stack.settings.EntityStackSettings;
import dev.rosewood.rosestacker.stack.settings.SpawnerStackSettings;
import dev.rosewood.rosestacker.utils.StackerUtils;
import dev.rosewood.rosestacker.utils.VersionUtils;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.DyeColor;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.BlockState;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerItemDamageEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.profile.PlayerProfile;
import org.bukkit.profile.PlayerTextures;
import org.jetbrains.annotations.ApiStatus;

public final class ItemUtils {
    private static final Map<String, ItemStack> skullCache = new HashMap<String, ItemStack>();
    private static Field field_SkullMeta_profile;
    private static ItemStack cachedStackingTool;

    public static Material getWoolMaterial(DyeColor dyeColor) {
        if (dyeColor == null) {
            return Material.WHITE_WOOL;
        }
        return Material.matchMaterial((String)(dyeColor.name() + "_WOOL"));
    }

    public static void takeItems(int amount, Player player, EquipmentSlot handType) {
        if (player.getGameMode() == GameMode.CREATIVE) {
            return;
        }
        ItemStack itemStack = handType == EquipmentSlot.HAND ? player.getInventory().getItemInMainHand() : player.getInventory().getItemInOffHand();
        int newAmount = itemStack.getAmount() - amount;
        if (newAmount <= 0) {
            if (handType == EquipmentSlot.HAND) {
                player.getInventory().setItemInMainHand(null);
            } else {
                player.getInventory().setItemInOffHand(null);
            }
        } else {
            itemStack.setAmount(newAmount);
        }
    }

    public static void dropItemsToPlayer(Player player, Collection<ItemStack> itemStacks) {
        ArrayList<ItemStack> extraItems = new ArrayList<ItemStack>();
        for (ItemStack itemStack : itemStacks) {
            extraItems.addAll(player.getInventory().addItem(new ItemStack[]{itemStack}).values());
        }
        if (!extraItems.isEmpty()) {
            RoseStacker.getInstance().getManager(StackManager.class).preStackItems(extraItems, player.getLocation());
        }
    }

    public static void damageTool(Player player) {
        ItemStack tool = player.getInventory().getItemInMainHand();
        ItemMeta itemMeta = tool.getItemMeta();
        if (itemMeta == null || itemMeta.isUnbreakable()) {
            return;
        }
        if (NMSUtil.isPaper() && (NMSUtil.getVersionNumber() > 19 || NMSUtil.getVersionNumber() == 19 && NMSUtil.getMinorVersionNumber() >= 2)) {
            player.damageItemStack(EquipmentSlot.HAND, 1);
            return;
        }
        if (!(itemMeta instanceof Damageable)) {
            return;
        }
        Damageable damageable = (Damageable)itemMeta;
        int unbreakingLevel = tool.getEnchantmentLevel(Enchantment.UNBREAKING);
        if (!ItemUtils.checkUnbreakingChance(unbreakingLevel)) {
            return;
        }
        PlayerItemDamageEvent event = new PlayerItemDamageEvent(player, tool, 1, 1);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled() || event.getDamage() == 0) {
            return;
        }
        damageable.setDamage(damageable.getDamage() + event.getDamage());
        tool.setItemMeta((ItemMeta)damageable);
        if (damageable.getDamage() >= damageable.getMaxDamage()) {
            player.getInventory().setItemInMainHand(null);
        }
    }

    private static boolean checkUnbreakingChance(int level) {
        return 1.0 / (double)(level + 1) > StackerUtils.RANDOM.nextDouble();
    }

    public static ItemStack getCustomSkull(String texture) {
        if (skullCache.containsKey(texture)) {
            return skullCache.get(texture).clone();
        }
        ItemStack skull = new ItemStack(Material.PLAYER_HEAD);
        if (texture == null || texture.isEmpty()) {
            return skull;
        }
        SkullMeta skullMeta = (SkullMeta)skull.getItemMeta();
        if (skullMeta == null) {
            return skull;
        }
        if (NMSUtil.getVersionNumber() >= 18) {
            PlayerProfile profile = Bukkit.createPlayerProfile((UUID)UUID.randomUUID());
            PlayerTextures textures = profile.getTextures();
            String decodedTextureJson = new String(Base64.getDecoder().decode(texture));
            String decodedTextureUrl = decodedTextureJson.substring(28, decodedTextureJson.length() - 4);
            try {
                textures.setSkin(new URL(decodedTextureUrl));
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            skullMeta.setOwnerProfile(profile);
        } else {
            GameProfile profile = new GameProfile(UUID.randomUUID(), "");
            profile.getProperties().put((Object)"textures", (Object)new Property("textures", texture));
            try {
                if (field_SkullMeta_profile == null) {
                    field_SkullMeta_profile = skullMeta.getClass().getDeclaredField("profile");
                    field_SkullMeta_profile.setAccessible(true);
                }
                field_SkullMeta_profile.set(skullMeta, profile);
            }
            catch (ReflectiveOperationException ex) {
                ex.printStackTrace();
            }
        }
        skull.setItemMeta((ItemMeta)skullMeta);
        skullCache.put(texture, skull);
        return skull.clone();
    }

    public static ItemStack getBlockAsStackedItemStack(Material material, int amount) {
        ItemStack itemStack = new ItemStack(material);
        if (amount == 1) {
            return itemStack;
        }
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta == null) {
            return itemStack;
        }
        BlockStackSettings stackSettings = RoseStacker.getInstance().getManager(StackSettingManager.class).getBlockStackSettings(material);
        StringPlaceholders placeholders = StringPlaceholders.builder("amount", StackerUtils.formatNumber(amount)).add("name", stackSettings.getDisplayName()).build();
        String displayString = RoseStacker.getInstance().getManager(LocaleManager.class).getLocaleMessage("block-stack-display", placeholders);
        itemMeta.setDisplayName(displayString);
        List<String> lore = RoseStacker.getInstance().getManager(LocaleManager.class).getLocaleMessages("stack-item-lore-block", placeholders);
        if (!lore.isEmpty()) {
            itemMeta.setLore(lore);
        }
        itemStack.setItemMeta(itemMeta);
        NMSHandler nmsHandler = NMSAdapter.getHandler();
        itemStack = nmsHandler.setItemStackNBT(itemStack, "StackSize", amount);
        return itemStack;
    }

    public static boolean isSpawnEgg(Material material) {
        return material.name().endsWith("_SPAWN_EGG");
    }

    @ApiStatus.Obsolete
    public static ItemStack getSpawnerAsStackedItemStack(EntityType entityType, int amount) {
        return ItemUtils.getSpawnerAsStackedItemStack(SpawnerType.of(entityType), amount);
    }

    public static ItemStack getSpawnerAsStackedItemStack(SpawnerType spawnerType, int amount) {
        NamespacedKey tooltipStyleKey;
        List<String> typeLore;
        List<String> globalLore;
        ItemStack itemStack = new ItemStack(Material.SPAWNER);
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta == null) {
            return itemStack;
        }
        StackSettingManager settingManager = RoseStacker.getInstance().getManager(StackSettingManager.class);
        String mobName = spawnerType.isEmpty() ? "Empty" : settingManager.getEntityStackSettings(spawnerType.next()).getDisplayName();
        SpawnerStackSettings stackSettings = settingManager.getSpawnerStackSettings(spawnerType);
        StringPlaceholders placeholders = StringPlaceholders.builder("amount", StackerUtils.formatNumber(amount)).add("name", stackSettings.getDisplayName()).add("entity_name", mobName).build();
        String displayString = amount == 1 ? RoseStacker.getInstance().getManager(LocaleManager.class).getLocaleMessage("spawner-stack-display-single", placeholders) : RoseStacker.getInstance().getManager(LocaleManager.class).getLocaleMessage("spawner-stack-display", placeholders);
        itemMeta.setDisplayName(displayString);
        if (SettingKey.SPAWNER_HIDE_VANILLA_ITEM_LORE.get().booleanValue()) {
            itemMeta.addItemFlags(new ItemFlag[]{VersionUtils.HIDE_ADDITIONAL_TOOLTIP});
        }
        LocaleManager localeManager = RoseStacker.getInstance().getManager(LocaleManager.class);
        if (amount == 1) {
            globalLore = localeManager.getLocaleMessages("stack-item-lore-spawner", placeholders);
            typeLore = stackSettings.getItemLoreSingular(placeholders);
        } else {
            globalLore = localeManager.getLocaleMessages("stack-item-lore-spawner-plural", placeholders);
            typeLore = stackSettings.getItemLorePlural(placeholders);
        }
        ArrayList<String> lore = new ArrayList<String>(globalLore.size() + typeLore.size());
        if (SettingKey.MISC_SPAWNER_LORE_DISPLAY_GLOBAL_LORE_FIRST.get().booleanValue()) {
            lore.addAll(globalLore);
            lore.addAll(typeLore);
        } else {
            lore.addAll(typeLore);
            lore.addAll(globalLore);
        }
        if (!lore.isEmpty()) {
            itemMeta.setLore(lore);
        }
        if ((NMSUtil.getVersionNumber() > 21 || NMSUtil.getVersionNumber() == 21 && NMSUtil.getMinorVersionNumber() >= 3) && (tooltipStyleKey = stackSettings.getTooltipStyleKey()) != null) {
            itemMeta.setTooltipStyle(tooltipStyleKey);
        }
        if (!spawnerType.isEmpty()) {
            BlockStateMeta blockStateMeta = (BlockStateMeta)itemMeta;
            CreatureSpawner creatureSpawner = (CreatureSpawner)blockStateMeta.getBlockState();
            CompatibilityAdapter.getCreatureSpawnerHandler().setSpawnedType(creatureSpawner, spawnerType.getOrThrow());
            blockStateMeta.setBlockState((BlockState)creatureSpawner);
        }
        itemStack.setItemMeta(itemMeta);
        NMSHandler nmsHandler = NMSAdapter.getHandler();
        itemStack = nmsHandler.setItemStackNBT(itemStack, "StackSize", amount);
        return itemStack;
    }

    public static ItemStack getEntityAsStackedItemStack(EntityType entityType, int amount) {
        EntityStackSettings stackSettings = RoseStacker.getInstance().getManager(StackSettingManager.class).getEntityStackSettings(entityType);
        Material spawnEggMaterial = stackSettings.getEntityTypeData().spawnEggMaterial();
        if (spawnEggMaterial == null) {
            return null;
        }
        ItemStack itemStack = new ItemStack(spawnEggMaterial);
        if (amount == 1) {
            return itemStack;
        }
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta == null) {
            return itemStack;
        }
        StringPlaceholders placeholders = StringPlaceholders.builder("amount", StackerUtils.formatNumber(amount)).add("name", stackSettings.getDisplayName()).build();
        String displayString = RoseStacker.getInstance().getManager(LocaleManager.class).getLocaleMessage("entity-stack-display-spawn-egg", placeholders);
        itemMeta.setDisplayName(displayString);
        List<String> lore = RoseStacker.getInstance().getManager(LocaleManager.class).getLocaleMessages("stack-item-lore-entity", placeholders);
        if (!lore.isEmpty()) {
            itemMeta.setLore(lore);
        }
        itemStack.setItemMeta(itemMeta);
        NMSHandler nmsHandler = NMSAdapter.getHandler();
        itemStack = nmsHandler.setItemStackNBT(itemStack, "StackSize", amount);
        return itemStack;
    }

    public static int getStackedItemStackAmount(ItemStack itemStack) {
        NMSHandler nmsHandler = NMSAdapter.getHandler();
        int stackSize = nmsHandler.getItemStackNBTInt(itemStack, "StackSize");
        return Math.max(stackSize, 1);
    }

    public static boolean hasStoredStackSize(ItemStack itemStack) {
        NMSHandler nmsHandler = NMSAdapter.getHandler();
        return nmsHandler.getItemStackNBTInt(itemStack, "StackSize") > 0;
    }

    public static EntityType getStackedItemEntityType(ItemStack itemStack) {
        EntityType entityType;
        BlockStateMeta blockStateMeta;
        if (itemStack.getType() != Material.SPAWNER) {
            return null;
        }
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta instanceof BlockStateMeta && (blockStateMeta = (BlockStateMeta)itemMeta).hasBlockState()) {
            CreatureSpawner creatureSpawner = (CreatureSpawner)blockStateMeta.getBlockState();
            return CompatibilityAdapter.getCreatureSpawnerHandler().getSpawnedType(creatureSpawner);
        }
        NMSHandler nmsHandler = NMSAdapter.getHandler();
        String entityTypeName = nmsHandler.getItemStackNBTString(itemStack, "Purpur.mob_type");
        if (entityTypeName.isEmpty()) {
            entityTypeName = nmsHandler.getItemStackNBTStringFromCompound(itemStack, "SilkSpawners", "entity");
        }
        if (entityTypeName.isEmpty()) {
            entityTypeName = nmsHandler.getItemStackNBTString(itemStack, "type").toUpperCase().replace(' ', '_');
        }
        if (entityTypeName.isEmpty()) {
            entityTypeName = nmsHandler.getItemStackNBTString(itemStack, "data");
        }
        if (entityTypeName.isEmpty()) {
            entityTypeName = nmsHandler.getItemStackNBTString(itemStack, "ms_mob");
        }
        if (!entityTypeName.isEmpty()) {
            try {
                NamespacedKey entityTypeKey = NamespacedKey.fromString((String)entityTypeName);
                for (EntityType entityType2 : EntityType.values()) {
                    if ((entityType2 == EntityType.UNKNOWN || !entityType2.getKey().equals((Object)entityTypeKey)) && !entityTypeName.equalsIgnoreCase(entityType2.name())) continue;
                    return EntityType.valueOf((String)entityTypeName);
                }
            }
            catch (Exception entityTypeKey) {
                // empty catch block
            }
        }
        if (!SettingKey.SPAWNER_ITEM_CHECK_DISPLAY_NAME.get().booleanValue()) {
            return null;
        }
        String name = ChatColor.stripColor((String)itemMeta.getDisplayName());
        if (!name.equals(itemMeta.getDisplayName()) && (entityType = ItemUtils.getEntityTypeFromName(name)) != null) {
            return entityType;
        }
        List lore = itemMeta.getLore();
        if (lore != null) {
            for (String line : lore) {
                EntityType entityType2;
                name = ChatColor.stripColor((String)line);
                if (name.equals(line) || (entityType2 = ItemUtils.getEntityTypeFromName(name)) == null) continue;
                return entityType2;
            }
        }
        return null;
    }

    private static EntityType getEntityTypeFromName(String name) {
        try {
            name = name.toUpperCase();
            int spawnerIndex = name.indexOf("SPAWNER");
            if (spawnerIndex != -1) {
                name = name.substring(0, spawnerIndex).trim();
            }
            return EntityType.valueOf((String)name.replaceAll(" ", "_"));
        }
        catch (Exception ignored) {
            return null;
        }
    }

    public static SpawnerType getStackedItemSpawnerType(ItemStack itemStack) {
        EntityType entityType = ItemUtils.getStackedItemEntityType(itemStack);
        return entityType == null ? SpawnerType.empty() : SpawnerType.of(entityType);
    }

    public static ItemStack getStackingTool() {
        if (cachedStackingTool != null) {
            return cachedStackingTool;
        }
        Material material = Material.matchMaterial((String)SettingKey.STACK_TOOL_MATERIAL.get());
        if (material == null) {
            material = Material.STICK;
            RoseStacker.getInstance().getLogger().warning("Invalid material for stacking tool in config.yml!");
        }
        String name = HexUtils.colorify(SettingKey.STACK_TOOL_NAME.get());
        List<String> lore = SettingKey.STACK_TOOL_LORE.get().stream().map(HexUtils::colorify).toList();
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return item;
        }
        meta.setDisplayName(name);
        meta.setLore(lore);
        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS, VersionUtils.HIDE_ADDITIONAL_TOOLTIP});
        meta.addEnchant(VersionUtils.INFINITY, 1, true);
        item.setItemMeta(meta);
        cachedStackingTool = item;
        return item;
    }

    public static boolean isStackingTool(ItemStack item) {
        return ItemUtils.getStackingTool().isSimilar(item);
    }

    public static List<ItemStack> getMultipliedItemStacks(Collection<ItemStack> itemStacks, double multiplier, boolean reduce) {
        ArrayList<ItemStack> unstackables = new ArrayList<ItemStack>();
        ArrayList<ItemStack> stackables = new ArrayList<ItemStack>();
        for (ItemStack itemStack : itemStacks) {
            if (itemStack.getMaxStackSize() == 1) {
                unstackables.add(itemStack);
                continue;
            }
            stackables.add(itemStack);
        }
        Map<ItemStack, Integer> counts = ItemUtils.reduceItemsByCounts(stackables).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> (int)((double)((Integer)entry.getValue()).intValue() * multiplier)));
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (Map.Entry<ItemStack, Integer> entry2 : counts.entrySet()) {
            ItemStack itemStack = entry2.getKey();
            int amount = entry2.getValue();
            if (reduce) {
                ItemStack clone = itemStack.clone();
                clone.setAmount(amount);
                items.add(clone);
                continue;
            }
            items.addAll(ItemUtils.splitItemStack(itemStack, amount));
        }
        items.addAll(unstackables);
        return items;
    }

    public static Collection<? extends ItemStack> splitItemStack(ItemStack itemStack, int amount) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        int maxStackSize = itemStack.getMaxStackSize();
        while (amount > 0) {
            ItemStack clone = itemStack.clone();
            if (amount > maxStackSize) {
                clone.setAmount(maxStackSize);
                items.add(clone);
                amount -= maxStackSize;
                continue;
            }
            clone.setAmount(amount);
            items.add(clone);
            amount = 0;
        }
        return items;
    }

    public static Map<ItemStack, Integer> reduceItemsByCounts(Collection<ItemStack> items) {
        HashMap<ItemStack, Integer> itemStackAmounts = new HashMap<ItemStack, Integer>();
        for (ItemStack itemStack : items) {
            if (itemStack == null || itemStack.getType() == Material.AIR) continue;
            Optional<Map.Entry> similar = itemStackAmounts.entrySet().stream().filter(x -> ((ItemStack)x.getKey()).isSimilar(itemStack)).findFirst();
            if (similar.isPresent()) {
                similar.get().setValue((Integer)similar.get().getValue() + itemStack.getAmount());
                continue;
            }
            ItemStack clone = itemStack.clone();
            clone.setAmount(1);
            itemStackAmounts.put(clone, itemStack.getAmount());
        }
        return itemStackAmounts;
    }

    public static void clearCache() {
        skullCache.clear();
        cachedStackingTool = null;
    }
}

