/*
 * Decompiled with CFR 0.152.
 */
package dev.rosewood.rosestacker.utils;

import dev.rosewood.rosestacker.RoseStacker;
import dev.rosewood.rosestacker.config.SettingKey;
import dev.rosewood.rosestacker.manager.StackSettingManager;
import dev.rosewood.rosestacker.nms.NMSAdapter;
import dev.rosewood.rosestacker.nms.NMSHandler;
import dev.rosewood.rosestacker.nms.spawner.StackedSpawnerTile;
import dev.rosewood.rosestacker.stack.settings.EntityStackSettings;
import dev.rosewood.rosestacker.utils.EntityUtils;
import dev.rosewood.rosestacker.utils.VersionUtils;
import java.util.ConcurrentModificationException;
import org.bukkit.NamespacedKey;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Hoglin;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.PiglinAbstract;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public final class PersistentDataUtils {
    private static final String UNSTACKABLE_METADATA_NAME = "unstackable";
    private static final String NO_AI_METADATA_NAME = "no_ai";
    private static final String SPAWNED_FROM_SPAWNER_METADATA_NAME = "spawner_spawned";
    private static final String SPAWNED_FROM_TRIAL_SPAWNER_METADATA_NAME = "trial_spawner_spawned";
    private static final String TOTAL_SPAWNS_METADATA_NAME = "total_spawns";

    public static void setUnstackable(Entity entity, boolean unstackable) {
        RoseStacker rosePlugin = RoseStacker.getInstance();
        if (unstackable) {
            entity.getPersistentDataContainer().set(new NamespacedKey((Plugin)rosePlugin, UNSTACKABLE_METADATA_NAME), PersistentDataType.INTEGER, (Object)1);
        } else {
            entity.getPersistentDataContainer().remove(new NamespacedKey((Plugin)rosePlugin, UNSTACKABLE_METADATA_NAME));
        }
    }

    public static boolean isUnstackable(Entity entity) {
        RoseStacker rosePlugin = RoseStacker.getInstance();
        return entity.getPersistentDataContainer().has(new NamespacedKey((Plugin)rosePlugin, UNSTACKABLE_METADATA_NAME), PersistentDataType.INTEGER);
    }

    public static void removeEntityAi(LivingEntity entity) {
        NamespacedKey key;
        RoseStacker rosePlugin = RoseStacker.getInstance();
        PersistentDataContainer dataContainer = entity.getPersistentDataContainer();
        if (!dataContainer.has(key = new NamespacedKey((Plugin)rosePlugin, NO_AI_METADATA_NAME), PersistentDataType.INTEGER)) {
            dataContainer.set(key, PersistentDataType.INTEGER, (Object)1);
        }
        PersistentDataUtils.applyDisabledAi(entity);
    }

    public static void reenableEntityAi(LivingEntity entity) {
        RoseStacker rosePlugin = RoseStacker.getInstance();
        PersistentDataContainer dataContainer = entity.getPersistentDataContainer();
        NamespacedKey key = new NamespacedKey((Plugin)rosePlugin, NO_AI_METADATA_NAME);
        dataContainer.remove(key);
        PersistentDataUtils.applyDisabledAi(entity, false);
    }

    public static void applyDisabledAi(LivingEntity entity) {
        PersistentDataUtils.applyDisabledAi(entity, true);
    }

    public static void applyDisabledAi(LivingEntity entity, boolean disable) {
        if (PersistentDataUtils.isAiDisabled(entity) || !disable) {
            AttributeInstance knockbackAttribute;
            if (SettingKey.SPAWNER_DISABLE_MOB_AI_OPTIONS_REMOVE_GOALS.get().booleanValue() && disable) {
                NMSHandler nmsHandler = NMSAdapter.getHandler();
                nmsHandler.removeEntityGoals(entity);
            }
            if (SettingKey.SPAWNER_DISABLE_MOB_AI_OPTIONS_DISABLE_ITEM_PICKUP.get().booleanValue()) {
                entity.setCanPickupItems(!disable);
            }
            if (SettingKey.SPAWNER_DISABLE_MOB_AI_OPTIONS_SET_UNAWARE.get().booleanValue() && entity instanceof Mob) {
                Mob mob = (Mob)entity;
                mob.setAware(!disable);
            }
            if (SettingKey.SPAWNER_DISABLE_MOB_AI_OPTIONS_SILENCE.get().booleanValue()) {
                entity.setSilent(disable);
            }
            if (SettingKey.SPAWNER_DISABLE_MOB_AI_OPTIONS_NO_KNOCKBACK.get().booleanValue() && (knockbackAttribute = entity.getAttribute(VersionUtils.KNOCKBACK_RESISTANCE)) != null) {
                knockbackAttribute.setBaseValue(disable ? Double.MAX_VALUE : 0.0);
            }
            if (SettingKey.SPAWNER_DISABLE_MOB_AI_OPTIONS_DISABLE_ZOMBIFICATION.get().booleanValue()) {
                if (entity instanceof PiglinAbstract) {
                    PiglinAbstract piglin = (PiglinAbstract)entity;
                    piglin.setImmuneToZombification(disable);
                } else if (entity instanceof Hoglin) {
                    Hoglin hoglin = (Hoglin)entity;
                    hoglin.setImmuneToZombification(disable);
                }
            }
            if (SettingKey.SPAWNER_DISABLE_MOB_AI_OPTIONS_DISABLE_COLLISION.get().booleanValue()) {
                entity.setCollidable(!disable);
            }
        }
    }

    public static boolean isAiDisabled(LivingEntity entity) {
        EntityStackSettings entityStackSettings = RoseStacker.getInstance().getManager(StackSettingManager.class).getEntityStackSettings(entity.getType());
        if (entityStackSettings != null && entityStackSettings.isMobAIDisabled()) {
            return true;
        }
        RoseStacker rosePlugin = RoseStacker.getInstance();
        return entity.getPersistentDataContainer().has(new NamespacedKey((Plugin)rosePlugin, NO_AI_METADATA_NAME), PersistentDataType.INTEGER);
    }

    public static void tagSpawnedFromSpawner(Entity entity) {
        RoseStacker rosePlugin = RoseStacker.getInstance();
        entity.getPersistentDataContainer().set(new NamespacedKey((Plugin)rosePlugin, SPAWNED_FROM_SPAWNER_METADATA_NAME), PersistentDataType.INTEGER, (Object)1);
    }

    public static boolean isSpawnedFromSpawner(Entity entity) {
        RoseStacker rosePlugin = RoseStacker.getInstance();
        return entity.getPersistentDataContainer().has(new NamespacedKey((Plugin)rosePlugin, SPAWNED_FROM_SPAWNER_METADATA_NAME), PersistentDataType.INTEGER) || EntityUtils.hasSpawnerSpawnReason(entity);
    }

    public static void tagSpawnedFromTrialSpawner(Entity entity) {
        RoseStacker rosePlugin = RoseStacker.getInstance();
        entity.getPersistentDataContainer().set(new NamespacedKey((Plugin)rosePlugin, SPAWNED_FROM_TRIAL_SPAWNER_METADATA_NAME), PersistentDataType.INTEGER, (Object)1);
    }

    public static boolean isSpawnedFromTrialSpawner(Entity entity) {
        RoseStacker rosePlugin = RoseStacker.getInstance();
        return entity.getPersistentDataContainer().has(new NamespacedKey((Plugin)rosePlugin, SPAWNED_FROM_TRIAL_SPAWNER_METADATA_NAME), PersistentDataType.INTEGER) || EntityUtils.hasTrialSpawnerSpawnReason(entity);
    }

    public static void increaseSpawnCount(StackedSpawnerTile spawner, long amount) {
        RoseStacker rosePlugin = RoseStacker.getInstance();
        PersistentDataContainer dataContainer = spawner.getPersistentDataContainer();
        if (dataContainer != null) {
            NamespacedKey key = new NamespacedKey((Plugin)rosePlugin, TOTAL_SPAWNS_METADATA_NAME);
            if (!dataContainer.has(key, PersistentDataType.LONG)) {
                dataContainer.set(key, PersistentDataType.LONG, (Object)amount);
            } else {
                dataContainer.set(key, PersistentDataType.LONG, (Object)(PersistentDataUtils.getTotalSpawnCount(spawner) + amount));
            }
        }
    }

    public static long getTotalSpawnCount(StackedSpawnerTile spawner) {
        try {
            RoseStacker rosePlugin = RoseStacker.getInstance();
            PersistentDataContainer persistentDataContainer = spawner.getPersistentDataContainer();
            if (persistentDataContainer == null) {
                return 0L;
            }
            NamespacedKey key = new NamespacedKey((Plugin)rosePlugin, TOTAL_SPAWNS_METADATA_NAME);
            Long amount = (Long)persistentDataContainer.get(key, PersistentDataType.LONG);
            return amount != null ? amount : 0L;
        }
        catch (ConcurrentModificationException e) {
            return 0L;
        }
    }
}

