/*
 * Decompiled with CFR 0.152.
 */
package dev.rosewood.rosestacker.utils;

import dev.rosewood.rosestacker.RoseStacker;
import dev.rosewood.rosestacker.config.SettingKey;
import dev.rosewood.rosestacker.lib.rosegarden.utils.EntitySpawnUtil;
import dev.rosewood.rosestacker.lib.rosegarden.utils.NMSUtil;
import dev.rosewood.rosestacker.manager.LocaleManager;
import dev.rosewood.rosestacker.utils.EntityUtils;
import dev.rosewood.rosestacker.utils.ItemUtils;
import dev.rosewood.rosestacker.utils.VersionUtils;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bukkit.Color;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Tag;
import org.bukkit.World;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.Player;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.permissions.Permissible;
import org.bukkit.permissions.PermissionAttachmentInfo;

public final class StackerUtils {
    public static final String MIN_SUPPORTED_VERSION = "1.16.5";
    public static final String MAX_SUPPORTED_VERSION = "1.21.10";
    public static final String MAX_SUPPORTED_LOCALE_VERSION = "1.21.10";
    public static final int ASSUMED_ENTITY_VISIBILITY_RANGE = 5625;
    public static final Particle.DustOptions STACKABLE_DUST_OPTIONS = new Particle.DustOptions(Color.fromRGB((int)65280), 1.5f);
    public static final Particle.DustOptions UNSTACKABLE_DUST_OPTIONS = new Particle.DustOptions(Color.fromRGB((int)0xFF0000), 1.5f);
    public static final Random RANDOM = new Random();
    private static Set<EntityType> cachedStackableEntityTypes;
    private static NumberFormat formatter;

    public static String formatName(String name) {
        return Arrays.stream(name.replace('_', ' ').split("\\s+")).map(x -> x.substring(0, 1).toUpperCase() + x.substring(1).toLowerCase()).collect(Collectors.joining(" "));
    }

    public static String formatMaterialName(Material material) {
        if (material == Material.TNT) {
            return "TNT";
        }
        return StackerUtils.formatName(material.name());
    }

    public static int randomInRange(int min, int max) {
        if (min == max) {
            return min;
        }
        if (min > max) {
            int temp = min;
            min = max;
            max = temp;
        }
        return RANDOM.nextInt(max - min + 1) + min;
    }

    public static Set<EntityType> getStackableEntityTypes() {
        if (cachedStackableEntityTypes != null) {
            return cachedStackableEntityTypes;
        }
        cachedStackableEntityTypes = Stream.of(EntityType.values()).filter(EntityType::isAlive).filter(EntityType::isSpawnable).filter(x -> x != EntityType.PLAYER && x != EntityType.ARMOR_STAND).collect(Collectors.toCollection(() -> EnumSet.noneOf(EntityType.class)));
        return cachedStackableEntityTypes;
    }

    public static boolean passesChance(double chance) {
        return RANDOM.nextDouble() <= chance;
    }

    public static int countPassedChances(double chance, int attempts) {
        if (chance == 0.0) {
            return 0;
        }
        if (chance == 1.0) {
            return attempts;
        }
        if (attempts < 128) {
            int passes = 0;
            for (int i = 0; i < attempts; ++i) {
                if (!StackerUtils.passesChance(chance)) continue;
                ++passes;
            }
            return passes;
        }
        double mean = (double)attempts * chance;
        double stdDev = Math.sqrt((double)attempts * chance) * (1.0 - chance);
        return (int)Math.round(RANDOM.nextGaussian(mean, stdDev));
    }

    public static void dropExperience(Location location, long lowerBound, long upperBound, int step) {
        long experience;
        World world = location.getWorld();
        if (world == null) {
            return;
        }
        int chunkAmount = Math.max(2, step);
        for (experience = RANDOM.nextLong(upperBound - lowerBound + 1L) + lowerBound; experience > (long)chunkAmount; experience -= (long)chunkAmount) {
            EntitySpawnUtil.spawn(location.clone().add(RANDOM.nextDouble() - 0.5, RANDOM.nextDouble() - 0.5, RANDOM.nextDouble() - 0.5), ExperienceOrb.class, x -> x.setExperience(chunkAmount));
        }
        if (experience > 0L) {
            int fExperience = (int)experience;
            EntitySpawnUtil.spawn(location.clone().add(RANDOM.nextDouble() - 0.5, RANDOM.nextDouble() - 0.5, RANDOM.nextDouble() - 0.5), ExperienceOrb.class, x -> x.setExperience(fExperience));
        }
    }

    public static List<Material> getPossibleStackableBlockMaterials() {
        return Arrays.stream(Material.values()).filter(x -> !x.isLegacy()).filter(Material::isBlock).filter(Material::isItem).filter(Material::isSolid).filter(x -> !StackerUtils.isInteractable(x)).filter(x -> !Tag.CORAL_PLANTS.isTagged((Keyed)x)).filter(x -> !Tag.SLABS.isTagged((Keyed)x)).filter(x -> !Tag.BANNERS.isTagged((Keyed)x)).filter(x -> !x.name().endsWith("_WALL")).filter(x -> !x.name().endsWith("_PRESSURE_PLATE")).sorted(Comparator.comparing(Enum::name)).toList();
    }

    public static boolean isInteractable(Material material) {
        return switch (material.getKey().getKey()) {
            case "redstone_ore", "deepslate_redstone_ore", "beacon", "tnt", "dragon_egg" -> false;
            default -> material.isInteractable();
        };
    }

    public static boolean isOccluding(Material material) {
        if (material.name().contains("GLASS") || material.name().endsWith("_STAINED_GLASS_PANE") || material.name().contains("FENCE") || material.name().endsWith("SLAB") || material.name().endsWith("WALL")) {
            return true;
        }
        return switch (material) {
            case Material.CHEST, Material.ENDER_CHEST, Material.TRAPPED_CHEST, Material.ICE -> true;
            default -> material.isOccluding();
        };
    }

    public static boolean isAir(Material material) {
        return switch (material) {
            case Material.AIR, Material.CAVE_AIR, Material.VOID_AIR -> true;
            default -> false;
        };
    }

    public static String formatNumber(long value) {
        return formatter.format(value);
    }

    public static String formatTicksAsTime(long value) {
        long seconds = value / 20L;
        long minutes = seconds / 60L;
        if (minutes > 0L) {
            return String.format("%dm %ds", minutes, seconds -= minutes * 60L);
        }
        return String.format("%ds", seconds);
    }

    public static int getPermissionDefinableValue(Permissible permissible, String permission, int lowerBound) {
        int amount = lowerBound;
        for (PermissionAttachmentInfo info : permissible.getEffectivePermissions()) {
            String target = info.getPermission().toLowerCase();
            if (!target.startsWith(permission) || !info.getValue()) continue;
            try {
                amount = Math.max(amount, Integer.parseInt(target.substring(target.lastIndexOf(46) + 1)));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return amount;
    }

    public static void clearCache() {
        cachedStackableEntityTypes = null;
        EntityUtils.clearCache();
        ItemUtils.clearCache();
        String separator = RoseStacker.getInstance().getManager(LocaleManager.class).getLocaleMessage("number-separator");
        DecimalFormatSymbols symbols = DecimalFormatSymbols.getInstance();
        symbols.setGroupingSeparator(!separator.isEmpty() ? separator.charAt(0) : (char)',');
        formatter = new DecimalFormat("#,##0", symbols);
    }

    public static int getLuckLevel(Player player) {
        double luck = 0.0;
        AttributeInstance attribute = player.getAttribute(VersionUtils.LUCK);
        if (attribute != null) {
            luck += attribute.getValue();
        }
        return (int)Math.floor(luck);
    }

    public static double getSilkTouchChanceRaw(Player player) {
        double chance = StackerUtils.getPermissionDefinableValue((Permissible)player, "rosestacker.silktouch.chance", SettingKey.SPAWNER_SILK_TOUCH_CHANCE.get());
        return chance += SettingKey.SPAWNER_SILK_TOUCH_LUCK_CHANCE_INCREASE.get() * (double)StackerUtils.getLuckLevel(player);
    }

    public static boolean isVanished(Player player) {
        return player.getMetadata("vanished").stream().anyMatch(MetadataValue::asBoolean);
    }

    public static Location adjustBlockLocation(Location location) {
        if (NMSUtil.getVersionNumber() > 21 || NMSUtil.getVersionNumber() == 21 && NMSUtil.getMinorVersionNumber() >= 3) {
            return location.add(0.5, 0.5, 0.5);
        }
        return location;
    }

    static {
        formatter = NumberFormat.getInstance();
    }
}

