/*
 * Decompiled with CFR 0.152.
 */
package dev.rosewood.rosestacker.utils;

import dev.rosewood.rosestacker.RoseStacker;
import dev.rosewood.rosestacker.lib.rosegarden.RosePlugin;
import dev.rosewood.rosestacker.lib.rosegarden.scheduler.RoseScheduler;
import org.bukkit.Bukkit;

public final class ThreadUtils {
    private static final RosePlugin PLUGIN = RoseStacker.getInstance();
    private static final RoseScheduler SCHEDULER = PLUGIN.getScheduler();

    private ThreadUtils() {
    }

    public static void runOnPrimary(Runnable runnable) {
        if (Bukkit.isPrimaryThread()) {
            runnable.run();
        } else {
            ThreadUtils.runSync(runnable);
        }
    }

    public static void runOffPrimary(Runnable runnable) {
        if (!Bukkit.isPrimaryThread()) {
            runnable.run();
        } else {
            ThreadUtils.runAsync(runnable);
        }
    }

    public static void runSync(Runnable runnable) {
        if (ThreadUtils.checkEnabled()) {
            SCHEDULER.runTask(runnable);
        }
    }

    public static void runSyncDelayed(Runnable runnable, long delay) {
        if (ThreadUtils.checkEnabled()) {
            SCHEDULER.runTaskLater(runnable, delay);
        }
    }

    public static void runAsync(Runnable runnable) {
        if (ThreadUtils.checkEnabled()) {
            SCHEDULER.runTaskAsync(runnable);
        }
    }

    public static void runAsyncDelayed(Runnable runnable, long delay) {
        if (ThreadUtils.checkEnabled()) {
            SCHEDULER.runTaskLaterAsync(runnable, delay);
        }
    }

    public static int getActiveThreads() {
        return SCHEDULER.getRunningTaskCount();
    }

    private static boolean checkEnabled() {
        return PLUGIN.isEnabled();
    }
}

