/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.bountifulbaubles.client.handler;

import com.jinqinxixi.bountifulbaubles.config.ModConfig;
import com.jinqinxixi.bountifulbaubles.item.Baubles.VampiricGloveItem;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;

@Mod.EventBusSubscriber
public class VampiricEventHandler {
    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        LivingEntity attacker;
        Entity entity = event.getSource().m_7640_();
        if (entity instanceof LivingEntity && VampiricEventHandler.hasAtLeastOneGlove(attacker = (LivingEntity)entity)) {
            double percent = ModConfig.getVampiricPercent();
            double maxHeal = ModConfig.getVampiricMax();
            float damage = event.getAmount();
            float healAmount = (float)Math.min((double)damage * percent, maxHeal);
            attacker.m_5634_(healAmount);
        }
    }

    private static boolean hasAtLeastOneGlove(LivingEntity entity) {
        return CuriosApi.getCuriosInventory((LivingEntity)entity).resolve().map(handler -> {
            for (String identifier : handler.getCurios().keySet()) {
                ICurioStacksHandler stackHandler = (ICurioStacksHandler)handler.getCurios().get(identifier);
                if (stackHandler == null) continue;
                for (int i = 0; i < stackHandler.getSlots(); ++i) {
                    if (!(stackHandler.getStacks().getStackInSlot(i).m_41720_() instanceof VampiricGloveItem)) continue;
                    return true;
                }
            }
            return false;
        }).orElse(false);
    }
}

