/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.bountifulbaubles.config;

import com.jinqinxixi.bountifulbaubles.BountifulBaublesMod;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModList;

public class ModConfig {
    public static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec SPEC;
    private static final String BAUBLES_REFORKED_MOD_ID = "baublesreforked";
    private static boolean baublesReforkedLoaded;
    public static final ForgeConfigSpec.DoubleValue HUSK_APPLE_CHANCE;
    public static final ForgeConfigSpec.DoubleValue STRAY_RING_CHANCE;
    public static final ForgeConfigSpec.DoubleValue SHULKER_HEART_CHANCE;
    public static final ForgeConfigSpec.DoubleValue CAVE_SPIDER_BEZOAR_CHANCE;
    public static final ForgeConfigSpec.DoubleValue EVOKER_TOTEM_CHANCE;
    public static final ForgeConfigSpec.DoubleValue ELDER_GUARDIAN_VITAMIN_CHANCE;
    public static final ForgeConfigSpec.DoubleValue DRAGON_SCALE_CHANCE;
    public static final ForgeConfigSpec.IntValue DRAGON_SCALE_MIN;
    public static final ForgeConfigSpec.IntValue DRAGON_SCALE_MAX;
    public static final ForgeConfigSpec.IntValue ANVIL_RECAST_EXP_COST;
    public static final ForgeConfigSpec.IntValue ANVIL_RECAST_MATERIAL_COST;
    public static final ForgeConfigSpec.DoubleValue SPRINT_JUMP_VERTICAL;
    public static final ForgeConfigSpec.DoubleValue SPRINT_JUMP_HORIZONTAL;
    public static final ForgeConfigSpec.IntValue COOLDOWN_TICKS;
    public static final ForgeConfigSpec.BooleanValue ENABLE_CURIOS;
    public static final ForgeConfigSpec.DoubleValue VAMPIRIC_PERCENT;
    public static final ForgeConfigSpec.DoubleValue VAMPIRIC_MAX;
    public static final ForgeConfigSpec.DoubleValue GAUNTLETS_ATTACK_SPEED;
    public static final ForgeConfigSpec.BooleanValue MODIFIER_ENABLED;
    public static final ForgeConfigSpec.IntValue TACTICAL_SCAN_INTERVAL;
    public static final ForgeConfigSpec.IntValue TACTICAL_MARK_DURATION;
    public static final ForgeConfigSpec.DoubleValue TACTICAL_SCAN_RADIUS;
    public static final ForgeConfigSpec.DoubleValue TACTICAL_UP_RANGE;
    public static final ForgeConfigSpec.DoubleValue TACTICAL_DOWN_RANGE;
    public static final ForgeConfigSpec.DoubleValue TACTICAL_DAMAGE_MULTIPLIER;
    public static final ForgeConfigSpec.ConfigValue<List<? extends Double>> LUCK_COIN_DAMAGE_BONUSES;
    public static final ForgeConfigSpec.ConfigValue<List<? extends Double>> LUCK_COIN_PROBABILITIES;
    public static final ForgeConfigSpec.DoubleValue THA_WIZARD_DURATION_MULTIPLIER;
    public static final ForgeConfigSpec.DoubleValue DROP_SPINDLE_REPAIR_CHANCE;
    public static final ForgeConfigSpec.IntValue DROP_SPINDLE_REPAIR_AMOUNT;
    public static final ForgeConfigSpec.IntValue DARK_EGG_COOLDOWN;
    public static final ForgeConfigSpec.IntValue DARK_EGG_VEX_COUNT;
    public static final ForgeConfigSpec.IntValue DARK_EGG_VEX_LIFETIME;
    public static final ForgeConfigSpec.IntValue MOSSY_RING_REPAIR_INTERVAL;
    public static final ForgeConfigSpec.IntValue MOSSY_RING_REPAIR_AMOUNT;
    public static final ForgeConfigSpec.IntValue MOSSY_BELT_REPAIR_INTERVAL;
    public static final ForgeConfigSpec.IntValue MOSSY_BELT_REPAIR_AMOUNT;
    public static final ForgeConfigSpec.IntValue MAD_AURA_COOLDOWN;
    public static final ForgeConfigSpec.DoubleValue DARK_DAGGER_EXECUTE_THRESHOLD;
    public static final ForgeConfigSpec.DoubleValue DARK_DAGGER_EXECUTE_DAMAGE;
    public static final ForgeConfigSpec.IntValue BLAZE_HEART_DURATION;
    public static final ForgeConfigSpec.IntValue WRATH_PENDANT_BUFF_DURATION;
    public static final ForgeConfigSpec.IntValue WRATH_PENDANT_BUFF_LEVEL;
    public static final ForgeConfigSpec.DoubleValue GOLDEN_SKULL_DROP_CHANCE;
    public static final ForgeConfigSpec.DoubleValue BUTCHERS_CLEAVER_DROP_CHANCE;
    public static final ForgeConfigSpec.IntValue RUBY_HEART_COOLDOWN;
    public static final ForgeConfigSpec.DoubleValue RUBY_HEART_HEALTH_THRESHOLD;
    public static final ForgeConfigSpec.DoubleValue ROCK_CANDY_SPEED_MULTIPLIER;
    public static final ForgeConfigSpec.DoubleValue ROCK_CANDY_DAMAGE_MULTIPLIER;
    public static final ForgeConfigSpec.ConfigValue<String> TREASURE_BAG_ITEMS;
    public static final ForgeConfigSpec.ConfigValue<String> DESERT_PYRAMID_LOOT;
    public static final ForgeConfigSpec.ConfigValue<String> JUNGLE_TEMPLE_LOOT;
    public static final ForgeConfigSpec.ConfigValue<String> ABANDONED_MINESHAFT_LOOT;
    public static final ForgeConfigSpec.ConfigValue<String> STRONGHOLD_LIBRARY_LOOT;
    public static final ForgeConfigSpec.ConfigValue<String> WOODLAND_MANSION_LOOT;
    public static final ForgeConfigSpec.ConfigValue<String> VILLAGE_TEMPLE_LOOT;
    public static final ForgeConfigSpec.ConfigValue<String> SHIPWRECK_TREASURE_LOOT;
    public static final ForgeConfigSpec.ConfigValue<String> PILLAGER_OUTPOST_LOOT;
    public static final ForgeConfigSpec.ConfigValue<String> BURIED_TREASURE_LOOT;
    public static final ForgeConfigSpec.ConfigValue<String> UNDERWATER_RUIN_BIG_LOOT;
    public static final ForgeConfigSpec.ConfigValue<String> UNDERWATER_RUIN_SMALL_LOOT;
    public static final ForgeConfigSpec.ConfigValue<String> IGLOO_CHEST_LOOT;
    public static final ForgeConfigSpec.ConfigValue<String> BASTION_TREASURE_LOOT;
    public static final ForgeConfigSpec.ConfigValue<String> BASTION_BRIDGE_LOOT;
    public static final ForgeConfigSpec.ConfigValue<String> BASTION_HOUSING_LOOT;
    public static final ForgeConfigSpec.ConfigValue<String> BASTION_OTHER_LOOT;
    public static final ForgeConfigSpec.ConfigValue<String> RUINED_PORTAL_LOOT;
    public static final ForgeConfigSpec.ConfigValue<String> END_CITY_LOOT;
    public static final ForgeConfigSpec.ConfigValue<String> ANCIENT_CITY_LOOT;
    public static final ForgeConfigSpec.ConfigValue<String> SIMPLE_DUNGEON_LOOT;
    public static final ForgeConfigSpec.ConfigValue<String> STRONGHOLD_CORRIDOR_LOOT;
    public static final ForgeConfigSpec.ConfigValue<String> FOSSIL_DINOSAUR_LOOT;
    public static final ForgeConfigSpec.ConfigValue<String> FOSSIL_MAMMAL_LOOT;
    public static final ForgeConfigSpec.ConfigValue<String> SHIPWRECK_SUPPLY_LOOT;
    public static final ForgeConfigSpec.ConfigValue<String> WOODLAND_CARTOGRAPHY_LOOT;
    public static final ForgeConfigSpec.ConfigValue<String> STRONGHOLD_CROSSING_LOOT;
    public static final ForgeConfigSpec.ConfigValue<String> SHIPWRECK_MAP_LOOT;
    public static final ForgeConfigSpec.DoubleValue CROSS_NECKLACE_INVULNERABILITY;
    public static final ForgeConfigSpec.BooleanValue CROSS_NECKLACE_PLAYERS_ONLY;
    public static final ForgeConfigSpec.ConfigValue<String> VILLAGE_ARMORER_LOOT;
    public static final ForgeConfigSpec.ConfigValue<String> VILLAGE_BUTCHER_LOOT;
    public static final ForgeConfigSpec.ConfigValue<String> VILLAGE_CARTOGRAPHER_LOOT;
    public static final ForgeConfigSpec.ConfigValue<String> VILLAGE_PLAINS_HOUSE_LOOT;
    public static final ForgeConfigSpec.ConfigValue<String> VILLAGE_FISHER_LOOT;
    public static final ForgeConfigSpec.ConfigValue<String> VILLAGE_FLETCHER_LOOT;
    public static final ForgeConfigSpec.ConfigValue<String> VILLAGE_TANNERY_LOOT;
    public static final ForgeConfigSpec.ConfigValue<String> VILLAGE_LIBRARY_LOOT;
    public static final ForgeConfigSpec.ConfigValue<String> VILLAGE_MASON_LOOT;
    public static final ForgeConfigSpec.ConfigValue<String> VILLAGE_SHEPHERD_LOOT;
    public static final ForgeConfigSpec.ConfigValue<String> VILLAGE_TOOLSMITH_LOOT;
    public static final ForgeConfigSpec.ConfigValue<String> VILLAGE_WEAPONSMITH_LOOT;
    public static final ForgeConfigSpec.ConfigValue<String> VILLAGE_DESERT_HOUSE_LOOT;
    public static final ForgeConfigSpec.ConfigValue<String> VILLAGE_SNOWY_HOUSE_LOOT;
    public static final ForgeConfigSpec.ConfigValue<String> VILLAGE_SAVANNA_HOUSE_LOOT;
    public static final ForgeConfigSpec.ConfigValue<String> VILLAGE_TAIGA_HOUSE_LOOT;
    private static final Map<ResourceLocation, ForgeConfigSpec.ConfigValue<String>> LOOT_MAPPING;
    public static Map<ResourceLocation, List<LootEntry>> lootConfig;

    private static ForgeConfigSpec.ConfigValue<String> defineLoot(String configKey, String structureId, String comment, String defaultValue) {
        return BUILDER.comment(comment + "\n\u7ed3\u6784ID: " + structureId).define(configKey + "Loot", (Object)defaultValue);
    }

    public static float getHuskAppleChance() {
        return ((Double)HUSK_APPLE_CHANCE.get()).floatValue();
    }

    public static float getStrayRingChance() {
        return ((Double)STRAY_RING_CHANCE.get()).floatValue();
    }

    public static float getElderGuardianVitaminChance() {
        return ((Double)ELDER_GUARDIAN_VITAMIN_CHANCE.get()).floatValue();
    }

    public static float getDragonScaleChance() {
        return ((Double)DRAGON_SCALE_CHANCE.get()).floatValue();
    }

    public static int getDragonScaleMin() {
        return (Integer)DRAGON_SCALE_MIN.get();
    }

    public static int getDragonScaleMax() {
        return (Integer)DRAGON_SCALE_MAX.get();
    }

    public static float getShulkerHeartChance() {
        return ((Double)SHULKER_HEART_CHANCE.get()).floatValue();
    }

    public static float getCaveSpiderBezoarChance() {
        return ((Double)CAVE_SPIDER_BEZOAR_CHANCE.get()).floatValue();
    }

    public static float getEvokerTotemChance() {
        return ((Double)EVOKER_TOTEM_CHANCE.get()).floatValue();
    }

    public static void loadLootConfig() {
        lootConfig.clear();
        LOOT_MAPPING.forEach((tableId, config) -> {
            String value = (String)config.get();
            if (value.isEmpty()) {
                return;
            }
            List<LootEntry> entries = ModConfig.parseLootEntries(value);
            if (!entries.isEmpty()) {
                lootConfig.put((ResourceLocation)tableId, entries);
            }
        });
    }

    private static List<LootEntry> parseLootEntries(String configValue) {
        ArrayList<LootEntry> entries = new ArrayList<LootEntry>();
        for (String entry : configValue.split(";")) {
            String[] parts = entry.split(",");
            if (parts.length != 4) continue;
            try {
                entries.add(new LootEntry(new ResourceLocation(parts[0]), Integer.parseInt(parts[1]), Integer.parseInt(parts[2]), Integer.parseInt(parts[3])));
            }
            catch (Exception e) {
                BountifulBaublesMod.LOGGER.error("Invalid loot entry: {}", (Object)entry);
            }
        }
        return entries;
    }

    public static double getCrossNecklaceBoost() {
        return (Double)CROSS_NECKLACE_INVULNERABILITY.get();
    }

    public static boolean crossNecklacePlayersOnly() {
        return (Boolean)CROSS_NECKLACE_PLAYERS_ONLY.get();
    }

    public static int getRecastExpCost() {
        return (Integer)ANVIL_RECAST_EXP_COST.get();
    }

    public static int getRecastMaterialCost() {
        return (Integer)ANVIL_RECAST_MATERIAL_COST.get();
    }

    public static double getSprintVertical() {
        return (Double)SPRINT_JUMP_VERTICAL.get();
    }

    public static double getSprintHorizontal() {
        return (Double)SPRINT_JUMP_HORIZONTAL.get();
    }

    public static int getCooldownTicks() {
        return (Integer)COOLDOWN_TICKS.get();
    }

    public static boolean isCuriosEnabled() {
        return (Boolean)ENABLE_CURIOS.get();
    }

    public static double getVampiricPercent() {
        return (Double)VAMPIRIC_PERCENT.get();
    }

    public static boolean isModifierEnabled() {
        return (Boolean)MODIFIER_ENABLED.get();
    }

    public static double getVampiricMax() {
        return (Double)VAMPIRIC_MAX.get();
    }

    public static double getGauntletsAttackSpeed() {
        return (Double)GAUNTLETS_ATTACK_SPEED.get();
    }

    public static int getTacticalScanInterval() {
        return (Integer)TACTICAL_SCAN_INTERVAL.get();
    }

    public static int getTacticalMarkDuration() {
        return (Integer)TACTICAL_MARK_DURATION.get();
    }

    public static double getTacticalScanRadius() {
        return (Double)TACTICAL_SCAN_RADIUS.get();
    }

    public static double getTacticalUpRange() {
        return (Double)TACTICAL_UP_RANGE.get();
    }

    public static double getTacticalDownRange() {
        return (Double)TACTICAL_DOWN_RANGE.get();
    }

    public static double getTacticalDamageMultiplier() {
        return (Double)TACTICAL_DAMAGE_MULTIPLIER.get();
    }

    public static List<Double> getLuckCoinDamageBonuses() {
        return new ArrayList<Double>((Collection)LUCK_COIN_DAMAGE_BONUSES.get());
    }

    public static List<Double> getLuckCoinProbabilities() {
        return new ArrayList<Double>((Collection)LUCK_COIN_PROBABILITIES.get());
    }

    public static double getThaWizardDurationMultiplier() {
        return (Double)THA_WIZARD_DURATION_MULTIPLIER.get();
    }

    public static double getDropSpindleRepairChance() {
        return (Double)DROP_SPINDLE_REPAIR_CHANCE.get();
    }

    public static int getDropSpindleRepairAmount() {
        return (Integer)DROP_SPINDLE_REPAIR_AMOUNT.get();
    }

    public static int getDarkEggCooldown() {
        return (Integer)DARK_EGG_COOLDOWN.get();
    }

    public static int getDarkEggVexCount() {
        return (Integer)DARK_EGG_VEX_COUNT.get();
    }

    public static int getDarkEggVexLifetime() {
        return (Integer)DARK_EGG_VEX_LIFETIME.get();
    }

    public static int getMossyRingRepairInterval() {
        return (Integer)MOSSY_RING_REPAIR_INTERVAL.get();
    }

    public static int getMossyRingRepairAmount() {
        return (Integer)MOSSY_RING_REPAIR_AMOUNT.get();
    }

    public static int getMossyBeltRepairInterval() {
        return (Integer)MOSSY_BELT_REPAIR_INTERVAL.get();
    }

    public static int getMossyBeltRepairAmount() {
        return (Integer)MOSSY_BELT_REPAIR_AMOUNT.get();
    }

    public static int getMadAuraCooldown() {
        return (Integer)MAD_AURA_COOLDOWN.get();
    }

    public static double getDarkDaggerExecuteThreshold() {
        return (Double)DARK_DAGGER_EXECUTE_THRESHOLD.get();
    }

    public static double getDarkDaggerExecuteDamage() {
        return (Double)DARK_DAGGER_EXECUTE_DAMAGE.get();
    }

    public static int getBlazeHeartDuration() {
        return (Integer)BLAZE_HEART_DURATION.get();
    }

    public static int getWrathPendantBuffLevel() {
        return (Integer)WRATH_PENDANT_BUFF_LEVEL.get();
    }

    public static int getWrathPendantBuffDuration() {
        return (Integer)WRATH_PENDANT_BUFF_DURATION.get();
    }

    static {
        baublesReforkedLoaded = ModList.get().isLoaded(BAUBLES_REFORKED_MOD_ID);
        BUILDER.push("Modifier Settings").comment(new String[]{"\u9970\u54c1\u4fee\u9970\u7cfb\u7edf", "Accessory Modifier System"});
        MODIFIER_ENABLED = BUILDER.comment(new String[]{"\u662f\u5426\u542f\u7528\u9970\u54c1\u4fee\u9970\u5668\u7cfb\u7edf", "Whether to enable the accessory modifier system", "\u6ce8\u610f\uff1a\u5982\u679c\u68c0\u6d4b\u5230\u5b89\u88c5\u4e86 Baubles Reforked \u6a21\u7ec4\uff0c\u6b64\u9009\u9879\u9ed8\u8ba4\u4e3a false", "Note: If Baubles Reforked mod is detected, this option defaults to false", "\u4f60\u4ecd\u7136\u53ef\u4ee5\u624b\u52a8\u542f\u7528\u6b64\u9009\u9879\uff0c\u4f46\u4e0d\u5efa\u8bae\u540c\u65f6\u4f7f\u7528\u4e24\u4e2a\u6a21\u7ec4\u7684\u4fee\u9970\u7b26\u7cfb\u7edf", "You can still enable this option manually, but it's not recommended to use both mods' modifier systems simultaneously"}).define("modifierEnabled", !baublesReforkedLoaded);
        BUILDER.pop();
        BUILDER.push("Anvil Recast Settings");
        ANVIL_RECAST_EXP_COST = BUILDER.comment(new String[]{"\u5168\u5c40\u91cd\u94f8\u7ecf\u9a8c\u6d88\u8017 (0-100)", "Global recast experience cost (0-100)"}).defineInRange("recastExpCost", 3, 0, 100);
        ANVIL_RECAST_MATERIAL_COST = BUILDER.comment(new String[]{"\u5168\u5c40\u91cd\u94f8\u6750\u6599\u6d88\u8017 (1-64)", "Global recast material cost (1-64)"}).defineInRange("recastMaterialCost", 1, 1, 64);
        BUILDER.pop();
        BUILDER.push("Cloud in a Bottle Settings");
        SPRINT_JUMP_VERTICAL = BUILDER.comment(new String[]{"\u75be\u8dd1\u8df3\u8dc3\u5782\u76f4\u52a0\u6210 (\u9ed8\u8ba40.5)", "Sprint jump vertical boost multiplier (default 0.5)"}).defineInRange("sprintVertical", 0.5, 0.0, 2.0);
        SPRINT_JUMP_HORIZONTAL = BUILDER.comment(new String[]{"\u75be\u8dd1\u8df3\u8dc3\u6c34\u5e73\u52a0\u6210 (\u9ed8\u8ba40.5)", "Sprint jump horizontal boost multiplier (default 0.5)"}).defineInRange("sprintHorizontal", 0.5, 0.0, 2.0);
        BUILDER.pop();
        BUILDER.push("Totem Settings");
        COOLDOWN_TICKS = BUILDER.comment(new String[]{"\u51b7\u5374\u65f6\u95f4(\u5355\u4f4dtick, 20tick=1\u79d2)", "Cooldown time (in ticks, 20 ticks = 1 second)"}).defineInRange("cooldown", 6000, 20, 72000);
        ENABLE_CURIOS = BUILDER.comment(new String[]{"\u542f\u7528Curios\u652f\u6301", "Enable Curios support"}).define("enableCurios", true);
        BUILDER.pop();
        BUILDER.push("Vampiric Glove Settings");
        VAMPIRIC_PERCENT = BUILDER.comment(new String[]{"\u5438\u8840\u767e\u5206\u6bd4 (0.0-1.0)", "Life steal percentage (0.0-1.0)"}).defineInRange("vampiricPercent", 0.2, 0.0, 1.0);
        VAMPIRIC_MAX = BUILDER.comment(new String[]{"\u5355\u6b21\u6700\u5927\u5438\u8840\u91cf", "Maximum life steal amount per hit"}).defineInRange("vampiricMax", 6.0, 0.0, 100.0);
        BUILDER.pop();
        BUILDER.push("Gauntlets Settings");
        GAUNTLETS_ATTACK_SPEED = BUILDER.comment(new String[]{"\u653b\u51fb\u901f\u5ea6\u52a0\u6210\u500d\u7387 (0.6=+60%)", "Attack speed boost multiplier (0.6 = +60%)"}).defineInRange("attackSpeed", 0.6, 0.0, 2.0);
        BUILDER.pop();
        BUILDER.push("Cross Necklace Settings").comment(new String[]{"\u5341\u5b57\u9879\u94fe\u76f8\u5173\u914d\u7f6e", "Cross Necklace Configuration"});
        CROSS_NECKLACE_INVULNERABILITY = BUILDER.comment(new String[]{"\u65e0\u654c\u65f6\u95f4\u5ef6\u957f\u500d\u7387 (0.8=\u5ef6\u957f80%\uff0c\u8bbe\u4e3a0\u7981\u7528\u6548\u679c)", "Invulnerability time extension multiplier (0.8 = +80%, set to 0 to disable)"}).defineInRange("crossNecklaceBoost", 0.8, 0.0, 5.0);
        CROSS_NECKLACE_PLAYERS_ONLY = BUILDER.comment(new String[]{"\u662f\u5426\u4ec5\u5bf9\u73a9\u5bb6\u751f\u6548", "Whether the effect only applies to players"}).define("crossNecklacePlayersOnly", true);
        BUILDER.pop();
        BUILDER.push("Wrath Pendant Settings").comment(new String[]{"\u6124\u6012\u540a\u5760\u76f8\u5173\u914d\u7f6e", "Wrath Pendant Configuration"});
        WRATH_PENDANT_BUFF_LEVEL = BUILDER.comment(new String[]{"\u6124\u6012\u540a\u5760\u7684BUFF\u7b49\u7ea7 (\u9ed8\u8ba43)", "Wrath Pendant buff level (default 3)"}).defineInRange("wrathPendantBuffLevel", 3, 1, 10);
        WRATH_PENDANT_BUFF_DURATION = BUILDER.comment(new String[]{"\u6124\u6012\u540a\u5760\u7684BUFF\u6301\u7eed\u65f6\u95f4 (\u5355\u4f4d\uff1atick\uff0c20tick=1\u79d2\uff0c\u9ed8\u8ba4100)", "Wrath Pendant buff duration (in ticks, 20 ticks = 1 second, default 100)"}).defineInRange("wrathPendantBuffDuration", 100, 20, 1200);
        BUILDER.pop();
        BUILDER.push("Tactical Goggles Settings").comment(new String[]{"\u6d1e\u5bdf\u4e4b\u773c\u76f8\u5173\u914d\u7f6e", "Tactical Goggles Configuration"});
        TACTICAL_SCAN_INTERVAL = BUILDER.comment(new String[]{"\u626b\u63cf\u95f4\u9694\uff08\u5355\u4f4d\uff1atick\uff0c20tick = 1\u79d2\uff09", "Scan interval (in ticks, 20 ticks = 1 second)"}).defineInRange("scanInterval", 300, 1, 1200);
        TACTICAL_MARK_DURATION = BUILDER.comment(new String[]{"\u6807\u8bb0\u6301\u7eed\u65f6\u95f4\uff08\u5355\u4f4d\uff1atick\uff09", "Mark duration (in ticks)"}).defineInRange("markDuration", 100, 1, 600);
        TACTICAL_SCAN_RADIUS = BUILDER.comment(new String[]{"\u6c34\u5e73\u626b\u63cf\u534a\u5f84", "Horizontal scan radius"}).defineInRange("scanRadius", 10.0, 1.0, 32.0);
        TACTICAL_UP_RANGE = BUILDER.comment(new String[]{"\u5411\u4e0a\u626b\u63cf\u8303\u56f4", "Upward scan range"}).defineInRange("upRange", 5.0, 1.0, 16.0);
        TACTICAL_DOWN_RANGE = BUILDER.comment(new String[]{"\u5411\u4e0b\u626b\u63cf\u8303\u56f4", "Downward scan range"}).defineInRange("downRange", 5.0, 1.0, 16.0);
        TACTICAL_DAMAGE_MULTIPLIER = BUILDER.comment(new String[]{"\u5bf9\u6807\u8bb0\u76ee\u6807\u7684\u4f24\u5bb3\u500d\u7387", "Damage multiplier against marked targets"}).defineInRange("damageMultiplier", 1.5, 1.0, 5.0);
        BUILDER.pop();
        BUILDER.push("Lucky Coin Settings").comment(new String[]{"\u5e78\u8fd0\u786c\u5e01\u76f8\u5173\u914d\u7f6e", "Lucky Coin Configuration"});
        LUCK_COIN_DAMAGE_BONUSES = BUILDER.comment(new String[]{"\u4f24\u5bb3\u52a0\u6210\u5217\u8868\uff080.05\u8868\u793a+5%\u4f24\u5bb3\uff09", "Damage bonus list (0.05 means +5% damage)"}).defineList("damageBonus", Arrays.asList(0.05, 0.1, 0.3), o -> o instanceof Double && (Double)o >= 0.0 && (Double)o <= 5.0);
        LUCK_COIN_PROBABILITIES = BUILDER.comment(new String[]{"\u6bcf\u4e2a\u4f24\u5bb3\u52a0\u6210\u5bf9\u5e94\u7684\u89e6\u53d1\u6982\u7387\uff08\u5fc5\u987b\u548c\u4f24\u5bb3\u52a0\u6210\u6570\u7ec4\u957f\u5ea6\u76f8\u540c\uff0c\u4e14\u6982\u7387\u548c\u5fc5\u987b\u7b49\u4e8e1.0\uff09", "Trigger probability for each damage bonus (must match the length of damage bonus array and sum up to 1.0)"}).defineList("probability", Arrays.asList(0.7, 0.2, 0.1), o -> o instanceof Double && (Double)o >= 0.0 && (Double)o <= 1.0);
        BUILDER.pop();
        BUILDER.push("Tha Wizard Settings").comment(new String[]{"\u5c0f\u5deb\u5e08\u9970\u54c1\u76f8\u5173\u914d\u7f6e", "Tha Wizard Accessory Configuration"});
        THA_WIZARD_DURATION_MULTIPLIER = BUILDER.comment(new String[]{"\u836f\u6c34\u6548\u679c\u6301\u7eed\u65f6\u95f4\u500d\u7387 (1.5 = \u5ef6\u957f50%)", "Potion effect duration multiplier (1.5 = +50% duration)"}).defineInRange("durationMultiplier", 1.5, 1.0, 5.0);
        BUILDER.pop();
        BUILDER.push("Drop Spindle Settings").comment(new String[]{"\u7eba\u9524\u76f8\u5173\u914d\u7f6e", "Drop Spindle Configuration"});
        DROP_SPINDLE_REPAIR_CHANCE = BUILDER.comment(new String[]{"\u6bcf\u6b21\u653b\u51fb\u65f6\u89e6\u53d1\u4fee\u590d\u7684\u6982\u7387 (0.25 = 25%)", "Chance to trigger repair on attack (0.25 = 25%)"}).defineInRange("repairChance", 0.25, 0.0, 1.0);
        DROP_SPINDLE_REPAIR_AMOUNT = BUILDER.comment(new String[]{"\u6bcf\u6b21\u4fee\u590d\u7684\u8010\u4e45\u5ea6", "Amount of durability repaired per trigger"}).defineInRange("repairAmount", 1, 1, 64);
        BUILDER.pop();
        BUILDER.push("Dark Egg Settings").comment(new String[]{"\u6697\u5f71\u4e4b\u5375\u76f8\u5173\u914d\u7f6e", "Dark Egg Configuration"});
        DARK_EGG_COOLDOWN = BUILDER.comment(new String[]{"\u6280\u80fd\u51b7\u5374\u65f6\u95f4\uff08\u5355\u4f4d\uff1atick\uff0c20tick = 1\u79d2\uff09", "Ability cooldown (in ticks, 20 ticks = 1 second)"}).defineInRange("cooldown", 1200, 200, 6000);
        DARK_EGG_VEX_COUNT = BUILDER.comment(new String[]{"\u6bcf\u6b21\u53ec\u5524\u7684\u607c\u9b3c\u6570\u91cf", "Number of Vexes summoned per use"}).defineInRange("vexCount", 3, 1, 10);
        DARK_EGG_VEX_LIFETIME = BUILDER.comment(new String[]{"\u607c\u9b3c\u5b58\u6d3b\u65f6\u95f4\uff08\u5355\u4f4d\uff1atick\uff09", "Vex lifetime duration (in ticks)"}).defineInRange("vexLifetime", 600, 100, 2400);
        BUILDER.pop();
        BUILDER.push("Mossy Ring Settings").comment(new String[]{"\u82d4\u85d3\u6212\u6307\u76f8\u5173\u914d\u7f6e", "Mossy Ring Configuration"});
        MOSSY_RING_REPAIR_INTERVAL = BUILDER.comment(new String[]{"\u4fee\u590d\u95f4\u9694\uff08\u5355\u4f4d\uff1atick\uff0c20tick = 1\u79d2\uff09", "Repair interval (in ticks, 20 ticks = 1 second)"}).defineInRange("repairInterval", 60, 20, 200);
        MOSSY_RING_REPAIR_AMOUNT = BUILDER.comment(new String[]{"\u6bcf\u6b21\u4fee\u590d\u7684\u8010\u4e45\u5ea6", "Amount of durability repaired per tick"}).defineInRange("repairAmount", 1, 1, 10);
        BUILDER.pop();
        BUILDER.push("Mossy Belt Settings").comment(new String[]{"\u82d4\u85d3\u8170\u5e26\u76f8\u5173\u914d\u7f6e", "Mossy Belt Configuration"});
        MOSSY_BELT_REPAIR_INTERVAL = BUILDER.comment(new String[]{"\u4fee\u590d\u95f4\u9694\uff08\u5355\u4f4d\uff1atick\uff0c20tick = 1\u79d2\uff09", "Repair interval (in ticks, 20 ticks = 1 second)"}).defineInRange("repairInterval", 60, 20, 200);
        MOSSY_BELT_REPAIR_AMOUNT = BUILDER.comment(new String[]{"\u6bcf\u6b21\u4fee\u590d\u7684\u8010\u4e45\u5ea6", "Amount of durability repaired per tick"}).defineInRange("repairAmount", 1, 1, 10);
        BUILDER.pop();
        BUILDER.push("Mad Aura Settings").comment(new String[]{"\u70bd\u5149\u73af\u76f8\u5173\u914d\u7f6e", "Mad Aura Configuration"});
        MAD_AURA_COOLDOWN = BUILDER.comment(new String[]{"\u6280\u80fd\u51b7\u5374\u65f6\u95f4\uff08\u5355\u4f4d\uff1atick\uff0c20tick = 1\u79d2\uff09", "Ability cooldown (in ticks, 20 ticks = 1 second)"}).defineInRange("cooldown", 600, 200, 2400);
        BUILDER.pop();
        BUILDER.push("Dark Dagger Settings").comment(new String[]{"\u6697\u5f71\u5315\u9996\u76f8\u5173\u914d\u7f6e", "Dark Dagger Configuration"});
        DARK_DAGGER_EXECUTE_THRESHOLD = BUILDER.comment(new String[]{"\u65a9\u6740\u9608\u503c\uff08\u76ee\u6807\u5269\u4f59\u751f\u547d\u503c\u767e\u5206\u6bd4\uff0c0.2 = 20%\uff09", "Execute threshold (target's remaining health percentage, 0.2 = 20%)"}).defineInRange("executeThreshold", 0.2, 0.05, 0.5);
        DARK_DAGGER_EXECUTE_DAMAGE = BUILDER.comment(new String[]{"\u65a9\u6740\u4f24\u5bb3\u503c", "Execute damage amount"}).defineInRange("executeDamage", 9.99999999E8, 1000.0, 9.99999999E8);
        BUILDER.pop();
        BUILDER.push("Blaze Heart Settings").comment(new String[]{"\u70c8\u7130\u4e4b\u5fc3\u76f8\u5173\u914d\u7f6e", "Blaze Heart Configuration"});
        BLAZE_HEART_DURATION = BUILDER.comment(new String[]{"\u751f\u547d\u6062\u590d\u6548\u679c\u6301\u7eed\u65f6\u95f4\uff08\u5355\u4f4d\uff1atick\uff0c20tick = 1\u79d2\uff09", "Regeneration effect duration (in ticks, 20 ticks = 1 second)"}).defineInRange("regenerationDuration", 900, 20, 2400);
        BUILDER.pop();
        BUILDER.push("Mob Drop Settings").comment(new String[]{"\u6240\u6709\u6982\u7387\u503c\u4e3a0.0-1.0\u4e4b\u95f4\u7684\u6d6e\u70b9\u6570\uff0c1.0=100%", "All probability values are floating-point numbers between 0.0-1.0, where 1.0 = 100%"});
        HUSK_APPLE_CHANCE = BUILDER.comment(new String[]{"\u5c38\u58f3\u6389\u843d\u7981\u679c\u6982\u7387 (\u9ed8\u8ba42.5%)", "Chance for Husks to drop Forbidden Apple (default 2.5%)"}).defineInRange("huskAppleChance", 0.025, 0.0, 1.0);
        STRAY_RING_CHANCE = BUILDER.comment(new String[]{"\u6d41\u6d6a\u8005\u6389\u843d\u8d85\u9891\u6212\u6307\u6982\u7387 (\u9ed8\u8ba43%)", "Chance for Strays to drop Overclock Ring (default 3%)"}).defineInRange("strayRingChance", 0.03, 0.0, 1.0);
        SHULKER_HEART_CHANCE = BUILDER.comment(new String[]{"\u6f5c\u5f71\u8d1d\u6389\u843d\u6f5c\u5f71\u4e4b\u5fc3\u6982\u7387 (\u9ed8\u8ba410%)", "Chance for Shulkers to drop Shulker Heart (default 10%)"}).defineInRange("shulkerHeartChance", 0.1, 0.0, 1.0);
        CAVE_SPIDER_BEZOAR_CHANCE = BUILDER.comment(new String[]{"\u6d1e\u7a74\u8718\u86db\u6389\u843d\u725b\u9ec4\u6982\u7387 (\u9ed8\u8ba45%)", "Chance for Cave Spiders to drop Bezoar (default 5%)"}).defineInRange("caveSpiderBezoarChance", 0.05, 0.0, 1.0);
        EVOKER_TOTEM_CHANCE = BUILDER.comment(new String[]{"\u5524\u9b54\u8005\u6389\u843d\u65e0\u9650\u56fe\u817e\u6982\u7387 (\u9ed8\u8ba410%)", "Chance for Evokers to drop Infinite Totem (default 10%)"}).defineInRange("evokerTotemChance", 0.1, 0.0, 1.0);
        ELDER_GUARDIAN_VITAMIN_CHANCE = BUILDER.comment(new String[]{"\u8fdc\u53e4\u5b88\u536b\u6389\u843d\u7ef4\u751f\u7d20\u6982\u7387 (\u9ed8\u8ba4100%)", "Chance for Elder Guardians to drop Vitamin (default 100%)"}).defineInRange("elderGuardianVitaminChance", 1.0, 0.0, 1.0);
        DRAGON_SCALE_CHANCE = BUILDER.comment(new String[]{"\u672b\u5f71\u9f99\u6389\u843d\u9cde\u7247\u7684\u6982\u7387 (\u9ed8\u8ba4100%)", "Chance for Ender Dragon to drop Scales (default 100%)"}).defineInRange("dragonScaleChance", 1.0, 0.0, 1.0);
        DRAGON_SCALE_MIN = BUILDER.comment(new String[]{"\u9cde\u7247\u6700\u5c0f\u6389\u843d\u6570\u91cf (\u9ed8\u8ba43)", "Minimum number of Dragon Scales dropped (default 3)"}).defineInRange("dragonScaleMin", 3, 0, 64);
        DRAGON_SCALE_MAX = BUILDER.comment(new String[]{"\u9cde\u7247\u6700\u5927\u6389\u843d\u6570\u91cf (\u9ed8\u8ba46)", "Maximum number of Dragon Scales dropped (default 6)"}).defineInRange("dragonScaleMax", 6, 0, 64);
        GOLDEN_SKULL_DROP_CHANCE = BUILDER.comment(new String[]{"\u9ec4\u91d1\u5934\u9885\u9970\u54c1\u89e6\u53d1\u5b9d\u85cf\u888b\u6389\u843d\u7684\u6982\u7387 (0.0-1.0)", "Chance for Golden Skull accessory to trigger treasure bag drops (0.0-1.0)"}).defineInRange("goldenSkullDropChance", 0.05, 0.0, 1.0);
        BUTCHERS_CLEAVER_DROP_CHANCE = BUILDER.comment(new String[]{"\u5c60\u5bb0\u9570\u9970\u54c1\u89e6\u53d1\u5934\u9885\u6389\u843d\u7684\u6982\u7387 (0.0-1.0)", "Chance for Butcher's Cleaver accessory to trigger head drops (0.0-1.0)"}).defineInRange("butchersCleaverDropChance", 0.1, 0.0, 1.0);
        RUBY_HEART_COOLDOWN = BUILDER.comment(new String[]{"\u7ea2\u5b9d\u77f3\u4e4b\u5fc3\u89e6\u53d1\u540e\u7684\u51b7\u5374\u65f6\u95f4\uff08\u4ee5\u79d2\u4e3a\u5355\u4f4d\uff09", "Ruby Heart cooldown after activation (in seconds)"}).defineInRange("rubyHeartCooldown", 60, 1, 3600);
        RUBY_HEART_HEALTH_THRESHOLD = BUILDER.comment(new String[]{"\u7ea2\u5b9d\u77f3\u4e4b\u5fc3\u89e6\u53d1\u6240\u9700\u7684\u751f\u547d\u503c\u9608\u503c\uff08\u5360\u6700\u5927\u751f\u547d\u503c\u7684\u767e\u5206\u6bd4\uff0c0.0-1.0\uff09", "Ruby Heart activation health threshold (percentage of max health, 0.0-1.0)"}).defineInRange("rubyHeartHealthThreshold", 0.3, 0.0, 1.0);
        ROCK_CANDY_SPEED_MULTIPLIER = BUILDER.comment(new String[]{"\u6c34\u6676\u7cd6\u9970\u54c1\u7684\u79fb\u52a8\u901f\u5ea6\u500d\u7387\uff081.0 = \u57fa\u7840\u901f\u5ea6\u7ffb\u500d\uff09", "Rock Candy accessory movement speed multiplier (1.0 = double base speed)"}).defineInRange("rockCandySpeedMultiplier", 1.0, 0.0, 5.0);
        ROCK_CANDY_DAMAGE_MULTIPLIER = BUILDER.comment(new String[]{"\u6c34\u6676\u7cd6\u9970\u54c1\u53d7\u5230\u7684\u4f24\u5bb3\u500d\u7387\uff082.0 = \u4f24\u5bb3\u7ffb\u500d\uff09", "Rock Candy accessory damage taken multiplier (2.0 = double damage)"}).defineInRange("rockCandyDamageMultiplier", 2.0, 1.0, 5.0);
        BUILDER.pop();
        BUILDER.push("Treasure Bag Settings").comment(new String[]{"\u5b9d\u85cf\u888b\u76f8\u5173\u914d\u7f6e", "Treasure Bag Configuration"});
        TREASURE_BAG_ITEMS = BUILDER.comment(new String[]{"\u5b9d\u85cf\u888b\u53ef\u80fd\u6389\u843d\u7684\u7269\u54c1\u5217\u8868", "List of possible items from treasure bags", "", "\u683c\u5f0f\uff1amodid:\u7269\u54c1ID,\u6743\u91cd", "Format: modid:item_id,weight", "", "\u793a\u4f8b\uff1aminecraft:diamond,10", "Example: minecraft:diamond,10", "", "\u5982\u679c\u6743\u91cd\u76f8\u540c\uff0c\u7269\u54c1\u6389\u843d\u6982\u7387\u76f8\u7b49", "Items will have equal chances if weights are the same"}).define("possible_items", (Object)"bountifulbaubles:minds_eye,10;bountifulbaubles:luck_coin,10;bountifulbaubles:dragon_breath,10;bountifulbaubles:ice_shard,10;bountifulbaubles:tha_spider,10;bountifulbaubles:creepo,10;bountifulbaubles:tha_wizard,10;bountifulbaubles:book_o_enchanting,10;bountifulbaubles:warm_void,10;bountifulbaubles:golden_melon,10;bountifulbaubles:fire_mind,10;bountifulbaubles:drop_spindle,10;bountifulbaubles:dark_egg,10;bountifulbaubles:mossy_ring,10;bountifulbaubles:mossy_belt,10;bountifulbaubles:mad_aura,10;bountifulbaubles:turtle_shell,10;bountifulbaubles:dark_dagger,10;bountifulbaubles:ember,10;bountifulbaubles:wither_nail,10;bountifulbaubles:serpent_tooth,10;bountifulbaubles:blaze_heart,10;bountifulbaubles:starfish,10;bountifulbaubles:golden_skull,10;bountifulbaubles:butchers_cleaver,10;bountifulbaubles:karma,10;bountifulbaubles:oxalis,10;bountifulbaubles:glory_shards,10;bountifulbaubles:ruby_heart,10;bountifulbaubles:rock_candy,10");
        BUILDER.pop();
        BUILDER.push("Loot Settings").comment(new String[]{"\u914d\u7f6e\u683c\u5f0f\uff1a\u7269\u54c1ID,\u6743\u91cd,\u6700\u5c0f\u6570\u91cf,\u6700\u5927\u6570\u91cf;\u591a\u4e2a\u7269\u54c1\u7528\u5206\u53f7\u5206\u9694", "Format: itemID,weight,minCount,maxCount;multiple items separated by semicolons"});
        DESERT_PYRAMID_LOOT = ModConfig.defineLoot("desertPyramid", "minecraft:chests/desert_pyramid", "\u6c99\u6f20\u795e\u6bbf\u6218\u5229\u54c1", "bountifulbaubles:potion_wormhole,6,1,2;bountifulbaubles:potion_recall,7,1,3;bountifulbaubles:magic_mirror,2,1,2;bountifulbaubles:broken_black_dragon_scale,2,1,2;bountifulbaubles:spectral_silt,8,1,7;bountifulbaubles:broken_heart,1,1,2;bountifulbaubles:lucky_horseshoe,1,1,2;bountifulbaubles:bottled_cloud,1,1,2;bountifulbaubles:endless_pearl,1,1,2;bountifulbaubles:treasure_bag,2,1,2");
        JUNGLE_TEMPLE_LOOT = ModConfig.defineLoot("jungleTemple", "minecraft:chests/jungle_temple", "\u4e1b\u6797\u795e\u5e99\u6218\u5229\u54c1", "bountifulbaubles:potion_wormhole,6,1,2;bountifulbaubles:potion_recall,7,1,2;bountifulbaubles:magic_mirror,2,1,2;bountifulbaubles:broken_black_dragon_scale,2,1,2;bountifulbaubles:spectral_silt,8,1,7;bountifulbaubles:curious_amulet,3,1,2;bountifulbaubles:curious_ring,3,1,2;bountifulbaubles:vampiric_glove,1,1,2;bountifulbaubles:gauntlets_dexterity,2,1,2;bountifulbaubles:treasure_bag,2,1,2");
        ABANDONED_MINESHAFT_LOOT = ModConfig.defineLoot("abandonedMineshaft", "minecraft:chests/abandoned_mineshaft", "\u5e9f\u5f03\u77ff\u4e95\u6218\u5229\u54c1", "bountifulbaubles:potion_wormhole,6,1,2;bountifulbaubles:potion_recall,7,1,2;bountifulbaubles:magic_mirror,2,1,2;bountifulbaubles:broken_black_dragon_scale,2,1,2;bountifulbaubles:spectral_silt,8,1,7;bountifulbaubles:sunglasses,3,1,2;bountifulbaubles:curious_crown,3,1,2;bountifulbaubles:auto_torch,3,1,2;bountifulbaubles:treasure_bag,2,1,2");
        STRONGHOLD_LIBRARY_LOOT = ModConfig.defineLoot("strongholdLibrary", "minecraft:chests/stronghold_library", "\u8981\u585e\u56fe\u4e66\u9986\u6218\u5229\u54c1", "bountifulbaubles:potion_wormhole,6,1,2;bountifulbaubles:potion_recall,7,1,2;bountifulbaubles:magic_mirror,2,1,2;bountifulbaubles:broken_black_dragon_scale,2,1,2;bountifulbaubles:spectral_silt,8,1,7;bountifulbaubles:treasure_bag,2,1,2");
        WOODLAND_MANSION_LOOT = ModConfig.defineLoot("woodlandMansion", "minecraft:chests/woodland_mansion", "\u6797\u5730\u5e9c\u90b8\u6218\u5229\u54c1", "bountifulbaubles:potion_wormhole,6,1,2;bountifulbaubles:potion_recall,7,1,2;bountifulbaubles:magic_mirror,2,1,2;bountifulbaubles:broken_black_dragon_scale,2,1,2;bountifulbaubles:spectral_silt,8,1,7;bountifulbaubles:treasure_bag,2,1,2");
        VILLAGE_TEMPLE_LOOT = ModConfig.defineLoot("villageTemple", "minecraft:chests/village/village_temple", "\u6751\u5e84\u6559\u5802\u6218\u5229\u54c1", "bountifulbaubles:potion_wormhole,6,1,2;bountifulbaubles:potion_recall,7,1,2;bountifulbaubles:magic_mirror,2,1,2;bountifulbaubles:broken_black_dragon_scale,2,1,2;bountifulbaubles:spectral_silt,8,1,7;bountifulbaubles:treasure_bag,2,1,2");
        SHIPWRECK_TREASURE_LOOT = ModConfig.defineLoot("shipwreckTreasure", "minecraft:chests/shipwreck_treasure", "\u6c89\u8239\u5b9d\u7bb1\u6218\u5229\u54c1", "bountifulbaubles:potion_wormhole,6,1,2;bountifulbaubles:potion_recall,7,1,2;bountifulbaubles:magic_mirror,2,1,2;bountifulbaubles:broken_black_dragon_scale,2,1,2;bountifulbaubles:spectral_silt,8,1,7;bountifulbaubles:treasure_bag,2,1,2");
        PILLAGER_OUTPOST_LOOT = ModConfig.defineLoot("pillagerOutpost", "minecraft:chests/pillager_outpost", "\u63a0\u593a\u8005\u524d\u54e8\u7ad9\u6218\u5229\u54c1", "bountifulbaubles:potion_wormhole,6,1,2;bountifulbaubles:potion_recall,7,1,2;bountifulbaubles:magic_mirror,2,1,2;bountifulbaubles:broken_black_dragon_scale,2,1,2;bountifulbaubles:spectral_silt,8,1,7;bountifulbaubles:black_dragon_scale,3,1,2;bountifulbaubles:phylactery_charm,1,1,2;bountifulbaubles:treasure_bag,2,1,2");
        BURIED_TREASURE_LOOT = ModConfig.defineLoot("buriedTreasure", "minecraft:chests/buried_treasure", "\u57cb\u85cf\u7684\u5b9d\u85cf\u6218\u5229\u54c1", "bountifulbaubles:potion_wormhole,6,1,2;bountifulbaubles:potion_recall,6,1,2;bountifulbaubles:wormhole_mirror,1,1,2;bountifulbaubles:broken_black_dragon_scale,2,1,2;bountifulbaubles:spectral_silt,8,1,7;bountifulbaubles:treasure_bag,2,1,2");
        UNDERWATER_RUIN_BIG_LOOT = ModConfig.defineLoot("underwaterRuinBig", "minecraft:chests/underwater_ruin_big", "\u5927\u578b\u6d77\u5e95\u5e9f\u589f\u6218\u5229\u54c1", "bountifulbaubles:potion_wormhole,6,1,2;bountifulbaubles:potion_recall,3,1,2;bountifulbaubles:magic_mirror,2,1,2;bountifulbaubles:broken_black_dragon_scale,2,1,2;bountifulbaubles:spectral_silt,8,1,7;bountifulbaubles:treasure_bag,2,1,2");
        UNDERWATER_RUIN_SMALL_LOOT = ModConfig.defineLoot("underwaterRuinSmall", "minecraft:chests/underwater_ruin_small", "\u5c0f\u578b\u6d77\u5e95\u5e9f\u589f\u6218\u5229\u54c1", "bountifulbaubles:potion_wormhole,6,1,2;bountifulbaubles:potion_recall,7,1,2;bountifulbaubles:magic_mirror,2,1,2;bountifulbaubles:broken_black_dragon_scale,2,1,2;bountifulbaubles:spectral_silt,8,1,7;bountifulbaubles:treasure_bag,2,1,2");
        IGLOO_CHEST_LOOT = ModConfig.defineLoot("iglooChest", "minecraft:chests/igloo_chest", "\u96ea\u5c4b\u5730\u4e0b\u5ba4\u6218\u5229\u54c1", "bountifulbaubles:potion_wormhole,6,1,2;bountifulbaubles:potion_recall,7,1,2;bountifulbaubles:magic_mirror,2,1,2;bountifulbaubles:broken_black_dragon_scale,2,1,2;bountifulbaubles:spectral_silt,8,1,7;bountifulbaubles:treasure_bag,2,1,2");
        SIMPLE_DUNGEON_LOOT = ModConfig.defineLoot("simpleDungeon", "minecraft:chests/simple_dungeon", "\u5c0f\u578b\u5730\u7262\u6218\u5229\u54c1", "bountifulbaubles:potion_wormhole,6,1,2;bountifulbaubles:potion_recall,7,1,2;bountifulbaubles:magic_mirror,2,1,2;bountifulbaubles:broken_black_dragon_scale,2,1,2;bountifulbaubles:spectral_silt,8,1,7;bountifulbaubles:balloon,3,1,1;bountifulbaubles:cobalt_shield,3,1,1;bountifulbaubles:auto_torch,3,1,2;bountifulbaubles:treasure_bag,2,1,2");
        STRONGHOLD_CORRIDOR_LOOT = ModConfig.defineLoot("strongholdCorridor", "minecraft:chests/stronghold_corridor", "\u8981\u585e\u8d70\u5eca\u6218\u5229\u54c1", "bountifulbaubles:potion_wormhole,6,1,2;bountifulbaubles:potion_recall,7,1,2;bountifulbaubles:magic_mirror,2,1,2;bountifulbaubles:broken_black_dragon_scale,2,1,2;bountifulbaubles:spectral_silt,8,1,7;bountifulbaubles:treasure_bag,2,1,2");
        FOSSIL_DINOSAUR_LOOT = ModConfig.defineLoot("fossilDinosaur", "minecraft:chests/fossil_dinosaur", "\u6050\u9f99\u5316\u77f3\u6218\u5229\u54c1", "");
        FOSSIL_MAMMAL_LOOT = ModConfig.defineLoot("fossilMammal", "minecraft:chests/fossil_mammal", "\u54fa\u4e73\u52a8\u7269\u5316\u77f3\u6218\u5229\u54c1", "");
        SHIPWRECK_SUPPLY_LOOT = ModConfig.defineLoot("shipwreckSupply", "minecraft:chests/shipwreck_supply", "\u6c89\u8239\u8865\u7ed9\u7bb1\u6218\u5229\u54c1", "bountifulbaubles:potion_wormhole,3,1,2;bountifulbaubles:potion_recall,3,1,2;bountifulbaubles:magic_mirror,2,1,2;bountifulbaubles:broken_black_dragon_scale,2,1,2;bountifulbaubles:spectral_silt,8,1,7;bountifulbaubles:treasure_bag,2,1,2");
        WOODLAND_CARTOGRAPHY_LOOT = ModConfig.defineLoot("woodlandCartography", "minecraft:chests/woodland_mansion_cartography", "\u6797\u5730\u5e9c\u90b8\u5236\u56fe\u5ba4\u6218\u5229\u54c1", "bountifulbaubles:potion_wormhole,3,1,2;bountifulbaubles:potion_recall,3,1,2;bountifulbaubles:magic_mirror,2,1,2;bountifulbaubles:broken_black_dragon_scale,2,1,2;bountifulbaubles:spectral_silt,8,1,7;bountifulbaubles:treasure_bag,2,1,2");
        STRONGHOLD_CROSSING_LOOT = ModConfig.defineLoot("strongholdCrossing", "minecraft:chests/stronghold_crossing", "\u8981\u585e\u5341\u5b57\u8def\u53e3\u6218\u5229\u54c1", "bountifulbaubles:potion_wormhole,3,1,2;bountifulbaubles:potion_recall,3,1,2;bountifulbaubles:magic_mirror,2,1,2;bountifulbaubles:broken_black_dragon_scale,2,1,2;bountifulbaubles:spectral_silt,8,1,7;bountifulbaubles:treasure_bag,2,1,2");
        SHIPWRECK_MAP_LOOT = ModConfig.defineLoot("shipwreckMap", "minecraft:chests/shipwreck_map", "\u6c89\u8239\u5730\u56fe\u7bb1\u6218\u5229\u54c1", "bountifulbaubles:potion_wormhole,3,1,2;bountifulbaubles:potion_recall,3,1,2;bountifulbaubles:magic_mirror,2,1,2;bountifulbaubles:broken_black_dragon_scale,2,1,2;bountifulbaubles:spectral_silt,8,1,7;bountifulbaubles:treasure_bag,2,1,2");
        BASTION_TREASURE_LOOT = ModConfig.defineLoot("bastionTreasure", "minecraft:chests/bastion_treasure", "\u5821\u5792\u9057\u8ff9\u5b9d\u85cf\u5ba4\u6218\u5229\u54c1", "bountifulbaubles:potion_wormhole,6,1,2;bountifulbaubles:potion_recall,7,1,2;bountifulbaubles:magic_mirror,2,1,2;bountifulbaubles:broken_black_dragon_scale,2,1,2;bountifulbaubles:spectral_silt,8,1,7;bountifulbaubles:amulet_sin_empty,8,1,7;bountifulbaubles:curious_knuckles,2,1,1;bountifulbaubles:treasure_bag,2,1,2");
        BASTION_BRIDGE_LOOT = ModConfig.defineLoot("bastionBridge", "minecraft:chests/bastion_bridge", "\u5821\u5792\u9057\u8ff9\u6865\u6881\u6218\u5229\u54c1", "bountifulbaubles:potion_wormhole,6,1,2;bountifulbaubles:potion_recall,7,1,2;bountifulbaubles:magic_mirror,2,1,2;bountifulbaubles:broken_black_dragon_scale,2,1,2;bountifulbaubles:spectral_silt,8,1,7;bountifulbaubles:amulet_sin_empty,5,1,3;bountifulbaubles:curious_knuckles,2,1,1;bountifulbaubles:treasure_bag,2,1,2");
        BASTION_HOUSING_LOOT = ModConfig.defineLoot("bastionHousing", "minecraft:chests/bastion_housing", "\u5821\u5792\u9057\u8ff9\u5c45\u4f4f\u533a\u6218\u5229\u54c1", "bountifulbaubles:potion_wormhole,6,1,2;bountifulbaubles:potion_recall,7,1,2;bountifulbaubles:magic_mirror,2,1,2;bountifulbaubles:broken_black_dragon_scale,2,1,2;bountifulbaubles:spectral_silt,8,1,7;bountifulbaubles:amulet_sin_empty,5,1,3;bountifulbaubles:curious_knuckles,2,1,1;bountifulbaubles:treasure_bag,2,1,2");
        BASTION_OTHER_LOOT = ModConfig.defineLoot("bastionOther", "minecraft:chests/bastion_other", "\u5821\u5792\u9057\u8ff9\u6742\u9879\u6218\u5229\u54c1", "bountifulbaubles:potion_wormhole,6,1,2;bountifulbaubles:potion_recall,7,1,2;bountifulbaubles:magic_mirror,2,1,2;bountifulbaubles:broken_black_dragon_scale,2,1,2;bountifulbaubles:spectral_silt,8,1,7;bountifulbaubles:amulet_sin_empty,5,1,3;bountifulbaubles:curious_knuckles,2,1,1;bountifulbaubles:treasure_bag,2,1,2");
        RUINED_PORTAL_LOOT = ModConfig.defineLoot("ruinedPortal", "minecraft:chests/ruined_portal", "\u5e9f\u5f03\u4f20\u9001\u95e8\u6218\u5229\u54c1", "bountifulbaubles:potion_wormhole,6,1,2;bountifulbaubles:potion_recall,7,1,2;bountifulbaubles:magic_mirror,2,1,2;bountifulbaubles:broken_black_dragon_scale,2,1,2;bountifulbaubles:spectral_silt,8,1,7;bountifulbaubles:obsidian_skull,3,1,2;bountifulbaubles:auto_torch,3,1,2;bountifulbaubles:treasure_bag,2,1,2");
        END_CITY_LOOT = ModConfig.defineLoot("endCity", "minecraft:chests/end_city_treasure", "\u672b\u5730\u57ce\u6218\u5229\u54c1", "bountifulbaubles:wrath_pendant,5,1,3;bountifulbaubles:gluttony_pendant,3,1,2;bountifulbaubles:pride_pendant,3,1,2;bountifulbaubles:treasure_bag,2,1,2");
        ANCIENT_CITY_LOOT = ModConfig.defineLoot("ancientCity", "minecraft:chests/ancient_city", "\u8fdc\u53e4\u57ce\u5e02\u6218\u5229\u54c1", "bountifulbaubles:wrath_pendant,5,1,3;bountifulbaubles:gluttony_pendant,3,1,2;bountifulbaubles:pride_pendant,3,1,2;bountifulbaubles:cross_necklace,3,1,2;bountifulbaubles:treasure_bag,2,1,2");
        VILLAGE_ARMORER_LOOT = ModConfig.defineLoot("villageArmorer", "minecraft:chests/village/village_armorer", "\u76d4\u7532\u5320\u5c0f\u5c4b (\u76d4\u7532\u5320)", "");
        VILLAGE_BUTCHER_LOOT = ModConfig.defineLoot("villageButcher", "minecraft:chests/village/village_butcher", "\u5c60\u592b\u5546\u5e97 (\u5c60\u592b)", "");
        VILLAGE_CARTOGRAPHER_LOOT = ModConfig.defineLoot("villageCartographer", "minecraft:chests/village/village_cartographer", "\u5236\u56fe\u5e08\u5c0f\u5c4b (\u5236\u56fe\u5e08)", "");
        VILLAGE_PLAINS_HOUSE_LOOT = ModConfig.defineLoot("villagePlainsHouse", "minecraft:chests/village/village_plains_house", "\u5e73\u539f\u519c\u820d (\u519c\u6c11)", "");
        VILLAGE_FISHER_LOOT = ModConfig.defineLoot("villageFisher", "minecraft:chests/village/village_fisher", "\u6e14\u592b\u5c0f\u5c4b (\u6e14\u592b)", "");
        VILLAGE_FLETCHER_LOOT = ModConfig.defineLoot("villageFletcher", "minecraft:chests/village/village_fletcher", "\u5236\u7bad\u5e08\u5c0f\u5c4b (\u5236\u7bad\u5e08)", "");
        VILLAGE_TANNERY_LOOT = ModConfig.defineLoot("villageTannery", "minecraft:chests/village/village_tannery", "\u5236\u9769\u5382 (\u76ae\u5320)", "");
        VILLAGE_LIBRARY_LOOT = ModConfig.defineLoot("villageLibrary", "minecraft:chests/village/village_library", "\u56fe\u4e66\u9986 (\u56fe\u4e66\u7ba1\u7406\u5458)", "");
        VILLAGE_MASON_LOOT = ModConfig.defineLoot("villageMason", "minecraft:chests/village/village_mason", "\u77f3\u5320\u5c0f\u5c4b (\u77f3\u5320)", "");
        VILLAGE_SHEPHERD_LOOT = ModConfig.defineLoot("villageShepherd", "minecraft:chests/village/village_shepherd", "\u7267\u7f8a\u4eba\u5c0f\u5c4b (\u7267\u7f8a\u4eba)", "");
        VILLAGE_TOOLSMITH_LOOT = ModConfig.defineLoot("villageToolsmith", "minecraft:chests/village/village_toolsmith", "\u5de5\u5177\u5320\u5c0f\u5c4b (\u5de5\u5177\u5320)", "");
        VILLAGE_WEAPONSMITH_LOOT = ModConfig.defineLoot("villageWeaponsmith", "minecraft:chests/village/village_weaponsmith", "\u6b66\u5668\u5320\u5c0f\u5c4b (\u6b66\u5668\u5320)", "");
        VILLAGE_DESERT_HOUSE_LOOT = ModConfig.defineLoot("villageDesertHouse", "minecraft:chests/village/village_desert_house", "\u6c99\u6f20\u6751\u5e84\u623f\u5c4b (\u5931\u4e1a\u6751\u6c11)", "");
        VILLAGE_SNOWY_HOUSE_LOOT = ModConfig.defineLoot("villageSnowyHouse", "minecraft:chests/village/village_snowy_house", "\u96ea\u539f\u6751\u5e84\u623f\u5c4b", "");
        VILLAGE_SAVANNA_HOUSE_LOOT = ModConfig.defineLoot("villageSavannaHouse", "minecraft:chests/village/village_savanna_house", "\u70ed\u5e26\u8349\u539f\u6751\u5e84\u623f\u5c4b", "");
        VILLAGE_TAIGA_HOUSE_LOOT = ModConfig.defineLoot("villageTaigaHouse", "minecraft:chests/village/village_taiga_house", "\u9488\u53f6\u6797\u6751\u5e84\u623f\u5c4b", "");
        BUILDER.pop();
        SPEC = BUILDER.build();
        LOOT_MAPPING = new HashMap<ResourceLocation, ForgeConfigSpec.ConfigValue<String>>();
        LOOT_MAPPING.put(new ResourceLocation("minecraft:chests/desert_pyramid"), DESERT_PYRAMID_LOOT);
        LOOT_MAPPING.put(new ResourceLocation("minecraft:chests/jungle_temple"), JUNGLE_TEMPLE_LOOT);
        LOOT_MAPPING.put(new ResourceLocation("minecraft:chests/abandoned_mineshaft"), ABANDONED_MINESHAFT_LOOT);
        LOOT_MAPPING.put(new ResourceLocation("minecraft:chests/stronghold_library"), STRONGHOLD_LIBRARY_LOOT);
        LOOT_MAPPING.put(new ResourceLocation("minecraft:chests/woodland_mansion"), WOODLAND_MANSION_LOOT);
        LOOT_MAPPING.put(new ResourceLocation("minecraft:chests/village/village_temple"), VILLAGE_TEMPLE_LOOT);
        LOOT_MAPPING.put(new ResourceLocation("minecraft:chests/shipwreck_treasure"), SHIPWRECK_TREASURE_LOOT);
        LOOT_MAPPING.put(new ResourceLocation("minecraft:chests/pillager_outpost"), PILLAGER_OUTPOST_LOOT);
        LOOT_MAPPING.put(new ResourceLocation("minecraft:chests/buried_treasure"), BURIED_TREASURE_LOOT);
        LOOT_MAPPING.put(new ResourceLocation("minecraft:chests/underwater_ruin_big"), UNDERWATER_RUIN_BIG_LOOT);
        LOOT_MAPPING.put(new ResourceLocation("minecraft:chests/underwater_ruin_small"), UNDERWATER_RUIN_SMALL_LOOT);
        LOOT_MAPPING.put(new ResourceLocation("minecraft:chests/igloo_chest"), IGLOO_CHEST_LOOT);
        LOOT_MAPPING.put(new ResourceLocation("minecraft:chests/bastion_treasure"), BASTION_TREASURE_LOOT);
        LOOT_MAPPING.put(new ResourceLocation("minecraft:chests/bastion_bridge"), BASTION_BRIDGE_LOOT);
        LOOT_MAPPING.put(new ResourceLocation("minecraft:chests/bastion_housing"), BASTION_HOUSING_LOOT);
        LOOT_MAPPING.put(new ResourceLocation("minecraft:chests/bastion_other"), BASTION_OTHER_LOOT);
        LOOT_MAPPING.put(new ResourceLocation("minecraft:chests/ruined_portal"), RUINED_PORTAL_LOOT);
        LOOT_MAPPING.put(new ResourceLocation("minecraft:chests/end_city_treasure"), END_CITY_LOOT);
        LOOT_MAPPING.put(new ResourceLocation("minecraft:chests/ancient_city"), ANCIENT_CITY_LOOT);
        LOOT_MAPPING.put(new ResourceLocation("minecraft:chests/simple_dungeon"), SIMPLE_DUNGEON_LOOT);
        LOOT_MAPPING.put(new ResourceLocation("minecraft:chests/stronghold_corridor"), STRONGHOLD_CORRIDOR_LOOT);
        LOOT_MAPPING.put(new ResourceLocation("minecraft:chests/fossil_dinosaur"), FOSSIL_DINOSAUR_LOOT);
        LOOT_MAPPING.put(new ResourceLocation("minecraft:chests/fossil_mammal"), FOSSIL_MAMMAL_LOOT);
        LOOT_MAPPING.put(new ResourceLocation("minecraft:chests/shipwreck_supply"), SHIPWRECK_SUPPLY_LOOT);
        LOOT_MAPPING.put(new ResourceLocation("minecraft:chests/woodland_mansion_cartography"), WOODLAND_CARTOGRAPHY_LOOT);
        LOOT_MAPPING.put(new ResourceLocation("minecraft:chests/stronghold_crossing"), STRONGHOLD_CROSSING_LOOT);
        LOOT_MAPPING.put(new ResourceLocation("minecraft:chests/shipwreck_map"), SHIPWRECK_MAP_LOOT);
        LOOT_MAPPING.put(new ResourceLocation("minecraft:chests/village/village_armorer"), VILLAGE_ARMORER_LOOT);
        LOOT_MAPPING.put(new ResourceLocation("minecraft:chests/village/village_butcher"), VILLAGE_BUTCHER_LOOT);
        LOOT_MAPPING.put(new ResourceLocation("minecraft:chests/village/village_cartographer"), VILLAGE_CARTOGRAPHER_LOOT);
        LOOT_MAPPING.put(new ResourceLocation("minecraft:chests/village/village_plains_house"), VILLAGE_PLAINS_HOUSE_LOOT);
        LOOT_MAPPING.put(new ResourceLocation("minecraft:chests/village/village_fisher"), VILLAGE_FISHER_LOOT);
        LOOT_MAPPING.put(new ResourceLocation("minecraft:chests/village/village_fletcher"), VILLAGE_FLETCHER_LOOT);
        LOOT_MAPPING.put(new ResourceLocation("minecraft:chests/village/village_tannery"), VILLAGE_TANNERY_LOOT);
        LOOT_MAPPING.put(new ResourceLocation("minecraft:chests/village/village_library"), VILLAGE_LIBRARY_LOOT);
        LOOT_MAPPING.put(new ResourceLocation("minecraft:chests/village/village_mason"), VILLAGE_MASON_LOOT);
        LOOT_MAPPING.put(new ResourceLocation("minecraft:chests/village/village_shepherd"), VILLAGE_SHEPHERD_LOOT);
        LOOT_MAPPING.put(new ResourceLocation("minecraft:chests/village/village_toolsmith"), VILLAGE_TOOLSMITH_LOOT);
        LOOT_MAPPING.put(new ResourceLocation("minecraft:chests/village/village_weaponsmith"), VILLAGE_WEAPONSMITH_LOOT);
        LOOT_MAPPING.put(new ResourceLocation("minecraft:chests/village/village_desert_house"), VILLAGE_DESERT_HOUSE_LOOT);
        LOOT_MAPPING.put(new ResourceLocation("minecraft:chests/village/village_snowy_house"), VILLAGE_SNOWY_HOUSE_LOOT);
        LOOT_MAPPING.put(new ResourceLocation("minecraft:chests/village/village_savanna_house"), VILLAGE_SAVANNA_HOUSE_LOOT);
        LOOT_MAPPING.put(new ResourceLocation("minecraft:chests/village/village_taiga_house"), VILLAGE_TAIGA_HOUSE_LOOT);
        lootConfig = new HashMap<ResourceLocation, List<LootEntry>>();
    }

    public static class LootEntry {
        public final ResourceLocation itemId;
        public final int weight;
        public final int minRolls;
        public final int maxRolls;

        public LootEntry(ResourceLocation itemId, int weight, int minRolls, int maxRolls) {
            this.itemId = itemId;
            this.weight = weight;
            this.minRolls = minRolls;
            this.maxRolls = maxRolls;
        }
    }
}

