/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.bountifulbaubles.event.listener;

import com.jinqinxixi.bountifulbaubles.config.ModConfig;
import com.jinqinxixi.bountifulbaubles.item.Baubles.AnkhShieldItem;
import com.jinqinxixi.bountifulbaubles.item.Baubles.CobaltShieldItem;
import com.jinqinxixi.bountifulbaubles.item.Baubles.GluttonyPendantItem;
import com.jinqinxixi.bountifulbaubles.item.Baubles.InfiniteTotemOfUndyingItem;
import com.jinqinxixi.bountifulbaubles.item.Baubles.ObsidianShieldItem;
import com.jinqinxixi.bountifulbaubles.item.Baubles.WrathPendantItem;
import com.jinqinxixi.bountifulbaubles.system.effect.ModEffects;
import com.jinqinxixi.bountifulbaubles.util.CuriosUtil;
import java.util.Map;
import java.util.Optional;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;

@Mod.EventBusSubscriber(modid="bountifulbaubles")
public class ModEvents {
    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        if (event.getEntity().m_9236_().m_5776_()) {
            return;
        }
        ModEvents.handleFireResistance(event);
    }

    @SubscribeEvent
    public static void onCriticalHit(CriticalHitEvent event) {
        if (event.getResult() != Event.Result.DENY) {
            ModEvents.handleCriticalHit(event.getEntity());
        }
    }

    @SubscribeEvent
    public static void onItemUseStart(LivingEntityUseItemEvent.Start event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (event.getItem().m_41614_() && ModEvents.hasCurioItem(player, GluttonyPendantItem.class)) {
                event.setDuration((int)((float)event.getDuration() * 0.5f));
            }
        }
    }

    @SubscribeEvent
    public static void onItemUseFinish(LivingEntityUseItemEvent.Finish event) {
        Player player;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && ModEvents.hasCurioItem(player = (Player)livingEntity, GluttonyPendantItem.class)) {
            ModEvents.applySinfulEffect(player, event.getItem());
        }
    }

    @SubscribeEvent
    public static void onLivingKnockBack(LivingKnockBackEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            ModEvents.handleKnockbackImmunity(player, event);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onPlayerDeath(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (!player.m_9236_().f_46443_) {
                boolean hasTotem;
                boolean bl = hasTotem = CuriosUtil.hasCurioItem(player, InfiniteTotemOfUndyingItem.class) || ModEvents.isHoldingTotem(player);
                if (hasTotem && InfiniteTotemOfUndyingItem.isReady(player)) {
                    event.setCanceled(true);
                    ItemStack totemStack = CuriosUtil.findCurioItemStack(player, InfiniteTotemOfUndyingItem.class).orElseGet(() -> ModEvents.findHeldTotem(player));
                    InfiniteTotemOfUndyingItem.triggerTotemEffects(player, totemStack);
                    InfiniteTotemOfUndyingItem.startCooldown(player);
                }
            }
        }
    }

    private static boolean isHoldingTotem(Player player) {
        return player.m_21205_().m_41720_() instanceof InfiniteTotemOfUndyingItem || player.m_21206_().m_41720_() instanceof InfiniteTotemOfUndyingItem;
    }

    private static ItemStack findHeldTotem(Player player) {
        ItemStack mainHand = player.m_21205_();
        return mainHand.m_41720_() instanceof InfiniteTotemOfUndyingItem ? mainHand : player.m_21206_();
    }

    private static void handleCriticalHit(Player player) {
        LazyOptional optional = player.getCapability(CuriosCapability.INVENTORY);
        optional.ifPresent(handler -> {
            for (Map.Entry entry : handler.getCurios().entrySet()) {
                for (int i = 0; i < ((ICurioStacksHandler)entry.getValue()).getSlots(); ++i) {
                    ItemStack stack = ((ICurioStacksHandler)entry.getValue()).getStacks().getStackInSlot(i);
                    if (!(stack.m_41720_() instanceof WrathPendantItem)) continue;
                    int buffLevel = ModConfig.getWrathPendantBuffLevel();
                    int buffDuration = ModConfig.getWrathPendantBuffDuration();
                    player.m_7292_(new MobEffectInstance((MobEffect)ModEffects.SINFUL.get(), buffDuration, buffLevel, false, true));
                    return;
                }
            }
        });
    }

    private static void handleFireResistance(LivingHurtEvent event) {
        LivingEntity livingEntity;
        DamageSource source = event.getSource();
        if (ModEvents.isFireDamage(source) && (livingEntity = event.getEntity()) instanceof Player) {
            boolean hasProtection;
            Player player = (Player)livingEntity;
            boolean bl = hasProtection = ModEvents.hasShieldInHand(player) || ModEvents.hasCurioItem(player, ObsidianShieldItem.class) || ModEvents.hasCurioItem(player, AnkhShieldItem.class);
            if (hasProtection) {
                event.setAmount(event.getAmount() * 0.5f);
            }
        }
    }

    private static void handleKnockbackImmunity(Player player, LivingKnockBackEvent event) {
        boolean isBlocking;
        boolean isHolding = ModEvents.hasShieldInHand(player);
        boolean hasCurio = ModEvents.hasCurioItem(player, CobaltShieldItem.class) || ModEvents.hasCurioItem(player, ObsidianShieldItem.class) || ModEvents.hasCurioItem(player, AnkhShieldItem.class);
        boolean bl = isBlocking = player.m_21254_() && isHolding;
        if (isHolding || hasCurio || isBlocking) {
            event.setCanceled(true);
            if (isHolding) {
                ModEvents.consumeHandheldShield(player);
            }
        }
    }

    private static boolean hasShieldInHand(Player player) {
        return ModEvents.isShieldItem(player.m_21205_()) || ModEvents.isShieldItem(player.m_21206_());
    }

    private static boolean isShieldItem(ItemStack stack) {
        return stack.m_41720_() instanceof CobaltShieldItem || stack.m_41720_() instanceof ObsidianShieldItem || stack.m_41720_() instanceof AnkhShieldItem;
    }

    private static void consumeHandheldShield(Player player) {
        if (ModEvents.isShieldItem(player.m_21205_())) {
            player.m_21205_().m_41622_(1, (LivingEntity)player, p -> p.m_21190_(InteractionHand.MAIN_HAND));
        } else if (ModEvents.isShieldItem(player.m_21206_())) {
            player.m_21206_().m_41622_(1, (LivingEntity)player, p -> p.m_21190_(InteractionHand.OFF_HAND));
        }
    }

    public static <T extends Item> boolean hasCurioItem(Player player, Class<T> itemClass) {
        LazyOptional optional = player.getCapability(CuriosCapability.INVENTORY);
        if (!optional.isPresent()) {
            return false;
        }
        ICuriosItemHandler handler = (ICuriosItemHandler)optional.resolve().get();
        for (Map.Entry entry : handler.getCurios().entrySet()) {
            ICurioStacksHandler stacksHandler = (ICurioStacksHandler)entry.getValue();
            for (int i = 0; i < stacksHandler.getSlots(); ++i) {
                if (!itemClass.isInstance(stacksHandler.getStacks().getStackInSlot(i).m_41720_())) continue;
                return true;
            }
        }
        return false;
    }

    private static void applySinfulEffect(Player player, ItemStack foodStack) {
        Optional.ofNullable(foodStack.m_41720_().m_41473_()).ifPresent(food -> {
            int level = ModEvents.calculateSinLevel(food.m_38744_(), food.m_38745_()) - 2;
            if (level >= 0) {
                player.m_7292_(new MobEffectInstance((MobEffect)ModEffects.SINFUL.get(), 200, level, false, true));
            }
        });
    }

    public static int calculateSinLevel(int hunger, float saturation) {
        return (int)Math.floor((double)hunger / 4.0 + (double)saturation / 6.0 + 1.0);
    }

    private static boolean isFireDamage(DamageSource source) {
        return source.m_276093_(DamageTypes.f_268631_) || source.m_276093_(DamageTypes.f_268684_) || source.m_276093_(DamageTypes.f_268468_);
    }
}

