/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.bountifulbaubles.item.Baubles;

import com.jinqinxixi.bountifulbaubles.system.modifier.ModifiableBaubleItem;
import com.jinqinxixi.bountifulbaubles.util.BaubleUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Equipable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class AnkhShieldItem
extends ModifiableBaubleItem
implements Equipable {
    private static final int MAX_DURABILITY = 1680;
    private static final ModifiableBaubleItem.Modifier[] MODIFIERS = ModifiableBaubleItem.Modifier.values();

    public AnkhShieldItem() {
        super(new Item.Properties().m_41503_(1680).m_41497_(Rarity.UNCOMMON).m_41486_());
    }

    @Override
    public ModifiableBaubleItem.Modifier[] getModifiers() {
        return MODIFIERS;
    }

    @Override
    public ICapabilityProvider initCapabilities(final ItemStack stack, CompoundTag unused) {
        return CuriosApi.createCurioProvider((ICurio)new ICurio(){

            public ItemStack getStack() {
                return stack;
            }

            public void onEquip(SlotContext slotContext, ItemStack prevStack) {
                LivingEntity entity = slotContext.entity();
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    AnkhShieldItem.this.applyModifier(player, stack);
                    if (player.m_21023_(MobEffects.f_216964_)) {
                        player.m_21195_(MobEffects.f_216964_);
                    }
                    if (player.m_21023_(MobEffects.f_19615_)) {
                        player.m_21195_(MobEffects.f_19615_);
                    }
                    if (player.m_21023_(MobEffects.f_19604_)) {
                        player.m_21195_(MobEffects.f_19604_);
                    }
                    if (player.m_21023_(MobEffects.f_19597_)) {
                        player.m_21195_(MobEffects.f_19597_);
                    }
                    if (player.m_21023_(MobEffects.f_19612_)) {
                        player.m_21195_(MobEffects.f_19612_);
                    }
                    if (player.m_21023_(MobEffects.f_19620_)) {
                        player.m_21195_(MobEffects.f_19620_);
                    }
                    if (player.m_21023_(MobEffects.f_19610_)) {
                        player.m_21195_(MobEffects.f_19610_);
                    }
                    if (player.m_21023_(MobEffects.f_19599_)) {
                        player.m_21195_(MobEffects.f_19599_);
                    }
                    if (player.m_21023_(MobEffects.f_19613_)) {
                        player.m_21195_(MobEffects.f_19613_);
                    }
                    if (player.m_21023_(MobEffects.f_19614_)) {
                        player.m_21195_(MobEffects.f_19614_);
                    }
                }
            }

            public void onUnequip(SlotContext slotContext, ItemStack newStack) {
                LivingEntity livingEntity = slotContext.entity();
                if (livingEntity instanceof Player) {
                    Player player = (Player)livingEntity;
                    AnkhShieldItem.this.removeModifier(player, stack);
                }
            }

            public boolean canEquip(SlotContext slotContext) {
                return true;
            }

            public boolean canUnequip(SlotContext slotContext) {
                return true;
            }
        });
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onEffectApplicable(MobEffectEvent.Applicable event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            MobEffectInstance effect = event.getEffectInstance();
            if (effect != null && (effect.m_19544_() == MobEffects.f_216964_ || effect.m_19544_() == MobEffects.f_19615_ || effect.m_19544_() == MobEffects.f_19604_ || effect.m_19544_() == MobEffects.f_19597_ || effect.m_19544_() == MobEffects.f_19612_ || effect.m_19544_() == MobEffects.f_19620_ || effect.m_19544_() == MobEffects.f_19610_ || effect.m_19544_() == MobEffects.f_19599_ || effect.m_19544_() == MobEffects.f_19613_ || effect.m_19544_() == MobEffects.f_19614_) && AnkhShieldItem.hasShield((LivingEntity)player)) {
                event.setResult(Event.Result.DENY);
            }
        }
    }

    @SubscribeEvent
    public static void onItemEquipped(LivingEquipmentChangeEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            ItemStack stack = event.getTo();
            if (stack.m_41720_() instanceof AnkhShieldItem && (event.getSlot() == EquipmentSlot.MAINHAND || event.getSlot() == EquipmentSlot.OFFHAND)) {
                if (player.m_21023_(MobEffects.f_216964_)) {
                    player.m_21195_(MobEffects.f_216964_);
                }
                if (player.m_21023_(MobEffects.f_19615_)) {
                    player.m_21195_(MobEffects.f_19615_);
                }
                if (player.m_21023_(MobEffects.f_19604_)) {
                    player.m_21195_(MobEffects.f_19604_);
                }
                if (player.m_21023_(MobEffects.f_19597_)) {
                    player.m_21195_(MobEffects.f_19597_);
                }
                if (player.m_21023_(MobEffects.f_19612_)) {
                    player.m_21195_(MobEffects.f_19612_);
                }
                if (player.m_21023_(MobEffects.f_19620_)) {
                    player.m_21195_(MobEffects.f_19620_);
                }
                if (player.m_21023_(MobEffects.f_19610_)) {
                    player.m_21195_(MobEffects.f_19610_);
                }
                if (player.m_21023_(MobEffects.f_19599_)) {
                    player.m_21195_(MobEffects.f_19599_);
                }
                if (player.m_21023_(MobEffects.f_19613_)) {
                    player.m_21195_(MobEffects.f_19613_);
                }
                if (player.m_21023_(MobEffects.f_19614_)) {
                    player.m_21195_(MobEffects.f_19614_);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        LivingEntity entity = event.getEntity();
        DamageSource source = event.getSource();
        if (AnkhShieldItem.isFireDamage(source) && !AnkhShieldItem.isLavaDamage(source) && AnkhShieldItem.hasShield(entity)) {
            event.setAmount(event.getAmount() * 0.5f);
        }
    }

    @SubscribeEvent
    public static void onLivingAttack(LivingAttackEvent event) {
        LivingEntity entity = event.getEntity();
        DamageSource source = event.getSource();
        if (AnkhShieldItem.isFireDamage(source) && AnkhShieldItem.hasShield(entity)) {
            entity.m_20095_();
        }
    }

    @SubscribeEvent
    public static void onKnockback(LivingKnockBackEvent event) {
        if (AnkhShieldItem.hasShield(event.getEntity())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        Player player;
        if (event.phase == TickEvent.Phase.END && !event.player.m_9236_().m_5776_() && AnkhShieldItem.hasShield((LivingEntity)(player = event.player))) {
            AnkhShieldItem.handleAutoRepair(player);
        }
    }

    private static void handleAutoRepair(Player player) {
        if (player.f_19797_ % 200 == 0) {
            AnkhShieldItem.repairShield(player.m_21205_());
            AnkhShieldItem.repairShield(player.m_21206_());
            CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(inv -> inv.findFirstCurio(stack -> stack.m_41720_() instanceof AnkhShieldItem).ifPresent(slotResult -> AnkhShieldItem.repairShield(slotResult.stack())));
        }
    }

    private static void repairShield(ItemStack stack) {
        if (stack.m_41720_() instanceof AnkhShieldItem && stack.m_41768_()) {
            stack.m_41721_(stack.m_41773_() - 1);
        }
    }

    private static boolean hasShield(LivingEntity entity) {
        if (!(entity instanceof Player)) {
            return false;
        }
        Player player = (Player)entity;
        boolean inHand = player.m_21120_(InteractionHand.MAIN_HAND).m_41720_() instanceof AnkhShieldItem || player.m_21120_(InteractionHand.OFF_HAND).m_41720_() instanceof AnkhShieldItem;
        boolean inCurio = CuriosApi.getCuriosInventory((LivingEntity)player).resolve().map(inv -> inv.findFirstCurio(stack -> stack.m_41720_() instanceof AnkhShieldItem).isPresent()).orElse(false);
        return inHand || inCurio;
    }

    private static boolean isFireDamage(DamageSource source) {
        return source.m_276093_(DamageTypes.f_268631_) || source.m_276093_(DamageTypes.f_268468_) || source.m_276093_(DamageTypes.f_268684_) || source.m_276093_(DamageTypes.f_268556_);
    }

    private static boolean isLavaDamage(DamageSource source) {
        return source.m_276093_(DamageTypes.f_268546_) || source.m_276093_(DamageTypes.f_268434_);
    }

    public boolean m_6832_(ItemStack toRepair, ItemStack repair) {
        return repair.m_150930_(Items.f_41999_);
    }

    public int m_6473_() {
        return 0;
    }

    public boolean m_8120_(ItemStack stack) {
        return false;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        player.m_6672_(hand);
        return InteractionResultHolder.m_19096_((Object)itemstack);
    }

    @SubscribeEvent
    public static void onLivingUpdate(LivingEvent.LivingTickEvent event) {
        Player player;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && AnkhShieldItem.hasShield((LivingEntity)(player = (Player)livingEntity))) {
            BaubleUtils.destroyNearbyWebs(player);
        }
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BLOCK;
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        return ToolActions.DEFAULT_SHIELD_ACTIONS.contains(toolAction);
    }

    public EquipmentSlot m_40402_() {
        return EquipmentSlot.OFFHAND;
    }

    public EquipmentSlot getEquipmentSlot(ItemStack stack) {
        return EquipmentSlot.OFFHAND;
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237115_((String)"tooltip.bountifulbaubles.ankh_shield.effect").m_130940_(ChatFormatting.BLUE));
        super.m_7373_(stack, level, tooltip, flag);
    }
}

