/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.bountifulbaubles.item.Baubles;

import com.jinqinxixi.bountifulbaubles.item.Baubles.HorseshoeBalloonItem;
import com.jinqinxixi.bountifulbaubles.system.modifier.ModifiableBaubleItem;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;

@Mod.EventBusSubscriber
public class BalloonItem
extends ModifiableBaubleItem {
    private static final ModifiableBaubleItem.Modifier[] MODIFIERS = ModifiableBaubleItem.Modifier.values();

    public BalloonItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public ModifiableBaubleItem.Modifier[] getModifiers() {
        return MODIFIERS;
    }

    @Override
    public ICapabilityProvider initCapabilities(final ItemStack stack, CompoundTag unused) {
        return CuriosApi.createCurioProvider((ICurio)new ICurio(){

            public ItemStack getStack() {
                return stack;
            }

            public void onEquip(SlotContext slotContext, ItemStack prevStack) {
                LivingEntity entity = slotContext.entity();
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    BalloonItem.this.applyModifier(player, stack);
                    BalloonItem.updateJumpEffect(player);
                }
            }

            public void onUnequip(SlotContext slotContext, ItemStack newStack) {
                LivingEntity entity = slotContext.entity();
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    BalloonItem.this.removeModifier(player, stack);
                    BalloonItem.updateJumpEffect(player);
                }
            }

            public boolean canEquip(SlotContext slotContext) {
                return true;
            }

            public boolean canUnequip(SlotContext slotContext) {
                return true;
            }
        });
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && !event.player.m_9236_().f_46443_) {
            Player player = event.player;
            BalloonItem.updateJumpEffect(player);
        }
    }

    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (event.getSource().m_276093_(DamageTypes.f_268671_)) {
                CuriosApi.getCuriosInventory((LivingEntity)player).resolve().ifPresent(curios -> {
                    boolean hasHorseshoe = curios.findFirstCurio(stack -> stack.m_41720_() instanceof HorseshoeBalloonItem).isPresent();
                    if (hasHorseshoe) {
                        return;
                    }
                    int balloons = curios.findCurios(stack -> stack.m_41720_() instanceof BalloonItem).size();
                    if (balloons > 0) {
                        float multiplier = (float)Math.pow(0.5, balloons);
                        event.setAmount(event.getAmount() * multiplier);
                    }
                });
            }
        }
    }

    static void updateJumpEffect(Player player) {
        int horseshoes;
        int balloons = CuriosApi.getCuriosInventory((LivingEntity)player).resolve().map(curios -> curios.findCurios(item -> item.m_41720_() instanceof BalloonItem).size()).orElse(0);
        int total = balloons + (horseshoes = CuriosApi.getCuriosInventory((LivingEntity)player).resolve().map(curios -> curios.findCurios(item -> item.m_41720_() instanceof HorseshoeBalloonItem).size()).orElse(0).intValue());
        if (total == 0) {
            return;
        }
        MobEffectInstance currentEffect = player.m_21124_(MobEffects.f_19603_);
        if (currentEffect != null && currentEffect.m_19571_()) {
            player.m_21195_(MobEffects.f_19603_);
        }
        int newAmplifier = 1 + (total - 1);
        player.m_7292_(new MobEffectInstance(MobEffects.f_19603_, 40, newAmplifier, false, false, true));
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237115_((String)"tooltip.bountifulbaubles.balloon.effects").m_130940_(ChatFormatting.BLUE));
        super.m_7373_(stack, level, tooltip, flag);
    }
}

